/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.text;

import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import org.netbeans.modules.visualweb.api.designer.DomProvider;
import org.netbeans.modules.visualweb.css2.ModelViewMapper;
import org.netbeans.modules.visualweb.designer.WebForm;
import org.netbeans.modules.visualweb.text.DesignerPaneBase;
import org.netbeans.modules.visualweb.text.DesignerPaneBaseUI;
import org.netbeans.modules.visualweb.text.actions.SelectLineAction;
import org.netbeans.modules.visualweb.text.actions.SelectWordAction;
import org.openide.ErrorManager;
import org.openide.util.WeakListeners;
import org.w3c.dom.Node;

class DesignerCaret
extends Rectangle
implements FocusListener,
MouseListener,
MouseMotionListener {
    private static transient Action selectWord = null;
    private static transient Action selectLine = null;
    private transient boolean installed;
    DesignerPaneBase component;
    boolean async = false;
    boolean visible;
    boolean flashOn;
    DomProvider.DomRange range = null;
    Object selectionTag;
    boolean selectionVisible;
    Timer flasher;
    Point magicCaretPosition;
    private final Handler handler = new Handler();
    private boolean ownsSelection;
    private boolean forceCaretPositionChange;
    private transient boolean shouldHandleRelease;

    public DomProvider.DomRange getRange() {
        return this.range;
    }

    boolean getAsynchronousMovement() {
        return this.async;
    }

    void setAsynchronousMovement(boolean bl) {
        this.async = bl;
    }

    protected final DesignerPaneBase getComponent() {
        return this.component;
    }

    protected final synchronized void repaint() {
        if (this.component != null) {
            this.component.repaint(this.x, this.y, this.width, this.height);
        }
    }

    protected final synchronized void repaintSelection() {
        if (this.component != null) {
            this.component.repaint();
        }
    }

    protected synchronized void damage(Rectangle rectangle) {
        if (rectangle != null) {
            this.x = rectangle.x - 4;
            this.y = rectangle.y;
            this.width = 10;
            this.height = rectangle.height;
            this.repaint();
        }
    }

    protected void adjustVisibility(Rectangle rectangle) {
        if (this.component == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.component.scrollRectToVisible(rectangle);
        } else {
            SwingUtilities.invokeLater(new SafeScroller(rectangle));
        }
    }

    private void positionCaret(MouseEvent mouseEvent) {
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        WebForm webForm = this.component.getWebForm();
        DomProvider.DomPosition domPosition = webForm.viewToModel(point);
        if (webForm.getManager().getInlineEditor() == null || !webForm.getManager().getInlineEditor().isDocumentEditor()) {
            domPosition = ModelViewMapper.findValidPosition(webForm, domPosition, true, webForm.getManager().getInlineEditor());
        }
        if (domPosition != DomProvider.DomPosition.NONE) {
            this.setDot(domPosition);
        }
    }

    private void moveCaret(MouseEvent mouseEvent) {
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        WebForm webForm = this.component.getWebForm();
        DomProvider.DomPosition domPosition = webForm.viewToModel(point);
        if (webForm.getManager().getInlineEditor() == null || !webForm.getManager().getInlineEditor().isDocumentEditor()) {
            domPosition = ModelViewMapper.findValidPosition(webForm, domPosition, true, webForm.getManager().getInlineEditor());
        }
        if (domPosition != DomProvider.DomPosition.NONE) {
            this.moveDot(domPosition);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.component.isEnabled()) {
            this.setVisible(true);
            this.setSelectionVisible(true);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        this.setVisible(false);
        this.setSelectionVisible(this.ownsSelection || focusEvent.isTemporary());
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed()) {
            DesignerPaneBase designerPaneBase;
            int n = mouseEvent.getClickCount();
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (mouseEvent.getClickCount() == 2) {
                    Action action = null;
                    ActionMap actionMap = this.getComponent().getActionMap();
                    if (actionMap != null) {
                        action = actionMap.get("select-word");
                    }
                    if (action == null) {
                        if (selectWord == null) {
                            selectWord = new SelectWordAction();
                        }
                        action = selectWord;
                    }
                    action.actionPerformed(new ActionEvent(this.getComponent(), 1001, null, mouseEvent.getWhen(), mouseEvent.getModifiers()));
                } else if (mouseEvent.getClickCount() == 3) {
                    Action action = null;
                    ActionMap actionMap = this.getComponent().getActionMap();
                    if (actionMap != null) {
                        action = actionMap.get("select-line");
                    }
                    if (action == null) {
                        if (selectLine == null) {
                            selectLine = new SelectLineAction();
                        }
                        action = selectLine;
                    }
                    action.actionPerformed(new ActionEvent(this.getComponent(), 1001, null, mouseEvent.getWhen(), mouseEvent.getModifiers()));
                }
            } else if (SwingUtilities.isMiddleMouseButton(mouseEvent) && n == 1 && (designerPaneBase = (DesignerPaneBase)mouseEvent.getSource()) != null) {
                try {
                    Toolkit toolkit = designerPaneBase.getToolkit();
                    Clipboard clipboard = toolkit.getSystemSelection();
                    if (clipboard != null) {
                        Transferable transferable;
                        this.adjustCaret(mouseEvent);
                        TransferHandler transferHandler = designerPaneBase.getTransferHandler();
                        if (transferHandler != null && (transferable = clipboard.getContents(null)) != null) {
                            transferHandler.importData(designerPaneBase, transferable);
                        }
                        this.adjustFocus(true);
                    }
                }
                catch (HeadlessException headlessException) {
                    ErrorManager.getDefault().notify(1, (Throwable)headlessException);
                }
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            if (mouseEvent.isConsumed()) {
                this.shouldHandleRelease = true;
            } else {
                this.shouldHandleRelease = false;
                this.adjustCaretAndFocus(mouseEvent);
            }
        }
    }

    private void adjustCaretAndFocus(MouseEvent mouseEvent) {
        this.adjustCaret(mouseEvent);
        this.adjustFocus(false);
    }

    private void adjustCaret(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 1) != 0 && this.getDot() != DomProvider.DomPosition.NONE) {
            this.moveCaret(mouseEvent);
        } else {
            this.positionCaret(mouseEvent);
        }
    }

    private void adjustFocus(boolean bl) {
        if (this.component != null && this.component.isEnabled() && this.component.isRequestFocusEnabled()) {
            if (bl) {
                this.component.requestFocusInWindow();
            } else {
                this.component.requestFocus();
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.shouldHandleRelease && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.adjustCaretAndFocus(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed() && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.moveCaret(mouseEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void paint(Graphics graphics) {
        if (this.isVisible() && this.flashOn) {
            DesignerPaneBaseUI designerPaneBaseUI = this.component.getUI();
            if (this.range == null) {
                return;
            }
            DomProvider.DomPosition domPosition = this.range.getDot();
            WebForm webForm = this.component.getWebForm();
            Rectangle rectangle = webForm.modelToView(domPosition);
            if (rectangle == null || rectangle.width == 0 && rectangle.height == 0) {
                return;
            }
            if (this.width > 0 && this.height > 0 && !this._contains(rectangle.x, rectangle.y, rectangle.width, rectangle.height)) {
                Rectangle rectangle2 = graphics.getClipBounds();
                if (rectangle2 != null && !rectangle2.contains(this)) {
                    this.repaint();
                }
                this.damage(rectangle);
            }
            graphics.setColor(this.component.getCaretColor());
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
            graphics.drawLine(rectangle.x + 1, rectangle.y, rectangle.x + 1, rectangle.y + rectangle.height - 1);
        }
    }

    public void install(DesignerPaneBase designerPaneBase) {
        if (this.installed) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("The designer caret is installed already!"));
            return;
        }
        this.installed = true;
        this.component = designerPaneBase;
        designerPaneBase.addFocusListener(this);
        DomProvider.DomDocument domDocument = designerPaneBase.getWebForm().getDomDocument();
        DomProvider.DomDocumentListener domDocumentListener = (DomProvider.DomDocumentListener)WeakListeners.create(DomProvider.DomDocumentListener.class, (EventListener)this.handler, (Object)domDocument);
        domDocument.addDomDocumentListener(domDocumentListener);
        if (this.component.hasFocus()) {
            this.focusGained(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deinstall(DesignerPaneBase designerPaneBase) {
        if (!this.installed) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("The designer caret was not installed before!"));
            return;
        }
        this.installed = false;
        designerPaneBase.removeFocusListener(this);
        DesignerCaret designerCaret = this;
        synchronized (designerCaret) {
            this.component = null;
        }
        if (this.flasher != null) {
            this.flasher.stop();
            this.flasher = null;
        }
        if (this.range != null) {
            this.range.detach();
            this.range = null;
        }
    }

    public void setSelectionVisible(boolean bl) {
        if (bl != this.selectionVisible) {
            this.selectionVisible = bl;
            if (!this.selectionVisible || this.hasSelection()) {
                this.repaintSelection();
            }
        }
    }

    public boolean isSelectionVisible() {
        return this.selectionVisible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        if (this.component != null) {
            DesignerPaneBaseUI designerPaneBaseUI = this.component.getUI();
            if (this.visible != bl) {
                this.visible = bl;
                if (this.range != null) {
                    DomProvider.DomPosition domPosition = this.range.getDot();
                    WebForm webForm = this.component.getWebForm();
                    Rectangle rectangle = webForm.modelToView(domPosition);
                    this.damage(rectangle);
                }
            }
        }
        if (this.flasher != null) {
            if (this.visible) {
                this.flashOn = true;
                this.flasher.start();
            } else {
                this.flasher.stop();
            }
        }
    }

    public void setBlinkRate(int n) {
        if (n != 0) {
            if (this.flasher == null) {
                this.flasher = new Timer(n, this.handler);
            }
            this.flasher.setDelay(n);
        } else if (this.flasher != null) {
            this.flasher.stop();
            this.flasher.removeActionListener(this.handler);
            this.flasher = null;
            this.flashOn = true;
        }
    }

    public int getBlinkRate() {
        return this.flasher == null ? 0 : this.flasher.getDelay();
    }

    public DomProvider.DomPosition getDot() {
        if (this.range == null) {
            return DomProvider.DomPosition.NONE;
        }
        return this.range.getDot();
    }

    public DomProvider.DomPosition getMark() {
        if (this.range == null) {
            return DomProvider.DomPosition.NONE;
        }
        return this.range.getMark();
    }

    public DomProvider.DomPosition getFirstPosition() {
        if (this.range == null) {
            return DomProvider.DomPosition.NONE;
        }
        return this.range.getFirstPosition();
    }

    public DomProvider.DomPosition getLastPosition() {
        if (this.range == null) {
            return DomProvider.DomPosition.NONE;
        }
        return this.range.getLastPosition();
    }

    public void setDot(DomProvider.DomPosition domPosition) {
        this.handleSetDot(domPosition);
    }

    public void moveDot(DomProvider.DomPosition domPosition) {
        if (domPosition == DomProvider.DomPosition.NONE && this.range == null) {
            return;
        }
        if (this.range != null && this.range.isDot(domPosition)) {
            return;
        }
        this.handleMoveDot(domPosition);
    }

    void handleMoveDot(DomProvider.DomPosition domPosition) {
        if (this.component.getWebForm().isRenderedNode(domPosition.getNode())) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalArgumentException("The node is expected not rendered" + domPosition.getNode()));
        }
        if (this.component.getWebForm().getPane().getPageBox().getElement().getOwnerDocument() != this.component.getWebForm().getHtmlDom()) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Owner document is expected to be html dom=" + this.component.getWebForm().getHtmlDom() + ", but it is dom=" + this.component.getWebForm().getPane().getPageBox().getElement().getOwnerDocument()));
        }
        this.changeCaretPosition(domPosition);
        this.setSelectionVisible(this.hasSelection());
        if (this.hasSelection()) {
            this.repaintSelection();
        }
    }

    void handleSetDot(DomProvider.DomPosition domPosition) {
        boolean bl;
        if (this.component == null || domPosition == null || domPosition == DomProvider.DomPosition.NONE) {
            if (this.range != null) {
                this.range.detach();
                this.range = null;
            }
            return;
        }
        if (this.component.getWebForm().isRenderedNode(domPosition.getNode()) && !this.component.getWebForm().getManager().isInlineEditing()) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("It is not in inline editing, and node is rendered node=" + domPosition.getNode()));
        }
        if (this.component.getWebForm().getPane().getPageBox().getElement().getOwnerDocument() != this.component.getWebForm().getHtmlDom()) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Owner document is expected to be html dom=" + this.component.getWebForm().getHtmlDom() + ", but it is dom=" + this.component.getWebForm().getPane().getPageBox().getElement().getOwnerDocument()));
        }
        Node node = domPosition.getNode();
        int n = domPosition.getOffset();
        if (this.range == null) {
            this.range = this.component.getWebForm().createDomRange(node, n, node, n);
            bl = true;
        } else {
            this.range.setMark(node, n, domPosition.getBias());
            bl = true;
        }
        if (bl || this.selectionTag != null || this.forceCaretPositionChange) {
            this.changeCaretPosition(domPosition);
        }
        this.setSelectionVisible(this.hasSelection());
    }

    void changeCaretPosition(DomProvider.DomPosition domPosition) {
        this.repaint();
        if (this.flasher != null && this.flasher.isRunning()) {
            this.flashOn = true;
            this.flasher.restart();
        }
        if (this.range == null) {
            this.range = this.component.getWebForm().createDomRange(domPosition.getNode(), domPosition.getOffset(), domPosition.getNode(), domPosition.getOffset());
        } else {
            this.range.setDot(domPosition.getNode(), domPosition.getOffset(), domPosition.getBias());
        }
        this.updateSystemSelection();
        this.setMagicCaretPosition(null);
        Runnable runnable = new Runnable(){

            public void run() {
                DesignerCaret.this.repaintNewCaret();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    void repaintNewCaret() {
        DesignerPaneBaseUI designerPaneBaseUI;
        if (this.component != null && (designerPaneBaseUI = this.component.getUI()) != null && this.range != null) {
            DomProvider.DomPosition domPosition = this.range.getDot();
            WebForm webForm = this.component.getWebForm();
            Rectangle rectangle = webForm.modelToView(domPosition);
            if (rectangle != null) {
                this.adjustVisibility(rectangle);
                if (this.getMagicCaretPosition() == null) {
                    this.setMagicCaretPosition(new Point(rectangle.x, rectangle.y));
                }
            }
            this.damage(rectangle);
        }
    }

    private void updateSystemSelection() {
        Clipboard clipboard;
        if (!this.range.isEmpty() && this.component != null && (clipboard = this.getSystemSelection()) != null) {
            String string = this.component.getWebForm().getDomDocument().getRangeText(this.range);
            clipboard.setContents(new StringSelection(string), this.getClipboardOwner());
            this.ownsSelection = true;
        }
    }

    private Clipboard getSystemSelection() {
        try {
            return this.component.getToolkit().getSystemSelection();
        }
        catch (HeadlessException headlessException) {
            ErrorManager.getDefault().notify(1, (Throwable)headlessException);
            return null;
        }
    }

    private ClipboardOwner getClipboardOwner() {
        return this.handler;
    }

    public void setMagicCaretPosition(Point point) {
        this.magicCaretPosition = point;
    }

    public Point getMagicCaretPosition() {
        return this.magicCaretPosition;
    }

    public void detachDom() {
        if (this.range != null) {
            this.range.detach();
            this.range = null;
        }
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public String toString() {
        if (this.range != null) {
            return this.range.toString();
        }
        return "Caret-range is nul";
    }

    private boolean _contains(int n, int n2, int n3, int n4) {
        int n5 = this.width;
        int n6 = this.height;
        if ((n5 | n6 | n3 | n4) < 0) {
            return false;
        }
        int n7 = this.x;
        int n8 = this.y;
        if (n < n7 || n2 < n8) {
            return false;
        }
        if (n3 > 0) {
            n5 += n7;
            if ((n3 += n) <= n ? n5 >= n7 || n3 > n5 : n5 >= n7 && n3 > n5) {
                return false;
            }
        } else if (n7 + n5 < n) {
            return false;
        }
        if (n4 > 0) {
            n6 += n8;
            if ((n4 += n2) <= n2 ? n6 >= n8 || n4 > n6 : n6 >= n8 && n4 > n6) {
                return false;
            }
        } else if (n8 + n6 < n2) {
            return false;
        }
        return true;
    }

    void removeSelection() {
        if (this.range == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Range is null."));
            return;
        }
        boolean bl = this.component.getWebForm().getDomDocument().deleteRangeContents(this.range);
        if (!bl) {
            UIManager.getLookAndFeel().provideErrorFeedback(this.component);
        }
    }

    String getSelectedText() {
        if (this.range == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Range is null."));
            return "";
        }
        if (this.component == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Component is null."));
            return "";
        }
        return this.component.getWebForm().getDomDocument().getRangeText(this.range);
    }

    public boolean hasSelection() {
        return this.range != null && !this.range.isEmpty();
    }

    public boolean removeNextChar() {
        WebForm webForm = this.component.getWebForm();
        return webForm.getDomDocument().deleteNextChar(webForm, this.range);
    }

    public boolean removePreviousChar() {
        WebForm webForm = this.component.getWebForm();
        return webForm.getDomDocument().deletePreviousChar(webForm, this.range);
    }

    boolean replaceSelection(String string) {
        return this.component.getWebForm().getDomDocument().insertString(this.component.getWebForm(), this.range, string);
    }

    public boolean isReadOnlyRegion() {
        return this.range != null ? this.range.isReadOnlyRegion() : false;
    }

    class Handler
    implements ActionListener,
    ClipboardOwner,
    DomProvider.DomDocumentListener {
        Handler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if ((DesignerCaret.this.width == 0 || DesignerCaret.this.height == 0) && DesignerCaret.this.isVisible() && DesignerCaret.this.component != null) {
                DesignerPaneBaseUI designerPaneBaseUI = DesignerCaret.this.component.getUI();
                if (DesignerCaret.this.range != null) {
                    DomProvider.DomPosition domPosition = DesignerCaret.this.range.getDot();
                    WebForm webForm = DesignerCaret.this.component.getWebForm();
                    Rectangle rectangle = webForm.modelToView(domPosition);
                    if (rectangle != null && rectangle.width != 0 && rectangle.height != 0) {
                        DesignerCaret.this.damage(rectangle);
                    }
                }
            }
            DesignerCaret.this.flashOn = !DesignerCaret.this.flashOn;
            DesignerCaret.this.repaint();
        }

        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
            if (DesignerCaret.this.ownsSelection) {
                DesignerCaret.this.ownsSelection = false;
                if (DesignerCaret.this.component != null && !DesignerCaret.this.component.hasFocus()) {
                    DesignerCaret.this.setSelectionVisible(false);
                }
            }
        }

        public void insertUpdate(DomProvider.DomDocumentEvent domDocumentEvent) {
            DesignerCaret.this.setDot(domDocumentEvent.getDomPosition());
        }

        public void componentMoved(DomProvider.DomDocumentEvent domDocumentEvent) {
            if (DesignerCaret.this.component == null) {
                return;
            }
            if (DesignerCaret.this.component.hasCaret()) {
                DomProvider.DomPosition domPosition = ModelViewMapper.getFirstDocumentPosition(DesignerCaret.this.component.getWebForm(), false);
                DesignerCaret.this.setDot(domPosition);
            }
        }

        public void componentsMoved(DomProvider.DomDocumentEvent domDocumentEvent) {
        }

        public void componentMovedTo(DomProvider.DomDocumentEvent domDocumentEvent) {
        }
    }

    class SafeScroller
    implements Runnable {
        Rectangle r;

        SafeScroller(Rectangle rectangle) {
            this.r = rectangle;
        }

        public void run() {
            if (DesignerCaret.this.component != null) {
                DesignerCaret.this.component.scrollRectToVisible(this.r);
            }
        }
    }
}

