/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import org.netbeans.modules.visualweb.designer.DesignerPane;
import org.netbeans.modules.visualweb.designer.Interaction;
import org.netbeans.modules.visualweb.designer.WebForm;
import org.w3c.dom.Element;

public class TableResizer
extends Interaction
implements KeyListener {
    protected transient Cursor previousCursor = null;
    private WebForm webform;
    private Element element;
    private int prevX = -500;
    private int prevY = -500;
    private int prevMouseX = -500;
    private int prevMouseY = -500;
    private Element tableComponentRootElement;
    private int direction;
    private boolean leftTopSide;
    private int spanLeft;
    private int spanTop;
    private int originalSize;
    private int otherSize;
    private int minimum;
    private int maximum;
    private int row;
    private int column;
    private Rectangle currentSize = null;

    public TableResizer(WebForm webForm, Element element, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Element element2) {
        this.webform = webForm;
        this.tableComponentRootElement = element;
        this.direction = n;
        this.leftTopSide = bl;
        this.spanLeft = n2;
        this.spanTop = n3;
        this.originalSize = n4;
        this.otherSize = n5;
        this.minimum = n6;
        this.maximum = n7;
        this.row = n8;
        this.column = n9;
        this.element = element2;
        assert (n6 >= 0);
        assert (n6 <= n7);
    }

    public void cancel(DesignerPane designerPane) {
        designerPane.removeKeyListener(this);
        this.cleanup(designerPane);
        this.currentSize = null;
    }

    private void cleanup(DesignerPane designerPane) {
        designerPane.setCursor(this.previousCursor);
        if (this.prevX != -500) {
            Rectangle rectangle = new Rectangle();
            this.resize(rectangle, this.prevX, this.prevY);
            ++rectangle.width;
            ++rectangle.height;
            designerPane.repaint(rectangle);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent != null && !mouseEvent.isConsumed()) {
            Point point = mouseEvent.getPoint();
            DesignerPane designerPane = this.webform.getPane();
            designerPane.removeKeyListener(this);
            int n = point.x;
            int n2 = point.y;
            Rectangle rectangle = new Rectangle();
            this.resize(rectangle, n, n2);
            if (this.direction == 1) {
                this.webform.getDomProviderService().resizeColumn(this.tableComponentRootElement, this.column, rectangle.width);
            } else {
                assert (this.direction == 0);
                this.webform.getDomProviderService().resizeRow(this.tableComponentRootElement, this.row, rectangle.height);
            }
            this.cleanup(designerPane);
            mouseEvent.consume();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        this.prevMouseX = point.x;
        this.prevMouseY = point.y;
        this.update(mouseEvent, point.x, point.y);
    }

    private void resize(Rectangle rectangle, int n, int n2) {
        rectangle.x = this.spanLeft;
        rectangle.y = this.spanTop;
        int n3 = 0;
        switch (this.direction) {
            case 0: {
                if (this.leftTopSide) {
                    n3 = this.originalSize - (n2 - this.spanTop);
                    rectangle.y = this.spanTop + this.originalSize - n3;
                    break;
                }
                n3 = n2 - this.spanTop;
                break;
            }
            case 1: {
                if (this.leftTopSide) {
                    n3 = this.originalSize - (n - this.spanLeft);
                    rectangle.x = this.spanLeft + this.originalSize - n3;
                    break;
                }
                n3 = n - this.spanLeft;
            }
        }
        if (n3 < this.minimum) {
            n3 = this.minimum;
        }
        if (n3 > this.maximum) {
            n3 = this.maximum;
        }
        switch (this.direction) {
            case 0: {
                rectangle.width = this.otherSize;
                n3 = this.webform.getDomProviderService().testResizeRow(this.tableComponentRootElement, this.row, this.column, n3);
                if (n3 == -1) {
                    n3 = 0;
                }
                rectangle.height = n3;
                break;
            }
            case 1: {
                n3 = this.webform.getDomProviderService().testResizeColumn(this.tableComponentRootElement, this.row, this.column, n3);
                if (n3 == -1) {
                    n3 = 0;
                }
                rectangle.width = n3;
                rectangle.height = this.otherSize;
            }
        }
    }

    public void paint(Graphics graphics) {
        if (this.currentSize != null) {
            if (DesignerPane.useAlpha) {
                graphics.setColor(this.webform.getColors().resizerColor);
                graphics.fillRect(this.currentSize.x + 1, this.currentSize.y + 1, this.currentSize.width - 1, this.currentSize.height - 1);
                graphics.setColor(this.webform.getColors().resizerColorBorder);
            } else {
                graphics.setColor(Color.BLACK);
            }
            graphics.drawRect(this.currentSize.x, this.currentSize.y, this.currentSize.width, this.currentSize.height);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed()) {
            Point point = mouseEvent.getPoint();
            this.prevMouseX = point.x;
            this.prevMouseY = point.y;
            DesignerPane designerPane = this.webform.getPane();
            designerPane.addKeyListener(this);
            this.previousCursor = designerPane.getCursor();
            designerPane.setCursor(Cursor.getPredefinedCursor(this.direction));
            this.update(mouseEvent, this.prevMouseX, this.prevMouseY);
            ImageIcon imageIcon = new ImageIcon(TableResizer.class.getResource("/org/netbeans/modules/visualweb/designer/resources/drag_resize.gif"));
            mouseEvent.consume();
        }
    }

    private void update(InputEvent inputEvent, int n, int n2) {
        if (!inputEvent.isConsumed()) {
            Rectangle rectangle;
            DesignerPane designerPane = this.webform.getPane();
            if (this.currentSize != null) {
                rectangle = this.currentSize;
                ++rectangle.width;
                ++rectangle.height;
            } else {
                rectangle = new Rectangle();
            }
            this.prevX = n;
            this.prevY = n2;
            this.currentSize = new Rectangle();
            this.resize(this.currentSize, this.prevX, this.prevY);
            rectangle.add(this.currentSize.x, this.currentSize.y);
            rectangle.add(this.currentSize.x + this.currentSize.width, this.currentSize.y + this.currentSize.height);
            ++rectangle.width;
            ++rectangle.height;
            designerPane.repaint(rectangle);
            int n3 = this.currentSize.width;
            int n4 = this.currentSize.height;
            if (n3 < 0) {
                n3 = 0;
            }
            if (n4 < 0) {
                n4 = 0;
            }
            int n5 = this.direction == 0 ? this.currentSize.height : this.currentSize.width;
            inputEvent.consume();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

