/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.modules.visualweb.api.designer.Designer;
import org.netbeans.modules.visualweb.api.designer.DomProvider;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssProvider;
import org.netbeans.modules.visualweb.api.designer.markup.MarkupService;
import org.netbeans.modules.visualweb.css2.BoxType;
import org.netbeans.modules.visualweb.css2.ContainerBox;
import org.netbeans.modules.visualweb.css2.CssBox;
import org.netbeans.modules.visualweb.css2.DomInspector;
import org.netbeans.modules.visualweb.css2.ExternalDocumentBox;
import org.netbeans.modules.visualweb.css2.LineBox;
import org.netbeans.modules.visualweb.css2.LineBoxGroup;
import org.netbeans.modules.visualweb.css2.ModelViewMapper;
import org.netbeans.modules.visualweb.css2.PageBox;
import org.netbeans.modules.visualweb.css2.SpaceBox;
import org.netbeans.modules.visualweb.css2.TextBox;
import org.netbeans.modules.visualweb.designer.DesignerPane;
import org.netbeans.modules.visualweb.designer.DndHandler;
import org.netbeans.modules.visualweb.designer.Dragger;
import org.netbeans.modules.visualweb.designer.InlineEditor;
import org.netbeans.modules.visualweb.designer.Interaction;
import org.netbeans.modules.visualweb.designer.Marquee;
import org.netbeans.modules.visualweb.designer.Resizer;
import org.netbeans.modules.visualweb.designer.SelectionManager;
import org.netbeans.modules.visualweb.designer.WebForm;
import org.netbeans.modules.visualweb.spi.designer.Decoration;
import org.netbeans.spi.palette.PaletteController;
import org.openide.awt.MouseUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InteractionManager {
    private static int DOUBLE_CLICK_DELTA = 300;
    public static final boolean ENABLE_DOM_INSPECTOR = true;
    private static final boolean SKIP_MOUSE_MOTION = false;
    private final WebForm webform;
    private InlineEditor inlineEditor;
    private Interaction interaction;
    private CssBox insertModeBox = null;
    private CssBox selectedBox = null;
    private Element highlightedComponentRootElement;
    private Element highlightedRegionElement;
    private MouseHandler mouseHandler;
    private Marquee sizer;
    private Dragger dragger;
    private Cursor insertCursor = null;
    private Cursor linkedCursor = null;
    private boolean ignoreCnC;

    public InteractionManager(WebForm webForm) {
        if (webForm == null) {
            throw new NullPointerException("Parameter webform is null!");
        }
        this.webform = webForm;
    }

    public void updateInsertBox() {
        if (this.insertModeBox == null) {
            return;
        }
        if (this.insertModeBox instanceof PageBox) {
            this.insertModeBox = this.webform.getPane().getPageBox();
            return;
        }
        Element element = this.insertModeBox.getElement();
        this.insertModeBox = this.webform.findCssBoxForElement(element);
    }

    public CssBox getInsertModeBox() {
        return this.insertModeBox;
    }

    void drawInlineEditorBox(Graphics2D graphics2D, Rectangle rectangle) {
        this.webform.getSelection().paintInlineEditorBox(graphics2D, rectangle);
    }

    public void setInsertBox(CssBox cssBox, MouseEvent mouseEvent) {
        DesignerPane designerPane = this.webform.getPane();
        if (cssBox != null && cssBox == designerPane.getPageBox() && this.webform.isGridMode()) {
            cssBox = null;
        }
        if (this.insertModeBox != cssBox) {
            boolean bl;
            this.insertModeBox = cssBox;
            if (cssBox != null) {
                Element element = CssBox.getElementForComponentRootCssBox(cssBox);
                if (this.webform.getDomProviderService().isIncludeComponentBox(element)) {
                    this.insertModeBox = null;
                    return;
                }
            }
            boolean bl2 = bl = cssBox != null || !this.webform.isGridMode();
            if (bl == designerPane.hasCaret()) {
                return;
            }
            if (bl) {
                designerPane.createCaret();
                DomProvider.DomPosition domPosition = DomProvider.DomPosition.NONE;
                if (mouseEvent != null) {
                    Element element;
                    domPosition = this.webform.viewToModel(mouseEvent.getPoint());
                    if (domPosition != DomProvider.DomPosition.NONE) {
                        domPosition = ModelViewMapper.findValidPosition(this.webform, domPosition, true, this.webform.getManager().getInlineEditor());
                    }
                    Element element2 = CssBox.getElementForComponentRootCssBox(cssBox);
                    if (domPosition != DomProvider.DomPosition.NONE && element2 != null && (element = MarkupService.getSourceElementForElement((Element)element2)) != null) {
                        domPosition = this.webform.createDomPosition(element, 0, DomProvider.DomPosition.Bias.FORWARD);
                    }
                }
                designerPane.setCaretDot(domPosition);
                designerPane.setCursor(Cursor.getPredefinedCursor(2));
                if (mouseEvent != null) {
                    designerPane.mousePressed(mouseEvent);
                    designerPane.mouseClicked(mouseEvent);
                }
                designerPane.setCaretVisible(true);
            } else {
                designerPane.setCaret(null);
            }
        }
    }

    private CssBox findInsertBox(CssBox cssBox) {
        ContainerBox containerBox;
        if (!this.webform.isGridMode()) {
            return this.webform.getPane().getPageBox();
        }
        CssBox cssBox2 = cssBox;
        while (cssBox != null) {
            if (cssBox.isGrid()) {
                return null;
            }
            if (cssBox.getBoxType().isAbsolutelyPositioned()) {
                if (cssBox instanceof ContainerBox) break;
                return null;
            }
            if (cssBox.getParent() == null || cssBox.getParent().isGrid()) {
                if (cssBox.getBoxType() != BoxType.LINEBOX && cssBox.isBlockLevel() && cssBox instanceof ContainerBox) break;
                return null;
            }
            cssBox = cssBox.getParent();
        }
        ContainerBox containerBox2 = containerBox = cssBox2 == null ? null : cssBox2.getParent();
        while (containerBox != null && containerBox != cssBox) {
            Element element = CssBox.getElementForComponentRootCssBox(containerBox);
            if (element != null && this.webform.getDomProviderService().isFacesComponent(element)) {
                return null;
            }
            containerBox = containerBox.getParent();
        }
        return cssBox;
    }

    public boolean isInlineEditing() {
        return this.inlineEditor != null;
    }

    public InlineEditor getInlineEditor() {
        return this.inlineEditor;
    }

    public void startInlineEditing(Element element, String string) {
        if (this.isInlineEditing() && this.getInlineEditor().isEditing(element, string)) {
            return;
        }
        this.finishInlineEditing(false);
        CssBox cssBox = ModelViewMapper.findBoxForComponentRootElement(this.webform.getPane().getPageBox(), element);
        this.startInlineEditing(element, string, cssBox, true, true, null, false);
    }

    public boolean startInlineEditing(Element element, String string, CssBox cssBox, boolean bl, boolean bl2, String string2, boolean bl3) {
        this.finishInlineEditing(false);
        if (cssBox == null) {
            cssBox = ModelViewMapper.findBoxForComponentRootElement(this.webform.getPane().getPageBox(), element);
        }
        this.inlineEditor = InlineEditor.getInlineEditor(this.webform, cssBox, element, string, bl3);
        if (this.inlineEditor != null) {
            SelectionManager selectionManager = this.webform.getSelection();
            if (bl && (!selectionManager.isSelected(element) || selectionManager.getNumSelected() > 1)) {
                selectionManager.setSelected(element, true);
            }
            DesignerPane designerPane = this.webform.getPane();
            designerPane.setCursor(Cursor.getPredefinedCursor(2));
            this.inlineEditor.start(bl2, string2);
            designerPane.repaint();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishInlineEditing(boolean bl) {
        if (this.inlineEditor != null) {
            try {
                this.inlineEditor.finish(bl);
            }
            finally {
                this.inlineEditor = null;
            }
            this.webform.getPane().repaint();
        }
    }

    private Element getDefaultSelectionComponentRootElement() {
        SelectionManager selectionManager = this.webform.getSelection();
        Element element = selectionManager.getPrimary();
        if (element == null && !selectionManager.isSelectionEmpty()) {
            Element element2;
            Element[] elementArray = selectionManager.getSelectedComponentRootElements();
            int n = elementArray.length;
            for (int i = 0; i < n && (element = (element2 = elementArray[i])) == null; ++i) {
            }
        }
        return element;
    }

    int updateDropState(Point point, boolean bl, Transferable transferable) {
        Object object;
        DesignerPane designerPane = this.webform.getPane();
        CssBox cssBox = ModelViewMapper.findBox(designerPane.getPageBox(), point.x, point.y);
        CssBox cssBox2 = this.findInsertBox(cssBox);
        if (cssBox2 == designerPane.getPageBox() && this.webform.isGridMode()) {
            cssBox2 = null;
        }
        DomProvider.DomPosition domPosition = DomProvider.DomPosition.NONE;
        if (!(cssBox instanceof ExternalDocumentBox)) {
            CssBox cssBox3;
            this.finishInlineEditing(true);
            assert (this.getInlineEditor() == null);
            domPosition = this.webform.viewToModel(point);
            if (InteractionManager.isReadOnlyRegion(domPosition)) {
                domPosition = DomProvider.DomPosition.NONE;
            }
            if (cssBox != null && cssBox.isGrid() && this.highlightedComponentRootElement == null) {
                domPosition = DomProvider.DomPosition.NONE;
            }
            if (domPosition != DomProvider.DomPosition.NONE && domPosition.getNode().getNodeType() == 1 && (cssBox3 = this.webform.findCssBoxForElement((Element)(object = (Element)domPosition.getNode()))) != null && cssBox3.isGrid()) {
                domPosition = DomProvider.DomPosition.NONE;
            }
        }
        object = designerPane.getDndHandler();
        int n = transferable != null ? ((DndHandler)object).getDropType(point, transferable, false) : (this.mouseHandler.isCnCInProgress() ? ((DndHandler)object).getDropType(point, this.mouseHandler.cncTransferable, false) : 0);
        if (n == 2) {
            designerPane.setCursor(this.getLinkedCursor());
        } else if (n == 1) {
            designerPane.setCursor(this.getInsertCursor());
        } else {
            assert (n == 0);
            designerPane.setCursor(Cursor.getPredefinedCursor(0));
        }
        Element element = MarkupService.getSourceElementForElement((Element)this.highlightedComponentRootElement);
        if (element == null) {
            element = MarkupService.getSourceElementForElement((Element)((DndHandler)object).getRecentDropTargetComponentRootElement());
        }
        if (element != null) {
            org.w3c.dom.Node node = domPosition.getNode();
            if (!(node instanceof Element)) {
                domPosition = DomProvider.DomPosition.NONE;
            }
            if (!InteractionManager.isPositionFromComponent(this.webform, domPosition, element)) {
                domPosition = DomProvider.DomPosition.NONE;
            } else if (!domPosition.isInside(element)) {
                domPosition = DomProvider.DomPosition.NONE;
            }
        }
        if (bl) {
            if (domPosition != DomProvider.DomPosition.NONE) {
                ((DndHandler)object).setInsertPosition(domPosition);
            } else {
                ((DndHandler)object).setDropPoint(point);
            }
            this.setInsertBox(null, null);
            if (this.webform.isGridMode()) {
                designerPane.setCaret(null);
            }
        } else if (domPosition != DomProvider.DomPosition.NONE) {
            if (!designerPane.hasCaret()) {
                designerPane.createCaret();
            }
            designerPane.setCaretVisible(true);
            designerPane.setCaretDot(domPosition);
        } else if (designerPane.hasCaret()) {
            designerPane.setCaret(null);
        }
        return n;
    }

    private static boolean isPositionFromComponent(WebForm webForm, DomProvider.DomPosition domPosition, Element element) {
        if (domPosition == null || element == null) {
            return false;
        }
        org.w3c.dom.Node node = domPosition.getNode();
        if (node instanceof Element) {
            return ModelViewMapper.findClosestComponentRootElement(webForm, (Element)node) == element;
        }
        return false;
    }

    public void highlight(Element element, Element element2) {
        if (element == this.highlightedComponentRootElement && element2 == this.highlightedRegionElement) {
            return;
        }
        this.highlightedComponentRootElement = element;
        this.highlightedRegionElement = element2;
        this.webform.getPane().repaint();
    }

    public boolean isHighlighted() {
        return this.highlightedComponentRootElement != null;
    }

    public void paint(Graphics2D graphics2D) {
        this.webform.getColors().sync();
        this.webform.paintDesignerDecorations(graphics2D);
        this.webform.getSelection().paintSelection(graphics2D);
        this.paintInsertModeBox(graphics2D);
        if (this.inlineEditor != null) {
            this.inlineEditor.paint(graphics2D);
        }
        if (this.interaction != null) {
            this.interaction.paint(graphics2D);
        }
        if (this.highlightedComponentRootElement != null) {
            Rectangle rectangle = null;
            if (this.highlightedRegionElement != null) {
                rectangle = this.webform.getPane().getPageBox().computeRegionBounds(this.highlightedRegionElement, null);
                this.highlightedRegionElement = null;
            }
            if (rectangle == null) {
                rectangle = ModelViewMapper.getComponentBounds(this.webform.getPane().getPageBox(), this.highlightedComponentRootElement);
            }
            if (rectangle == null) {
                this.highlightedComponentRootElement = null;
            } else {
                graphics2D.setColor(this.webform.getColors().dropTargetColor);
                graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
        this.webform.getSelection().paintSelHierarchy(graphics2D);
    }

    private void paintInsertModeBox(Graphics2D graphics2D) {
        if (this.insertModeBox != null && !(this.insertModeBox instanceof PageBox)) {
            Rectangle rectangle = new Rectangle(this.insertModeBox.getAbsoluteX(), this.insertModeBox.getAbsoluteY(), this.insertModeBox.getWidth(), this.insertModeBox.getHeight());
            this.drawInlineEditorBox(graphics2D, rectangle);
        }
    }

    public MouseHandler getMouseHandler() {
        if (this.mouseHandler == null) {
            this.mouseHandler = new MouseHandler();
        }
        return this.mouseHandler;
    }

    public static void translateMousePos(Point point, Component component) {
    }

    Cursor getInsertCursor() {
        if (this.insertCursor == null) {
            DesignerPane designerPane = this.webform.getPane();
            Image image = null;
            Point point = null;
            image = Utilities.loadImage((String)"org/netbeans/modules/visualweb/designer/resources/insert-cursor.gif");
            point = new Point(9, 9);
            Toolkit toolkit = designerPane.getToolkit();
            this.insertCursor = toolkit.createCustomCursor(image, point, "CROSSINSERT_CURSOR");
        }
        return this.insertCursor;
    }

    Cursor getLinkedCursor() {
        if (this.linkedCursor == null) {
            DesignerPane designerPane = this.webform.getPane();
            Image image = null;
            Point point = null;
            image = Utilities.loadImage((String)"org/netbeans/modules/visualweb/designer/resources/linked-cursor.gif");
            point = new Point(9, 9);
            Toolkit toolkit = designerPane.getToolkit();
            this.linkedCursor = toolkit.createCustomCursor(image, point, "CROSSLINKED_CURSOR");
        }
        return this.linkedCursor;
    }

    public static void stopCnCForWebForm(WebForm webForm) {
        if (webForm == null) {
            return;
        }
        webForm.getManager().mouseHandler.stopCnC();
    }

    private boolean isInsideBoxDecoration(CssBox cssBox, int n, int n2) {
        Decoration decoration = cssBox.getDecoration();
        if (decoration != null && this.webform.isShowDecorations()) {
            int n3 = cssBox.getAbsoluteX() + cssBox.getWidth();
            int n4 = cssBox.getAbsoluteY();
            int n5 = n3 + decoration.getWidth();
            int n6 = n4 + decoration.getHeight();
            return n >= n3 && n <= n5 && n2 >= n4 && n2 <= n6;
        }
        return false;
    }

    private static boolean isInside(CssBox cssBox, MouseEvent mouseEvent) {
        return mouseEvent.getX() >= cssBox.getAbsoluteX() && mouseEvent.getX() <= cssBox.getAbsoluteX() + cssBox.getWidth() && mouseEvent.getY() >= cssBox.getAbsoluteY() && mouseEvent.getY() <= cssBox.getAbsoluteY() + cssBox.getHeight();
    }

    private static boolean isBelow(CssBox cssBox, CssBox cssBox2) {
        if (cssBox2 == cssBox) {
            return true;
        }
        ContainerBox containerBox = cssBox2.getParent();
        if (containerBox == null) {
            return false;
        }
        return InteractionManager.isBelow(cssBox, containerBox);
    }

    public DomProvider.DomPosition findTextPosition(int n, int n2) {
        CssBox cssBox = ModelViewMapper.findBox(this.webform.getPane().getPageBox(), n, n2);
        CssBox cssBox2 = this.findInsertBox(cssBox);
        if (cssBox2 != null) {
            DomProvider.DomPosition domPosition = ModelViewMapper.viewToModel(this.webform, n, n2);
            if (this.getInlineEditor() == null || !this.getInlineEditor().isDocumentEditor()) {
                domPosition = ModelViewMapper.findValidPosition(this.webform, domPosition, true, this.webform.getManager().getInlineEditor());
            }
            return domPosition;
        }
        return DomProvider.DomPosition.NONE;
    }

    private static Element findMovableParentComponentRootElement(CssBox cssBox) {
        if (cssBox.getBoxType().isAbsolutelyPositioned() || cssBox.getParent().isGrid()) {
            return CssBox.getElementForComponentRootCssBox(cssBox);
        }
        CssBox cssBox2 = cssBox;
        for (ContainerBox containerBox = cssBox.getParent(); containerBox != null; containerBox = containerBox.getParent()) {
            Element element = CssBox.getElementForComponentRootCssBox(cssBox2);
            if (containerBox.isGrid()) {
                return element;
            }
            Element element2 = CssBox.getElementForComponentRootCssBox(containerBox);
            WebForm webForm = cssBox.getWebForm();
            if (webForm.getDomProviderService().isSpecialComponent(element2)) {
                return element;
            }
            if (containerBox.getBoxType().isPositioned()) {
                return element2;
            }
            cssBox2 = containerBox;
        }
        return null;
    }

    public void syncSelection(boolean bl) {
        this.finishInlineEditing(true);
        this.highlightedComponentRootElement = null;
        this.highlightedRegionElement = null;
    }

    private void selectDomInspectorBox(CssBox cssBox) {
        DomInspector.show(cssBox);
    }

    public static boolean isToggleEvent(MouseEvent mouseEvent) {
        return mouseEvent.isShiftDown() || Utilities.getOperatingSystem() != 4096 && mouseEvent.isControlDown();
    }

    public static boolean isMenuEvent(MouseEvent mouseEvent) {
        if (mouseEvent.isShiftDown()) {
            return false;
        }
        return mouseEvent.isPopupTrigger() || mouseEvent.getButton() != 1;
    }

    public static boolean isLinkingEvent(MouseEvent mouseEvent) {
        return mouseEvent.isShiftDown() && mouseEvent.isControlDown();
    }

    public static boolean isDomEvent(MouseEvent mouseEvent) {
        boolean bl;
        boolean bl2 = bl = Utilities.getOperatingSystem() == 4096;
        return bl ? mouseEvent.isAltDown() : mouseEvent.isControlDown() && mouseEvent.isAltDown();
    }

    private Element getSelectableParent(Element element) {
        if (element == null) {
            return null;
        }
        Element element2 = this.webform.getDomProviderService().getParentComponent(element);
        while (element2 != null) {
            if (ModelViewMapper.findBox(this.webform.getPane().getPageBox(), element2) == null) {
                element2 = this.webform.getDomProviderService().getParentComponent(element2);
                continue;
            }
            if (this.webform.getDomProviderService().isRootContainerComponent(element2)) {
                return null;
            }
            if (!this.webform.getDomProviderService().isSpecialComponent(element2)) break;
            return null;
        }
        return element2;
    }

    private static void processDefaultDecorationAction(final CssBox cssBox) {
        Decoration decoration = cssBox.getDecoration();
        if (decoration == null) {
            return;
        }
        Action action = decoration.getDefaultAction();
        final Action action2 = action instanceof ContextAwareAction ? ((ContextAwareAction)action).createContextAwareInstance(decoration.getContext()) : action;
        if (action2 != null) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    action2.actionPerformed(new ActionEvent(cssBox, -1, null));
                }
            });
        }
    }

    private void showDecorationPopupMenu(CssBox cssBox, Component component, int n, int n2) {
        Decoration decoration = cssBox.getDecoration();
        if (decoration == null) {
            return;
        }
        Action[] actionArray = decoration.getActions();
        if (actionArray.length == 0) {
            return;
        }
        this.webform.fireUserPopupActionPerformed(new DefaultDesignerPopupEvent(this.webform, component, actionArray, decoration.getContext(), n, n2));
    }

    void inlineEdit(final Element[] elementArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (Element element : elementArray) {
                    Element[] elementArray2;
                    if (element == null) continue;
                    boolean bl = InteractionManager.this.startInlineEditing(element, null, null, false, true, null, true);
                    if (bl) {
                        return;
                    }
                    for (Element element2 : elementArray2 = InteractionManager.this.webform.getDomProviderService().getChildComponents(element)) {
                        if (element2 == null || !(bl = InteractionManager.this.startInlineEditing(element2, null, null, false, true, null, true))) continue;
                        return;
                    }
                }
            }
        });
    }

    static boolean isReadOnlyRegion(DomProvider.DomPosition domPosition) {
        org.w3c.dom.Node node = domPosition.getNode();
        while (node != null && !((node = node.getParentNode()) instanceof Document)) {
        }
        return node == null;
    }

    private static TopComponent findCommonPaletteWindow() {
        return InteractionManager.findTopComponentOfId("CommonPalette");
    }

    private static TopComponent findTopComponentOfId(String string) {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(string);
        if (topComponent == null) {
            InteractionManager.info(new NullPointerException("TopComponent of id=" + string + " not found!"));
            return null;
        }
        return topComponent;
    }

    private static Transferable getTransferableFromCommonPalette(WebForm webForm) {
        Lookup lookup = webForm.getPaletteController().getSelectedItem();
        if (lookup == null) {
            return null;
        }
        Node node = (Node)lookup.lookup(Node.class);
        if (node == null) {
            return null;
        }
        try {
            return node.clipboardCopy();
        }
        catch (IOException iOException) {
            InteractionManager.info(iOException);
            return null;
        }
    }

    private static Transferable getTransferableFromExplorer(TopComponent topComponent) {
        Node node;
        ExplorerManager.Provider provider;
        Node[] nodeArray;
        if (topComponent instanceof ExplorerManager.Provider && (nodeArray = (provider = (ExplorerManager.Provider)topComponent).getExplorerManager().getSelectedNodes()) != null && nodeArray.length == 1 && (node = nodeArray[0]) != null) {
            try {
                return node.clipboardCopy();
            }
            catch (IOException iOException) {
                InteractionManager.info(iOException);
            }
        }
        return null;
    }

    void setIgnoreCnC(boolean bl) {
        this.ignoreCnC = bl;
    }

    private boolean isIgnoreCnC() {
        return this.ignoreCnC;
    }

    public Point getPastePoint() {
        Point point = this.getMouseHandler().getCurrentPos();
        if (point != null) {
            Point point2 = new Point(point);
            this.getMouseHandler().clearCurrentPos();
            return point2;
        }
        Element element = this.webform.getSelection().getPositionElement();
        if (element == null) {
            return null;
        }
        int n = CssProvider.getValueService().getCssLength(element, 41);
        int n2 = CssProvider.getValueService().getCssLength(element, 39);
        if (n != 0x7FFFFFFE || n2 != 0x7FFFFFFE) {
            if (n2 == 0x7FFFFFFE) {
                n2 = 0;
            }
            if (n == 0x7FFFFFFE) {
                n = 0;
            }
            int n3 = this.webform.getGridWidth();
            int n4 = this.webform.getGridHeight();
            return new Point(n2 + n3, n + n4);
        }
        return null;
    }

    private static Logger getLogger() {
        return Logger.getLogger(InteractionManager.class.getName());
    }

    private static void fine(Exception exception) {
        InteractionManager.getLogger().log(Level.FINE, null, exception);
    }

    private static void info(Exception exception) {
        InteractionManager.getLogger().log(Level.INFO, null, exception);
    }

    private static void info(String string) {
        InteractionManager.getLogger().info(string);
    }

    static class DefaultDesignerPopupEvent
    implements Designer.DesignerPopupEvent {
        private final Designer designer;
        private final Component component;
        private final Action[] actions;
        private final Lookup context;
        private final int x;
        private final int y;

        public DefaultDesignerPopupEvent(Designer designer, Component component, Action[] actionArray, Lookup lookup, int n, int n2) {
            this.designer = designer;
            this.component = component;
            this.actions = actionArray;
            this.context = lookup;
            this.x = n;
            this.y = n2;
        }

        public Component getComponent() {
            return this.component;
        }

        public Action[] getActions() {
            return this.actions;
        }

        public Lookup getContext() {
            return this.context;
        }

        public Designer getDesigner() {
            return this.designer;
        }

        public Designer.Box getBox() {
            return null;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }

    private static class DefaultDesignerClickEvent
    implements Designer.DesignerClickEvent {
        private boolean consumed;
        private final int clickCount;
        private final Designer designer;
        private final Designer.Box box;

        public DefaultDesignerClickEvent(Designer designer, Designer.Box box, int n) {
            this.designer = designer;
            this.box = box;
            this.clickCount = n;
        }

        public boolean isConsumed() {
            return this.consumed;
        }

        public void consume() {
            this.consumed = true;
        }

        public int getClickCount() {
            return this.clickCount;
        }

        public Designer getDesigner() {
            return this.designer;
        }

        public Designer.Box getBox() {
            return this.box;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private Point currentPos = new Point(-1, -1);
        private int menuPosX;
        private int menuPosY;
        private boolean dontCycleInClickHandler;
        private Timer cycleTimer;
        private Transferable cncTransferable;
        private WeakReference<TopComponent> cncOriginWRef = new WeakReference<Object>(null);

        public Point getCurrentPos() {
            if (this.currentPos.x >= 0 && this.currentPos.y >= 0) {
                return this.currentPos;
            }
            if (this.menuPosX >= 0) {
                return new Point(this.menuPosX, this.menuPosY);
            }
            return null;
        }

        public void clearCurrentPos() {
            this.currentPos.x = -1;
            this.currentPos.y = -1;
            this.menuPosX = -1;
            this.menuPosY = -1;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            DesignerPane designerPane = InteractionManager.this.webform.getPane();
            if (designerPane == null) {
                return;
            }
            PageBox pageBox = designerPane.getPageBox();
            if (pageBox == null) {
                return;
            }
            if (InteractionManager.isDomEvent(mouseEvent)) {
                CssBox cssBox = pageBox.findCssBox(mouseEvent.getX(), mouseEvent.getY());
                InteractionManager.this.selectDomInspectorBox(cssBox);
                return;
            }
            pageBox.setSelected(null);
            if (InteractionManager.this.inlineEditor != null) {
                InteractionManager.this.inlineEditor.checkInitialDoubleClick(mouseEvent);
            }
            if (!this.isCnCInProgress() && InteractionManager.this.inlineEditor != null && designerPane.hasCaret() && InteractionManager.this.inlineEditor.isEdited(ModelViewMapper.findBox(designerPane.getPageBox(), mouseEvent.getX(), mouseEvent.getY()))) {
                designerPane.mouseClicked(mouseEvent);
                return;
            }
            SelectionManager selectionManager = InteractionManager.this.webform.getSelection();
            CssBox cssBox = ModelViewMapper.findBox(designerPane.getPageBox(), mouseEvent.getX(), mouseEvent.getY());
            boolean bl = selectionManager.isBelowSelected(cssBox);
            DefaultDesignerClickEvent defaultDesignerClickEvent = new DefaultDesignerClickEvent(InteractionManager.this.webform, cssBox, mouseEvent.getClickCount());
            InteractionManager.this.webform.fireUserElementClicked(defaultDesignerClickEvent);
            if (defaultDesignerClickEvent.isConsumed()) {
                return;
            }
            if (!this.isCnCInProgress() && InteractionManager.this.insertModeBox != null && designerPane.hasCaret() && InteractionManager.isInside(InteractionManager.this.insertModeBox, mouseEvent) && !MouseUtils.isDoubleClick((MouseEvent)mouseEvent)) {
                designerPane.mouseClicked(mouseEvent);
                if (InteractionManager.this.inlineEditor == null && bl && !this.dontCycleInClickHandler) {
                    if (cssBox.getBoxType() == BoxType.TEXT) {
                        cssBox = cssBox.getParent();
                    }
                    if (InteractionManager.this.startInlineEditing(CssBox.getElementForComponentRootCssBox(cssBox), null, cssBox, true, true, null, false)) {
                        return;
                    }
                }
                return;
            }
            if (!InteractionManager.this.webform.isGridMode() && designerPane.hasCaret()) {
                designerPane.mouseClicked(mouseEvent);
            }
            if (MouseUtils.isDoubleClick((MouseEvent)mouseEvent)) {
                if (!InteractionManager.this.isInlineEditing()) {
                    if (InteractionManager.this.isInsideBoxDecoration(cssBox, mouseEvent.getX(), mouseEvent.getY())) {
                        InteractionManager.processDefaultDecorationAction(cssBox);
                    } else {
                        WebForm.DefaultDesignerEvent defaultDesignerEvent = new WebForm.DefaultDesignerEvent(InteractionManager.this.webform, cssBox);
                        InteractionManager.this.webform.fireUserActionPerformed(defaultDesignerEvent);
                    }
                }
            } else if (InteractionManager.isToggleEvent(mouseEvent)) {
                this.selectAt(mouseEvent, false);
            } else if (!this.dontCycleInClickHandler) {
                Object object;
                CssBox cssBox2;
                for (cssBox2 = cssBox; cssBox2 != null && ((object = CssBox.getComponentRootElementForCssBox(cssBox2)) == null || object == designerPane.getPageBox()); cssBox2 = cssBox2.getParent()) {
                }
                if (cssBox2 == null) {
                    object = InteractionManager.this.findInsertBox(cssBox);
                    InteractionManager.this.setInsertBox((CssBox)object, mouseEvent);
                } else {
                    object = CssBox.getComponentRootElementForCssBox(cssBox2);
                    if (InteractionManager.this.inlineEditor == null && selectionManager.isSelected((Element)object) && InteractionManager.this.startInlineEditing((Element)object, null, cssBox, true, true, null, false)) {
                        return;
                    }
                    this.requestCycle(mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }

        private void cancelCycleRequest() {
            if (this.cycleTimer != null) {
                this.cycleTimer.stop();
                this.cycleTimer = null;
            }
        }

        private void requestCycle(final int n, final int n2) {
            this.cancelCycleRequest();
            int n3 = DOUBLE_CLICK_DELTA;
            this.cycleTimer = new Timer(n3, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MouseHandler.this.cycleTimer = null;
                    MouseHandler.this.cycleSelection(n, n2);
                }
            });
            this.cycleTimer.setRepeats(false);
            this.cycleTimer.setCoalesce(true);
            this.cycleTimer.start();
        }

        private void cycleSelection(int n, int n2) {
            Element element;
            CssBox cssBox;
            for (cssBox = ModelViewMapper.findBox(InteractionManager.this.webform.getPane().getPageBox(), n, n2); cssBox != null && CssBox.getComponentRootElementForCssBox(cssBox) == null; cssBox = cssBox.getParent()) {
            }
            SelectionManager selectionManager = InteractionManager.this.webform.getSelection();
            CssBox cssBox2 = null;
            if (cssBox != null) {
                element = CssBox.getComponentRootElementForCssBox(cssBox);
                cssBox2 = element != null && selectionManager.isSelected(element) ? cssBox : selectionManager.getSelectedAncestor(cssBox);
            }
            if (cssBox2 != null) {
                element = CssBox.getComponentRootElementForCssBox(cssBox2);
                Element element2 = InteractionManager.this.getSelectableParent(element);
                boolean bl = false;
                while (element2 != null) {
                    CssBox cssBox3 = ModelViewMapper.findBox(InteractionManager.this.webform.getPane().getPageBox(), element2);
                    if (cssBox3 != null) {
                        selectionManager.selectComponents(new Element[]{element2}, true);
                        bl = true;
                        break;
                    }
                    element2 = InteractionManager.this.webform.getDomProviderService().getParentComponent(element2);
                }
                if (!bl && cssBox != cssBox2) {
                    selectionManager.selectComponents(new Element[]{CssBox.getComponentRootElementForCssBox(cssBox)}, true);
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            Object object;
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.currentPos.x = mouseEvent.getX();
                this.currentPos.y = mouseEvent.getY();
            }
            if (InteractionManager.this.interaction != null) {
                InteractionManager.this.setInsertBox(null, null);
            }
            DesignerPane designerPane = InteractionManager.this.webform.getPane();
            if (!this.isCnCInProgress() && InteractionManager.this.inlineEditor != null && designerPane.hasCaret()) {
                designerPane.mouseDragged(mouseEvent);
                return;
            }
            if (!this.isCnCInProgress() && InteractionManager.this.insertModeBox != null && designerPane.hasCaret() && InteractionManager.isInside(InteractionManager.this.insertModeBox, mouseEvent)) {
                object = ModelViewMapper.findBox(designerPane.getPageBox(), mouseEvent.getX(), mouseEvent.getY());
                if (CssBox.getElementForComponentRootCssBox((CssBox)object) == null) {
                    designerPane.mouseDragged(mouseEvent);
                    return;
                }
            } else if (!InteractionManager.this.webform.isGridMode() && designerPane.hasCaret()) {
                designerPane.mouseDragged(mouseEvent);
            }
            object = mouseEvent.getPoint();
            InteractionManager.translateMousePos((Point)object, (Component)mouseEvent.getSource());
            if (InteractionManager.this.interaction != null) {
                InteractionManager.this.interaction.mouseDragged(mouseEvent);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Object object;
            CssBox cssBox;
            Element element;
            int n;
            PageBox pageBox;
            int n2;
            DesignerPane designerPane = InteractionManager.this.webform.getPane();
            designerPane.requestFocus();
            this.cancelCycleRequest();
            this.dontCycleInClickHandler = false;
            if (InteractionManager.isDomEvent(mouseEvent)) {
                return;
            }
            Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY(), designerPane);
            int n3 = point.x;
            int n4 = point.y;
            SelectionManager selectionManager = InteractionManager.this.webform.getSelection();
            int n5 = selectionManager.getSelectionHandleDir(n3, n4, n2 = (pageBox = designerPane.getPageBox()).getWidth(), n = pageBox.getHeight());
            if (n5 == 13) {
                element = selectionManager.getSelectionHandleView(n3, n4, n2, n);
                cssBox = ModelViewMapper.findBoxForComponentRootElement(pageBox, element);
            } else {
                cssBox = ModelViewMapper.findBox(pageBox, n3, n4);
                element = ModelViewMapper.findElement(cssBox);
            }
            if (InteractionManager.this.inlineEditor != null) {
                object = ModelViewMapper.findBox(pageBox, mouseEvent.getX(), mouseEvent.getY());
                if (!InteractionManager.this.inlineEditor.isEdited((CssBox)object)) {
                    InteractionManager.this.finishInlineEditing(false);
                }
            }
            if (!this.isCnCInProgress() && InteractionManager.this.inlineEditor != null && designerPane.hasCaret()) {
                if ((CssBox.getElementForComponentRootCssBox(cssBox) == null || cssBox == pageBox) && InteractionManager.this.inlineEditor.isEdited(cssBox)) {
                    designerPane.mousePressed(mouseEvent);
                }
            } else if (!this.isCnCInProgress() && InteractionManager.this.insertModeBox != null && designerPane.hasCaret() && InteractionManager.isInside(InteractionManager.this.insertModeBox, mouseEvent)) {
                designerPane.mousePressed(mouseEvent);
            } else if (!this.isCnCInProgress() && !InteractionManager.this.webform.isGridMode()) {
                if (!designerPane.hasCaret()) {
                    designerPane.createCaret();
                }
                designerPane.mousePressed(mouseEvent);
            }
            if (InteractionManager.isMenuEvent(mouseEvent)) {
                this.dontCycleInClickHandler = true;
                this.ensurePointSelected(mouseEvent);
                this.menuPosX = mouseEvent.getX();
                this.menuPosY = mouseEvent.getY();
                object = ModelViewMapper.findBox(pageBox, mouseEvent.getX(), mouseEvent.getY());
                Element element2 = null;
                if (object != null) {
                    element2 = ((CssBox)object).getElement();
                }
                if (InteractionManager.this.isInsideBoxDecoration((CssBox)object, mouseEvent.getX(), mouseEvent.getY())) {
                    InteractionManager.this.showDecorationPopupMenu((CssBox)object, mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else {
                    InteractionManager.this.webform.fireUserPopupActionPerformed(new DefaultDesignerPopupEvent(InteractionManager.this.webform, mouseEvent.getComponent(), null, null, point.x, point.y));
                }
                return;
            }
            if (this.isCnCInProgress()) {
                InteractionManager.this.setInsertBox(null, null);
                object = cssBox.isGrid() ? cssBox : null;
                InteractionManager.this.sizer = new Marquee(InteractionManager.this.webform, (CssBox)object);
                InteractionManager.this.sizer.setSelect(false);
                InteractionManager.this.sizer.setSnapToGrid(InteractionManager.this.webform.isGridSnap());
                InteractionManager.this.sizer.setInsertCursor(true);
                InteractionManager.this.interaction = InteractionManager.this.sizer;
                InteractionManager.this.interaction.mousePressed(mouseEvent);
                return;
            }
            if (n4 > selectionManager.selectionViewPos) {
                selectionManager.selectAncestor(n3, n4);
                return;
            }
            if (n5 != 0 && n5 != 13) {
                object = selectionManager.getSelectionHandleView(n3, n4, n2, n);
                CssBox cssBox2 = ModelViewMapper.findBoxForComponentRootElement(InteractionManager.this.webform.getPane().getPageBox(), (Element)object);
                if (cssBox2 == null) {
                    return;
                }
                List<Rectangle> list = ModelViewMapper.getComponentRectangles(InteractionManager.this.webform.getPane().getPageBox(), (Element)object);
                Rectangle rectangle = list != null && list.size() > 0 ? list.get(0) : ModelViewMapper.getComponentBounds(InteractionManager.this.webform.getPane().getPageBox(), (Element)object);
                boolean bl = Resizer.hasMaintainAspectRatioResizeConstraint(Resizer.getResizeConstraints(InteractionManager.this.webform, (Element)object));
                InteractionManager.this.interaction = new Resizer(InteractionManager.this.webform, (Element)object, cssBox2, n5, rectangle, bl);
                InteractionManager.this.interaction.mousePressed(mouseEvent);
            } else {
                if (InteractionManager.isLinkingEvent(mouseEvent)) {
                    int n6 = 0;
                    ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>(n6);
                    ArrayList<CssBox> arrayList2 = new ArrayList<CssBox>(n6);
                    Element[] elementArray = new Element[]{};
                    InteractionManager.this.dragger = new Dragger(InteractionManager.this.webform, arrayList2, arrayList, elementArray);
                    InteractionManager.this.interaction = InteractionManager.this.dragger;
                    InteractionManager.this.interaction.mousePressed(mouseEvent);
                    return;
                }
                if (element == null || cssBox == null || cssBox == designerPane.getPageBox() || cssBox.isGrid() && (mouseEvent.isShiftDown() || mouseEvent.isControlDown())) {
                    InteractionManager.this.setInsertBox(null, null);
                    if (cssBox != null && cssBox.isGrid()) {
                        InteractionManager.this.interaction = new Marquee(InteractionManager.this.webform, cssBox);
                        InteractionManager.this.interaction.mousePressed(mouseEvent);
                    } else if (!selectionManager.isSelectionEmpty()) {
                        selectionManager.clearSelection(true);
                    }
                } else {
                    Object object2;
                    Object object3;
                    if ((cssBox.getBoxType() == BoxType.TEXT || cssBox.getBoxType() == BoxType.SPACE) && InteractionManager.this.inlineEditor != null && InteractionManager.this.inlineEditor.isEdited(cssBox)) {
                        this.dontCycleInClickHandler = this.ensurePointSelected(mouseEvent);
                        return;
                    }
                    if ((cssBox.getBoxType() == BoxType.TEXT || cssBox.getBoxType() == BoxType.SPACE) && InteractionManager.this.insertModeBox != null && InteractionManager.isBelow(InteractionManager.this.insertModeBox, cssBox)) {
                        if (cssBox instanceof TextBox) {
                            object3 = (TextBox)cssBox;
                            object = ((TextBox)object3).getNode();
                            object2 = ((TextBox)object3).getFirstPosition();
                        } else if (cssBox instanceof SpaceBox) {
                            object3 = (SpaceBox)cssBox;
                            object = ((SpaceBox)object3).getNode();
                            object2 = ((SpaceBox)object3).getFirstPosition();
                        } else {
                            object = null;
                            object2 = DomProvider.DomPosition.NONE;
                        }
                        if (object != null && ModelViewMapper.isValidPosition(InteractionManager.this.webform, (DomProvider.DomPosition)object2, false, InteractionManager.this.webform.getManager().getInlineEditor())) {
                            if (!selectionManager.isBelowSelected(cssBox) && !selectionManager.isSelectionEmpty()) {
                                selectionManager.clearSelection(true);
                            }
                            this.dontCycleInClickHandler = this.ensurePointSelected(mouseEvent);
                            return;
                        }
                    }
                    InteractionManager.this.interaction = cssBox.getInternalResizer(n3, n4);
                    if (InteractionManager.this.interaction != null) {
                        InteractionManager.this.interaction.mousePressed(mouseEvent);
                        return;
                    }
                    this.dontCycleInClickHandler = this.ensurePointSelected(mouseEvent);
                    int n7 = selectionManager.getNumSelected() + 1;
                    object2 = new ArrayList(n7);
                    object3 = new ArrayList(n7);
                    ArrayList<Element> arrayList = new ArrayList<Element>(n7);
                    for (Element element2 : selectionManager.getSelectedComponentRootElements()) {
                        Rectangle rectangle;
                        CssBox cssBox2 = ModelViewMapper.findBoxForComponentRootElement(InteractionManager.this.webform.getPane().getPageBox(), element2);
                        if (cssBox2 == null) {
                            InteractionManager.info("No box found for element=" + element2);
                            continue;
                        }
                        if (cssBox2 == designerPane.getPageBox() || (rectangle = ModelViewMapper.getComponentBounds(InteractionManager.this.webform.getPane().getPageBox(), element2)) == null) continue;
                        this.addDragItem((List<Rectangle>)object2, (List<CssBox>)object3, arrayList, rectangle, point, cssBox2);
                    }
                    if (!selectionManager.isSelected(element)) {
                        Rectangle rectangle = ModelViewMapper.findShape(pageBox, element);
                        CssBox cssBox3 = ModelViewMapper.findBoxForComponentRootElement(pageBox, element);
                        if (rectangle != null) {
                            this.addDragItem((List<Rectangle>)object2, (List<CssBox>)object3, arrayList, rectangle, point, cssBox3);
                        }
                    }
                    if (object2.size() > 0) {
                        InteractionManager.this.dragger = new Dragger(InteractionManager.this.webform, (List<CssBox>)object3, (List<Rectangle>)object2, arrayList.toArray(new Element[arrayList.size()]));
                        InteractionManager.this.interaction = InteractionManager.this.dragger;
                        InteractionManager.this.interaction.mousePressed(mouseEvent);
                    }
                }
            }
        }

        private boolean ensurePointSelected(MouseEvent mouseEvent) {
            Element element;
            CssBox cssBox = ModelViewMapper.findBox(InteractionManager.this.webform.getPane().getPageBox(), mouseEvent.getX(), mouseEvent.getY());
            SelectionManager selectionManager = InteractionManager.this.webform.getSelection();
            CssBox cssBox2 = null;
            if (cssBox != null) {
                element = CssBox.getElementForComponentRootCssBox(cssBox);
                cssBox2 = element != null && selectionManager.isSelected(element) ? cssBox : selectionManager.getSelectedAncestor(cssBox);
            }
            if (cssBox2 == null && !InteractionManager.isToggleEvent(mouseEvent)) {
                this.selectAt(mouseEvent, true);
                return true;
            }
            element = CssBox.getElementForComponentRootCssBox(cssBox2);
            if (selectionManager.getPrimary() != element) {
                selectionManager.setPrimary(element);
                InteractionManager.this.webform.getPane().repaint();
            }
            return false;
        }

        private void addDragItem(List<Rectangle> list, List<CssBox> list2, List<Element> list3, Rectangle rectangle, Point point, CssBox cssBox) {
            Element element = CssBox.getElementForComponentRootCssBox(cssBox);
            Element element2 = InteractionManager.findMovableParentComponentRootElement(cssBox);
            if (element2 == null) {
                element2 = element;
            }
            if (element2 != element) {
                element = element2;
                if (list3.contains(element)) {
                    return;
                }
                cssBox = ModelViewMapper.findBoxForComponentRootElement(InteractionManager.this.webform.getPane().getPageBox(), element2);
                if (cssBox == null) {
                    InteractionManager.info("Didn't find box for " + element2);
                    return;
                }
                rectangle = new Rectangle(cssBox.getAbsoluteX(), cssBox.getAbsoluteY(), cssBox.getWidth(), cssBox.getHeight());
            }
            Rectangle rectangle2 = new Rectangle(rectangle.x - point.x, rectangle.y - point.y, rectangle.width, rectangle.height);
            list.add(rectangle2);
            list2.add(cssBox);
            list3.add(element);
        }

        public void escape() {
            DesignerPane designerPane = InteractionManager.this.webform.getPane();
            PageBox pageBox = designerPane.getPageBox();
            if (InteractionManager.this.inlineEditor != null) {
                designerPane.setCursor(Cursor.getPredefinedCursor(0));
                InteractionManager.this.finishInlineEditing(true);
            } else if (pageBox.getSelected() != null) {
                CssBox cssBox = null;
                org.w3c.dom.Node node = pageBox.getSelected().getElement().getParentNode();
                if (node instanceof Element) {
                    cssBox = ModelViewMapper.findBox(pageBox, (Element)node);
                }
                if (cssBox == null) {
                    cssBox = pageBox.getSelected().getParent();
                }
                while (cssBox instanceof LineBox || cssBox instanceof LineBoxGroup) {
                    cssBox = cssBox.getParent();
                }
                if (cssBox != null) {
                    InteractionManager.this.selectDomInspectorBox(cssBox);
                }
                return;
            }
            if (InteractionManager.this.insertModeBox != null) {
                InteractionManager.this.setInsertBox(null, null);
                designerPane.setCursor(Cursor.getPredefinedCursor(0));
                designerPane.repaint();
            } else if (InteractionManager.this.interaction != null) {
                if (InteractionManager.this.sizer != null) {
                    InteractionManager.this.sizer = null;
                    if (this.isCnCInProgress()) {
                        this.stopCnC();
                    }
                }
                InteractionManager.this.dragger = null;
                InteractionManager.this.interaction.cancel(designerPane);
                InteractionManager.this.interaction = null;
                designerPane.setCursor(Cursor.getPredefinedCursor(0));
            } else if (this.isCnCInProgress()) {
                this.stopCnC();
                designerPane.setCursor(Cursor.getPredefinedCursor(0));
            } else {
                Element element = InteractionManager.this.getDefaultSelectionComponentRootElement();
                Element element2 = InteractionManager.this.getSelectableParent(element);
                if (element2 != null) {
                    InteractionManager.this.webform.getSelection().selectComponent(element2);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            Object object;
            DesignerPane designerPane = InteractionManager.this.webform.getPane();
            if (!this.isCnCInProgress() && InteractionManager.this.inlineEditor != null && designerPane.hasCaret()) {
                object = ModelViewMapper.findBox(designerPane.getPageBox(), mouseEvent.getX(), mouseEvent.getY());
                if (CssBox.getElementForComponentRootCssBox((CssBox)object) == null && InteractionManager.this.inlineEditor.isEdited((CssBox)object)) {
                    designerPane.mouseReleased(mouseEvent);
                }
            } else if (!this.isCnCInProgress() && InteractionManager.this.insertModeBox != null && designerPane.hasCaret() && InteractionManager.isInside(InteractionManager.this.insertModeBox, mouseEvent)) {
                object = ModelViewMapper.findBox(designerPane.getPageBox(), mouseEvent.getX(), mouseEvent.getY());
                if (CssBox.getElementForComponentRootCssBox((CssBox)object) == null) {
                    designerPane.mouseReleased(mouseEvent);
                }
            } else if (!InteractionManager.this.webform.isGridMode() && designerPane.hasCaret()) {
                designerPane.mouseReleased(mouseEvent);
            }
            if (InteractionManager.this.sizer != null) {
                object = InteractionManager.this.sizer.getBounds();
                InteractionManager.this.interaction.mouseReleased(mouseEvent);
                InteractionManager.this.interaction = null;
                InteractionManager.this.sizer = null;
                if (this.isCnCInProgress()) {
                    Transferable transferable = this.cncTransferable;
                    this.stopCnC();
                    DndHandler dndHandler = designerPane.getDndHandler();
                    this.dontCycleInClickHandler = true;
                    Point point = ((Rectangle)object).width == 0 && ((Rectangle)object).height == 0 ? mouseEvent.getPoint() : new Point(((Rectangle)object).x, ((Rectangle)object).y);
                    InteractionManager.this.updateDropState(point, true, null);
                    InteractionManager.translateMousePos(point, (Component)mouseEvent.getSource());
                    Dimension dimension = ((Rectangle)object).getSize();
                    if (dimension.width > 2 || dimension.height > 2) {
                        dndHandler.setDropSize(dimension);
                    }
                    Transferable transferable2 = null;
                    if (transferable == null) {
                        InteractionManager.info(new IllegalStateException("Invalid item=" + transferable));
                    } else {
                        transferable2 = transferable;
                    }
                    int n = dndHandler.getDropType(point, transferable2, false);
                    if (n != 0 && transferable2 != null) {
                        dndHandler.importData(designerPane, transferable2);
                    }
                    this.mouseMoved(mouseEvent);
                }
            } else if (InteractionManager.this.dragger != null) {
                boolean bl = InteractionManager.this.dragger.hasMoved();
                InteractionManager.this.interaction.mouseReleased(mouseEvent);
                InteractionManager.this.interaction = null;
                InteractionManager.this.dragger = null;
                SelectionManager selectionManager = InteractionManager.this.webform.getSelection();
            } else if (InteractionManager.this.interaction != null) {
                InteractionManager.this.interaction.mouseReleased(mouseEvent);
                InteractionManager.this.interaction = null;
            }
        }

        public void selectAt(MouseEvent mouseEvent, boolean bl) {
            Point point = mouseEvent.getPoint();
            InteractionManager.translateMousePos(point, (Component)mouseEvent.getSource());
            int n = point.x;
            int n2 = point.y;
            SelectionManager selectionManager = InteractionManager.this.webform.getSelection();
            if (point.y > selectionManager.selectionViewPos) {
                selectionManager.selectAncestor(point.x, point.y);
            }
            Element element = null;
            CssBox cssBox = ModelViewMapper.findBox(InteractionManager.this.webform.getPane().getPageBox(), n, n2);
            if (cssBox != null && !(cssBox instanceof PageBox)) {
                element = ModelViewMapper.findComponentRootElement(cssBox);
            }
            if (element != null) {
                boolean bl2;
                CssBox cssBox2;
                selectionManager.setPrimary(element);
                CssBox cssBox3 = ModelViewMapper.findBoxForComponentRootElement(InteractionManager.this.webform.getPane().getPageBox(), element);
                CssBox cssBox4 = null;
                if (bl) {
                    cssBox2 = selectionManager.getSelectedAncestor(cssBox3);
                    if (cssBox2 != null && cssBox2 != cssBox3) {
                        element = CssBox.getElementForComponentRootCssBox(cssBox2);
                    }
                } else {
                    cssBox2 = selectionManager.isSelected(element) ? cssBox3 : null;
                }
                boolean bl3 = bl2 = cssBox2 != null;
                if (InteractionManager.isToggleEvent(mouseEvent)) {
                    this.dontCycleInClickHandler = true;
                    if (bl2) {
                        selectionManager.removeSelected(element, false);
                    } else {
                        selectionManager.addSelected(element, false);
                    }
                } else if (bl2 && mouseEvent.getButton() == 1) {
                    cssBox4 = cssBox2;
                } else if (!bl2) {
                    selectionManager.clearSelection(false);
                    selectionManager.addSelected(element, false);
                }
                cssBox4 = InteractionManager.this.findInsertBox(cssBox4);
                InteractionManager.this.setInsertBox(cssBox4, mouseEvent);
                selectionManager.updateSelectionImmediate();
                InteractionManager.this.webform.getPane().repaint();
                InteractionManager.this.selectedBox = null;
            } else {
                if (cssBox != null) {
                    cssBox = InteractionManager.this.findInsertBox(cssBox);
                    if (InteractionManager.this.selectedBox == cssBox) {
                        InteractionManager.this.setInsertBox(cssBox, mouseEvent);
                    } else {
                        InteractionManager.this.setInsertBox(null, null);
                    }
                } else {
                    InteractionManager.this.setInsertBox(null, null);
                }
                InteractionManager.this.selectedBox = cssBox;
                selectionManager.clearSelectionImmediate();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 0) {
                InteractionManager.this.setIgnoreCnC(false);
            }
            this.tryStartCnC();
        }

        private void tryStartCnC() {
            if (InteractionManager.this.isIgnoreCnC()) {
                InteractionManager.this.setIgnoreCnC(false);
                this.cncTransferable = null;
                return;
            }
            TopComponent topComponent = TopComponent.getRegistry().getActivated();
            this.cncOriginWRef = new WeakReference<TopComponent>(topComponent);
            if (topComponent == null) {
                this.cncTransferable = null;
                return;
            }
            this.cncTransferable = topComponent == InteractionManager.findCommonPaletteWindow() ? InteractionManager.getTransferableFromCommonPalette(InteractionManager.this.webform) : (topComponent instanceof ExplorerManager.Provider ? InteractionManager.getTransferableFromExplorer(topComponent) : null);
        }

        private boolean isCnCInProgress() {
            return this.cncTransferable != null;
        }

        private void stopCnC() {
            this.cncTransferable = null;
            TopComponent topComponent = (TopComponent)this.cncOriginWRef.get();
            if (topComponent instanceof ExplorerManager.Provider) {
                this.clearExplorerManager(((ExplorerManager.Provider)topComponent).getExplorerManager());
            } else {
                this.clearPaletteSelection();
            }
        }

        private void clearExplorerManager(ExplorerManager explorerManager) {
            try {
                if (explorerManager == null) {
                    return;
                }
                explorerManager.setSelectedNodes(new Node[0]);
            }
            catch (PropertyVetoException propertyVetoException) {
                InteractionManager.fine(propertyVetoException);
            }
        }

        private void clearPaletteSelection() {
            WebForm webForm = InteractionManager.this.webform;
            if (webForm == null) {
                return;
            }
            PaletteController paletteController = webForm.getPaletteController();
            if (paletteController == null) {
                return;
            }
            paletteController.clearSelection();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.currentPos.x = -1;
            this.currentPos.y = -1;
            this.stopCnC();
            InteractionManager.this.webform.getPane().getDndHandler().clearDropMatch();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            int n;
            this.currentPos.x = mouseEvent.getX();
            this.currentPos.y = mouseEvent.getY();
            if (InteractionManager.this.dragger != null) {
                try {
                    InteractionManager.this.interaction.mouseDragged(mouseEvent);
                }
                catch (Exception exception) {
                    InteractionManager.info(exception);
                    this.escape();
                }
                return;
            }
            Point point = mouseEvent.getPoint();
            if (InteractionManager.this.sizer != null || this.isCnCInProgress()) {
                InteractionManager.this.updateDropState(point, false, null);
                return;
            }
            InteractionManager.translateMousePos(point, (Component)mouseEvent.getSource());
            int n2 = point.x;
            int n3 = point.y;
            SelectionManager selectionManager = InteractionManager.this.webform.getSelection();
            DesignerPane designerPane = InteractionManager.this.webform.getPane();
            PageBox pageBox = designerPane.getPageBox();
            if (pageBox == null) {
                return;
            }
            int n4 = pageBox.getWidth();
            int n5 = selectionManager.getSelectionHandleDir(n2, n3, n4, n = pageBox.getHeight());
            if (n5 != 0) {
                designerPane.setCursor(Cursor.getPredefinedCursor(n5));
                return;
            }
            CssBox cssBox = ModelViewMapper.findBox(pageBox, n2, n3);
            Element element = CssBox.getElementForComponentRootCssBox(cssBox);
            Element element2 = ModelViewMapper.findElement(pageBox, n2, n3);
            int n6 = cssBox.getInternalResizeDirection(n2, n3);
            if (n6 != 0) {
                designerPane.setCursor(Cursor.getPredefinedCursor(n6));
            } else if (InteractionManager.this.selectedBox != null && InteractionManager.isInside(InteractionManager.this.selectedBox, mouseEvent)) {
                designerPane.setCursor(Cursor.getPredefinedCursor(2));
            } else if (InteractionManager.this.inlineEditor != null && InteractionManager.this.inlineEditor.isEdited(cssBox)) {
                if (cssBox != pageBox && element != null) {
                    designerPane.setCursor(Cursor.getPredefinedCursor(13));
                } else {
                    designerPane.setCursor(Cursor.getPredefinedCursor(2));
                }
            } else if (InteractionManager.this.insertModeBox != null && InteractionManager.isInside(InteractionManager.this.insertModeBox, mouseEvent)) {
                if (cssBox != pageBox && element != null) {
                    designerPane.setCursor(Cursor.getPredefinedCursor(13));
                } else {
                    designerPane.setCursor(Cursor.getPredefinedCursor(2));
                }
            } else if (element2 != null && cssBox != pageBox) {
                designerPane.setCursor(Cursor.getPredefinedCursor(13));
            } else {
                designerPane.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }
}

