/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.css2;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.visualweb.api.designer.DomProvider;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssProvider;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssValue;
import org.netbeans.modules.visualweb.css2.BoxList;
import org.netbeans.modules.visualweb.css2.BoxType;
import org.netbeans.modules.visualweb.css2.ContainerBox;
import org.netbeans.modules.visualweb.css2.CssBox;
import org.netbeans.modules.visualweb.css2.FormatContext;
import org.netbeans.modules.visualweb.css2.LineBox;
import org.netbeans.modules.visualweb.css2.ModelViewMapper;
import org.netbeans.modules.visualweb.css2.PageBox;
import org.netbeans.modules.visualweb.css2.SpaceBox;
import org.netbeans.modules.visualweb.css2.TableBox;
import org.netbeans.modules.visualweb.css2.TextBox;
import org.netbeans.modules.visualweb.designer.CssUtilities;
import org.netbeans.modules.visualweb.designer.DesignerPane;
import org.netbeans.modules.visualweb.designer.WebForm;
import org.openide.ErrorManager;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineBoxGroup
extends ContainerBox {
    private final FontMetrics metrics;
    private LineBox lineBox = null;
    private int targetY;
    List<CssBox> floats = null;
    private BoxList allBoxes;

    public LineBoxGroup(WebForm webForm, Element element, FontMetrics fontMetrics) {
        super(webForm, element, BoxType.LINEBOX, true, false);
        this.metrics = fontMetrics;
        this.effectiveTopMargin = 0;
        this.effectiveBottomMargin = 0;
    }

    @Override
    protected void initialize() {
        this.effectiveTopMargin = 0;
        this.effectiveBottomMargin = 0;
    }

    @Override
    protected void initializeInvariants() {
    }

    @Override
    protected void initializeBackground() {
    }

    public FontMetrics getMetrics() {
        return this.metrics;
    }

    public boolean isEmpty() {
        return this.allBoxes == null || this.allBoxes.size() == 0;
    }

    @Override
    protected void addBox(CssBox cssBox, CssBox cssBox2, CssBox cssBox3) {
        Element element;
        CssBox cssBox4;
        Element element2;
        Element element3;
        assert (cssBox.isInlineBox() || cssBox.getBoxType() == BoxType.FLOAT);
        if (this.allBoxes == null) {
            this.allBoxes = new BoxList(10);
        } else if (cssBox.getBoxType() == BoxType.SPACE && this.allBoxes != null && this.allBoxes.get(this.allBoxes.size() - 1).getBoxType() == BoxType.SPACE) {
            return;
        }
        if (cssBox2 != null && (element3 = ModelViewMapper.findClosestComponentRootElement(this.webform, cssBox.getElement())) != (element2 = ModelViewMapper.findClosestComponentRootElement(this.webform, cssBox2.getElement()))) {
            cssBox4 = LineBoxGroup.getNextCssBox(this.allBoxes, cssBox2);
            while (cssBox4 != null && element2 == (element = ModelViewMapper.findClosestComponentRootElement(this.webform, cssBox4.getElement()))) {
                cssBox2 = cssBox4;
                cssBox3 = null;
                cssBox4 = LineBoxGroup.getNextCssBox(this.allBoxes, cssBox4);
            }
        }
        if (cssBox3 != null && (element3 = ModelViewMapper.findClosestComponentRootElement(this.webform, cssBox.getElement())) != (element2 = ModelViewMapper.findClosestComponentRootElement(this.webform, cssBox3.getElement()))) {
            cssBox4 = LineBoxGroup.getPreviousCssBox(this.allBoxes, cssBox3);
            while (cssBox4 != null && (element = ModelViewMapper.findClosestComponentRootElement(this.webform, cssBox4.getElement())) == element2) {
                cssBox2 = null;
                cssBox3 = cssBox4;
                cssBox4 = LineBoxGroup.getPreviousCssBox(this.allBoxes, cssBox4);
            }
        }
        this.allBoxes.add(cssBox, cssBox2, cssBox3);
        cssBox.setParent(this);
        cssBox.setPositionedBy(this);
    }

    private static CssBox getNextCssBox(BoxList boxList, CssBox cssBox) {
        int n;
        if (boxList == null || cssBox == null) {
            return null;
        }
        int n2 = boxList.indexOf(cssBox);
        int n3 = n = n2 < boxList.size() - 1 ? n2 + 1 : -1;
        if (n == -1) {
            return null;
        }
        return boxList.get(n);
    }

    private static CssBox getPreviousCssBox(BoxList boxList, CssBox cssBox) {
        int n;
        if (boxList == null || cssBox == null) {
            return null;
        }
        int n2 = boxList.indexOf(cssBox);
        int n3 = n = n2 > 0 ? n2 - 1 : -1;
        if (n == -1) {
            return null;
        }
        return boxList.get(n);
    }

    @Override
    protected boolean removeBox(CssBox cssBox) {
        ContainerBox containerBox;
        if (this.allBoxes == null) {
            ErrorManager.getDefault().log("Unexpected removeBox " + cssBox + ": lbg already empty");
            return false;
        }
        boolean bl = this.allBoxes.remove(cssBox);
        if (this.allBoxes.size() == 0 && (containerBox = this.getParent()) != null) {
            containerBox.removeBox(this);
        }
        return bl;
    }

    @Override
    protected CssBox[] getBoxesToRemove(CssBox cssBox) {
        Element element = cssBox.getElement();
        if (element != null) {
            int n = this.allBoxes.size();
            ArrayList<CssBox> arrayList = new ArrayList<CssBox>();
            for (int i = 0; i < n; ++i) {
                CssBox cssBox2 = this.allBoxes.get(i);
                if (cssBox2 == null || !LineBoxGroup.isSameOrParentElementOf(element, cssBox2.getElement())) continue;
                arrayList.add(cssBox2);
            }
            return arrayList.toArray(new CssBox[arrayList.size()]);
        }
        return new CssBox[]{cssBox};
    }

    @Override
    protected CssBox notifyChildResize(CssBox cssBox, FormatContext formatContext) {
        int n = this.contentHeight;
        this.relayout(formatContext);
        ContainerBox containerBox = this.getParent();
        if (this.contentHeight != n) {
            return containerBox.notifyChildResize(this, formatContext);
        }
        containerBox.positionBox(this, formatContext);
        return this;
    }

    @Override
    protected void layoutChild(CssBox cssBox, FormatContext formatContext, boolean bl) {
    }

    private void addToLineBox(FormatContext formatContext, CssBox cssBox) {
        if (this.lineBox == null) {
            int n = formatContext.getMaxWidth(this, this.targetY);
            int n2 = 0;
            Element element = this.getElement();
            if (super.getBoxCount() == 0 && element != null && (n2 = CssUtilities.getCssLength(element, 52)) == 0x7FFFFFFE) {
                n2 = 0;
            }
            this.lineBox = new LineBox(this.webform, element, n, n2);
            this.lineBox.setParent(this);
            this.lineBox.setContainingBlock(this.containingBlockX, this.containingBlockY, this.containingBlockWidth, this.containingBlockHeight);
        }
        this.lineBox.addBox(cssBox, null, null);
    }

    @Override
    public void relayout(FormatContext formatContext) {
        if (this.allBoxes == null) {
            return;
        }
        this.removeBoxes();
        this.targetY = 0;
        this.lineBox = null;
        this.contentWidth = 0;
        this.contentHeight = 0;
        this.relayoutChildren(formatContext, this.allBoxes, this.getElement());
        this.finishLine(formatContext);
        this.width = this.contentWidth;
        this.height = this.contentHeight;
    }

    private void relayoutChildren(FormatContext formatContext, BoxList boxList, Element element) {
        CssValue cssValue;
        if (boxList == null) {
            return;
        }
        int n = boxList.size();
        boolean bl = true;
        if (element != null) {
            cssValue = CssProvider.getEngineService().getComputedValueForElement(element, 57);
            bl = CssProvider.getValueService().isNormalValue(cssValue);
        }
        cssValue = new ArrayList();
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            CssBox cssBox = boxList.get(i);
            if (cssValue.contains(cssBox)) continue;
            if (cssBox.getBoxType() == BoxType.FLOAT || cssBox.getBoxType() == BoxType.RELATIVE) {
                if (cssBox.isInlineBox() && !cssBox.isReplacedBox() && cssBox instanceof ContainerBox && cssBox.getBoxType() != BoxType.FLOAT) {
                    LineBox lineBox = this.lineBox;
                    n3 = this.targetY;
                    n2 = this.contentWidth;
                    int n4 = this.contentHeight;
                    int n5 = 0;
                    this.lineBox = new LineBox(this.webform, cssBox.getElement(), this.containingBlockWidth, n5);
                    this.lineBox.isFloated = cssBox.getBoxType() == BoxType.FLOAT;
                    this.lineBox.setParent(this);
                    this.lineBox.setContainingBlock(this.containingBlockX, this.containingBlockY, this.containingBlockWidth, this.containingBlockHeight);
                    this.relayoutChildren(formatContext, ((ContainerBox)cssBox).getBoxList(), cssBox.getElement());
                    this.finishLine(formatContext);
                    this.lineBox = lineBox;
                    this.targetY = n3;
                    this.contentWidth = n2;
                    this.contentHeight = n4;
                } else if (cssBox.getBoxType() == BoxType.RELATIVE) {
                    super.layoutChild(cssBox, formatContext, true);
                    this.addToLineBox(formatContext, cssBox);
                } else {
                    assert (cssBox.getBoxType() == BoxType.FLOAT);
                    if (this.floats == null) {
                        this.floats = new ArrayList<CssBox>();
                    }
                    super.addBox(cssBox, null, null);
                    this.floats.add(cssBox);
                }
                if (this.lineBox != null && !this.lineBox.isEmpty() || this.floats == null) continue;
                this.finishFloats(formatContext);
                continue;
            }
            if (cssBox.getBoxType() == BoxType.SPACE) {
                if (!bl || this.lineBox == null || this.lineBox.isEmpty() || this.lineBox.canFit(formatContext, cssBox, this.targetY)) {
                    this.addToLineBox(formatContext, cssBox);
                    continue;
                }
                this.finishLine(formatContext);
                this.addToLineBox(formatContext, cssBox);
                continue;
            }
            if (cssBox.getBoxType() == BoxType.LINEBREAK) {
                this.addToLineBox(formatContext, cssBox);
                this.finishLine(formatContext);
                if (formatContext.floats == null) continue;
                CssValue cssValue2 = CssProvider.getEngineService().getComputedValueForElement(cssBox.getElement(), 18);
                if (CssProvider.getValueService().isNoneValue(cssValue2) || (n3 = formatContext.clear(cssValue2, null)) <= Integer.MIN_VALUE || (n2 = n3 - (this.getAbsoluteY() + this.targetY)) <= 0) continue;
                this.targetY += n2;
                this.contentHeight += n2;
                this.height += n2;
                continue;
            }
            if (!cssBox.isReplacedBox() && cssBox instanceof ContainerBox && !(cssBox instanceof TableBox)) {
                BoxList boxList2 = ((ContainerBox)cssBox).getBoxList();
                if (boxList2 == null && cssBox instanceof LineBoxGroup) {
                    boxList2 = ((LineBoxGroup)cssBox).allBoxes;
                }
                if (boxList2 == null) continue;
                n3 = boxList2.size();
                for (n2 = 0; n2 < n3; ++n2) {
                    boxList2.get((int)n2).originalInlineContainer = cssBox;
                }
                this.relayoutChildren(formatContext, boxList2, cssBox.getElement());
                continue;
            }
            boolean bl2 = true;
            if (cssBox.getBoxType() == BoxType.TEXT) {
                bl2 = false;
            } else if (cssBox.getBoxType() == BoxType.SPACE) {
                bl2 = false;
            }
            if (bl2) {
                super.layoutChild(cssBox, formatContext, true);
                this.positionBox(cssBox, formatContext);
            }
            if (!bl || this.lineBox == null || this.lineBox.isEmpty() || this.lineBox.canFit(formatContext, cssBox, this.targetY)) {
                this.addToLineBox(formatContext, cssBox);
                continue;
            }
            this.finishLine(formatContext);
            this.addToLineBox(formatContext, cssBox);
        }
    }

    private void finishLine(FormatContext formatContext) {
        if (this.lineBox == null || this.lineBox.isEmpty()) {
            if (this.floats != null) {
                this.finishFloats(formatContext);
            }
            return;
        }
        int n = this.lineBox.applyVerticalAlignments();
        if (n == 0) {
            if (this.metrics != null) {
                n = this.metrics.getHeight();
            } else {
                ErrorManager.getDefault().log("Big hack in computing line height for linebox!");
                n = 14;
            }
        }
        this.lineBox.contentWidth = this.lineBox.getActualWidth();
        this.lineBox.contentHeight = n;
        this.lineBox.width = this.lineBox.contentWidth;
        this.lineBox.height = this.lineBox.contentHeight;
        int n2 = this.lineBox.isFloated || LineBoxGroup.hasFloatParent(this.lineBox) ? 0 : formatContext.getLeftEdge(this.lineBox, this, this.targetY, n);
        this.lineBox.applyHorizontalAlignments(n2, n, formatContext);
        if (this.lineBox.contentWidth > this.contentWidth) {
            this.contentWidth = this.lineBox.contentWidth;
        }
        this.contentHeight += this.lineBox.contentHeight;
        if (this.lineBox.getX() == 0x7FFFFFFD) {
            this.lineBox.setX(0);
        }
        this.lineBox.setY(this.targetY);
        super.addBox(this.lineBox, null, null);
        this.targetY += n;
        if (this.lineBox != null && this.lineBox.isFloated) {
            if (this.floats == null) {
                this.floats = new ArrayList<CssBox>();
            }
            this.floats.add(this.lineBox);
            this.lineBox = null;
        } else if (this.floats != null) {
            this.lineBox = null;
            this.finishFloats(formatContext);
        } else {
            this.lineBox = null;
        }
    }

    private static boolean hasFloatParent(CssBox cssBox) {
        if (cssBox == null) {
            return false;
        }
        for (ContainerBox containerBox = cssBox.getParent(); containerBox != null; containerBox = containerBox.getParent()) {
            if (containerBox.getBoxType() != BoxType.FLOAT) continue;
            return true;
        }
        return false;
    }

    void finishRelatives(FormatContext formatContext) {
        int n = this.allBoxes.size();
        for (int i = 0; i < n; ++i) {
            CssBox cssBox = this.allBoxes.get(i);
            if (cssBox.getBoxType() != BoxType.RELATIVE) continue;
            super.setContainingBlock(cssBox, formatContext);
            Element element = cssBox.getElement();
            CssProvider.getEngineService().uncomputeValueForElement(element, 39);
            CssProvider.getEngineService().uncomputeValueForElement(element, 40);
            CssProvider.getEngineService().uncomputeValueForElement(element, 41);
            CssProvider.getEngineService().uncomputeValueForElement(element, 42);
            cssBox.left = CssUtilities.getCssLength(element, 39);
            cssBox.right = CssUtilities.getCssLength(element, 40);
            cssBox.top = CssUtilities.getCssLength(element, 41);
            cssBox.bottom = CssUtilities.getCssLength(element, 42);
            if (cssBox.left == 0x7FFFFFFE) {
                if (cssBox.right == 0x7FFFFFFE) {
                    cssBox.left = 0;
                    cssBox.right = 0;
                } else {
                    cssBox.left = -cssBox.right;
                }
            } else {
                cssBox.right = cssBox.right == 0x7FFFFFFE ? -cssBox.left : -cssBox.left;
            }
            if (cssBox.top == 0x7FFFFFFE) {
                if (cssBox.bottom == 0x7FFFFFFE) {
                    cssBox.top = 0;
                    cssBox.bottom = 0;
                } else {
                    cssBox.top = -cssBox.bottom;
                }
            } else {
                cssBox.bottom = cssBox.bottom == 0x7FFFFFFE ? -cssBox.top : -cssBox.top;
            }
            int n2 = cssBox.getX() + cssBox.left;
            int n3 = cssBox.getY() + cssBox.top;
            cssBox.setLocation(n2, n3);
        }
    }

    private void finishFloats(FormatContext formatContext) {
        if (this.floats != null) {
            int n = this.floats.size();
            for (int i = 0; i < n; ++i) {
                int n2;
                CssBox cssBox;
                CssBox cssBox2 = this.floats.get(i);
                if (cssBox2.getBoxType() != BoxType.LINEBOX) {
                    super.layoutChild(cssBox2, formatContext, true);
                    this.positionBox(cssBox2, formatContext);
                }
                int n3 = this.targetY;
                if (cssBox2.isClearBox()) {
                    cssBox = formatContext.getPrevFloatingForClear(cssBox2);
                    if (cssBox != null) {
                        n2 = formatContext.adjustY(cssBox.getHeight() + cssBox.bottomMargin + cssBox.topMargin, cssBox, this) + cssBox2.topMargin;
                        n3 = Math.max(this.targetY, n2);
                    }
                } else {
                    cssBox = formatContext.getPrevFloatingForFloat(cssBox2);
                    if (cssBox != null) {
                        n2 = formatContext.adjustY(0, cssBox, this);
                        n3 = Math.max(this.targetY, n2);
                    }
                }
                if (formatContext.getMaxWidth(cssBox2, this, n3, cssBox2.getHeight()) < cssBox2.getWidth() && (cssBox = formatContext.getLowestFloatingForFloat(cssBox2)) != null) {
                    n2 = formatContext.adjustY(cssBox.getHeight(), cssBox, this);
                    n3 = Math.max(this.targetY, n2);
                }
                this.positionFloatBox(n3, cssBox2, formatContext);
            }
        }
        this.floats = null;
    }

    private void positionFloatBox(int n, CssBox cssBox, FormatContext formatContext) {
        boolean bl;
        cssBox.effectiveTopMargin = 0;
        cssBox.effectiveBottomMargin = 0;
        ContainerBox containerBox = cssBox.getParent();
        assert (containerBox != null);
        assert (containerBox == this);
        CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(cssBox.getElement(), 23);
        if (CssProvider.getValueService().isLeftValue(cssValue)) {
            bl = true;
        } else if (CssProvider.getValueService().isRightValue(cssValue)) {
            bl = false;
        } else {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Unexpected floating value, cssFloating=" + cssValue));
            return;
        }
        cssBox.effectiveTopMargin = cssBox.topMargin;
        cssBox.effectiveBottomMargin = cssBox.bottomMargin;
        int n2 = bl ? formatContext.getLeftEdge(cssBox, this, n, cssBox.getHeight()) : formatContext.getRightEdge(cssBox, this, n, cssBox.getHeight()) - cssBox.getWidth();
        cssBox.setLocation(n2, n);
        formatContext.addFloat(n2, n, cssBox, bl);
    }

    @Override
    public int getPrefMinWidth() {
        Object object;
        if (this.allBoxes == null) {
            return 0;
        }
        boolean bl = true;
        Element element = this.getElement();
        if (element != null) {
            object = CssProvider.getEngineService().getComputedValueForElement(element, 57);
            bl = CssProvider.getValueService().isNormalValue((CssValue)object);
        }
        if (bl) {
            int n = 0;
            int n2 = this.allBoxes.size();
            for (int i = 0; i < n2; ++i) {
                CssBox cssBox = this.allBoxes.get(i);
                int n3 = cssBox.getBoxType() == BoxType.LINEBREAK ? 0 : cssBox.getPrefMinWidth();
                if (n3 <= n) continue;
                n = n3;
            }
            return n;
        }
        object = this.allBoxes;
        int n = 0;
        int n4 = 0;
        int n5 = ((BoxList)object).size();
        for (int i = 0; i < n5; ++i) {
            CssBox cssBox = ((BoxList)object).get(i);
            n4 = cssBox.getBoxType() == BoxType.LINEBREAK ? 0 : (n4 += cssBox.getPrefMinWidth());
            if (n4 <= n) continue;
            n = n4;
        }
        return n;
    }

    @Override
    public int getPrefWidth() {
        return this.getPrefWidth(this.allBoxes);
    }

    protected int getPrefWidth(BoxList boxList) {
        if (boxList == null) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        int n3 = boxList.size();
        for (int i = 0; i < n3; ++i) {
            CssBox cssBox = boxList.get(i);
            n2 = cssBox.getBoxType() == BoxType.LINEBREAK ? 0 : (n2 += cssBox.getPrefWidth());
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    @Override
    protected void initializeHorizontalWidths(FormatContext formatContext) {
        if (this.allBoxes == null) {
            return;
        }
        int n = this.allBoxes.size();
        for (int i = 0; i < n; ++i) {
            CssBox cssBox = this.allBoxes.get(i);
            if (cssBox.getBoxType().isAbsolutelyPositioned()) continue;
            cssBox.initializeHorizontalWidths(formatContext);
        }
    }

    @Override
    void computeHorizontalLengths(FormatContext formatContext) {
    }

    @Override
    void computeVerticalLengths(FormatContext formatContext) {
    }

    int getSizeWithFloats() {
        CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(this.getElement(), 23);
        if (CssProvider.getValueService().isLeftValue(cssValue) || CssProvider.getValueService().isRightValue(cssValue)) {
            boolean bl = false;
            int n = Integer.MAX_VALUE;
            int n2 = Integer.MIN_VALUE;
            int n3 = this.getBoxCount();
            for (int i = 0; i < n3; ++i) {
                CssBox cssBox = this.getBox(i);
                cssValue = CssProvider.getEngineService().getComputedValueForElement(cssBox.getElement(), 23);
                if (!CssProvider.getValueService().isLeftValue(cssValue) && !CssProvider.getValueService().isRightValue(cssValue)) continue;
                if (cssBox.getY() < n) {
                    n = cssBox.getY();
                }
                if (cssBox.getY() + cssBox.getHeight() > n2) {
                    n2 = cssBox.getY() + cssBox.getHeight();
                }
                bl = true;
            }
            if (bl && n2 != Integer.MAX_VALUE) {
                return n2 - n;
            }
        }
        return 0;
    }

    LineBoxGroup split(CssBox cssBox) {
        int n;
        int n2;
        assert (this.allBoxes != null);
        int n3 = this.allBoxes.size();
        for (n2 = 0; n2 < n3 && this.allBoxes.get(n2) != cssBox; ++n2) {
        }
        assert (n2 < n3);
        LineBoxGroup lineBoxGroup = new LineBoxGroup(this.webform, this.getElement(), this.metrics);
        int n4 = n3 - ++n2;
        lineBoxGroup.allBoxes = new BoxList(n4 + 4);
        for (n = n2; n < n3; ++n) {
            lineBoxGroup.allBoxes.add(this.allBoxes.get(n), null, null);
        }
        for (n = 0; n < n4; ++n) {
            lineBoxGroup.allBoxes.get(n).setParent(lineBoxGroup);
            lineBoxGroup.allBoxes.get(n).setPositionedBy(lineBoxGroup);
        }
        this.allBoxes.truncate(n2);
        return lineBoxGroup;
    }

    @Override
    public void computeRectangles(Element element, List<Rectangle> list) {
        Rectangle rectangle = null;
        int n = this.getBoxCount();
        for (int i = 0; i < n; ++i) {
            CssBox cssBox = this.getBox(i);
            if (cssBox instanceof LineBox) {
                LineBox lineBox = (LineBox)cssBox;
                int n2 = lineBox.getBoxCount();
                for (int j = 0; j < n2; ++j) {
                    Element element2;
                    CssBox cssBox2 = lineBox.getBox(j);
                    Element element3 = element2 = cssBox2 == null ? null : cssBox2.getElement();
                    if (!LineBoxGroup.isSameOrParentElementOf(element, element2) && !this.hasComponentAncestor(cssBox2, element)) continue;
                    Rectangle rectangle2 = new Rectangle(cssBox2.getAbsoluteX(), cssBox2.getAbsoluteY(), cssBox2.getWidth(), cssBox2.getHeight());
                    if (rectangle == null) {
                        rectangle = rectangle2;
                        continue;
                    }
                    rectangle.add(rectangle2);
                }
                continue;
            }
            assert (cssBox.getBoxType() == BoxType.FLOAT || cssBox.getBoxType() == BoxType.RELATIVE);
            cssBox.computeRectangles(element, list);
        }
        if (rectangle != null) {
            list.add(rectangle);
        }
    }

    @Override
    public Rectangle computeBounds(Element element, Rectangle rectangle) {
        int n = this.getBoxCount();
        for (int i = 0; i < n; ++i) {
            CssBox cssBox = this.getBox(i);
            if (cssBox instanceof LineBox) {
                LineBox lineBox = (LineBox)cssBox;
                int n2 = lineBox.getBoxCount();
                for (int j = 0; j < n2; ++j) {
                    Element element2;
                    CssBox cssBox2 = lineBox.getBox(j);
                    Element element3 = element2 = cssBox2 == null ? null : cssBox2.getElement();
                    if (!LineBoxGroup.isSameOrParentElementOf(element, element2) && !this.hasComponentAncestor(cssBox2, element)) continue;
                    Rectangle rectangle2 = new Rectangle(cssBox2.getAbsoluteX(), cssBox2.getAbsoluteY(), cssBox2.getWidth(), cssBox2.getHeight());
                    if (rectangle == null) {
                        rectangle = rectangle2;
                        continue;
                    }
                    rectangle.add(rectangle2);
                }
                continue;
            }
            assert (cssBox.getBoxType() == BoxType.FLOAT || cssBox.getBoxType() == BoxType.RELATIVE);
            rectangle = cssBox.computeBounds(element, rectangle);
        }
        return rectangle;
    }

    private boolean hasComponentAncestor(CssBox cssBox, Element element) {
        while (cssBox != null && cssBox != this) {
            if (cssBox.getElement() == element) {
                return true;
            }
            cssBox = cssBox.getParent();
        }
        return false;
    }

    private static boolean isSameOrParentElementOf(Element element, Element element2) {
        if (element == null || element2 == null) {
            return false;
        }
        for (Node node = element2; node != null; node = node.getParentNode()) {
            if (node != element) continue;
            return true;
        }
        return false;
    }

    public BoxList getManagedBoxes() {
        return this.allBoxes;
    }

    @Override
    protected void paintBackground(Graphics graphics, int n, int n2) {
        DesignerPane designerPane = this.webform.getPane();
        if (designerPane == null) {
            return;
        }
        if (designerPane.hasCaretSelection()) {
            DomProvider.DomPosition domPosition = designerPane.getFirstPosition();
            DomProvider.DomPosition domPosition2 = domPosition.getRenderedPosition();
            DomProvider.DomPosition domPosition3 = designerPane.getLastPosition();
            DomProvider.DomPosition domPosition4 = domPosition3.getRenderedPosition();
            Node node = this.findFirstNode();
            if (node == null) {
                return;
            }
            Node node2 = this.findLastNode();
            Node node3 = domPosition2.getNode();
            if (node3 == null) {
                return;
            }
            Node node4 = domPosition4.getNode();
            if (node4 == null) {
                return;
            }
            int n3 = this.webform.compareBoundaryPoints(node3, domPosition2.getOffset(), node2, 10000);
            int n4 = this.webform.compareBoundaryPoints(node4, domPosition4.getOffset(), node, 0);
            if (n3 >= 0 && n4 <= 0) {
                PageBox pageBox = designerPane.getPageBox();
                Rectangle rectangle = ModelViewMapper.modelToView(pageBox, domPosition);
                Rectangle rectangle2 = ModelViewMapper.modelToView(pageBox, domPosition3);
                if (rectangle != null && rectangle2 != null) {
                    Rectangle rectangle3;
                    if (rectangle2.y < rectangle.y || rectangle.y == rectangle2.y && rectangle2.x < rectangle.x) {
                        rectangle3 = rectangle;
                        rectangle = rectangle2;
                        rectangle2 = rectangle3;
                    }
                    graphics.setColor(designerPane.getSelectionColor());
                    if (rectangle.y == rectangle2.y) {
                        rectangle2.width = 0;
                        rectangle3 = rectangle.union(rectangle2);
                        if (rectangle3.y + rectangle3.height < n2) {
                            return;
                        }
                        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                    } else {
                        int n5;
                        int n6;
                        int n7;
                        if (rectangle2.y + rectangle2.height < n2) {
                            return;
                        }
                        int n8 = n2 + this.height;
                        if (rectangle.y + rectangle.height > n2 && rectangle.y < n8) {
                            n7 = n + this.width - rectangle.x;
                            n6 = rectangle.y;
                            n5 = n6 + rectangle.height;
                            if (n6 < n2) {
                                n6 = n2;
                            }
                            if (n5 > n8) {
                                n5 = n8;
                            }
                            graphics.fillRect(rectangle.x, n6, n7, n5 - n6);
                        }
                        if (rectangle.y + rectangle.height != rectangle2.y && (n5 = (n7 = rectangle.y + rectangle.height) + (n6 = rectangle2.y - (rectangle.y + rectangle.height))) > n2 && n7 < n8) {
                            if (n5 > n8) {
                                n5 = n8;
                            }
                            if (n7 < n2) {
                                n7 = n2;
                            }
                            graphics.fillRect(n, n7, this.width, n5 - n7);
                        }
                        if (rectangle2.y + rectangle2.height > n2 && rectangle2.y < n8) {
                            n7 = rectangle2.y;
                            n6 = n7 + rectangle2.height;
                            if (n7 < n2) {
                                n7 = n2;
                            }
                            if (n6 > n8) {
                                n6 = n8;
                            }
                            graphics.fillRect(n, n7, rectangle2.x - n, n6 - n7);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void paint(Graphics graphics, int n, int n2) {
        CssBox cssBox;
        int n3;
        n += this.getX();
        n2 += this.getY();
        if (Math.abs(n += this.leftMargin) > 50000 || Math.abs(n2 += this.effectiveTopMargin) > 50000 || Math.abs(this.width) > 50000 || Math.abs(this.height) > 50000) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Fatal painting error:\nbad box=" + this + "\nparent of bad box=" + this.getParent()));
            return;
        }
        int n4 = this.getBoxCount();
        for (n3 = 0; n3 < n4; ++n3) {
            cssBox = this.getBox(n3);
            if (cssBox.getBoxType() != BoxType.LINEBOX) continue;
            cssBox.paintBackground(graphics, n, n2);
        }
        this.paintBackground(graphics, n, n2);
        n4 = this.getBoxCount();
        for (n3 = 0; n3 < n4; ++n3) {
            cssBox = this.getBox(n3);
            CssBox cssBox2 = cssBox.getPositionedBy();
            if (cssBox2 != this) {
                cssBox.paint(graphics, cssBox2.getAbsoluteX(), cssBox2.getAbsoluteY());
                continue;
            }
            cssBox.paint(graphics, n, n2);
        }
        if (CssBox.paintSpaces) {
            graphics.setColor(Color.CYAN);
            graphics.drawRect(this.getAbsoluteX(), this.getAbsoluteY(), this.width, this.height);
        }
    }

    private Node findFirstNode() {
        int n = this.allBoxes.size();
        for (int i = 0; i < n; ++i) {
            CssBox cssBox = this.allBoxes.get(i);
            if (cssBox.getBoxType() == BoxType.TEXT) {
                return ((TextBox)cssBox).getNode();
            }
            if (cssBox.getBoxType() == BoxType.SPACE) {
                return ((SpaceBox)cssBox).getNode();
            }
            if (cssBox.getElement() == null) continue;
            return cssBox.getElement();
        }
        return null;
    }

    private Node findLastNode() {
        for (int i = this.allBoxes.size() - 1; i >= 0; --i) {
            CssBox cssBox = this.allBoxes.get(i);
            if (cssBox.getBoxType() == BoxType.TEXT) {
                return ((TextBox)cssBox).getNode();
            }
            if (cssBox.getBoxType() == BoxType.SPACE) {
                return ((SpaceBox)cssBox).getNode();
            }
            if (cssBox.getElement() == null) continue;
            return cssBox.getElement();
        }
        return null;
    }
}

