/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Point2D;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.lib.terminalemulator.ActiveRegion;
import org.netbeans.lib.terminalemulator.Attr;
import org.netbeans.lib.terminalemulator.BCoord;
import org.netbeans.lib.terminalemulator.BExtent;
import org.netbeans.lib.terminalemulator.Buffer;
import org.netbeans.lib.terminalemulator.Coord;
import org.netbeans.lib.terminalemulator.Extent;
import org.netbeans.lib.terminalemulator.Interp;
import org.netbeans.lib.terminalemulator.InterpDumb;
import org.netbeans.lib.terminalemulator.InterpKit;
import org.netbeans.lib.terminalemulator.Line;
import org.netbeans.lib.terminalemulator.LineVisitor;
import org.netbeans.lib.terminalemulator.LogicalLineVisitor;
import org.netbeans.lib.terminalemulator.MyFontMetrics;
import org.netbeans.lib.terminalemulator.Ops;
import org.netbeans.lib.terminalemulator.RegionManager;
import org.netbeans.lib.terminalemulator.Screen;
import org.netbeans.lib.terminalemulator.Sel;
import org.netbeans.lib.terminalemulator.State;
import org.netbeans.lib.terminalemulator.TermInputListener;
import org.netbeans.lib.terminalemulator.TermListener;
import org.netbeans.lib.terminalemulator.TermStream;
import org.netbeans.lib.terminalemulator.WordDelineator;

public class Term
extends JComponent
implements Accessible {
    private State st = new State();
    private Sel sel = new Sel(this, this.st);
    private Ops ops = new OpsImpl();
    private int top_margin = 0;
    private int bot_margin = 0;
    private int cull_count = 0;
    private static final int cull_frequency = 50;
    protected int firsta = 0;
    private int charsInPrehistory = 0;
    private static final int modulo = 0x3FFFFFFF;
    private Screen screen;
    private JScrollBar vscroll_bar;
    private ScrollWrapper hscroll_wrapper;
    private JScrollBar hscroll_bar;
    private boolean has_focus;
    private int n_putchar;
    private int n_putchars;
    private int n_linefeeds;
    private int n_repaint;
    private int n_paint;
    MyFontMetrics metrics = null;
    Buffer buf = new Buffer(80);
    private RegionManager region_manager = new RegionManager();
    private Point left_down_point;
    private Clipboard systemClipboard = this.getToolkit().getSystemClipboard();
    private Clipboard systemSelection = this.getToolkit().getSystemSelection();
    private TermStream base_stream;
    private TermStream dce_end = this.base_stream = new BaseTermStream();
    private TermStream dte_end = this.base_stream;
    public static final int DEBUG_OPS = 1;
    public static final int DEBUG_KEYS = 2;
    public static final int DEBUG_INPUT = 4;
    public static final int DEBUG_OUTPUT = 8;
    public static final int DEBUG_WRAP = 16;
    public static final int DEBUG_MARGINS = 32;
    private int debug_gutter_width = 0;
    private int debug = 0;
    private WordDelineator default_word_delineator;
    WordDelineator word_delineator = this.default_word_delineator = new WordDelineator();
    private LinkedList input_listeners = new LinkedList();
    private LinkedList listeners = new LinkedList();
    private boolean click_to_type = true;
    private boolean read_only = false;
    private HashSet keystroke_set = new HashSet();
    private boolean passOn = true;
    private int hscroll_count = 0;
    private Scroller scroller;
    private Point drag_point;
    private int scrolling_direction = 0;
    private MemUse lastMemUse = new MemUse();
    private static Extent old_extent = null;
    private boolean size_rounded = true;
    private Color actual_foreground;
    private Color actual_background;
    private boolean check_selection;
    private int totcols;
    private final Point newp = new Point();
    private char[] xferBuf = new char[80];
    private final boolean do_margins = true;
    private static final char ESC = '\u001b';
    private int old_rows = -1;
    private boolean reverse_video = false;
    private Color active_color = Color.lightGray;
    private boolean anchored = false;
    private Interp interp = new InterpDumb(this.ops);
    private int history_size = 20;
    private int glyph_gutter_width;
    private Image[] glyph_images = new Image[256];
    private final Color[] custom_color = new Color[8];
    private final Color[] standard_color = new Color[8];
    private boolean cursor_visible = true;
    private boolean refresh_enabled = true;
    boolean selection_xor = false;
    private int tab_size = 8;
    private boolean scroll_on_input = true;
    private boolean scroll_on_output = true;
    private boolean track_cursor = true;
    private boolean horizontally_scrollable = true;
    private AccessibleContext accessible_context;

    public void pushStream(TermStream termStream) {
        if (this.dce_end == this.base_stream) {
            this.dte_end = termStream;
            termStream.setToDCE(this.base_stream);
            termStream.setToDTE(this.base_stream);
            this.dce_end = termStream;
        } else {
            this.dte_end.setToDCE(termStream);
            termStream.setToDCE(this.base_stream);
            termStream.setToDTE(this.dce_end);
            this.dce_end = termStream;
        }
        termStream.setTerm(this);
    }

    public void setDebugFlags(int n) {
        this.debug = n;
    }

    private boolean debugOps() {
        return (this.debug & 1) == 1;
    }

    private boolean debugKeys() {
        return (this.debug & 2) == 2;
    }

    private boolean debugWrap() {
        return (this.debug & 0x10) == 16;
    }

    private boolean debugMargins() {
        return true;
    }

    protected boolean debugInput() {
        return (this.debug & 4) == 4;
    }

    protected boolean debugOutput() {
        return (this.debug & 8) == 8;
    }

    private int topMargin() {
        return this.top_margin == 0 ? 0 : this.top_margin - 1;
    }

    private int botMargin() {
        return this.bot_margin == 0 ? this.st.rows - 1 : this.bot_margin - 1;
    }

    private int beginx() {
        return this.buf.nlines - this.st.rows;
    }

    private Line cursor_line() {
        return this.buf.lineAt(this.st.cursor.row);
    }

    public void setWordDelineator(WordDelineator wordDelineator) {
        this.word_delineator = wordDelineator == null ? this.default_word_delineator : wordDelineator;
    }

    public WordDelineator getWordDelineator() {
        return this.word_delineator;
    }

    public void setInputListener(TermInputListener termInputListener) {
        this.addInputListener(termInputListener);
    }

    public void addInputListener(TermInputListener termInputListener) {
        this.input_listeners.add(termInputListener);
    }

    public void removeInputListener(TermInputListener termInputListener) {
        this.input_listeners.remove(termInputListener);
    }

    private void fireChar(char c) {
        ListIterator listIterator = this.input_listeners.listIterator();
        while (listIterator.hasNext()) {
            TermInputListener termInputListener = (TermInputListener)listIterator.next();
            termInputListener.sendChar(c);
        }
    }

    private void fireChars(char[] cArray, int n, int n2) {
        ListIterator listIterator = this.input_listeners.listIterator();
        while (listIterator.hasNext()) {
            TermInputListener termInputListener = (TermInputListener)listIterator.next();
            termInputListener.sendChars(cArray, n, n2);
        }
    }

    public void setListener(TermListener termListener) {
        this.addListener(termListener);
    }

    public void addListener(TermListener termListener) {
        this.listeners.add(termListener);
    }

    public void removeListener(TermListener termListener) {
        this.listeners.remove(termListener);
    }

    private void fireSizeChanged(Dimension dimension, Dimension dimension2) {
        ListIterator listIterator = this.listeners.listIterator();
        while (listIterator.hasNext()) {
            TermListener termListener = (TermListener)listIterator.next();
            termListener.sizeChanged(dimension, dimension2);
        }
    }

    public void setClickToType(boolean bl) {
        this.click_to_type = bl;
    }

    public boolean isClickToType() {
        return this.click_to_type;
    }

    public void setReadOnly(boolean bl) {
        this.read_only = bl;
    }

    public boolean isReadOnly() {
        return this.read_only;
    }

    public void clear() {
        for (int i = 0; i < this.st.rows; ++i) {
            Line line = this.buf.lineAt(this.beginx() + i);
            line.reset();
        }
        this.regionManager().reset();
    }

    public void clearHistoryNoRefresh() {
        this.sel.cancel(true);
        int n = this.buf.visibleCols();
        this.buf = new Buffer(n);
        this.firsta = 0;
        this.charsInPrehistory = 0;
        this.st.firstx = 0;
        this.st.firsty = 0;
        this.st.cursor.row = 0;
        this.st.cursor.col = 0;
        this.st.attr = 0;
        this.st.saveCursor();
        this.st.restoreCursor();
        this.adjust_lines(this.st.rows);
        this.st.firstx = 0;
        this.st.firsty = 0;
        this.regionManager().reset();
        this.screen.possiblyUpdateCaretText();
    }

    public void clearHistory() {
        this.clearHistoryNoRefresh();
        this.repaint(true);
    }

    public RegionManager regionManager() {
        return this.region_manager;
    }

    public String textWithin(Coord coord, Coord coord2) {
        if (coord == null || coord2 == null) {
            return null;
        }
        final StringBuffer stringBuffer = new StringBuffer();
        this.visitLines(coord, coord2, false, new LineVisitor(){

            public boolean visit(Line line, int n, int n2, int n3) {
                line.accumulateInto(n2, n3, stringBuffer);
                return true;
            }
        });
        return stringBuffer.toString();
    }

    public String getRowText(int n) {
        Line line = this.buf.lineAt(n);
        if (line == null) {
            return null;
        }
        return line.stringBuffer().toString();
    }

    public HashSet getKeyStrokeSet() {
        return this.keystroke_set;
    }

    public void setKeyStrokeSet(HashSet hashSet) {
        this.keystroke_set = hashSet;
    }

    private boolean maybeConsume(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return false;
        }
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
        if (this.keystroke_set == null || !this.keystroke_set.contains(keyStroke)) {
            keyEvent.consume();
            return true;
        }
        return false;
    }

    void visitLines(Coord coord, Coord coord2, boolean bl, LineVisitor lineVisitor) {
        this.buf.visitLines(coord.toBCoord(this.firsta), coord2.toBCoord(this.firsta), bl, lineVisitor);
    }

    public void visitLogicalLines(Coord coord, Coord coord2, final LogicalLineVisitor logicalLineVisitor) {
        LineVisitor lineVisitor = new LineVisitor(){
            String text = "";
            int lineno = 0;
            Coord begin = null;
            Coord end = null;

            public boolean visit(Line line, int n, int n2, int n3) {
                if (line.isWrapped()) {
                    if (this.begin == null) {
                        this.begin = new Coord(new BCoord(n, n2), Term.this.firsta);
                    }
                    this.text = this.text + line.text(n2, n3);
                } else {
                    if (this.begin == null) {
                        this.begin = new Coord(new BCoord(n, n2), Term.this.firsta);
                    }
                    this.end = new Coord(new BCoord(n, n3), Term.this.firsta);
                    this.text = this.text + line.text(n2, n3);
                    if (!logicalLineVisitor.visit(this.lineno, this.begin, this.end, this.text)) {
                        return false;
                    }
                    ++this.lineno;
                    this.text = "";
                    this.begin = null;
                    this.end = null;
                }
                return true;
            }
        };
        if (coord == null) {
            coord = new Coord();
        }
        if (coord2 == null) {
            int n = this.buf.nlines - 1;
            Line line = this.buf.lineAt(n);
            coord2 = new Coord(new BCoord(n, line.length() - 1), this.firsta);
        }
        if (coord.compareTo(coord2) > 0) {
            return;
        }
        this.buf.visitLines(coord.toBCoord(this.firsta), coord2.toBCoord(this.firsta), false, lineVisitor);
    }

    public void reverseVisitLogicalLines(Coord coord, Coord coord2, final LogicalLineVisitor logicalLineVisitor) {
        LineVisitor lineVisitor = new LineVisitor(){
            String text = "";
            int lineno = 0;
            Coord begin = null;
            Coord end = null;

            public boolean visit(Line line, int n, int n2, int n3) {
                boolean bl = false;
                if (n > 0 && Term.this.buf.lineAt(n - 1).isWrapped()) {
                    bl = true;
                }
                if (bl) {
                    if (this.end == null) {
                        this.end = new Coord(new BCoord(n, n3), Term.this.firsta);
                    }
                    this.text = line.text(n2, n3) + this.text;
                } else {
                    if (this.end == null) {
                        this.end = new Coord(new BCoord(n, n3), Term.this.firsta);
                    }
                    this.begin = new Coord(new BCoord(n, n2), Term.this.firsta);
                    this.text = line.text(n2, n3) + this.text;
                    if (!logicalLineVisitor.visit(this.lineno, this.begin, this.end, this.text)) {
                        return false;
                    }
                    ++this.lineno;
                    this.text = "";
                    this.begin = null;
                    this.end = null;
                }
                return true;
            }
        };
        if (coord == null) {
            coord = new Coord();
        }
        if (coord2 == null) {
            int n = this.buf.nlines - 1;
            Line line = this.buf.lineAt(n);
            coord2 = new Coord(new BCoord(n, line.length() - 1), this.firsta);
        }
        if (coord.compareTo(coord2) > 0) {
            return;
        }
        this.buf.reverseVisitLines(coord.toBCoord(this.firsta), coord2.toBCoord(this.firsta), false, lineVisitor);
    }

    public Extent extentInLogicalLine(Coord coord, int n, int n2) {
        Coord coord2 = (Coord)coord.clone();
        while (n-- > 0) {
            coord2 = new Coord(this.buf.advance(coord2.toBCoord(this.firsta)), this.firsta);
        }
        Coord coord3 = (Coord)coord2.clone();
        while (--n2 > 0) {
            coord3 = new Coord(this.buf.advance(coord3.toBCoord(this.firsta)), this.firsta);
        }
        return new Extent(coord2, coord3);
    }

    private boolean cursor_was_visible() {
        return this.st.cursor.row - 1 >= this.st.firstx && this.st.cursor.row - 1 < this.st.firstx + this.st.rows;
    }

    public void possiblyNormalize(Coord coord) {
        if (coord == null) {
            return;
        }
        BCoord bCoord = coord.toBCoord(this.firsta);
        if (bCoord.row >= this.st.firstx && bCoord.row < this.st.firstx + this.st.rows) {
            return;
        }
        this.st.firstx = bCoord.row - this.st.rows / 2;
        if (this.st.firstx < 0) {
            this.st.firstx = 0;
        } else if (this.st.firstx + this.st.rows > this.buf.nlines) {
            this.st.firstx = this.buf.nlines - this.st.rows;
        }
        this.repaint(true);
    }

    public void possiblyNormalize(ActiveRegion activeRegion) {
        if (activeRegion == null) {
            return;
        }
        BCoord bCoord = activeRegion.begin.toBCoord(this.firsta);
        BCoord bCoord2 = activeRegion.end.toBCoord(this.firsta);
        if (bCoord.row >= this.st.firstx && bCoord2.row < this.st.firstx + this.st.rows) {
            return;
        }
        if (bCoord2.row - bCoord.row + 1 >= this.st.rows) {
            this.st.firstx = bCoord.row;
        } else {
            this.st.firstx = bCoord.row - this.st.rows / 2;
            if (this.st.firstx < 0) {
                this.st.firstx = 0;
            } else if (this.st.firstx + this.st.rows > this.buf.nlines) {
                this.st.firstx = this.buf.nlines - this.st.rows;
            } else if (this.st.firstx + this.st.rows <= bCoord2.row) {
                this.st.firstx = bCoord2.row - this.st.rows + 1;
            }
        }
        this.repaint(true);
    }

    public boolean isCoordVisible(Coord coord) {
        BCoord bCoord = coord.toBCoord(this.firsta);
        return bCoord.row >= this.st.firstx && bCoord.row < this.st.firstx + this.st.rows;
    }

    private void possiblyScrollOnInput() {
        if (!this.scroll_on_input) {
            return;
        }
        if (this.st.cursor.row < this.st.firstx || this.st.cursor.row >= this.st.firstx + this.st.rows) {
            this.st.firstx = this.buf.nlines - this.st.rows;
            this.repaint(true);
        }
    }

    private void hscrollReset(char c) {
        Term.ckEventDispatchThread();
        this.hscroll_count = c == '\n' || c == '\r' ? 8 : (this.hscroll_count += 8);
    }

    private void possiblyHScroll() {
        if (!this.horizontally_scrollable) {
            return;
        }
        Term.ckEventDispatchThread();
        if (this.hscroll_count > 0) {
            --this.hscroll_count;
        } else {
            return;
        }
        if (this.st.cursor.col >= this.st.firsty + this.buf.visibleCols()) {
            this.st.firsty = this.st.cursor.col - this.buf.visibleCols() + 1;
            this.buf.noteColumn(this.st.cursor.col + 1);
            this.repaint(true);
        } else if (this.st.cursor.col - this.buf.visibleCols() < this.st.firsty) {
            this.st.firsty = this.st.cursor.col - this.buf.visibleCols() + 1;
            if (this.st.firsty < 0) {
                this.st.firsty = 0;
            } else {
                this.repaint(true);
            }
        }
    }

    public void setAttribute(int n) {
        this.st.attr = Attr.setAttribute(this.st.attr, n);
    }

    public void setCharacterAttribute(Coord coord, Coord coord2, final int n, final boolean bl) {
        this.visitLines(coord, coord2, false, new LineVisitor(){

            public boolean visit(Line line, int n4, int n2, int n3) {
                line.setCharacterAttribute(n2, n3, n, bl);
                return true;
            }
        });
        this.repaint(false);
    }

    public void setGlyph(int n, int n2) {
        Line line = this.cursor_line();
        line.setGlyphId(n);
        line.setBackgroundColor(n2);
    }

    public void setRowGlyph(int n, int n2, int n3) {
        Coord coord = new Coord();
        coord.row = n;
        coord.col = 0;
        BCoord bCoord = coord.toBCoord(this.firsta);
        Line line = this.buf.lineAt(bCoord.row);
        if (line == null) {
            return;
        }
        line.setGlyphId(n2);
        line.setBackgroundColor(n3);
        this.possibly_repaint(false);
    }

    private void adjust_lines(int n) {
        if (n > 0) {
            this.st.firstx -= n;
            while (this.st.firstx < 0) {
                this.buf.appendLine();
                ++this.st.firstx;
            }
        } else if (n < 0) {
            int n2;
            int n3 = this.st.rows - n;
            int n4 = this.buf.nlines - this.st.cursor.row - 1;
            if (n4 < 0) {
                n4 = 0;
            }
            if (n4 > -n) {
                n2 = -n;
            } else {
                n2 = n4;
                this.st.firstx += -n - n4;
            }
            while (n2-- > 0) {
                this.buf.removeLineAt(this.buf.nlines - 1);
            }
        }
        this.adjust_scrollbar();
    }

    public int getHistoryBuffSize() {
        return this.buf.nlines - this.st.rows;
    }

    private void limit_lines() {
        int n;
        if (this.anchored) {
            return;
        }
        int n2 = this.buf.nlines - this.st.rows;
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = n2 - this.history_size) > 0) {
            int n3 = this.buf.removeLinesAt(0, n);
            this.charsInPrehistory += n3;
            this.st.adjust(-n);
            this.firsta += n;
            if (++this.cull_count % 50 == 0) {
                this.region_manager.cull(this.firsta);
            }
            if (this.firsta + this.buf.nlines >= 0x3FFFFFFF) {
                int n4 = this.firsta;
                this.firsta = 0;
                this.sel.relocate(n4, this.firsta);
                this.region_manager.relocate(n4, this.firsta);
            }
        }
        this.sel.adjust(this.firsta, 0, this.firsta + this.buf.nlines);
        this.adjust_scrollbar();
    }

    private void scroll_to(int n, MouseEvent mouseEvent) {
        if (n == this.scrolling_direction) {
            if (n == 0) {
                BCoord bCoord = this.toBufCoords(this.toViewCoord(mouseEvent.getPoint()));
                this.sel.track(new Coord(bCoord, this.firsta));
                this.repaint(false);
            }
            return;
        }
        if (this.scroller != null) {
            this.scroller.interrupt();
            this.scroller = null;
        }
        if (n == 0) {
            BCoord bCoord = this.toBufCoords(this.toViewCoord(mouseEvent.getPoint()));
            this.sel.track(new Coord(bCoord, this.firsta));
            this.repaint(false);
        } else {
            this.scroller = new Scroller(n);
            this.scroller.start();
        }
        this.scrolling_direction = n;
    }

    public Term() {
        this.st.rows = 25;
        this.st.firstx = 0;
        this.st.firsty = 0;
        this.standard_color[0] = Color.black;
        this.standard_color[1] = Color.red;
        this.standard_color[2] = Color.green;
        this.standard_color[3] = Color.yellow;
        this.standard_color[4] = Color.blue;
        this.standard_color[5] = Color.magenta;
        this.standard_color[6] = Color.cyan;
        this.standard_color[7] = Color.white;
        this.custom_color[0] = Color.black;
        this.custom_color[1] = Color.black;
        this.custom_color[2] = Color.black;
        this.custom_color[3] = Color.black;
        this.custom_color[4] = Color.black;
        this.custom_color[5] = Color.black;
        this.custom_color[6] = Color.black;
        this.custom_color[7] = Color.black;
        Font font = UIManager.getFont("TextArea.font");
        if (font == null) {
            font = UIManager.getFont("controlFont");
        }
        if (font != null) {
            this.setFont(new Font("Monospaced", 0, font.getSize() + 1));
        } else {
            this.setFont(new Font("Monospaced", 0, 12));
        }
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        this.screen = new Screen(this, this.buf.visibleCols() * this.metrics.width + this.glyph_gutter_width + this.debug_gutter_width, this.st.rows * this.metrics.height);
        this.add("Center", this.screen);
        this.screen.setBackground(null);
        this.screen.setCursor(Cursor.getPredefinedCursor(2));
        this.adjust_lines(this.st.rows);
        this.st.cursor.row = 0;
        this.vscroll_bar = new JScrollBar(1);
        this.add("East", this.vscroll_bar);
        this.vscroll_bar.setValues(this.st.firstx, this.st.rows - 1, 0, this.st.rows);
        this.vscroll_bar.setUnitIncrement(1);
        this.vscroll_bar.setEnabled(true);
        this.vscroll_bar.setFocusable(false);
        this.vscroll_bar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                JScrollBar jScrollBar = (JScrollBar)adjustmentEvent.getAdjustable();
                switch (adjustmentEvent.getAdjustmentType()) {
                    case 5: {
                        int n = adjustmentEvent.getValue();
                        if (n == ((Term)Term.this).st.firstx) break;
                        ((Term)Term.this).st.firstx = n;
                        Term.this.repaint(false);
                        break;
                    }
                }
            }
        });
        this.hscroll_bar = new JScrollBar(0);
        this.hscroll_bar.setValues(this.st.firsty, this.buf.totalCols() - 1, 0, this.buf.totalCols());
        this.hscroll_bar.setUnitIncrement(1);
        this.hscroll_bar.setEnabled(true);
        this.hscroll_bar.setFocusable(false);
        this.hscroll_wrapper = new ScrollWrapper(this.hscroll_bar);
        this.add("South", this.hscroll_wrapper);
        this.hscroll_bar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                JScrollBar jScrollBar = (JScrollBar)adjustmentEvent.getAdjustable();
                switch (adjustmentEvent.getAdjustmentType()) {
                    case 5: {
                        int n = adjustmentEvent.getValue();
                        if (n == ((Term)Term.this).st.firsty) break;
                        ((Term)Term.this).st.firsty = n;
                        Term.this.repaint(false);
                        break;
                    }
                }
            }
        });
        this.screen.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                Dimension dimension = Term.this.screen.getSize();
                Term.this.sizeChanged(dimension.width, dimension.height);
                Term.this.repaint(true);
            }
        });
        this.screen.addKeyListener(new KeyListener(){
            boolean saw_return;

            public void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                if (Term.this.debugKeys()) {
                    System.out.println("term: keyTyped: " + keyEvent);
                }
                if (Term.this.read_only) {
                    return;
                }
                if (c == '\n' && this.saw_return) {
                    this.saw_return = false;
                    c = '\r';
                }
                if (Term.this.passOn && Term.this.maybeConsume(keyEvent)) {
                    Term.this.on_char(c);
                    Term.this.possiblyScrollOnInput();
                }
                Term.this.hscrollReset(c);
            }

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 65485: {
                        Term.this.copyToClipboard();
                        break;
                    }
                    case 65487: {
                        Term.this.pasteFromClipboard();
                        break;
                    }
                    case 10: {
                        this.saw_return = true;
                        break;
                    }
                    case 33: {
                        if (keyEvent.getModifiers() == 2) {
                            Term.this.pageLeft(1);
                            break;
                        }
                        Term.this.pageUp(1);
                        break;
                    }
                    case 34: {
                        if (keyEvent.getModifiers() == 2) {
                            Term.this.pageRight(1);
                            break;
                        }
                        Term.this.pageDown(1);
                        break;
                    }
                    case 38: {
                        if (keyEvent.getModifiers() == 2) {
                            Term.this.lineUp(1);
                            break;
                        }
                        Term.this.onCursorKey(keyEvent);
                        break;
                    }
                    case 40: {
                        if (keyEvent.getModifiers() == 2) {
                            Term.this.lineDown(1);
                            break;
                        }
                        Term.this.onCursorKey(keyEvent);
                        break;
                    }
                    case 37: {
                        Term.this.onCursorKey(keyEvent);
                        break;
                    }
                    case 39: {
                        Term.this.onCursorKey(keyEvent);
                    }
                }
                Term.this.passOn = Term.this.maybeConsume(keyEvent);
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    this.saw_return = false;
                }
                Term.this.maybeConsume(keyEvent);
            }
        });
        this.screen.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    return;
                }
                if (Term.this.left_down_point != null) {
                    BCoord bCoord = Term.this.toBufCoords(Term.this.toViewCoord(Term.this.left_down_point));
                    Term.this.sel.track(new Coord(bCoord, Term.this.firsta));
                    Term.this.left_down_point = null;
                }
                Term.this.drag_point = mouseEvent.getPoint();
                int n = 0;
                if (((Term)Term.this).drag_point.y < 0) {
                    n |= 2;
                } else if (((Term)Term.this).drag_point.y > ((Term)Term.this).screen.getSize().height) {
                    n |= 4;
                }
                if (((Term)Term.this).drag_point.x < 0) {
                    n |= 8;
                } else if (((Term)Term.this).drag_point.x > ((Term)Term.this).screen.getSize().width) {
                    n |= 0x10;
                }
                Term.this.scroll_to(n, mouseEvent);
            }

            public void mouseMoved(MouseEvent mouseEvent) {
            }
        });
        Term.addMouseWheelHandler(this.screen, this.vscroll_bar);
        this.screen.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                BCoord bCoord = Term.this.toBufCoords(Term.this.toViewCoord(mouseEvent.getPoint()));
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    if (Term.this.click_to_type) {
                        Term.this.requestFocus();
                    }
                } else if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                    Term.this.pasteFromSelection();
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    if (mouseEvent.isShiftDown()) {
                        BCoord bCoord = Term.this.toBufCoords(Term.this.toViewCoord(mouseEvent.getPoint()));
                        if (Term.this.sel.extend(new Coord(bCoord, Term.this.firsta))) {
                            Term.this.fireSelectionExtentChanged();
                            Term.this.repaint(false);
                        }
                        return;
                    }
                    if (Term.this.sel.cancel(false)) {
                        Term.this.repaint(false);
                    }
                    if (mouseEvent.getClickCount() == 1) {
                        Term.this.left_down_point = (Point)mouseEvent.getPoint().clone();
                    } else if (mouseEvent.getClickCount() == 2) {
                        BCoord bCoord = Term.this.toBufCoords(Term.this.toViewCoord(mouseEvent.getPoint()));
                        BExtent bExtent = Term.this.buf.find_word(Term.this.word_delineator, bCoord);
                        Term.this.sel.select_word(bExtent.toExtent(Term.this.firsta));
                        Term.this.repaint(false);
                    } else if (mouseEvent.getClickCount() == 3) {
                        BCoord bCoord = Term.this.toBufCoords(Term.this.toViewCoord(mouseEvent.getPoint()));
                        Term.this.sel.select_line(new Coord(bCoord, Term.this.firsta));
                        Term.this.repaint(false);
                    }
                    Term.this.fireSelectionExtentChanged();
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    if (mouseEvent.isShiftDown()) {
                        return;
                    }
                    if (Term.this.scroller != null) {
                        Term.this.scroller.interrupt();
                        Term.this.scroller = null;
                    }
                    if (Term.this.left_down_point == null) {
                        Term.this.sel.done();
                    }
                    Term.this.left_down_point = null;
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                if (!Term.this.click_to_type) {
                    Term.this.requestFocus();
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.screen.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                Term.this.has_focus = true;
                Term.this.repaint(false);
            }

            public void focusLost(FocusEvent focusEvent) {
                Term.this.has_focus = false;
                Term.this.repaint(false);
            }
        });
    }

    static void indent(boolean bl) {
        if (bl) {
            System.out.println("\t");
        }
    }

    public void printStats(String string) {
        boolean bl;
        boolean bl2 = bl = string != null;
        if (string != null) {
            System.out.println(string);
        }
        this.buf.printStats(bl);
        Term.indent(bl);
        System.out.println("  View:  rows " + this.st.rows + "  v cols " + this.buf.visibleCols() + "  t cols " + this.buf.totalCols() + "  history " + this.history_size);
        Term.indent(bl);
        System.out.println("         firstx " + this.st.firstx + "  firsty " + this.st.firsty + "  firsta " + this.firsta);
        Term.indent(bl);
        System.out.println("         gutter " + this.glyph_gutter_width);
        Term.indent(bl);
        System.out.println("Cursor:  " + this.st.cursor + "  topMargin " + this.topMargin() + "  botMargin " + this.botMargin());
        this.printCounts(bl);
        MemUse memUse = new MemUse();
        MemUse memUse2 = memUse.changeFrom(this.lastMemUse);
        Term.indent(bl);
        memUse.print("Memory:");
        Term.indent(bl);
        memUse2.print(" Delta:");
    }

    public void printCounts(boolean bl) {
        Term.indent(bl);
        System.out.println("Counts:  putChar() " + this.n_putchar + "  putChars() " + this.n_putchars);
        Term.indent(bl);
        System.out.println("         linefeeds " + this.n_linefeeds);
        Term.indent(bl);
        System.out.println("         repaint() " + this.n_repaint + "  paint() " + this.n_paint);
    }

    public void resetStats() {
        this.n_putchar = 0;
        this.n_putchars = 0;
        this.n_linefeeds = 0;
        this.n_repaint = 0;
        this.n_paint = 0;
        this.lastMemUse = new MemUse();
    }

    public void paste() {
        this.pasteFromClipboard();
    }

    private void pasteHelp(Clipboard clipboard) {
        if (this.read_only) {
            return;
        }
        Transferable transferable = clipboard.getContents(this.screen);
        if (transferable == null) {
            return;
        }
        if (!transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return;
        }
        try {
            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            char[] cArray = string.toCharArray();
            this.sendChars(cArray, 0, cArray.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void pasteFromSelection() {
        if (this.systemSelection == null) {
            return;
        }
        this.pasteHelp(this.systemSelection);
    }

    public void pasteFromClipboard() {
        this.pasteHelp(this.systemClipboard);
    }

    public void copy() {
        this.copyToClipboard();
    }

    public void copyToClipboard() {
        String string = this.sel.getSelection();
        if (string != null) {
            StringSelection stringSelection = new StringSelection(string);
            this.systemClipboard.setContents(stringSelection, this.sel);
        }
    }

    public void copyToSelection() {
        if (this.systemSelection == null) {
            return;
        }
        String string = this.sel.getSelection();
        StringSelection stringSelection = new StringSelection(string);
        this.systemSelection.setContents(stringSelection, this.sel);
    }

    void fireSelectionExtentChanged() {
        Extent extent = this.getSelectionExtent();
        this.firePropertyChange("selectionExtent", old_extent, extent);
        old_extent = extent;
    }

    public void setRows(int n) {
        if (this.old_rows == -1) {
            this.old_rows = this.st.rows;
        }
        this.st.rows = n;
        this.updateScreenSize();
    }

    public int getRows() {
        return this.st.rows;
    }

    public void setColumns(int n) {
        this.buf.setVisibleCols(n);
        this.updateScreenSize();
    }

    void noteColumn(Line line, int n) {
        int n2 = line.bufToCell(this.metrics, n);
        this.buf.noteColumn(n2);
    }

    void checkForMultiCell(char c) {
        this.metrics.checkForMultiCell(c);
    }

    public int getColumns() {
        return this.buf.visibleCols();
    }

    public void setRowsColumns(int n, int n2) {
        if (this.old_rows == -1) {
            this.old_rows = this.st.rows;
        }
        this.st.rows = n;
        this.buf.setVisibleCols(n2);
        this.updateScreenSize();
    }

    public void setSizeRounded(boolean bl) {
        this.size_rounded = bl;
        this.updateScreenSize();
    }

    public boolean isSizeRounded() {
        return this.size_rounded;
    }

    public void fillSizeInfo(Dimension dimension, Dimension dimension2) {
        dimension.height = this.st.rows;
        dimension.width = this.buf.visibleCols();
        Dimension dimension3 = this.screen.getSize();
        dimension2.width = dimension3.width - this.glyph_gutter_width - this.debug_gutter_width;
        dimension2.height = dimension3.height;
    }

    protected void updateTtySize() {
        if (this.screen != null) {
            Dimension dimension = new Dimension(this.buf.visibleCols(), this.st.rows);
            Dimension dimension2 = this.screen.getSize();
            this.fireSizeChanged(dimension, dimension2);
        }
    }

    BCoord toViewCoord(BCoord bCoord) {
        Line line = this.buf.lineAt(bCoord.row);
        if (line != null) {
            int n = this.buf.lineAt(bCoord.row).bufToCell(this.metrics, bCoord.col);
            BCoord bCoord2 = new BCoord(bCoord.row - this.st.firstx, n - this.st.firsty);
            return bCoord2;
        }
        return null;
    }

    Point toPixel(BCoord bCoord) {
        Point point = new Point(bCoord.col * this.metrics.width + this.glyph_gutter_width + this.debug_gutter_width, bCoord.row * this.metrics.height);
        return point;
    }

    public Point toPixel(Coord coord) {
        BCoord bCoord = coord.toBCoord(this.firsta);
        return this.toPixel(bCoord);
    }

    BCoord toViewCoord(Point point) {
        BCoord bCoord = new BCoord(point.y / this.metrics.height, (point.x - this.glyph_gutter_width - this.debug_gutter_width) / this.metrics.width);
        bCoord.clip(this.st.rows, this.buf.visibleCols());
        return bCoord;
    }

    BCoord toBufCoords(BCoord bCoord) {
        int n = this.st.firstx + bCoord.row;
        if (n >= this.buf.nlines) {
            n = this.buf.nlines - 1;
        }
        int n2 = this.buf.lineAt(n).cellToBuf(this.metrics, this.st.firsty + bCoord.col);
        BCoord bCoord2 = new BCoord(n, n2);
        return bCoord2;
    }

    public Point mapToViewRowCol(Point point) {
        BCoord bCoord = this.toViewCoord(point);
        return new Point(bCoord.col, bCoord.row);
    }

    public Point mapToBufRowCol(Point point) {
        BCoord bCoord = this.toBufCoords(this.toViewCoord(point));
        return new Point(bCoord.col, bCoord.row);
    }

    private Color rendition_to_color(int n) {
        switch (n) {
            case 40: {
                return this.standard_color[0];
            }
            case 41: {
                return this.standard_color[1];
            }
            case 42: {
                return this.standard_color[2];
            }
            case 43: {
                return this.standard_color[3];
            }
            case 44: {
                return this.standard_color[4];
            }
            case 45: {
                return this.standard_color[5];
            }
            case 46: {
                return this.standard_color[6];
            }
            case 47: {
                return this.standard_color[7];
            }
            case 58: {
                return this.custom_color[0];
            }
            case 59: {
                return this.custom_color[1];
            }
            case 60: {
                return this.custom_color[2];
            }
            case 61: {
                return this.custom_color[3];
            }
            case 62: {
                return this.custom_color[4];
            }
            case 63: {
                return this.custom_color[5];
            }
            case 64: {
                return this.custom_color[6];
            }
            case 65: {
                return this.custom_color[7];
            }
        }
        return null;
    }

    private void do_run(Graphics graphics, int n, int n2, int n3, int n4, Line line, int n5, int n6, int n7) {
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        if (this.metrics.isMultiCell()) {
            n12 = line.bufToCell(this.metrics, n6);
            n11 = line.bufToCell(this.metrics, n7 + 1) - 1;
            n10 = n2 + (n12 - this.st.firsty) * this.metrics.width;
            int n13 = n11 - n12 + 1;
            if (n13 <= 0) {
                return;
            }
            n9 = n7 - n6 + 1;
            n8 = n13 * this.metrics.width;
        } else {
            n10 = n2 + (n6 - this.st.firsty) * this.metrics.width;
            n9 = n7 - n6 + 1;
            if (n9 <= 0) {
                return;
            }
            n8 = n9 * this.metrics.width;
        }
        n12 = (n5 & 0x800) == 2048 ? 1 : 0;
        n11 = (n5 & 0x10000) == 65536 ? 1 : 0;
        Color color = null;
        color = n11 != 0 ? this.active_color : this.backgroundColor(n12 != 0, n5);
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRect(n10, n, n8, this.metrics.height - this.metrics.leading);
        }
        Color color2 = this.foregroundColor(n12 != 0, n5);
        graphics.setColor(color2);
        if ((n5 & 0x2000) == 8192) {
            int n14 = this.metrics.height - this.metrics.leading - 1;
            graphics.drawLine(n10, n + n14, n10 + n8, n + n14);
        }
        this.myDrawChars(graphics, line, n6, n9, n10, n3);
        if ((n5 & 0x4000) == 16384) {
            this.myDrawChars(graphics, line, n6, n9, n10 + 1, n3);
        }
    }

    private void massage_glyphs(GlyphVector glyphVector, int n, int n2, Line line) {
        Point2D point2D = glyphVector.getGlyphPosition(0);
        this.newp.y = (int)point2D.getY();
        int n3 = (int)point2D.getX();
        for (int i = 0; i < n2; ++i) {
            this.newp.x = n3;
            glyphVector.setGlyphPosition(i, this.newp);
            n3 += line.width(this.metrics, n + i) * this.metrics.width;
        }
    }

    private void myDrawChars(Graphics graphics, Line line, int n, int n2, int n3, int n4) {
        if (this.xferBuf.length < line.length()) {
            this.xferBuf = new char[line.length()];
        }
        line.getChars(this.xferBuf);
        if (this.metrics.isMultiCell()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            char[] cArray = new char[n2];
            System.arraycopy(this.xferBuf, n, cArray, 0, n2);
            GlyphVector glyphVector = this.getFont().createGlyphVector(fontRenderContext, cArray);
            this.massage_glyphs(glyphVector, n, n2, line);
            graphics2D.drawGlyphVector(glyphVector, n3, n4);
        } else {
            graphics.drawChars(this.xferBuf, n, n2, n3, n4);
        }
    }

    private void paint_line_new(Graphics graphics, Line line, int n, int n2, int n3, int n4, Extent extent) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = line.length();
        if (n10 == 0) {
            return;
        }
        if (this.metrics.isMultiCell()) {
            n9 = line.cellToBuf(this.metrics, this.st.firsty);
            n8 = line.bufToCell(this.metrics, n9);
            int n11 = this.st.firsty - n8;
            if (n11 > 0) {
                ++n9;
                n7 = n11 * this.metrics.width;
                n2 += n7;
            }
            n6 = line.cellToBuf(this.metrics, this.st.firsty + this.buf.visibleCols() - 1);
        } else {
            n6 = this.st.firsty + this.buf.visibleCols() - 1;
            n9 = this.st.firsty;
        }
        n6 = Math.min(n6, n10 - 1);
        if (n9 > n6) {
            return;
        }
        n8 = n6 - n9 + 1;
        if (!line.hasAttributes()) {
            if (this.debugWrap()) {
                if (line.isWrapped() && line.isAboutToWrap()) {
                    graphics.setColor(Color.red);
                } else if (line.isAboutToWrap()) {
                    graphics.setColor(Color.orange);
                } else if (line.isWrapped()) {
                    graphics.setColor(Color.magenta);
                }
            }
            this.myDrawChars(graphics, line, n9, n8, n2, n4);
            return;
        }
        int[] nArray = line.attrArray();
        n7 = -1;
        int n12 = -1;
        if (this.check_selection && extent != null) {
            n5 = this.firsta + n;
            Coord coord = extent.begin;
            Coord coord2 = extent.end;
            if (coord.row <= n5 && coord2.row >= n5) {
                if (coord.row == coord2.row) {
                    n7 = coord.col;
                    n12 = coord2.col;
                } else if (n5 == coord.row) {
                    n7 = coord.col;
                    n12 = this.totcols;
                } else if (n5 == coord2.row) {
                    n7 = 0;
                    n12 = coord2.col;
                } else {
                    n7 = 0;
                    n12 = this.totcols;
                }
            }
        }
        int n13 = n5 = n9;
        while (true) {
            int n14 = nArray[n5];
            for (n13 = n5 + 1; n13 <= n6 && nArray[n13] == n14; ++n13) {
            }
            int n15 = n14 & 0xFFFEF610;
            if (n7 == -1 || n12 < n5 || n7 > --n13) {
                this.do_run(graphics, n3, n2, n4, n, line, n14, n5, n13);
            } else if (n7 <= n5 && n12 >= n13) {
                this.do_run(graphics, n3, n2, n4, n, line, n15, n5, n13);
            } else if (n7 > n5 && n12 < n13) {
                this.do_run(graphics, n3, n2, n4, n, line, n14, n5, n7 - 1);
                this.do_run(graphics, n3, n2, n4, n, line, n15, n7, n12);
                this.do_run(graphics, n3, n2, n4, n, line, n14, n12 + 1, n13);
            } else if (n7 <= n5) {
                this.do_run(graphics, n3, n2, n4, n, line, n15, n5, n12);
                this.do_run(graphics, n3, n2, n4, n, line, n14, n12 + 1, n13);
            } else if (n12 >= n13) {
                this.do_run(graphics, n3, n2, n4, n, line, n14, n5, n7 - 1);
                this.do_run(graphics, n3, n2, n4, n, line, n15, n7, n13);
            }
            if (n13 + 1 >= n6) break;
            n5 = n13 + 1;
        }
    }

    void do_paint(Graphics graphics) {
        int n;
        Line line;
        Term.ckEventDispatchThread();
        if (this.st.firstx == -1) {
            return;
        }
        graphics.setFont(this.getFont());
        ++this.n_paint;
        if (this.reverse_video) {
            this.actual_foreground = this.getBackground();
            this.actual_background = this.getForeground();
        } else {
            this.actual_foreground = this.getForeground();
            this.actual_background = this.getBackground();
        }
        graphics.setColor(this.actual_background);
        graphics.fillRect(0, 0, this.screen.getSize().width, this.screen.getSize().height);
        int n2 = this.debug_gutter_width + this.glyph_gutter_width;
        int n3 = this.st.firstx;
        for (int i = 0; i < this.st.rows && (line = this.buf.lineAt(n3)) != null; ++i) {
            int n4 = this.metrics.height * i;
            Color color = this.rendition_to_color(line.getBackgroundColor());
            if (color != null) {
                n = this.metrics.height - this.metrics.leading;
                graphics.setColor(color);
                graphics.fillRect(n2, n4, this.screen.getWidth(), n);
            }
            ++n3;
        }
        if (!this.selection_xor) {
            this.sel.paint(graphics);
        }
        graphics.setColor(this.actual_foreground);
        Extent extent = this.sel.getExtent();
        this.check_selection = extent != null && !this.selection_xor;
        this.totcols = this.buf.totalCols();
        n3 = this.st.firstx;
        for (int i = 0; i < this.st.rows; ++i) {
            Object object;
            Line line2 = this.buf.lineAt(n3);
            if (line2 == null) {
                this.printStats(null);
                break;
            }
            n2 = 0;
            int n5 = this.metrics.height * i;
            n = n5 + this.metrics.ascent;
            if (this.debug_gutter_width > 0) {
                object = "" + (this.firsta + this.st.firstx + i);
                graphics.drawString((String)object, n2, n);
            }
            n2 += this.debug_gutter_width;
            if (this.glyph_gutter_width > 0 && (object = this.glyph_images[line2.getGlyphId()]) != null) {
                int n6 = n5;
                graphics.drawImage((Image)object, n2, n6, Color.white, null);
            }
            this.paint_line_new(graphics, line2, i + this.st.firstx, n2 += this.glyph_gutter_width, n5, n, extent);
            graphics.setColor(this.actual_foreground);
            ++n3;
        }
        this.paint_cursor(graphics);
        if (this.selection_xor) {
            this.sel.paint(graphics);
        }
        if (this.debugMargins()) {
            this.paint_margins(graphics);
        }
    }

    private void paint_margins(Graphics graphics) {
    }

    private void paint_cursor(Graphics graphics) {
        if (!this.cursor_visible) {
            return;
        }
        if (this.st.cursor.row == -1) {
            return;
        }
        int n = this.st.cursor.row - this.st.firstx;
        if (n >= this.st.rows) {
            return;
        }
        int n2 = this.st.cursor.col - this.st.firsty;
        if (n2 >= this.buf.visibleCols()) {
            return;
        }
        if (n2 < 0) {
            return;
        }
        graphics.setXORMode(this.actual_background);
        int n3 = n2 * this.metrics.width + this.glyph_gutter_width + this.debug_gutter_width;
        int n4 = n * this.metrics.height;
        int n5 = this.metrics.width;
        int n6 = this.metrics.height - this.metrics.leading;
        if (this.has_focus) {
            graphics.fillRect(n3, n4, n5, n6);
        } else {
            graphics.drawRect(n3, n4, n5, n6);
        }
    }

    private boolean possiblyScrollDown() {
        if (this.st.cursor.row >= this.st.firstx + this.botMargin() + 1) {
            if (this.topMargin() == 0) {
                if (this.scroll_on_output || this.cursor_was_visible() && this.track_cursor) {
                    ++this.st.firstx;
                }
                return true;
            }
            this.st.cursor.row = this.st.firstx + this.botMargin();
            Line line = this.buf.moveLineFromTo(this.st.firstx + this.topMargin(), this.st.cursor.row);
            line.reset();
            return false;
        }
        return false;
    }

    public void putChar(char c) {
        this.dce_end.putChar(c);
    }

    public void putChars(char[] cArray, int n, int n2) {
        this.dce_end.putChars(cArray, n, n2);
    }

    public void flush() {
        this.dce_end.flush();
    }

    private void reply(String string) {
        for (int i = 0; i < string.length(); ++i) {
            this.sendChar(string.charAt(i));
        }
    }

    private void putc_work(char c) {
        this.interp.processChar(c);
        this.possiblyHScroll();
        this.screen.possiblyUpdateCaretText();
    }

    private void on_char(char c) {
        this.sendChar(c);
    }

    private void onCursorKey(KeyEvent keyEvent) {
        this.sendChar('\u001b');
        this.sendChar('[');
        keyEvent.consume();
        switch (keyEvent.getKeyCode()) {
            case 38: {
                this.sendChar('A');
                break;
            }
            case 40: {
                this.sendChar('B');
                break;
            }
            case 39: {
                this.sendChar('C');
                break;
            }
            case 37: {
                this.sendChar('D');
            }
        }
    }

    private void sendChars(char[] cArray, int n, int n2) {
        this.dte_end.sendChars(cArray, n, n2);
    }

    private void sendChar(char c) {
        this.dte_end.sendChar(c);
    }

    private void adjust_scrollbar() {
        this.adjust_scrollbar_impl();
    }

    private void adjust_scrollbar_impl() {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.vscroll_bar != null) {
            n4 = this.st.firstx;
            n3 = this.st.rows - 1;
            n2 = 0;
            n = this.buf.nlines <= this.st.rows ? this.st.rows - 1 : this.buf.nlines - 1;
            this.vscroll_bar.setValues(n4, n3, n2, n);
        }
        if (this.hscroll_bar != null && this.horizontally_scrollable) {
            n4 = this.st.firsty;
            n3 = this.buf.visibleCols() - 1;
            n2 = 0;
            n = this.buf.totalCols() <= this.buf.visibleCols() ? this.buf.visibleCols() - 1 : this.buf.totalCols() - 1;
            this.hscroll_bar.setValues(n4, n3, n2, n);
        }
    }

    private Dimension calculateSize() {
        int n = this.buf.visibleCols() * this.metrics.width + this.glyph_gutter_width + this.debug_gutter_width;
        int n2 = this.st.rows * this.metrics.height;
        Dimension dimension = new Dimension(n, n2);
        return dimension;
    }

    private void updateScreenSize() {
        if (this.screen != null) {
            Dimension dimension = this.calculateSize();
            this.sizeChanged(dimension.width, dimension.height);
        }
    }

    void sizeChanged(int n, int n2) {
        int n3 = (n - this.glyph_gutter_width - this.debug_gutter_width) / this.metrics.width;
        this.buf.setVisibleCols(n3);
        if (this.old_rows == -1) {
            this.old_rows = this.st.rows;
        }
        this.st.rows = n2 / this.metrics.height;
        if (this.st.rows < 1) {
            this.st.rows = 1;
        }
        int n4 = this.st.rows - this.old_rows;
        this.old_rows = -1;
        this.adjust_lines(n4);
        this.limit_lines();
        Dimension dimension = this.isSizeRounded() ? this.calculateSize() : new Dimension(n, n2);
        this.screen.setPreferredSize(dimension);
        this.invalidate();
        if (this.getParent() != null) {
            this.getParent().validate();
        }
        this.updateTtySize();
    }

    protected void possibly_repaint(boolean bl) {
        if (!this.refresh_enabled) {
            return;
        }
        this.repaint(bl);
    }

    protected void repaint(boolean bl) {
        ++this.n_repaint;
        if (bl) {
            this.adjust_scrollbar();
        }
        this.screen.repaint(20L);
    }

    public void setReverseVideo(boolean bl) {
        this.reverse_video = bl;
        this.repaint(false);
    }

    public boolean isReverseVideo() {
        return this.reverse_video;
    }

    public void setHighlightColor(Color color) {
        this.sel.setColor(color);
        this.repaint(false);
    }

    public Color getHighlightColor() {
        return this.sel.getColor();
    }

    public void setHighlightXORColor(Color color) {
        this.sel.setXORColor(color);
        this.repaint(false);
    }

    public Color getHighlightXORColor() {
        return this.sel.getXORColor();
    }

    public void setActiveColor(Color color) {
        this.active_color = color;
        this.repaint(false);
    }

    public Color getActiveColor() {
        return this.active_color;
    }

    public void setAnchored(boolean bl) {
        Term.ckEventDispatchThread();
        if (bl) {
            this.anchored = false;
            this.limit_lines();
            this.anchored = true;
        } else {
            this.anchored = false;
            this.limit_lines();
            this.repaint(false);
        }
    }

    public boolean isAnchored() {
        return this.anchored;
    }

    public JComponent getCanvas() {
        return this.screen;
    }

    public JComponent getScreen() {
        return this.screen;
    }

    public Ops ops() {
        return this.ops;
    }

    public void setEmulation(String string) {
        Interp interp = InterpKit.forName(string, this.ops);
        if (interp == null) {
            return;
        }
        this.interp = interp;
    }

    public String getEmulation() {
        return this.getInterp().name();
    }

    public void setInterp(Interp interp) {
        this.interp = interp;
    }

    public Interp getInterp() {
        return this.interp;
    }

    public void setHistorySize(int n) {
        this.history_size = n;
        this.limit_lines();
        this.repaint(true);
    }

    public int getHistorySize() {
        return this.history_size;
    }

    public void setGlyphGutterWidth(int n) {
        this.glyph_gutter_width = n;
        if (this.glyph_gutter_width > 30) {
            this.glyph_gutter_width = 30;
        }
        this.updateScreenSize();
    }

    public void setGlyphImage(int n, Image image) {
        if (n > 256) {
            return;
        }
        this.glyph_images[n] = image;
    }

    public Dimension getGlyphCellSize() {
        return new Dimension(this.glyph_gutter_width, this.metrics.height);
    }

    public void setCustomColor(int n, Color color) {
        this.custom_color[n] = color;
    }

    public int getCursorRow() {
        return this.st.cursor.row;
    }

    public int getCursorCol() {
        return this.cursor_line().cellToBuf(this.metrics, this.st.cursor.col);
    }

    public Coord getCursorCoord() {
        Line line = this.buf.lineAt(this.st.cursor.row);
        return new Coord(new BCoord(this.st.cursor.row, line.cellToBuf(this.metrics, this.st.cursor.col)), this.firsta);
    }

    public void goTo(Coord coord) {
        this.setCursorCoord(coord);
    }

    public void setCursorCoord(Coord coord) {
        Coord coord2 = (Coord)coord.clone();
        coord2.clip(this.st.rows, this.buf.visibleCols(), this.firsta);
        this.st.cursor = coord2.toBCoord(this.firsta);
        this.st.cursor.col = this.cursor_line().bufToCell(this.metrics, this.st.cursor.col);
        this.repaint(true);
    }

    public void setCursorVisible(boolean bl) {
        this.cursor_visible = bl;
    }

    public boolean isCursorVisible() {
        return this.cursor_visible;
    }

    public Coord backup(Coord coord) {
        BCoord bCoord = this.buf.backup(coord.toBCoord(this.firsta));
        if (bCoord == null) {
            return null;
        }
        return new Coord(bCoord, this.firsta);
    }

    public Coord advance(Coord coord) {
        return new Coord(this.buf.advance(coord.toBCoord(this.firsta)), this.firsta);
    }

    public String getSelectedText() {
        return this.sel.getSelection();
    }

    public Extent getSelectionExtent() {
        return this.sel.getExtent();
    }

    public void setSelectionExtent(Extent extent) {
        extent.begin.clip(this.buf.nlines, this.buf.totalCols(), this.firsta);
        extent.end.clip(this.buf.nlines, this.buf.totalCols(), this.firsta);
        this.sel.setExtent(extent);
        this.repaint(false);
    }

    public void clearSelection() {
        this.sel.cancel(true);
        this.repaint(false);
    }

    public void setAutoCopy(boolean bl) {
    }

    public boolean isAutoCopy() {
        return true;
    }

    public void setRefreshEnabled(boolean bl) {
        this.refresh_enabled = bl;
        if (bl) {
            this.repaint(true);
        }
    }

    public boolean isRefreshEnabled() {
        return this.refresh_enabled;
    }

    public void setSelectionXOR(boolean bl) {
        this.selection_xor = bl;
        this.repaint(false);
    }

    public boolean isSelectionXOR() {
        return this.selection_xor;
    }

    public void setTabSize(int n) {
        this.tab_size = n;
    }

    public int getTabSize() {
        return this.tab_size;
    }

    public void setScrollOnInput(boolean bl) {
        this.scroll_on_input = bl;
    }

    public boolean isScrollOnInput() {
        return this.scroll_on_input;
    }

    public void setScrollOnOutput(boolean bl) {
        this.scroll_on_output = bl;
    }

    public boolean isScrollOnOutput() {
        return this.scroll_on_output;
    }

    public void setTrackCursor(boolean bl) {
        this.track_cursor = bl;
    }

    public boolean isTrackCursor() {
        return this.track_cursor;
    }

    public void setHorizontallyScrollable(boolean bl) {
        this.horizontally_scrollable = bl;
        this.hscroll_wrapper.setVisible(bl);
    }

    public boolean isHorizontallyScrollable() {
        return this.horizontally_scrollable;
    }

    public void setText(String string) {
        this.clearHistoryNoRefresh();
        this.appendText(string, true);
    }

    public void appendText(String string, boolean bl) {
        if (string == null) {
            return;
        }
        Term.ckEventDispatchThread();
        for (int i = 0; i < string.length(); ++i) {
            this.putc_work(string.charAt(i));
            if (string.charAt(i) != '\n') continue;
            this.putc_work('\r');
        }
        if (bl) {
            this.repaint(true);
        }
    }

    public void pageUp(int n) {
        Term.ckEventDispatchThread();
        this.st.firstx -= n * this.st.rows;
        if (this.st.firstx < 0) {
            this.st.firstx = 0;
        }
        this.repaint(true);
    }

    public void pageDown(int n) {
        Term.ckEventDispatchThread();
        this.st.firstx += n * this.st.rows;
        if (this.st.firstx + this.st.rows > this.buf.nlines) {
            this.st.firstx = this.buf.nlines - this.st.rows;
        }
        this.repaint(true);
    }

    public void lineUp(int n) {
        Term.ckEventDispatchThread();
        this.st.firstx -= n;
        if (this.st.firstx < 0) {
            this.st.firstx = 0;
        }
        this.repaint(true);
    }

    public void lineDown(int n) {
        Term.ckEventDispatchThread();
        this.st.firstx += n;
        if (this.st.firstx + this.st.rows > this.buf.nlines) {
            this.st.firstx = this.buf.nlines - this.st.rows;
        }
        this.repaint(true);
    }

    public void pageLeft(int n) {
        this.columnLeft(n * this.buf.visibleCols());
    }

    public void pageRight(int n) {
        this.columnRight(n * this.buf.visibleCols());
    }

    public void columnRight(int n) {
        Term.ckEventDispatchThread();
        this.st.firsty += n;
        if (this.st.firsty + this.buf.visibleCols() > this.buf.totalCols()) {
            this.st.firsty = this.buf.totalCols() - this.buf.visibleCols();
        }
        this.repaint(true);
    }

    public void columnLeft(int n) {
        Term.ckEventDispatchThread();
        this.st.firsty -= n;
        if (this.st.firsty < 0) {
            this.st.firsty = 0;
        }
        this.repaint(true);
    }

    public int charWidth(char c) {
        return this.metrics.wcwidth(c);
    }

    public void setFont(Font font) {
        Font font2 = new Font("Monospaced", font.getStyle(), font.getSize());
        super.setFont(font2);
        this.metrics = new MyFontMetrics(this, font2);
        this.updateScreenSize();
    }

    public void requestFocus() {
        this.screen.requestFocus();
    }

    public boolean requestFocusInWindow() {
        return this.screen.requestFocusInWindow();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.hscroll_bar.setEnabled(bl);
        this.vscroll_bar.setEnabled(bl);
        this.screen.setEnabled(bl);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessible_context == null) {
            this.accessible_context = new AccessibleTerm();
        }
        return this.accessible_context;
    }

    public int CoordToPosition(Coord coord) {
        BCoord bCoord = coord.toBCoord(this.firsta);
        int n = this.charsInPrehistory;
        for (int i = 0; i < bCoord.row; ++i) {
            Line line = this.buf.lineAt(i);
            n += line.length();
            if (line.isWrapped()) continue;
            ++n;
        }
        return n += coord.col;
    }

    public Coord PositionToCoord(int n) {
        int n2 = this.charsInPrehistory;
        for (int i = 0; i < this.buf.nlines; ++i) {
            Line line = this.buf.lineAt(i);
            n2 += line.length();
            if (!line.isWrapped()) {
                ++n2;
            }
            if (n2 <= n) continue;
            BCoord bCoord = new BCoord();
            bCoord.row = i;
            bCoord.col = this.buf.lineAt(i).length() + 1 - (n2 - n);
            return new Coord(bCoord, this.firsta);
        }
        return null;
    }

    int getCharCount() {
        int n = this.charsInPrehistory;
        for (int i = 0; i < this.buf.nlines; ++i) {
            Line line = this.buf.lineAt(i);
            n += line.length();
            if (line.isWrapped()) continue;
            ++n;
        }
        return n;
    }

    Rectangle getCharacterBounds(Coord coord) {
        Object object;
        if (coord == null) {
            return null;
        }
        BCoord bCoord = coord.toBCoord(this.firsta);
        char c = '\u0000';
        try {
            object = this.buf.lineAt(bCoord.row);
            c = ((Line)object).charAt(bCoord.col);
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = this.toPixel(bCoord);
        Rectangle rectangle = new Rectangle();
        rectangle.x = ((Point)object).x;
        rectangle.y = ((Point)object).y;
        rectangle.width = this.metrics.width * this.charWidth(c);
        rectangle.height = this.metrics.height;
        return rectangle;
    }

    Color backgroundColor(boolean bl, int n) {
        Color color = null;
        if (bl) {
            int n2 = Attr.foregroundColor(n);
            color = n2 != 0 && n2 <= 8 ? this.standard_color[n2 - 1] : (n2 > 8 ? this.custom_color[n2 - 9] : this.actual_foreground);
        } else {
            int n3 = Attr.backgroundColor(n);
            if (n3 != 0 && n3 <= 8) {
                color = this.standard_color[n3 - 1];
            } else if (n3 > 8) {
                color = this.custom_color[n3 - 9];
            }
        }
        return color;
    }

    Color foregroundColor(boolean bl, int n) {
        int n2;
        int n3;
        Color color = null;
        color = bl ? ((n3 = Attr.backgroundColor(n)) != 0 && n3 <= 8 ? this.standard_color[n3 - 1] : (n3 > 8 ? this.custom_color[n3 - 9] : this.actual_background)) : ((n2 = Attr.foregroundColor(n)) != 0 && n2 <= 8 ? this.standard_color[n2 - 1] : (n2 > 8 ? this.custom_color[n2 - 9] : this.actual_foreground));
        return color;
    }

    private static void ckEventDispatchThread() {
    }

    private static void addMouseWheelHandler(JComponent jComponent, JScrollBar jScrollBar) {
        jComponent.addMouseWheelListener(new MouseWheelHandler(jScrollBar));
    }

    private static class MouseWheelHandler
    implements MouseWheelListener {
        private JScrollBar scrollbar;

        public MouseWheelHandler(JScrollBar jScrollBar) {
            this.scrollbar = jScrollBar;
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            int n = mouseWheelEvent.getUnitsToScroll() * this.scrollbar.getUnitIncrement();
            this.scrollbar.setValue(this.scrollbar.getValue() + n);
        }
    }

    protected class AccessibleTerm
    extends JComponent.AccessibleJComponent {
        protected AccessibleTerm() {
            super(Term.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }

        public void setAccessibleName(String string) {
            Term.this.screen.getAccessibleContext().setAccessibleName(string);
        }
    }

    private class OpsImpl
    implements Ops {
        long last_time = System.currentTimeMillis();

        private OpsImpl() {
        }

        public void op_pause() {
            Thread.currentThread();
            Thread.yield();
        }

        public void op_char(char c) {
            if (Term.this.debugOps()) {
                System.out.println("op_char('" + c + "') = " + c);
            }
            Line line = Term.this.cursor_line();
            int n = line.cellToBuf(Term.this.metrics, ((Term)Term.this).st.cursor.col);
            if (Term.this.debugOps()) {
                System.out.println("op_char(): st.cursor.col " + ((Term)Term.this).st.cursor.col + " insertion_col " + n);
            }
            if (!((Term)Term.this).st.overstrike) {
                line.insertCharAt(Term.this, ' ', n, ((Term)Term.this).st.attr);
            }
            int n2 = Term.this.metrics.wcwidth(c);
            if (line.isAboutToWrap() || n2 > 1 && ((Term)Term.this).st.cursor.col + n2 > Term.this.buf.visibleCols() && !Term.this.horizontally_scrollable) {
                if (Term.this.debugOps()) {
                    System.out.println("\twrapping it");
                }
                line.setWrapped(true);
                line.setAboutToWrap(false);
                this.op_line_feed();
                this.op_carriage_return();
                line = Term.this.cursor_line();
                n = 0;
            }
            line.setCharAt(Term.this, c, n, ((Term)Term.this).st.attr);
            ((Term)Term.this).st.cursor.col += n2;
            if (((Term)Term.this).st.cursor.col >= Term.this.buf.visibleCols() && !Term.this.horizontally_scrollable) {
                if (Term.this.debugOps()) {
                    System.out.println("\tabout to wrap");
                }
                line.setAboutToWrap(true);
                ((Term)Term.this).st.cursor.col -= n2;
            }
        }

        public void op_as() {
        }

        public void op_ae() {
        }

        public void op_attr(int n) {
            if (Term.this.debugOps()) {
                System.out.println("op_attr(" + n + ")");
            }
            Term.this.setAttribute(n);
        }

        public void op_bel() {
            if (Term.this.debugOps()) {
                System.out.println("op_bel()");
            }
        }

        public void op_back_space() {
            if (Term.this.debugOps()) {
                System.out.println("op_back_space");
            }
            if (((Term)Term.this).st.cursor.col > 0) {
                if (!Term.this.cursor_line().isAboutToWrap()) {
                    --((Term)Term.this).st.cursor.col;
                }
                Term.this.cursor_line().setAboutToWrap(false);
                if (((Term)Term.this).st.cursor.col == 0 && ((Term)Term.this).st.cursor.row > 0) {
                    Line line;
                    if (Term.this.debugOps()) {
                        System.out.println("\tchecking if prev is wrapped");
                    }
                    if ((line = Term.this.buf.lineAt(((Term)Term.this).st.cursor.row - 1)).isWrapped()) {
                        if (Term.this.debugOps()) {
                            System.out.println("\tit is");
                        }
                        --((Term)Term.this).st.cursor.row;
                        int n = line.cellToBuf(Term.this.metrics, Term.this.buf.visibleCols() - 1);
                        ((Term)Term.this).st.cursor.col = line.bufToCell(Term.this.metrics, n);
                        line.setWrapped(false);
                        line.setAboutToWrap(true);
                    }
                }
            }
        }

        public void op_line_feed() {
            if (Term.this.debugOps()) {
                System.out.println("op_line_feed");
            }
            Line line = Term.this.cursor_line();
            ++((Term)Term.this).st.cursor.row;
            if (Term.this.possiblyScrollDown()) {
                Term.this.buf.addLineAt(((Term)Term.this).st.cursor.row);
                Term.this.limit_lines();
                if (Term.this.debugOps()) {
                    System.out.println("op_line_feed ADJUSTED");
                }
            }
            boolean bl = line.isAboutToWrap();
            Term.this.cursor_line().setAboutToWrap(bl);
            line.setAboutToWrap(false);
            Term.this.n_linefeeds++;
        }

        public void op_tab() {
            if (Term.this.debugOps()) {
                System.out.println("op_tab");
            }
            if (((Term)Term.this).st.cursor.col == Term.this.buf.visibleCols() - 1 && !Term.this.horizontally_scrollable) {
                return;
            }
            Line line = Term.this.cursor_line();
            int n = line.cellToBuf(Term.this.metrics, ((Term)Term.this).st.cursor.col);
            ++((Term)Term.this).st.cursor.col;
            ++n;
            while ((((Term)Term.this).st.cursor.col < Term.this.buf.visibleCols() - 1 || Term.this.horizontally_scrollable) && ((Term)Term.this).st.cursor.col % Term.this.tab_size != 0) {
                ++((Term)Term.this).st.cursor.col;
                ++n;
            }
        }

        public void op_carriage_return() {
            if (Term.this.debugOps()) {
                System.out.println("op_carriage_return");
            }
            ((Term)Term.this).st.cursor.col = 0;
            Term.this.cursor_line().setAboutToWrap(false);
        }

        public void op_al(int n) {
            if (Term.this.debugOps()) {
                System.out.println("op_al(" + n + ")");
            }
            while (n-- > 0) {
                boolean bl = Term.this.cursor_line().setAboutToWrap(false);
                Line line = Term.this.buf.moveLineFromTo(((Term)Term.this).st.firstx + Term.this.botMargin(), ((Term)Term.this).st.cursor.row);
                line.reset();
                Term.this.cursor_line().setAboutToWrap(bl);
            }
            switch (Term.this.sel.intersection(((Term)Term.this).st.cursor.row - 1)) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    Term.this.sel.cancel(true);
                    break;
                }
                case 4: {
                    Term.this.sel.adjust(Term.this.firsta, 1, Term.this.firsta + Term.this.buf.nlines);
                }
            }
        }

        public void op_bc(int n) {
            if (Term.this.debugOps()) {
                System.out.println("op_bc(" + n + ")");
            }
            while (n-- > 0) {
                if (((Term)Term.this).st.cursor.col <= 0) {
                    return;
                }
                --((Term)Term.this).st.cursor.col;
            }
            Term.this.cursor_line().setAboutToWrap(false);
        }

        public void op_cm(int n, int n2) {
            if (Term.this.debugOps()) {
                System.out.println("op_cm(row " + n + ", col " + n2 + ")");
            }
            if (n == 0) {
                n = 1;
            }
            if (n2 == 0) {
                n2 = 1;
            }
            if (n > ((Term)Term.this).st.rows) {
                n = ((Term)Term.this).st.rows;
            }
            if (n2 > Term.this.buf.visibleCols()) {
                n2 = Term.this.buf.visibleCols();
            }
            Term.this.cursor_line().setAboutToWrap(false);
            ((Term)Term.this).st.cursor.row = Term.this.beginx() + n - 1;
            ((Term)Term.this).st.cursor.col = n2 - 1;
        }

        public void op_cl() {
            if (Term.this.debugOps()) {
                System.out.println("op_cl");
            }
            Term.this.cursor_line().setAboutToWrap(false);
            Term.this.clear();
            ((Term)Term.this).st.cursor.row = Term.this.beginx();
            ((Term)Term.this).st.cursor.col = 0;
        }

        public void op_ce() {
            if (Term.this.debugOps()) {
                System.out.println("op_ce");
            }
            Line line = Term.this.cursor_line();
            line.clearToEndFrom(Term.this, line.cellToBuf(Term.this.metrics, ((Term)Term.this).st.cursor.col));
            switch (Term.this.sel.intersection(((Term)Term.this).st.cursor.row)) {
                case 0: 
                case 1: 
                case 4: {
                    break;
                }
                case 2: 
                case 3: {
                    Term.this.sel.cancel(true);
                }
            }
        }

        public void op_cd() {
            if (Term.this.debugOps()) {
                System.out.println("op_cd -- clear to end of screen");
            }
            for (int i = ((Term)Term.this).st.cursor.row; i < Term.this.beginx() + ((Term)Term.this).st.rows; ++i) {
                Line line = Term.this.buf.lineAt(i);
                line.reset();
            }
            switch (Term.this.sel.intersection(((Term)Term.this).st.cursor.row)) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    Term.this.sel.cancel(true);
                }
            }
        }

        public void op_dc(int n) {
            if (Term.this.debugOps()) {
                System.out.println("op_dc(" + n + ")");
            }
            if (n == 0) {
                n = 1;
            }
            Line line = Term.this.cursor_line();
            while (n-- > 0) {
                line.deleteCharAt(line.cellToBuf(Term.this.metrics, ((Term)Term.this).st.cursor.col));
            }
        }

        public void op_dl(int n) {
            if (Term.this.debugOps()) {
                System.out.println("op_dl(" + n + ")");
            }
            while (n-- > 0) {
                boolean bl = Term.this.cursor_line().setAboutToWrap(false);
                Line line = Term.this.buf.moveLineFromTo(((Term)Term.this).st.cursor.row, Term.this.beginx() + Term.this.botMargin() - 1);
                line.reset();
                Term.this.cursor_line().setAboutToWrap(bl);
            }
            switch (Term.this.sel.intersection(((Term)Term.this).st.cursor.row)) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    Term.this.sel.cancel(true);
                    break;
                }
                case 4: {
                    Term.this.sel.adjust(Term.this.firsta, -1, Term.this.firsta + Term.this.buf.nlines);
                }
            }
        }

        public void op_do(int n) {
            if (Term.this.debugOps()) {
                System.out.println("op_do(" + n + ") -- down");
            }
            boolean bl = Term.this.cursor_line().setAboutToWrap(false);
            while (n-- > 0) {
                ++((Term)Term.this).st.cursor.row;
                if (((Term)Term.this).st.cursor.row < Term.this.buf.nlines || !Term.this.possiblyScrollDown()) continue;
                Term.this.buf.addLineAt(((Term)Term.this).st.cursor.row);
                Term.this.limit_lines();
                if (!Term.this.debugOps()) continue;
                System.out.println("op_do ADJUSTED");
            }
            Term.this.cursor_line().setAboutToWrap(bl);
        }

        public void op_ho() {
            if (Term.this.debugOps()) {
                System.out.println("op_ho -- home");
            }
            Term.this.cursor_line().setAboutToWrap(false);
            ((Term)Term.this).st.cursor.row = Term.this.beginx();
            ((Term)Term.this).st.cursor.col = 0;
        }

        public void op_ic(int n) {
            if (Term.this.debugOps()) {
                System.out.println("op_ic(" + n + ")");
            }
            Line line = Term.this.cursor_line();
            int n2 = line.cellToBuf(Term.this.metrics, ((Term)Term.this).st.cursor.col);
            while (n-- > 0) {
                line.insertCharAt(Term.this, ' ', n2, ((Term)Term.this).st.attr);
            }
        }

        public void op_nd(int n) {
            if (Term.this.debugOps()) {
                System.out.println("op_nd(" + n + ")");
            }
            int n2 = ((Term)Term.this).st.cursor.col;
            while (n-- > 0) {
                if (++n2 < Term.this.buf.visibleCols()) continue;
                if (Term.this.debugOps()) {
                    System.out.println("\tbailing out at count " + n);
                }
                --n2;
                break;
            }
            ((Term)Term.this).st.cursor.col = n2;
        }

        public void op_up(int n) {
            if (Term.this.debugOps()) {
                System.out.println("op_up(" + n + ")");
            }
            boolean bl = Term.this.cursor_line().setAboutToWrap(false);
            while (n-- > 0) {
                --((Term)Term.this).st.cursor.row;
                if (((Term)Term.this).st.cursor.row >= ((Term)Term.this).st.firstx) continue;
                ((Term)Term.this).st.cursor.row = ((Term)Term.this).st.firstx;
                Line line = Term.this.buf.moveLineFromTo(((Term)Term.this).st.firstx + Term.this.botMargin(), ((Term)Term.this).st.cursor.row);
                line.reset();
            }
            Term.this.cursor_line().setAboutToWrap(bl);
        }

        public void op_sc() {
            if (Term.this.debugOps()) {
                System.out.println("op_sc()");
            }
            Term.this.st.saveCursor();
        }

        public void op_rc() {
            if (Term.this.debugOps()) {
                System.out.println("op_rc()");
            }
            Term.this.st.restoreCursor();
        }

        public void op_glyph(int n, int n2) {
            if (Term.this.debugOps()) {
                System.out.println("op_glyph(glyph " + n + ", rendition " + n2 + ")");
            }
            Term.this.setGlyph(n, n2);
        }

        public void op_reverse(boolean bl) {
            Term.this.setReverseVideo(bl);
        }

        public void op_cursor_visible(boolean bl) {
            Term.this.setCursorVisible(bl);
        }

        public void op_icon_name(String string) {
            if (Term.this.debugOps()) {
                System.out.println("op_icon_name(" + string + ")");
            }
        }

        public void op_win_title(String string) {
            if (Term.this.debugOps()) {
                System.out.println("op_win_title(" + string + ")");
            }
        }

        public void op_cwd(String string) {
            if (Term.this.debugOps()) {
                System.out.println("op_cwd(" + string + ")");
            }
        }

        public void op_margin(int n, int n2) {
            if (Term.this.debugOps()) {
                System.out.println("op_margin(" + n + ", " + n2 + ")");
            }
            if (n < 0) {
                Term.this.top_margin = 0;
            } else if (n > ((Term)Term.this).st.rows) {
                Term.this.top_margin = ((Term)Term.this).st.rows;
            } else {
                Term.this.top_margin = n;
            }
            if (n2 < 0) {
                Term.this.bot_margin = 0;
            } else if (n2 > ((Term)Term.this).st.rows) {
                Term.this.bot_margin = ((Term)Term.this).st.rows;
            } else {
                Term.this.bot_margin = n2;
            }
            if (Term.this.top_margin > Term.this.bot_margin) {
                int n3 = Term.this.top_margin;
                Term.this.top_margin = Term.this.bot_margin;
                Term.this.bot_margin = n3;
            }
        }

        public void op_time(boolean bl) {
            int n;
            long l = System.currentTimeMillis();
            long l2 = l - this.last_time;
            Date date = new Date(l);
            String string = date.toString();
            String string2 = "" + l2 / 1000L + "." + l2 % 1000L;
            String string3 = string + " Elapsed (sec): " + string2;
            String string4 = "putChar " + Term.this.n_putchar + "  putChars " + Term.this.n_putchars + "  linefeeds " + Term.this.n_linefeeds + "  repaint " + Term.this.n_repaint + "  paint " + Term.this.n_paint;
            Term.this.setAttribute(41);
            for (n = 0; n < string3.length(); ++n) {
                this.op_char(string3.charAt(n));
            }
            this.op_line_feed();
            this.op_carriage_return();
            for (n = 0; n < string4.length(); ++n) {
                this.op_char(string4.charAt(n));
            }
            Term.this.setAttribute(0);
            this.last_time = l;
            Term.this.n_putchar = 0;
            Term.this.n_putchars = 0;
            Term.this.n_linefeeds = 0;
            Term.this.n_paint = 0;
            Term.this.n_repaint = 0;
            Term.this.repaint(true);
        }

        public int op_get_width() {
            return Term.this.horizontally_scrollable ? Term.this.buf.totalCols() : Term.this.buf.visibleCols();
        }

        public int op_get_column() {
            return ((Term)Term.this).st.cursor.col;
        }

        public void op_soft_reset() {
            ((Term)Term.this).st.overstrike = true;
            Term.this.top_margin = 0;
            Term.this.bot_margin = 0;
            ((Term)Term.this).st.attr = 0;
            Term.this.repaint(false);
        }

        public void op_full_reset() {
            this.op_soft_reset();
            this.op_cl();
            Term.this.reverse_video = false;
            Term.this.repaint(false);
        }

        public void op_set_mode(int n) {
            switch (n) {
                case 4: {
                    ((Term)Term.this).st.overstrike = false;
                    break;
                }
            }
        }

        public void op_reset_mode(int n) {
            switch (n) {
                case 4: {
                    ((Term)Term.this).st.overstrike = true;
                    break;
                }
            }
        }

        public void op_status_report(int n) {
            switch (n) {
                case 5: {
                    Term.this.reply("\u001b[0n");
                    break;
                }
                case 6: {
                    Term.this.reply("\u001b[" + (((Term)Term.this).st.cursor.row - ((Term)Term.this).st.firstx) + ";" + ((Term)Term.this).st.cursor.col + "R");
                }
            }
        }
    }

    private static class MemUse {
        private long free;
        private long max;
        private long total;

        public MemUse() {
            this.free = Runtime.getRuntime().freeMemory();
            this.max = Runtime.getRuntime().maxMemory();
            this.total = Runtime.getRuntime().totalMemory();
        }

        private MemUse(long l, long l2, long l3) {
            this.free = l;
            this.max = l2;
            this.total = l3;
        }

        public MemUse changeFrom(MemUse memUse) {
            return new MemUse(this.free - memUse.free, this.max - memUse.max, this.total - memUse.total);
        }

        private long unused() {
            return this.max - (this.total + this.free);
        }

        private void print(String string) {
            System.out.println(string + "  max " + this.max / 1024L + "K" + " = " + "  total " + this.total / 1024L + "K" + " + " + "  free " + this.free / 1024L + "K" + " + " + "  unused " + this.unused() / 1024L + "K");
        }
    }

    private class Scroller
    extends Thread {
        public static final int UP = 2;
        public static final int DOWN = 4;
        public static final int LEFT = 8;
        public static final int RIGHT = 16;
        private int direction;

        public Scroller(int n) {
            this.direction = n;
        }

        private boolean extend() {
            BCoord bCoord;
            Term.ckEventDispatchThread();
            if (((Term)Term.this).sel.sel_extent == null) {
                return false;
            }
            BCoord bCoord2 = ((Term)Term.this).sel.sel_extent.toBCoord(Term.this.firsta);
            BCoord bCoord3 = Term.this.toViewCoord(bCoord2);
            int n = bCoord3.row;
            int n2 = bCoord3.col;
            if ((this.direction & 4) == 4) {
                Term.this.lineDown(1);
                n = ((Term)Term.this).st.rows - 1;
                n2 = Term.this.buf.totalCols();
            } else if ((this.direction & 2) == 2) {
                Term.this.lineUp(1);
                n = 0;
                n2 = 0;
            } else {
                bCoord = Term.this.toViewCoord(Term.this.drag_point);
                n = bCoord.row;
                n2 = bCoord.col;
            }
            if ((this.direction & 8) == 8) {
                --((Term)Term.this).st.firsty;
                if (((Term)Term.this).st.firsty < 0) {
                    ((Term)Term.this).st.firsty = 0;
                }
                n2 = 0;
            } else if ((this.direction & 0x10) == 16) {
                ++((Term)Term.this).st.firsty;
                int n3 = Term.this.buf.totalCols() - Term.this.buf.visibleCols();
                if (n3 < 0) {
                    n3 = 0;
                }
                if (((Term)Term.this).st.firsty > n3) {
                    ((Term)Term.this).st.firsty = n3;
                }
                n2 = ((Term)Term.this).st.firsty + Term.this.buf.visibleCols();
            }
            bCoord = new BCoord(n, n2);
            BCoord bCoord4 = Term.this.toBufCoords(bCoord);
            Term.this.sel.track(new Coord(bCoord4, Term.this.firsta));
            Term.this.repaint(true);
            return true;
        }

        public void run() {
            while (true) {
                this.extend();
                try {
                    Scroller.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }
    }

    private class BaseTermStream
    extends TermStream {
        private BaseTermStream() {
        }

        public void flush() {
            Term.this.repaint(true);
        }

        public void putChar(char c) {
            Term.ckEventDispatchThread();
            Term.this.n_putchar++;
            Term.this.putc_work(c);
            Term.this.possibly_repaint(true);
        }

        public void putChars(char[] cArray, int n, int n2) {
            Term.ckEventDispatchThread();
            Term.this.n_putchars++;
            for (int i = 0; i < n2; ++i) {
                Term.this.putc_work(cArray[n + i]);
            }
            Term.this.possibly_repaint(true);
        }

        public void sendChar(char c) {
            Term.this.fireChar(c);
        }

        public void sendChars(char[] cArray, int n, int n2) {
            Term.this.fireChars(cArray, n, n2);
        }
    }

    private class ScrollWrapper
    extends JComponent
    implements Accessible {
        public JScrollBar scroll_bar;
        private AccessibleContext accessible_context;

        public ScrollWrapper(JScrollBar jScrollBar) {
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            int n = ((Term)Term.this).vscroll_bar.getMaximumSize().width;
            gridBagConstraints.insets = new Insets(0, 0, 0, n);
            this.add((Component)jScrollBar, gridBagConstraints);
            this.scroll_bar = jScrollBar;
        }

        protected void paintComponent(Graphics graphics) {
            Dimension dimension = this.getSize();
            graphics.clearRect(0, 0, dimension.width, dimension.height);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessible_context == null) {
                this.accessible_context = new AccessibleScrollWrapper();
            }
            return this.accessible_context;
        }

        protected class AccessibleScrollWrapper
        extends JComponent.AccessibleJComponent {
            protected AccessibleScrollWrapper() {
                super(ScrollWrapper.this);
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.PANEL;
            }
        }
    }
}

