/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import org.netbeans.lib.terminalemulator.TermStream;

public class LineDiscipline
extends TermStream {
    private static final char[] bs_sequence = new char[]{'\b', ' ', '\b'};
    private StringBuffer line = new StringBuffer();
    private int send_buf_sz = 2;
    private char[] send_buf = new char[this.send_buf_sz];
    private int put_capacity = 16;
    private int put_length = 0;
    private char[] put_buf = new char[this.put_capacity];

    char[] send_buf(int n) {
        if (n >= this.send_buf_sz) {
            this.send_buf_sz = n + 1;
            this.send_buf = new char[this.send_buf_sz];
        }
        return this.send_buf;
    }

    public void flush() {
        this.toDTE.flush();
    }

    public void putChar(char c) {
        this.put_length = 0;
        this.processChar(c);
        this.toDTE.putChars(this.put_buf, 0, this.put_length);
    }

    public void putChars(char[] cArray, int n, int n2) {
        this.put_length = 0;
        for (int i = 0; i < n2; ++i) {
            this.processChar(cArray[n + i]);
        }
        this.toDTE.putChars(this.put_buf, 0, this.put_length);
    }

    private void processChar(char c) {
        this.appendChar(c);
        if (c == '\n') {
            this.appendChar('\r');
        }
    }

    private void appendChar(char c) {
        if (this.put_length >= this.put_capacity) {
            int n = this.put_capacity * 2;
            if (n < 0) {
                n = Integer.MAX_VALUE;
            }
            char[] cArray = new char[n];
            System.arraycopy(this.put_buf, 0, cArray, 0, this.put_length);
            this.put_buf = cArray;
            this.put_capacity = n;
        }
        this.put_buf[this.put_length++] = c;
    }

    public void sendChar(char c) {
        if (c == '\r') {
            this.toDTE.putChar(c);
            this.toDTE.flush();
            c = (char)10;
            this.toDTE.putChar(c);
            this.toDTE.flush();
            this.line.append(c);
            int n = this.line.length();
            char[] cArray = this.send_buf(n);
            this.line.getChars(0, n, cArray, 0);
            this.toDCE.sendChars(cArray, 0, n);
            this.line.delete(0, 99999);
        } else if (c == '\n') {
            this.toDTE.putChar('\r');
            this.toDTE.flush();
            this.toDTE.putChar(c);
            this.toDTE.flush();
            this.line.append(c);
            int n = this.line.length();
            char[] cArray = this.send_buf(n);
            this.line.getChars(0, n, cArray, 0);
            this.toDCE.sendChars(cArray, 0, n);
            this.line.delete(0, 99999);
        } else if (c == '\b') {
            int n = this.line.length();
            if (n == 0) {
                return;
            }
            char c2 = ' ';
            try {
                c2 = this.line.charAt(n - 1);
            }
            catch (Exception exception) {
                return;
            }
            int n2 = this.getTerm().charWidth(c2);
            this.line.delete(n - 1, n);
            while (--n2 > 0) {
                this.line.append(' ');
            }
            this.toDTE.putChars(bs_sequence, 0, 3);
            this.toDTE.flush();
        } else {
            this.toDTE.putChar(c);
            this.toDTE.flush();
            this.line.append(c);
        }
    }

    public void sendChars(char[] cArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.sendChar(cArray[n + i]);
        }
    }
}

