/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.modules.java.freeform.JavaProjectGenerator;
import org.netbeans.modules.java.freeform.ui.ProjectModel;
import org.netbeans.spi.java.project.support.ui.IncludeExcludeVisualizer;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceFoldersPanel
extends JPanel
implements HelpCtx.Provider,
ListSelectionListener {
    private SourcesModel sourceFoldersModel;
    private SourcesModel testFoldersModel;
    private ChangeListener listener;
    private boolean isWizard;
    private ProjectModel model;
    private JButton addFolder;
    private JButton addTestFolder;
    private JButton downFolder;
    private JButton downTestFolder;
    private JComboBox encodingComboBox;
    private JLabel encodingLabel;
    private JButton includesExcludesButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextArea jTextArea1;
    private JButton removeFolder;
    private JButton removeTestFolder;
    private JTable sourceFolders;
    private JComboBox sourceLevel;
    private JTable testFolders;
    private JButton upFolder;
    private JButton upTestFolder;

    public SourceFoldersPanel() {
        this(true);
    }

    public SourceFoldersPanel(boolean bl) {
        this.isWizard = bl;
        this.initComponents();
        this.sourceFoldersModel = new SourcesModel(false);
        this.sourceFolders.setModel(this.sourceFoldersModel);
        this.sourceFolders.getSelectionModel().addListSelectionListener(this);
        this.testFoldersModel = new SourcesModel(true);
        this.testFolders.setModel(this.testFoldersModel);
        this.testFolders.getSelectionModel().addListSelectionListener(this);
        this.sourceFolders.getTableHeader().setReorderingAllowed(false);
        this.sourceFolders.setDefaultRenderer(String.class, new ToolTipRenderer());
        this.testFolders.getTableHeader().setReorderingAllowed(false);
        this.testFolders.setDefaultRenderer(String.class, new ToolTipRenderer());
        this.initSourceLevel();
        this.jLabel1.setVisible(bl);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(SourceFoldersPanel.class);
    }

    public void setChangeListener(ChangeListener changeListener) {
        this.listener = changeListener;
    }

    private void initSourceLevel() {
        this.sourceLevel.addItem(NbBundle.getMessage(SourceFoldersPanel.class, (String)"LBL_SourceFoldersPanel_JDK13"));
        this.sourceLevel.addItem(NbBundle.getMessage(SourceFoldersPanel.class, (String)"LBL_SourceFoldersPanel_JDK14"));
        this.sourceLevel.addItem(NbBundle.getMessage(SourceFoldersPanel.class, (String)"LBL_SourceFoldersPanel_JDK15"));
    }

    private void updateButtons() {
        this.removeFolder.setEnabled(this.sourceFolders.getSelectedRowCount() > 0);
        this.removeTestFolder.setEnabled(this.testFolders.getSelectedRowCount() > 0);
        this.updateUpDownButtons();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateButtons();
    }

    private void updateUpDownButtons() {
        int n = this.sourceFolders.getSelectionModel().getMinSelectionIndex();
        int n2 = this.sourceFolders.getSelectionModel().getMaxSelectionIndex();
        this.upFolder.setEnabled(n > 0);
        this.downFolder.setEnabled(n2 > -1 && n2 < this.sourceFoldersModel.getRowCount() - 1);
        n = this.testFolders.getSelectionModel().getMinSelectionIndex();
        n2 = this.testFolders.getSelectionModel().getMaxSelectionIndex();
        this.upTestFolder.setEnabled(n > 0);
        this.downTestFolder.setEnabled(n2 > -1 && n2 < this.testFoldersModel.getRowCount() - 1);
    }

    private void updateSourceLevelCombo(String string) {
        if (string.equals("1.3")) {
            this.sourceLevel.setSelectedIndex(0);
        } else if (string.equals("1.4")) {
            this.sourceLevel.setSelectedIndex(1);
        } else if (string.equals("1.5")) {
            this.sourceLevel.setSelectedIndex(2);
        } else {
            this.sourceLevel.addItem(string);
            this.sourceLevel.setSelectedIndex(3);
        }
    }

    private void updateEncodingCombo() {
        this.encodingComboBox.setModel(new EncodingModel());
    }

    private String getSourceLevelValue(int n) {
        switch (n) {
            case 0: {
                return "1.3";
            }
            case 1: {
                return "1.4";
            }
            case 2: {
                return "1.5";
            }
        }
        return null;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.sourceLevel = new JComboBox();
        this.addFolder = new JButton();
        this.removeFolder = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.sourceFolders = new JTable();
        this.jScrollPane2 = new JScrollPane();
        this.testFolders = new JTable();
        this.jLabel4 = new JLabel();
        this.addTestFolder = new JButton();
        this.removeTestFolder = new JButton();
        this.upFolder = new JButton();
        this.downFolder = new JButton();
        this.downTestFolder = new JButton();
        this.upTestFolder = new JButton();
        this.includesExcludesButton = new JButton();
        this.encodingLabel = new JLabel();
        this.encodingComboBox = new JComboBox();
        this.jPanel1 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jTextArea1 = new JTextArea();
        this.setMinimumSize(new Dimension(265, 375));
        this.setPreferredSize(new Dimension(800, 500));
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SourceFoldersPanel.class, (String)"LBL_SourceFoldersPanel_jLabel1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceFoldersPanel.class, (String)"ACSD_SourceFoldersPanel_jLabel1"));
        this.jLabel2.setLabelFor(this.sourceFolders);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SourceFoldersPanel.class, (String)"LBL_SourceFoldersPanel_jLabel2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceFoldersPanel.class, (String)"ACSD_SourceFoldersPanel_jLabel2"));
        this.jLabel3.setLabelFor(this.sourceLevel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(SourceFoldersPanel.class, (String)"LBL_SourceFoldersPanel_jLabel3"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SourceFoldersPanel.class, (String)"ACSD_SourceLevel_Label"));
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceFoldersPanel.class, (String)"ACSD_SourceFoldersPanel_jLabel3"));
        this.sourceLevel.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SourceFoldersPanel.this.sourceLevelItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 0, 16);
        this.add((Component)this.sourceLevel, gridBagConstraints);
        this.sourceLevel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SourceFoldersPanel.class, (String)"ACSD_SourceLevel_Name"));
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/java/freeform/ui/Bundle");
        this.sourceLevel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_SourceFoldersPanel_sourceLevel"));
        Mnemonics.setLocalizedText((AbstractButton)this.addFolder, (String)NbBundle.getMessage(SourceFoldersPanel.class, (String)"BTN_SourceFoldersPanel_addFolder"));
        this.addFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourceFoldersPanel.this.addFolderActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.addFolder, gridBagConstraints);
        this.addFolder.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceFoldersPanel.class, (String)"ACSD_SourceFoldersPanel_addFolder"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeFolder, (String)NbBundle.getMessage(SourceFoldersPanel.class, (String)"BTN_SourceFoldersPanel_removeFolder"));
        this.removeFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourceFoldersPanel.this.removeFolderActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.removeFolder, gridBagConstraints);
        this.removeFolder.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceFoldersPanel.class, (String)"ACSD_SourceFoldersPanel_removeFolder"));
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setViewportView(this.sourceFolders);
        this.sourceFolders.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceFoldersPanel.class, (String)"ACSD_SourceFoldersPanel_sourceFolders"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 12, 8);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jScrollPane1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceFoldersPanel.class, (String)"ACSD_SourceFoldersPanel_jScrollPanel1"));
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.jScrollPane2.setViewportView(this.testFolders);
        this.testFolders.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_SourceFoldersPanel_testFolders"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 8, 8);
        this.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jScrollPane2.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_SourceFoldersPanel_jScrollPane2"));
        this.jLabel4.setLabelFor(this.testFolders);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(SourceFoldersPanel.class, (String)"LBL_TestSourceFoldersPanel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel4, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addTestFolder, (String)NbBundle.getMessage(SourceFoldersPanel.class, (String)"BTN_SourceFoldersPanel_addTestFolder"));
        this.addTestFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourceFoldersPanel.this.addTestFolderActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.addTestFolder, gridBagConstraints);
        this.addTestFolder.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_SourceFoldersPanel_addTestFolder"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeTestFolder, (String)NbBundle.getMessage(SourceFoldersPanel.class, (String)"BTN_SourceFoldersPanel_removeTestFolder"));
        this.removeTestFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourceFoldersPanel.this.removeTestFolderActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.removeTestFolder, gridBagConstraints);
        this.removeTestFolder.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_SourceFoldersPanel_removeTestFolder"));
        Mnemonics.setLocalizedText((AbstractButton)this.upFolder, (String)NbBundle.getMessage(SourceFoldersPanel.class, (String)"BTN_SourceFoldersPanel_upFolder"));
        this.upFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourceFoldersPanel.this.upFolderActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.upFolder, gridBagConstraints);
        this.upFolder.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_SourceFoldersPanel_upFolder"));
        Mnemonics.setLocalizedText((AbstractButton)this.downFolder, (String)NbBundle.getMessage(SourceFoldersPanel.class, (String)"BTN_SourceFoldersPanel_downFolder"));
        this.downFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourceFoldersPanel.this.downFolderActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.downFolder, gridBagConstraints);
        this.downFolder.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_SourceFoldersPanel_downFolder"));
        Mnemonics.setLocalizedText((AbstractButton)this.downTestFolder, (String)NbBundle.getMessage(SourceFoldersPanel.class, (String)"BTN_SourceFoldersPanel_downTestFolder"));
        this.downTestFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourceFoldersPanel.this.downTestFolderActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.downTestFolder, gridBagConstraints);
        this.downTestFolder.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_SourceFoldersPanel_downTestFolder"));
        Mnemonics.setLocalizedText((AbstractButton)this.upTestFolder, (String)NbBundle.getMessage(SourceFoldersPanel.class, (String)"BTN_SourceFoldersPanel_upTestFolder"));
        this.upTestFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourceFoldersPanel.this.upTestFolderActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.upTestFolder, gridBagConstraints);
        this.upTestFolder.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_SourceFoldersPanel_upTestFolder"));
        Mnemonics.setLocalizedText((AbstractButton)this.includesExcludesButton, (String)NbBundle.getMessage(SourceFoldersPanel.class, (String)"SourceFoldersPanel.includesExcludesButton.text"));
        this.includesExcludesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourceFoldersPanel.this.includesExcludesButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.includesExcludesButton, gridBagConstraints);
        this.includesExcludesButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SourceFoldersPanel.class, (String)"ACSD_Includes-Excludes_Name"));
        this.includesExcludesButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceFoldersPanel.class, (String)"ACSD_Includes-Excludes_Desc"));
        Mnemonics.setLocalizedText((JLabel)this.encodingLabel, (String)NbBundle.getMessage(SourceFoldersPanel.class, (String)"LBL_Encoding"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.add((Component)this.encodingLabel, gridBagConstraints);
        this.encodingLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SourceFoldersPanel.class, (String)"ACSD_Encoding_Label_Name"));
        this.encodingLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceFoldersPanel.class, (String)"ACSD_Encoding_Label_Desc"));
        this.encodingComboBox.setRenderer(new EncodingRenderer());
        this.encodingComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourceFoldersPanel.this.encodingComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(6, 0, 0, 16);
        this.add((Component)this.encodingComboBox, gridBagConstraints);
        this.encodingComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SourceFoldersPanel.class, (String)"ACSD_Encoding_Name"));
        this.encodingComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceFoldersPanel.class, (String)"ACSD_Encoding_Desc"));
        this.jPanel1.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Label.disabledForeground")));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel5.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/java/freeform/resources/alert_32.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 8, 8, 0);
        this.jPanel1.add((Component)this.jLabel5, gridBagConstraints);
        this.jTextArea1.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setText(NbBundle.getMessage(SourceFoldersPanel.class, (String)"Freeform_Warning_Message"));
        this.jTextArea1.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 10, 4, 4);
        this.jPanel1.add((Component)this.jTextArea1, gridBagConstraints);
        this.jTextArea1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SourceFoldersPanel.class, (String)"ACSN_Freeform_Warning_Message"));
        this.jTextArea1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceFoldersPanel.class, (String)"ACSD_Freeform_Warning_Message"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void encodingComboBoxActionPerformed(ActionEvent actionEvent) {
        Object object = this.encodingComboBox.getModel().getSelectedItem();
        if (object instanceof Charset) {
            this.model.setEncoding(((Charset)object).name());
            FileEncodingQuery.setDefaultEncoding((Charset)((Charset)object));
        } else {
            this.model.setEncoding(object.toString());
        }
    }

    private void includesExcludesButtonActionPerformed(ActionEvent actionEvent) {
        IncludeExcludeVisualizer includeExcludeVisualizer = new IncludeExcludeVisualizer();
        ArrayList<File> arrayList = new ArrayList<File>();
        for (JavaProjectGenerator.SourceFolder object : this.model.getSourceFolders()) {
            includeExcludeVisualizer.setIncludePattern(object.includes != null ? object.includes : "**");
            includeExcludeVisualizer.setExcludePattern(object.excludes != null ? object.excludes : "");
            File file = Util.resolveFile((PropertyEvaluator)this.model.getEvaluator(), (File)this.model.getNBProjectFolder(), (String)object.location);
            if (!file.isDirectory()) continue;
            arrayList.add(file);
        }
        includeExcludeVisualizer.setRoots(arrayList.toArray(new File[arrayList.size()]));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)includeExcludeVisualizer.getVisualizerPanel(), NbBundle.getMessage(SourceFoldersPanel.class, (String)"SourceFoldersPanel.title.includeExclude"));
        dialogDescriptor.setOptionType(2);
        if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor))) {
            for (JavaProjectGenerator.SourceFolder sourceFolder : this.model.getSourceFolders()) {
                sourceFolder.includes = includeExcludeVisualizer.getIncludePattern().equals("**") ? null : includeExcludeVisualizer.getIncludePattern();
                sourceFolder.excludes = includeExcludeVisualizer.getExcludePattern().equals("") ? null : includeExcludeVisualizer.getExcludePattern();
            }
        }
    }

    private void downTestFolderActionPerformed(ActionEvent actionEvent) {
        int n;
        int[] nArray = this.testFolders.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        for (n = nArray.length - 1; n >= 0; --n) {
            int n2 = this.calcRealSourceIndex(nArray[n], true);
            this.model.moveSourceFolder(n2, n2 + 1);
        }
        this.testFoldersModel.fireTableDataChanged();
        this.testFolders.getSelectionModel().clearSelection();
        for (n = 0; n < nArray.length; ++n) {
            this.testFolders.getSelectionModel().addSelectionInterval(nArray[n] + 1, nArray[n] + 1);
        }
    }

    private void upTestFolderActionPerformed(ActionEvent actionEvent) {
        int n;
        int[] nArray = this.testFolders.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        for (n = 0; n < nArray.length; ++n) {
            int n2 = this.calcRealSourceIndex(nArray[n], true);
            this.model.moveSourceFolder(n2, n2 - 1);
        }
        this.testFoldersModel.fireTableDataChanged();
        this.testFolders.getSelectionModel().clearSelection();
        for (n = 0; n < nArray.length; ++n) {
            this.testFolders.getSelectionModel().addSelectionInterval(nArray[n] - 1, nArray[n] - 1);
        }
    }

    private void downFolderActionPerformed(ActionEvent actionEvent) {
        int n;
        int[] nArray = this.sourceFolders.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        for (n = nArray.length - 1; n >= 0; --n) {
            int n2 = this.calcRealSourceIndex(nArray[n], false);
            this.model.moveSourceFolder(n2, n2 + 1);
        }
        this.sourceFoldersModel.fireTableDataChanged();
        this.sourceFolders.getSelectionModel().clearSelection();
        for (n = 0; n < nArray.length; ++n) {
            this.sourceFolders.getSelectionModel().addSelectionInterval(nArray[n] + 1, nArray[n] + 1);
        }
    }

    private void upFolderActionPerformed(ActionEvent actionEvent) {
        int n;
        int[] nArray = this.sourceFolders.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        for (n = 0; n < nArray.length; ++n) {
            int n2 = this.calcRealSourceIndex(nArray[n], false);
            this.model.moveSourceFolder(n2, n2 - 1);
        }
        this.sourceFoldersModel.fireTableDataChanged();
        this.sourceFolders.getSelectionModel().clearSelection();
        for (n = 0; n < nArray.length; ++n) {
            this.sourceFolders.getSelectionModel().addSelectionInterval(nArray[n] - 1, nArray[n] - 1);
        }
    }

    private void removeTestFolderActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.testFolders.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        for (int i = nArray.length - 1; i >= 0; --i) {
            String string = this.getItem((int)nArray[i], (boolean)true).location;
            this.model.removeSourceFolder(this.calcRealSourceIndex(nArray[i], true));
        }
        this.testFoldersModel.fireTableDataChanged();
        if (this.listener != null) {
            this.listener.stateChanged(null);
        }
        this.updateButtons();
    }

    private void addTestFolderActionPerformed(ActionEvent actionEvent) {
        this.doAddFolderActionPerformed(actionEvent, true);
    }

    private void sourceLevelItemStateChanged(ItemEvent itemEvent) {
        if (this.sourceLevel.getSelectedIndex() != -1 && this.model != null) {
            String string = this.getSourceLevelValue(this.sourceLevel.getSelectedIndex());
            if (string == null) {
                string = (String)this.sourceLevel.getSelectedItem();
            }
            this.model.setSourceLevel(string);
        }
    }

    private void removeFolderActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.sourceFolders.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        for (int i = nArray.length - 1; i >= 0; --i) {
            String string = this.getItem((int)nArray[i], (boolean)false).location;
            this.model.removeSourceFolder(this.calcRealSourceIndex(nArray[i], false));
        }
        this.sourceFoldersModel.fireTableDataChanged();
        if (this.listener != null) {
            this.listener.stateChanged(null);
        }
        this.updateButtons();
    }

    private void addFolderActionPerformed(ActionEvent actionEvent) {
        this.doAddFolderActionPerformed(actionEvent, false);
    }

    private void doAddFolderActionPerformed(ActionEvent actionEvent, boolean bl) {
        File[] fileArray;
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(1);
        if (this.model.getBaseFolder() != null) {
            fileArray = this.model.getBaseFolder().listFiles();
            if (fileArray != null && fileArray.length > 0) {
                jFileChooser.setSelectedFile(fileArray[0]);
            } else {
                jFileChooser.setSelectedFile(this.model.getBaseFolder());
            }
        }
        if (bl) {
            jFileChooser.setDialogTitle(NbBundle.getMessage(SourceFoldersPanel.class, (String)"LBL_Browse_Test_Folder"));
        } else {
            jFileChooser.setDialogTitle(NbBundle.getMessage(SourceFoldersPanel.class, (String)"LBL_Browse_Source_Folder"));
        }
        jFileChooser.setMultiSelectionEnabled(true);
        if (0 == jFileChooser.showOpenDialog(this)) {
            fileArray = jFileChooser.getSelectedFiles();
            this.model.setEncoding(this.encodingComboBox.getModel().getSelectedItem().toString());
            Set<File> set = SourceFoldersPanel.processRoots(this.model, fileArray, bl, this.isWizard);
            if (bl) {
                this.testFoldersModel.fireTableDataChanged();
            } else {
                this.sourceFoldersModel.fireTableDataChanged();
            }
            if (this.listener != null) {
                this.listener.stateChanged(null);
            }
            this.updateButtons();
            if (set.size() > 0) {
                this.showInvalidRootsWarning(set);
            }
        }
    }

    static Set<File> processRoots(ProjectModel projectModel, File[] fileArray, boolean bl, boolean bl2) {
        HashSet<File> hashSet = new HashSet<File>();
        block0: for (File file : fileArray) {
            File file2 = FileUtil.normalizeFile((File)file);
            String string = Util.relativizeLocation((File)projectModel.getBaseFolder(), (File)projectModel.getNBProjectFolder(), (File)file2);
            Project project = bl2 ? null : FileOwnerQuery.getOwner((URI)projectModel.getNBProjectFolder().toURI());
            Project project2 = FileOwnerQuery.getOwner((URI)file2.toURI());
            if (!(project2 == null || project != null && project.equals(project2) || SourceFoldersPanel.isParentOf(projectModel.getNBProjectFolder(), file2) || SourceFoldersPanel.isParentOf(projectModel.getBaseFolder(), file2))) {
                hashSet.add(file2);
                continue;
            }
            List<JavaProjectGenerator.SourceFolder> list = projectModel.getSourceFolders();
            for (JavaProjectGenerator.SourceFolder sourceFolder2 : list) {
                if (!string.equals(sourceFolder2.location)) continue;
                if ((!bl || projectModel.isTestSourceFolder(sourceFolder2)) && (bl || !projectModel.isTestSourceFolder(sourceFolder2))) continue block0;
                hashSet.add(file2);
                continue block0;
            }
            JavaProjectGenerator.SourceFolder sourceFolder = new JavaProjectGenerator.SourceFolder();
            sourceFolder.location = string;
            sourceFolder.type = "java";
            sourceFolder.style = "packages";
            sourceFolder.label = SourceFoldersPanel.getDefaultLabel(sourceFolder.location, bl);
            if (!list.isEmpty()) {
                JavaProjectGenerator.SourceFolder sourceFolder2;
                sourceFolder2 = list.iterator().next();
                sourceFolder.includes = sourceFolder2.includes;
                sourceFolder.excludes = sourceFolder2.excludes;
            }
            sourceFolder.encoding = projectModel.getEncoding();
            projectModel.addSourceFolder(sourceFolder, bl);
        }
        return hashSet;
    }

    private static boolean isParentOf(File file, File file2) {
        while (file2 != null && !file2.equals(file)) {
            file2 = file2.getParentFile();
        }
        return file2 != null && file2.equals(file);
    }

    private void showInvalidRootsWarning(Set<File> set) {
        JButton jButton = new JButton(NbBundle.getMessage(SourceFoldersPanel.class, (String)"CTL_SourceFolderPanel_Close"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceFoldersPanel.class, (String)"AD_SourceFolderPanel_Close"));
        WarningDlg warningDlg = new WarningDlg(set);
        String string = NbBundle.getMessage(SourceFoldersPanel.class, (String)"MSG_InvalidRoot");
        JOptionPane jOptionPane = new JOptionPane(new Object[]{string, warningDlg}, 2, 0, null, new Object[0], null);
        jOptionPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceFoldersPanel.class, (String)"AD_InvalidRootDlg"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jOptionPane, NbBundle.getMessage(SourceFoldersPanel.class, (String)"TITLE_InvalidRoot"), true, new Object[]{jButton}, (Object)jButton, 0, null, null);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
    }

    static String getDefaultLabel(String string, boolean bl) {
        if (string.equals(".") || "${project.dir}/".equals(string + "/")) {
            return bl ? NbBundle.getMessage(SourceFoldersPanel.class, (String)"LBL_default_test_packages") : NbBundle.getMessage(SourceFoldersPanel.class, (String)"LBL_default_source_packages");
        }
        String string2 = string;
        if (string2.startsWith("${project.dir}/")) {
            string2 = string2.substring("${project.dir}/".length());
        }
        return string2.replace('/', File.separatorChar);
    }

    public static String getLocationDisplayName(PropertyEvaluator propertyEvaluator, File file, String string) {
        File file2 = Util.resolveFile((PropertyEvaluator)propertyEvaluator, (File)file, (String)string);
        if (file2 == null) {
            return string;
        }
        String string2 = file2.getAbsolutePath();
        if (CollocationQuery.areCollocated((File)file, (File)file2)) {
            string2 = PropertyUtils.relativizeFile((File)file, (File)file2).replace('/', File.separatorChar);
        }
        return string2;
    }

    private JavaProjectGenerator.SourceFolder getItem(int n, boolean bl) {
        return this.model.getSourceFolder(this.calcRealSourceIndex(n, bl));
    }

    private int calcRealSourceIndex(int n, boolean bl) {
        int n2 = 0;
        for (int i = 0; i < this.model.getSourceFoldersCount(); ++i) {
            JavaProjectGenerator.SourceFolder sourceFolder = this.model.getSourceFolder(i);
            boolean bl2 = this.model.isTestSourceFolder(sourceFolder);
            if (bl && !bl2 || !bl && bl2) continue;
            if (n == n2) {
                return i;
            }
            ++n2;
        }
        throw new ArrayIndexOutOfBoundsException("index=" + n + " tests=" + bl + " realIndex=" + n2);
    }

    public boolean hasSomeSourceFolder() {
        return this.model.getSourceFoldersCount() > 0;
    }

    public void setModel(ProjectModel projectModel, AntProjectHelper antProjectHelper) {
        this.model = projectModel;
        this.updateSourceLevelCombo(projectModel.getSourceLevel());
        this.updateEncodingCombo();
        this.updateButtons();
        this.sourceFoldersModel.fireTableDataChanged();
    }

    private static FileObject getAntScript(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator) {
        String string = propertyEvaluator.getProperty("ant.script");
        if (string != null) {
            File file = antProjectHelper.resolveFile(string);
            if (!file.exists()) {
                return null;
            }
            FileObject fileObject = FileUtil.toFileObject((File)file);
            return fileObject;
        }
        FileObject fileObject = antProjectHelper.getProjectDirectory().getFileObject("build.xml");
        return fileObject;
    }

    private static class WarningDlg
    extends JPanel {
        public WarningDlg(Set set) {
            this.initGui(set);
        }

        private void initGui(Set set) {
            this.setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)NbBundle.getMessage(SourceFoldersPanel.class, (String)"LBL_InvalidRoot"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(12, 0, 6, 0);
            ((GridBagLayout)this.getLayout()).setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
            JList<Object> jList = new JList<Object>(set.toArray());
            jList.setCellRenderer(new InvalidRootRenderer(true));
            JScrollPane jScrollPane = new JScrollPane(jList);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 12, 0);
            ((GridBagLayout)this.getLayout()).setConstraints(jScrollPane, gridBagConstraints);
            this.add(jScrollPane);
            jLabel.setLabelFor(jList);
            jList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceFoldersPanel.class, (String)"AD_InvalidRoot"));
            JLabel jLabel2 = new JLabel();
            jLabel2.setText(NbBundle.getMessage(SourceFoldersPanel.class, (String)"MSG_InvalidRoot2"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            ((GridBagLayout)this.getLayout()).setConstraints(jLabel2, gridBagConstraints);
            this.add(jLabel2);
        }

        private static class InvalidRootRenderer
        extends DefaultListCellRenderer {
            private boolean projectConflict;

            public InvalidRootRenderer(boolean bl) {
                this.projectConflict = bl;
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Project project;
                File file = (File)object;
                String string = file.getAbsolutePath();
                if (this.projectConflict && (project = FileOwnerQuery.getOwner((URI)file.toURI())) != null) {
                    ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
                    String string2 = projectInformation.getDisplayName();
                    string = NbBundle.getMessage(SourceFoldersPanel.class, (String)"TXT_RootOwnedByProject", (Object)string, (Object)string2);
                }
                return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            }
        }
    }

    private class ToolTipRenderer
    extends DefaultTableCellRenderer {
        private ToolTipRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component instanceof JComponent) {
                ((JComponent)component).setToolTipText((String)object);
            }
            return component;
        }
    }

    private static class EncodingRenderer
    extends DefaultListCellRenderer
    implements UIResource {
        public EncodingRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setName("ComboBox.listRenderer");
            String string = null;
            string = object instanceof Charset ? ((Charset)object).displayName() : object.toString();
            this.setText(string);
            this.setIcon(null);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }

        public String getName() {
            String string = super.getName();
            return string == null ? "ComboBox.renderer" : string;
        }
    }

    private class EncodingModel
    extends DefaultComboBoxModel {
        public EncodingModel() {
            Object object = null;
            if (SourceFoldersPanel.this.model.getEncoding() == null) {
                this.addElement(ProjectModel.NO_ENCODING);
                object = ProjectModel.NO_ENCODING;
            }
            for (Charset charset : Charset.availableCharsets().values()) {
                if (charset.name().equals(SourceFoldersPanel.this.model.getEncoding())) {
                    object = charset;
                }
                this.addElement(charset);
            }
            if (SourceFoldersPanel.this.isWizard) {
                this.setSelectedItem(FileEncodingQuery.getDefaultEncoding());
            } else if (object != null) {
                this.setSelectedItem(object);
            }
        }
    }

    private class SourcesModel
    extends AbstractTableModel {
        private boolean tests;

        public SourcesModel(boolean bl) {
            this.tests = bl;
        }

        public int getColumnCount() {
            return SourceFoldersPanel.this.isWizard ? 1 : 2;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return NbBundle.getMessage(SourceFoldersPanel.class, (String)"LBL_SourceFoldersPanel_Package");
                }
            }
            return NbBundle.getMessage(SourceFoldersPanel.class, (String)"LBL_SourceFoldersPanel_Label");
        }

        public int getRowCount() {
            if (SourceFoldersPanel.this.model == null) {
                return 0;
            }
            int n = 0;
            for (int i = 0; i < SourceFoldersPanel.this.model.getSourceFoldersCount(); ++i) {
                JavaProjectGenerator.SourceFolder sourceFolder = SourceFoldersPanel.this.model.getSourceFolder(i);
                boolean bl = SourceFoldersPanel.this.model.isTestSourceFolder(sourceFolder);
                if (this.tests && bl) {
                    ++n;
                }
                if (this.tests || bl) continue;
                ++n;
            }
            return n;
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                String string = ((SourceFoldersPanel)SourceFoldersPanel.this).getItem((int)n, (boolean)this.tests).location;
                string = SourceFoldersPanel.getLocationDisplayName(SourceFoldersPanel.this.model.getEvaluator(), SourceFoldersPanel.this.model.getNBProjectFolder(), string);
                return string;
            }
            return ((SourceFoldersPanel)SourceFoldersPanel.this).getItem((int)n, (boolean)this.tests).label;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        public Class getColumnClass(int n) {
            return String.class;
        }

        public void setValueAt(Object object, int n, int n2) {
            JavaProjectGenerator.SourceFolder sourceFolder = SourceFoldersPanel.this.getItem(n, this.tests);
            sourceFolder.label = (String)object;
            if (sourceFolder.label.length() == 0) {
                sourceFolder.label = SourceFoldersPanel.getDefaultLabel(sourceFolder.location, this.tests);
            }
        }
    }
}

