/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.modules.java.freeform.JavaProjectGenerator;
import org.netbeans.modules.java.freeform.ui.ClasspathPanel;
import org.netbeans.modules.java.freeform.ui.ProjectModel;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputPanel
extends JPanel
implements HelpCtx.Provider {
    private DefaultListModel listModel;
    private File lastChosenFile = null;
    private boolean isSeparateClasspath = true;
    private List<ProjectModel.CompilationUnitKey> compUnitsKeys;
    private boolean ignoreEvent;
    private ProjectModel model;
    private JButton addOutput;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JTextArea jTextArea2;
    private JTextField javadoc;
    private JButton javadocBrowse;
    private JLabel javadocLabel;
    private JList output;
    private JButton removeOutput;
    private JComboBox sourceFolder;

    public OutputPanel() {
        this.initComponents();
        this.jTextArea1.setBackground(this.getBackground());
        this.listModel = new DefaultListModel();
        this.output.setModel(this.listModel);
        this.output.setSelectionMode(0);
        this.javadoc.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                OutputPanel.this.update();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                OutputPanel.this.update();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                OutputPanel.this.update();
            }
        });
        this.jTextArea1.setDisabledTextColor(this.jLabel2.getForeground());
    }

    private void update() {
        int n = this.sourceFolder.getSelectedIndex();
        assert (n >= 0);
        ProjectModel.CompilationUnitKey compilationUnitKey = this.compUnitsKeys.get(n);
        JavaProjectGenerator.JavaCompilationUnit javaCompilationUnit = this.model.getCompilationUnit(compilationUnitKey, this.model.isTestSourceFolder(n));
        this.updateCompilationUnitJavadoc(javaCompilationUnit);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(OutputPanel.class);
    }

    private void updateControls() {
        this.sourceFolder.removeAllItems();
        this.compUnitsKeys = this.model.createCompilationUnitKeys();
        this.isSeparateClasspath = !ProjectModel.isSingleCompilationUnit(this.compUnitsKeys);
        List<String> list = ClasspathPanel.createComboContent(this.compUnitsKeys, this.model.getEvaluator(), this.model.getNBProjectFolder());
        for (String string : list) {
            this.sourceFolder.addItem(string);
        }
        if (list.size() > 0) {
            this.ignoreEvent = true;
            this.sourceFolder.setSelectedIndex(0);
            this.ignoreEvent = false;
        }
        this.loadOutput();
        boolean bl = this.model.canHaveSeparateClasspath();
        this.jLabel2.setEnabled(bl && this.isSeparateClasspath);
        this.sourceFolder.setEnabled(bl && this.isSeparateClasspath);
        this.addOutput.setEnabled(this.compUnitsKeys.size() > 0);
        this.output.setEnabled(this.compUnitsKeys.size() > 0);
        this.javadoc.setEnabled(this.compUnitsKeys.size() > 0);
        this.javadocBrowse.setEnabled(this.compUnitsKeys.size() > 0);
        this.updateButtons();
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.addOutput = new JButton();
        this.removeOutput = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.output = new JList();
        this.jPanel1 = new JPanel();
        this.sourceFolder = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jTextArea1 = new JTextArea();
        this.jPanel2 = new JPanel();
        this.javadoc = new JTextField();
        this.javadocBrowse = new JButton();
        this.javadocLabel = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextArea2 = new JTextArea();
        this.setPreferredSize(new Dimension(275, 202));
        this.setLayout(new GridBagLayout());
        this.jLabel3.setLabelFor(this.output);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(OutputPanel.class, (String)"LBL_OutputPanel_jLabel3"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(OutputPanel.class, (String)"ACSD_OutputPanel_jLabel3"));
        Mnemonics.setLocalizedText((AbstractButton)this.addOutput, (String)NbBundle.getMessage(OutputPanel.class, (String)"BTN_OutputPanel_addOutput"));
        this.addOutput.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OutputPanel.this.addOutputActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 6, 0);
        this.add((Component)this.addOutput, gridBagConstraints);
        this.addOutput.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(OutputPanel.class, (String)"ACSD_OutputPanel_addOutput"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeOutput, (String)NbBundle.getMessage(OutputPanel.class, (String)"BTN_OutputPanel_removeOutput"));
        this.removeOutput.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OutputPanel.this.removeOutputActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 6, 0);
        this.add((Component)this.removeOutput, gridBagConstraints);
        this.removeOutput.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(OutputPanel.class, (String)"ACSD_OutputPanel_removeOutput"));
        this.output.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                OutputPanel.this.outputValueChanged(listSelectionEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.output);
        this.output.getAccessibleContext().setAccessibleName(NbBundle.getMessage(OutputPanel.class, (String)"ACSN_OutputPanel_output"));
        this.output.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(OutputPanel.class, (String)"ACSD_OutputPanel_output"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jScrollPane1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(OutputPanel.class, (String)"ACSD_OutputPanel_jScrollPanel1"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.sourceFolder.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                OutputPanel.this.sourceFolderItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.sourceFolder, gridBagConstraints);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/java/freeform/ui/Bundle");
        this.sourceFolder.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_OutputPanel_sourceFolder"));
        this.jLabel2.setLabelFor(this.sourceFolder);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(OutputPanel.class, (String)"LBL_OutputPanel_jLabel1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setText(NbBundle.getMessage(OutputPanel.class, (String)"MSG_OutputPanel_jTextArea1"));
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.jTextArea1, gridBagConstraints);
        this.jTextArea1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(OutputPanel.class, (String)"ACSN_OutputPanel_jTextArea1"));
        this.jTextArea1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(OutputPanel.class, (String)"ACSD_OutputPanel_jTextArea1"));
        this.jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.jPanel2.add((Component)this.javadoc, gridBagConstraints);
        this.javadoc.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_OutputPanel_javadoc"));
        Mnemonics.setLocalizedText((AbstractButton)this.javadocBrowse, (String)NbBundle.getMessage(OutputPanel.class, (String)"BTN_OutputPanel_browseJavadoc"));
        this.javadocBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OutputPanel.this.javadocBrowseActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.jPanel2.add((Component)this.javadocBrowse, gridBagConstraints);
        this.javadocBrowse.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_OutputPanel_javadocBrowse"));
        this.javadocLabel.setLabelFor(this.javadoc);
        Mnemonics.setLocalizedText((JLabel)this.javadocLabel, (String)NbBundle.getMessage(OutputPanel.class, (String)"LBL_OutputPanel_JavadocLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.jPanel2.add((Component)this.javadocLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel3.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Label.disabledForeground")));
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/java/freeform/resources/alert_32.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 8, 8, 0);
        this.jPanel3.add((Component)this.jLabel1, gridBagConstraints);
        this.jTextArea2.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.jTextArea2.setEditable(false);
        this.jTextArea2.setLineWrap(true);
        this.jTextArea2.setText(NbBundle.getMessage(OutputPanel.class, (String)"Freeform_Warning_Message"));
        this.jTextArea2.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 10, 4, 4);
        this.jPanel3.add((Component)this.jTextArea2, gridBagConstraints);
        this.jTextArea2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(OutputPanel.class, (String)"ACSN_Freeform_Warning_Message"));
        this.jTextArea2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(OutputPanel.class, (String)"ACSD_Freeform_Warning_Message"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jPanel3, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(OutputPanel.class, (String)"ACSN_OutputPanel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(OutputPanel.class, (String)"ACSD_OutputPanel"));
    }

    private void javadocBrowseActionPerformed(ActionEvent actionEvent) {
        Object object;
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setMultiSelectionEnabled(false);
        if (this.lastChosenFile != null) {
            jFileChooser.setSelectedFile(this.lastChosenFile);
        } else if (this.javadoc.getText().length() > 0) {
            jFileChooser.setSelectedFile(new File(this.javadoc.getText()));
        } else {
            object = this.model.getBaseFolder().listFiles();
            if (object != null && ((File[])object).length > 0) {
                jFileChooser.setSelectedFile(object[0]);
            } else {
                jFileChooser.setSelectedFile(this.model.getBaseFolder());
            }
        }
        jFileChooser.setDialogTitle(NbBundle.getMessage(OutputPanel.class, (String)"LBL_Browse_Javadoc"));
        if (0 == jFileChooser.showOpenDialog(this)) {
            object = jFileChooser.getSelectedFile();
            object = FileUtil.normalizeFile((File)object);
            this.javadoc.setText(((File)object).getAbsolutePath());
            this.lastChosenFile = object;
        }
    }

    private void outputValueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateButtons();
    }

    private void sourceFolderItemStateChanged(ItemEvent itemEvent) {
        if (this.ignoreEvent) {
            return;
        }
        if (itemEvent.getStateChange() == 2) {
            int n = this.findIndex(itemEvent.getItem());
            if (n != -1) {
                this.saveOutput(n);
            }
        } else {
            this.loadOutput();
        }
    }

    private int findIndex(Object object) {
        for (int i = 0; i < this.sourceFolder.getModel().getSize(); ++i) {
            if (!this.sourceFolder.getModel().getElementAt(i).equals(object)) continue;
            return i;
        }
        return -1;
    }

    private void saveOutput(int n) {
        ProjectModel.CompilationUnitKey compilationUnitKey = this.compUnitsKeys.get(n);
        JavaProjectGenerator.JavaCompilationUnit javaCompilationUnit = this.model.getCompilationUnit(compilationUnitKey, this.model.isTestSourceFolder(n));
        this.updateCompilationUnitOutput(javaCompilationUnit);
        this.updateCompilationUnitJavadoc(javaCompilationUnit);
    }

    private void loadOutput() {
        int n;
        if (this.isSeparateClasspath) {
            n = this.sourceFolder.getSelectedIndex();
            if (n == -1) {
                return;
            }
        } else {
            n = 0;
        }
        ProjectModel.CompilationUnitKey compilationUnitKey = this.compUnitsKeys.get(n);
        JavaProjectGenerator.JavaCompilationUnit javaCompilationUnit = this.model.getCompilationUnit(compilationUnitKey, this.model.isTestSourceFolder(n));
        this.updateJListOutput(javaCompilationUnit.output);
        this.updateJavadocField(javaCompilationUnit.javadoc);
    }

    private void updateJavadocField(List<String> list) {
        String string = "";
        boolean bl = true;
        if (list != null) {
            File file;
            if (list.size() > 1) {
                string = this.getListAsString(list);
                bl = false;
            } else if (list.size() == 1 && (file = Util.resolveFile((PropertyEvaluator)this.model.getEvaluator(), (File)this.model.getNBProjectFolder(), (String)list.get(0))) != null) {
                string = file.getAbsolutePath();
            }
        }
        this.javadoc.setEnabled(bl);
        this.javadocBrowse.setEnabled(bl);
        this.javadoc.setText(string);
    }

    private String getListAsString(List<String> list) {
        assert (list != null);
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : list) {
            File file = Util.resolveFile((PropertyEvaluator)this.model.getEvaluator(), (File)this.model.getNBProjectFolder(), (String)string);
            if (file == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(file.getAbsolutePath());
        }
        return stringBuffer.toString();
    }

    private void updateCompilationUnitJavadoc(JavaProjectGenerator.JavaCompilationUnit javaCompilationUnit) {
        if (this.javadoc.isEnabled()) {
            if (this.javadoc.getText().length() > 0) {
                javaCompilationUnit.javadoc = new ArrayList<String>();
                for (String string : this.javadoc.getText().split(",")) {
                    File file = FileUtil.normalizeFile((File)new File(string.trim()));
                    String string2 = Util.relativizeLocation((File)this.model.getBaseFolder(), (File)this.model.getNBProjectFolder(), (File)file);
                    javaCompilationUnit.javadoc.add(string2);
                }
            } else {
                javaCompilationUnit.javadoc = null;
            }
        }
    }

    private void updateCompilationUnitOutput(JavaProjectGenerator.JavaCompilationUnit javaCompilationUnit) {
        if (this.output.getModel().getSize() == 0) {
            javaCompilationUnit.output = null;
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.output.getModel().getSize(); ++i) {
            File file = new File((String)this.output.getModel().getElementAt(i));
            String string = Util.relativizeLocation((File)this.model.getBaseFolder(), (File)this.model.getNBProjectFolder(), (File)file);
            arrayList.add(string);
        }
        javaCompilationUnit.output = arrayList;
    }

    private void updateJListOutput(List<String> list) {
        this.listModel.removeAllElements();
        if (list != null) {
            for (String string : list) {
                File file = Util.resolveFile((PropertyEvaluator)this.model.getEvaluator(), (File)this.model.getNBProjectFolder(), (String)string);
                if (file == null) continue;
                this.listModel.addElement(file.getAbsolutePath());
            }
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.removeOutput.setEnabled(this.output.isEnabled() && this.listModel.getSize() > 0 && this.output.getSelectedIndex() != -1);
    }

    private void removeOutputActionPerformed(ActionEvent actionEvent) {
        int n = this.output.getSelectedIndex();
        if (n != -1) {
            this.listModel.remove(n);
        }
        this.applyChanges();
        this.updateButtons();
    }

    private void addOutputActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setMultiSelectionEnabled(true);
        if (this.lastChosenFile != null) {
            jFileChooser.setSelectedFile(this.lastChosenFile);
        } else {
            File[] fileArray = this.model.getBaseFolder().listFiles();
            if (fileArray != null && fileArray.length > 0) {
                jFileChooser.setSelectedFile(fileArray[0]);
            } else {
                jFileChooser.setSelectedFile(this.model.getBaseFolder());
            }
        }
        jFileChooser.setDialogTitle(NbBundle.getMessage(OutputPanel.class, (String)"LBL_Browse_Output"));
        if (0 == jFileChooser.showOpenDialog(this)) {
            for (File file : jFileChooser.getSelectedFiles()) {
                file = FileUtil.normalizeFile((File)file);
                this.listModel.addElement(file.getAbsolutePath());
                this.lastChosenFile = file;
            }
            this.applyChanges();
            this.updateButtons();
        }
    }

    private void applyChanges() {
        if (this.isSeparateClasspath) {
            if (this.sourceFolder.getSelectedIndex() != -1) {
                this.saveOutput(this.sourceFolder.getSelectedIndex());
            }
        } else {
            this.saveOutput(0);
        }
    }

    void setModel(ProjectModel projectModel) {
        this.model = projectModel;
        this.updateControls();
        projectModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                OutputPanel.this.updateControls();
            }
        });
    }
}

