/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.model.DiagramModel;
import org.netbeans.modules.bpel.design.model.elements.VisualElement;
import org.netbeans.modules.bpel.design.model.patterns.CompositePattern;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.editors.api.EditorUtil;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.search.Decorator;
import org.netbeans.modules.xml.xam.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Diagram {
    private DesignView myView;

    public Diagram(DesignView designView) {
        this.myView = designView;
    }

    public JComponent getComponent() {
        return this.myView;
    }

    public List<Element> getElements(boolean bl) {
        DiagramModel diagramModel = this.myView.getModel();
        ArrayList<Element> arrayList = new ArrayList<Element>();
        this.travel(this.getRoot(diagramModel, bl), arrayList, "");
        return arrayList;
    }

    private void travel(Pattern pattern, List<Element> list, String string) {
        if (pattern == null) {
            return;
        }
        this.travel(pattern.getElements(), list, string);
        if (pattern instanceof CompositePattern) {
            CompositePattern compositePattern = (CompositePattern)pattern;
            this.travel(compositePattern.getBorder(), list, string);
            List<Pattern> list2 = compositePattern.getNestedPatterns();
            for (Pattern pattern2 : list2) {
                this.travel(pattern2, list, string + "  ");
            }
        }
    }

    private void travel(Collection<VisualElement> collection, List<Element> list, String string) {
        for (VisualElement visualElement : collection) {
            this.travel(visualElement, list, string);
        }
    }

    private void travel(VisualElement visualElement, List<Element> list, String string) {
        if (visualElement != null) {
            list.add(new Element(visualElement));
        }
    }

    private Pattern getRoot(DiagramModel diagramModel, boolean bl) {
        if (bl) {
            return diagramModel.getView().getSelectionModel().getSelectedPattern();
        }
        return diagramModel.getRootPattern();
    }

    public void clearHighlighting() {
        Decorator.getDecorator(this.myView).clearHighlighting();
    }

    public static class Element {
        private VisualElement myElement;

        Element(VisualElement visualElement) {
            this.myElement = visualElement;
        }

        public String getName() {
            return this.myElement.getText();
        }

        public void gotoSource() {
            EditorUtil.goToSource((Component)this.getBpelEntity());
        }

        public void gotoDesign() {
            Pattern pattern = this.myElement.getPattern();
            DesignView designView = pattern.getModel().getView();
            designView.getSelectionModel().setSelectedPattern(pattern);
            this.getDecorator().select(this.getBpelEntity());
        }

        public void highlight() {
            this.getDecorator().doHighlight(this.getBpelEntity(), true);
        }

        public void unhighlight() {
            this.getDecorator().doHighlight(this.getBpelEntity(), false);
        }

        private Decorator getDecorator() {
            return Decorator.getDecorator(this.myElement.getPattern().getModel().getView());
        }

        public BpelEntity getBpelEntity() {
            return this.myElement.getPattern().getOMReference();
        }
    }
}

