/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties.props;

import java.awt.Component;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.events.VetoException;
import org.netbeans.modules.bpel.nodes.BpelNode;
import org.netbeans.modules.bpel.properties.PropertyType;
import org.netbeans.modules.bpel.properties.editors.FormBundle;
import org.netbeans.modules.bpel.properties.props.PropertyVetoError;
import org.netbeans.modules.soa.ui.ClassBasedPool;
import org.netbeans.modules.soa.ui.UserNotification;
import org.netbeans.modules.soa.ui.nodes.InstanceRef;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.modules.xml.xam.ui.XAMUtils;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public final class PropertyUtils {
    public static final ClassBasedPool<Component> propertyCustomizerPool = new ClassBasedPool();
    public static final ClassBasedPool<PropertyEditor> propertyEditorPool = new ClassBasedPool();

    public static Node.Property registerCalculatedProperty(Object object, Sheet.Set set, PropertyType propertyType, String string, String string2) {
        return PropertyUtils.registerCalculatedProperty(object, set, propertyType, string, string2, null);
    }

    public static Node.Property registerCalculatedProperty(Object object, Sheet.Set set, PropertyType propertyType, String string, String string2, String string3) {
        return PropertyUtils.registerPropertyImpl(null, object, set, null, null, propertyType, string, string2, string3);
    }

    public static Node.Property registerProperty(InstanceRef instanceRef, Sheet.Set set, PropertyType propertyType, String string, String string2, String string3) {
        return PropertyUtils.registerPropertyImpl(instanceRef, null, set, null, null, propertyType, string, string2, string3);
    }

    public static Node.Property registerElementProperty(InstanceRef instanceRef, Object object, Sheet.Set set, Class clazz, PropertyType propertyType, String string, String string2, String string3) {
        return PropertyUtils.registerPropertyImpl(instanceRef, object, set, null, clazz, propertyType, string, string2, string3);
    }

    public static Node.Property registerAttributeProperty(InstanceRef instanceRef, Sheet.Set set, String string, PropertyType propertyType, String string2, String string3, String string4) {
        return PropertyUtils.registerPropertyImpl(instanceRef, null, set, string, null, propertyType, string2, string3, string4);
    }

    private static Node.Property registerPropertyImpl(InstanceRef instanceRef, final Object object, Sheet.Set set, String string, Class clazz, PropertyType propertyType, String string2, String string3, String string4) {
        try {
            InstanceRef instanceRef2;
            Reflection reflection;
            Class<?> clazz2 = propertyType.getPropertyClass();
            String string5 = propertyType.toString();
            String string6 = propertyType.getDisplayName();
            Class clazz3 = propertyType.getPropertyEditorClass();
            if (object == null && instanceRef != null) {
                Reflection reflection2 = new Reflection(instanceRef, clazz2, string2, string3, string4);
                if (reflection2 != null) {
                    reflection2.setName(string5);
                    reflection2.setValue("PropertyTypeAttribute", (Object)propertyType);
                    reflection2.setDisplayName(string6);
                    if (clazz3 != null) {
                        reflection2.setPropertyEditorClass(clazz3);
                    }
                    if (string != null && string.length() > 0) {
                        reflection2.setValue("BOUNDED_ATTRIBUTE_NAME", string);
                    }
                    if (clazz != null) {
                        reflection2.setValue("BOUNDED_ELEMENT_CLASS", clazz);
                    }
                    set.put((Node.Property)reflection2);
                    return reflection2;
                }
            } else if (object != null && instanceRef == null && (reflection = new Reflection(instanceRef2 = new InstanceRef(){

                public Object getReference() {
                    return object;
                }

                public Object getAlternativeReference() {
                    return null;
                }
            }, clazz2, string2, string3, string4)) != null) {
                reflection.setName(string5);
                reflection.setValue("PropertyTypeAttribute", (Object)propertyType);
                reflection.setDisplayName(string6);
                if (clazz3 != null) {
                    reflection.setPropertyEditorClass(clazz3);
                }
                if (string != null && string.length() > 0) {
                    reflection.setValue("BOUNDED_ATTRIBUTE_NAME", string);
                }
                if (clazz != null) {
                    reflection.setValue("BOUNDED_ELEMENT_CLASS", clazz);
                }
                set.put((Node.Property)reflection);
                return reflection;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ErrorManager.getDefault().notify((Throwable)noSuchMethodException);
        }
        return null;
    }

    public static Node.Property createPropertyStub(PropertyType propertyType) {
        PropertySupport.ReadOnly readOnly = null;
        try {
            Class<?> clazz = propertyType.getPropertyClass();
            String string = propertyType.toString();
            String string2 = propertyType.getDisplayName();
            Class clazz2 = propertyType.getPropertyEditorClass();
            readOnly = new PropertySupport.ReadOnly(string, clazz, string2, "This property is stub!"){

                public Object getValue() throws IllegalAccessException, InvocationTargetException {
                    return null;
                }
            };
            if (readOnly != null) {
                readOnly.setValue("PropertyTypeAttribute", (Object)propertyType);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        return readOnly;
    }

    public static Node.Property lookForPropertyByName(Node node, String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        for (Node.PropertySet propertySet : node.getPropertySets()) {
            for (Node.Property property : propertySet.getProperties()) {
                String string2 = property.getName();
                if (!string.equals(string2)) continue;
                return property;
            }
        }
        return null;
    }

    public static Node.Property lookForPropertyByType(Node node, PropertyType propertyType) {
        if (propertyType == null) {
            return null;
        }
        return PropertyUtils.lookForPropertyByType(node.getPropertySets(), propertyType);
    }

    public static Node.Property lookForPropertyByType(Node.PropertySet[] propertySetArray, PropertyType propertyType) {
        for (Node.PropertySet propertySet : propertySetArray) {
            for (Node.Property property : propertySet.getProperties()) {
                Object object = property.getValue("PropertyTypeAttribute");
                if (object == null) continue;
                assert (object instanceof PropertyType);
                if (!propertyType.equals((Object)((PropertyType)((Object)object)))) continue;
                return property;
            }
        }
        return null;
    }

    public static Node.Property lookForPropertyByBoundedAttribute(Node node, String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        for (Node.PropertySet propertySet : node.getPropertySets()) {
            for (Node.Property property : propertySet.getProperties()) {
                Object object = property.getValue("BOUNDED_ATTRIBUTE_NAME");
                if (object == null) continue;
                assert (object instanceof String);
                if (!string.equals((String)object)) continue;
                return property;
            }
        }
        return null;
    }

    public static Node.Property lookForPropertyByBoundedElement(Node node, Class clazz) {
        if (clazz == null) {
            return null;
        }
        for (Node.PropertySet propertySet : node.getPropertySets()) {
            for (Node.Property property : propertySet.getProperties()) {
                Object object = property.getValue("BOUNDED_ELEMENT_CLASS");
                if (object == null) continue;
                assert (object instanceof Class);
                if (!((Class)object).isAssignableFrom(clazz)) continue;
                return property;
            }
        }
        return null;
    }

    public static class Reflection
    extends Node.Property {
        protected InstanceRef myInstanceRef;
        private Method mySetter;
        private Method myGetter;
        private Method myRemover;
        private Class propertyEditorClass;
        private PropertyEditor myPropertyEditor;

        public Reflection(InstanceRef instanceRef, Class clazz, Method method, Method method2, Method method3) {
            super(clazz);
            assert (instanceRef != null);
            this.myInstanceRef = instanceRef;
            this.mySetter = method2;
            this.myGetter = method;
            this.myRemover = method3;
            this.checkMethods();
        }

        public Reflection(InstanceRef instanceRef, Class clazz, String string, String string2, String string3) throws NoSuchMethodException {
            super(clazz);
            assert (instanceRef != null);
            Method method = null;
            Method method2 = null;
            Method method3 = null;
            this.myInstanceRef = instanceRef;
            Class[] classArray = this.findAccessibleClasses(instanceRef);
            if (string != null) {
                method = this.tryFindMethodByName(classArray, string, new Class[0]);
            }
            if (string2 != null) {
                method2 = this.tryFindMethodByName(classArray, string2, new Class[]{clazz});
            }
            if (string3 != null) {
                method3 = this.tryFindMethodByName(classArray, string3, new Class[0]);
            }
            this.mySetter = method2;
            this.myGetter = method;
            this.myRemover = method3;
            this.checkMethods();
        }

        private Class[] findAccessibleClasses(InstanceRef instanceRef) {
            Class clazz;
            Class[] classArray = new Class[2];
            int n = 0;
            Object object = instanceRef.getReference();
            if (object != null && (clazz = Reflection.findAccessibleClass(object)) != null) {
                classArray[n] = clazz;
                ++n;
            }
            if ((object = instanceRef.getAlternativeReference()) != null && (clazz = Reflection.findAccessibleClass(object)) != null) {
                classArray[n] = clazz;
                ++n;
            }
            if (n == 0) {
                throw new RuntimeException("InstanceRef doesn't provide any instances");
            }
            return classArray;
        }

        private Method tryFindMethodByName(Class[] classArray, String string, Class[] classArray2) throws NoSuchMethodException {
            Method method = null;
            boolean bl = false;
            if (string != null) {
                for (Class clazz : classArray) {
                    if (clazz != null) {
                        try {
                            method = clazz.getMethod(string, classArray2);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                    if (method == null) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                StringBuffer stringBuffer = new StringBuffer();
                int n = 1;
                for (Class clazz : classArray) {
                    if (clazz == null) continue;
                    if (n != 0) {
                        n = 0;
                    } else {
                        stringBuffer.append("; ");
                    }
                    stringBuffer.append(clazz.getName());
                }
                throw new NoSuchMethodException("The method \"" + string + "\" can't be found " + "by the PropertyUtils.Reflection in the classes: " + stringBuffer);
            }
            return method;
        }

        public Reflection(InstanceRef instanceRef, Class clazz, String string) throws NoSuchMethodException {
            super(clazz);
            assert (instanceRef != null);
            Method method = null;
            Method method2 = null;
            Method method3 = null;
            Object object = instanceRef.getReference();
            Class clazz2 = Reflection.findAccessibleClass(object);
            method = clazz2.getMethod(Reflection.firstLetterToUpperCase(string, "get"), new Class[0]);
            if (method == null) {
                method = clazz2.getMethod(Reflection.firstLetterToUpperCase(string, "is"), new Class[0]);
            }
            method2 = clazz2.getMethod(Reflection.firstLetterToUpperCase(string, "set"), clazz);
            method3 = clazz2.getMethod(Reflection.firstLetterToUpperCase(string, "remove"), new Class[0]);
            this.myInstanceRef = instanceRef;
            this.mySetter = method2;
            this.myGetter = method;
            this.myRemover = method3;
            this.checkMethods();
        }

        private void checkMethods() throws IllegalArgumentException {
            if (this.myGetter != null && !Modifier.isPublic(this.myGetter.getModifiers())) {
                throw new IllegalArgumentException("Cannot use a non-public getter " + this.myGetter);
            }
            if (this.mySetter != null && !Modifier.isPublic(this.mySetter.getModifiers())) {
                throw new IllegalArgumentException("Cannot use a non-public setter " + this.mySetter);
            }
            if (this.myRemover != null && !Modifier.isPublic(this.myRemover.getModifiers())) {
                throw new IllegalArgumentException("Cannot use a non-public remover " + this.myRemover);
            }
        }

        public InstanceRef getInstanceRef() {
            return this.myInstanceRef;
        }

        private static Class findAccessibleClass(Object object) {
            if (object instanceof BpelEntity) {
                return ((BpelEntity)object).getElementType();
            }
            return Reflection.findAccessibleClass(object.getClass());
        }

        private static Class findAccessibleClass(Class clazz) {
            if (Modifier.isPublic(clazz.getModifiers())) {
                return clazz;
            }
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 == null) {
                return Object.class;
            }
            return Reflection.findAccessibleClass(clazz2);
        }

        private static String firstLetterToUpperCase(String string, String string2) {
            switch (string.length()) {
                case 0: {
                    return string2;
                }
                case 1: {
                    return string2 + Character.toUpperCase(string.charAt(0));
                }
            }
            return string2 + Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }

        public boolean canRead() {
            return this.myGetter != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValue() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (this.myGetter == null) {
                throw new IllegalAccessException();
            }
            try {
                return this.invokeMethod(this.myInstanceRef, this.myGetter, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
                try {
                    this.myGetter.setAccessible(true);
                    Object object = this.invokeMethod(this.myInstanceRef, this.myGetter, new Object[0]);
                    this.myGetter.setAccessible(false);
                    return object;
                }
                catch (Throwable throwable) {
                    try {
                        this.myGetter.setAccessible(false);
                        throw throwable;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        StringBuffer stringBuffer = new StringBuffer("Attempted to invoke method ");
                        stringBuffer.append(this.myGetter.getName());
                        stringBuffer.append(" from class ");
                        stringBuffer.append(this.myGetter.getDeclaringClass().getName());
                        stringBuffer.append(" on an instance of ");
                        stringBuffer.append(this.myGetter.getDeclaringClass().getName());
                        stringBuffer.append(" Problem:");
                        stringBuffer.append(illegalArgumentException.getMessage());
                        IllegalArgumentException illegalArgumentException2 = new IllegalArgumentException(stringBuffer.toString());
                        ErrorManager.getDefault().annotate((Throwable)illegalArgumentException2, (Throwable)illegalArgumentException);
                        throw illegalArgumentException2;
                    }
                }
            }
        }

        public boolean canWrite() {
            Model model = this.getModel();
            if (model != null && !XAMUtils.isWritable((Model)model)) {
                return false;
            }
            return this.mySetter != null;
        }

        public Model getModel() {
            DocumentComponent documentComponent = this.getDocumentComponent();
            return documentComponent != null ? documentComponent.getModel() : null;
        }

        public DocumentComponent getDocumentComponent() {
            BpelNode bpelNode;
            Object object = this.myInstanceRef.getReference();
            if (object != null) {
                Object t;
                if (object instanceof DocumentComponent) {
                    return (DocumentComponent)object;
                }
                if (object instanceof BpelNode && (t = (bpelNode = (BpelNode)((Object)object)).getReference()) != null && t instanceof DocumentComponent) {
                    return (DocumentComponent)t;
                }
            }
            if (this.myInstanceRef.getAlternativeReference() != null) {
                if (this.myInstanceRef.getAlternativeReference() instanceof DocumentComponent) {
                    return (DocumentComponent)this.myInstanceRef.getAlternativeReference();
                }
                if (this.myInstanceRef.getAlternativeReference() instanceof BpelNode && (bpelNode = (BpelNode)((Object)this.myInstanceRef.getAlternativeReference())).getReference() != null && bpelNode.getReference() instanceof DocumentComponent) {
                    return (DocumentComponent)bpelNode.getReference();
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            block23: {
                try {
                    if (object == null || object instanceof String && ((String)object).length() == 0) {
                        if (this.canRemove()) {
                            try {
                                this.invokeMethod(this.myInstanceRef, this.myRemover, new Object[0]);
                                break block23;
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                try {
                                    this.myRemover.setAccessible(true);
                                    this.invokeMethod(this.myInstanceRef, this.myRemover, new Object[0]);
                                    break block23;
                                }
                                finally {
                                    this.myRemover.setAccessible(false);
                                }
                            }
                        }
                        Object object2 = this.getValue();
                        if (!(object2 == null || object2 instanceof String && ((String)object2).length() == 0)) {
                            PropertyEditor propertyEditor = this.getPropertyEditor();
                            propertyEditor.setValue(object2);
                            String string = propertyEditor.getAsText();
                            if (string != null && string.length() != 0) {
                                String string2 = NbBundle.getMessage(FormBundle.class, (String)"ERR_REQURED_PROPERTY");
                                PropertyType propertyType = (PropertyType)((Object)this.getValue("PropertyTypeAttribute"));
                                String string3 = propertyType != null ? propertyType.getDisplayName() : this.getName();
                                string2 = MessageFormat.format(string2, string3);
                                throw new InvocationTargetException(new VetoException(string2, null));
                            }
                        }
                        break block23;
                    }
                    try {
                        if (this.mySetter == null) {
                            throw new IllegalAccessException();
                        }
                        this.invokeMethod(this.myInstanceRef, this.mySetter, object);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        try {
                            this.mySetter.setAccessible(true);
                            this.invokeMethod(this.myInstanceRef, this.mySetter, object);
                        }
                        finally {
                            this.mySetter.setAccessible(false);
                        }
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getTargetException();
                    boolean bl = false;
                    if (throwable instanceof VetoException) {
                        StackTraceElement[] stackTraceElementArray;
                        for (StackTraceElement stackTraceElement : stackTraceElementArray = invocationTargetException.getStackTrace()) {
                            if (stackTraceElement.getMethodName().equals("stopCellEditing") && stackTraceElement.getClassName().equals("org.openide.explorer.propertysheet.SheetCellEditor")) {
                                UserNotification.showMessage((String)throwable.getLocalizedMessage());
                                bl = true;
                                break;
                            }
                            if (stackTraceElement.getMethodName().equals("cancelValue") && stackTraceElement.getClassName().equals("org.openide.explorer.propertysheet.PropertyDialogManager")) {
                                bl = true;
                                break;
                            }
                            if (!stackTraceElement.getMethodName().equals("actionPerformed") || !stackTraceElement.getClassName().equals("org.openide.explorer.propertysheet.PropertyDialogManager")) continue;
                            throw new PropertyVetoError(throwable);
                        }
                    } else if (!(throwable instanceof Exception)) {
                        ErrorManager.getDefault().notify(throwable);
                        bl = false;
                    }
                    if (bl) break block23;
                    throw invocationTargetException;
                }
            }
        }

        public boolean canRemove() {
            Model model = this.getModel();
            if (model != null && !XAMUtils.isWritable((Model)model)) {
                return false;
            }
            return this.myRemover != null;
        }

        public void removeValue() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (this.myRemover == null) {
                throw new IllegalAccessException();
            }
            this.setValue(null);
        }

        public synchronized PropertyEditor getPropertyEditor() {
            if (this.myPropertyEditor == null && this.propertyEditorClass != null) {
                Object var1_1 = null;
                if (var1_1 == null) {
                    try {
                        var1_1 = this.propertyEditorClass.newInstance();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (var1_1 instanceof PropertyEditor) {
                    this.myPropertyEditor = var1_1;
                }
            }
            if (this.myPropertyEditor != null) {
                return this.myPropertyEditor;
            }
            return super.getPropertyEditor();
        }

        public void setPropertyEditorClass(Class clazz) {
            this.propertyEditorClass = clazz;
        }

        private Object invokeMethod(InstanceRef instanceRef, Method method, Object ... objectArray) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            Class<?> clazz = method.getDeclaringClass();
            Object object = instanceRef.getReference();
            if (object != null && clazz.isAssignableFrom(object.getClass())) {
                return method.invoke(object, objectArray);
            }
            object = instanceRef.getAlternativeReference();
            if (object != null && clazz.isAssignableFrom(object.getClass())) {
                return method.invoke(object, objectArray);
            }
            throw new IllegalArgumentException("The method \"" + method.getName() + "\" can't be called for the specified objecs");
        }
    }
}

