/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties.editors.controls;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.bpel.editors.api.ui.valid.ErrorMessagesBundle;
import org.netbeans.modules.bpel.model.api.BaseScope;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.MessageExchange;
import org.netbeans.modules.bpel.model.api.MessageExchangeContainer;
import org.netbeans.modules.bpel.model.api.references.BpelReference;
import org.netbeans.modules.bpel.model.api.references.BpelReferenceable;
import org.netbeans.modules.bpel.model.api.references.ReferenceCollection;
import org.netbeans.modules.bpel.model.api.support.VisibilityScope;
import org.netbeans.modules.bpel.model.spi.FindHelper;
import org.netbeans.modules.bpel.properties.PropertyType;
import org.netbeans.modules.bpel.properties.choosers.MessageExchangeChooserPanel;
import org.netbeans.modules.bpel.properties.editors.FormBundle;
import org.netbeans.modules.bpel.properties.editors.controls.TreeNodeChooser;
import org.netbeans.modules.bpel.properties.props.PropertyUtils;
import org.netbeans.modules.soa.ui.ExtendedLookup;
import org.netbeans.modules.soa.ui.form.CustomNodeEditor;
import org.netbeans.modules.soa.ui.form.EditorLifeCycleAdapter;
import org.netbeans.modules.soa.ui.form.valid.DefaultDialogDescriptor;
import org.netbeans.modules.soa.ui.form.valid.DefaultValidator;
import org.netbeans.modules.soa.ui.form.valid.SoaDialogDisplayer;
import org.netbeans.modules.soa.ui.form.valid.ValidStateManager;
import org.netbeans.modules.soa.ui.form.valid.Validator;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class MessageExchangeController
extends EditorLifeCycleAdapter
implements Validator.Provider {
    static final long serialVersionUID = 1L;
    private CustomNodeEditor myEditor;
    private DefaultValidator myValidator;
    private Timer inputDelayTimer;
    private MessageExchange myMsgEx;
    private JTextField fldMessageExchange;
    private JButton btnChooseMsgEx;

    public MessageExchangeController(CustomNodeEditor customNodeEditor) {
        this.myEditor = customNodeEditor;
        this.createContent();
    }

    public void createContent() {
        this.btnChooseMsgEx = new JButton();
        this.fldMessageExchange = new JTextField();
        this.btnChooseMsgEx.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MessageExchangeController.this.chooseMessageExchange();
            }
        });
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MessageExchangeController.this.recalculateMsgEx();
                MessageExchangeController.this.getValidator().revalidate(true);
            }
        };
        this.inputDelayTimer = new Timer(400, actionListener);
        this.inputDelayTimer.setCoalesce(true);
        this.inputDelayTimer.setRepeats(false);
        DocumentListener documentListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                MessageExchangeController.this.inputDelayTimer.restart();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                MessageExchangeController.this.inputDelayTimer.restart();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                MessageExchangeController.this.inputDelayTimer.restart();
            }
        };
        this.fldMessageExchange.getDocument().addDocumentListener(documentListener);
        FocusAdapter focusAdapter = new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                MessageExchangeController.this.inputDelayTimer.stop();
                MessageExchangeController.this.recalculateMsgEx();
                MessageExchangeController.this.getValidator().revalidate(true);
            }
        };
        this.fldMessageExchange.addFocusListener(focusAdapter);
    }

    private void chooseMessageExchange() {
        MessageExchange messageExchange;
        Lookup lookup = this.myEditor.getLookup();
        VisibilityScope visibilityScope = new VisibilityScope((BpelEntity)this.myEditor.getEditedObject(), lookup);
        ExtendedLookup extendedLookup = new ExtendedLookup(lookup, new Object[]{visibilityScope});
        MessageExchangeChooserPanel messageExchangeChooserPanel = new MessageExchangeChooserPanel((Lookup)extendedLookup);
        TreeNodeChooser treeNodeChooser = new TreeNodeChooser(messageExchangeChooserPanel);
        treeNodeChooser.initControls();
        if (this.myMsgEx != null) {
            messageExchangeChooserPanel.setSelectedValue(this.myMsgEx);
        }
        String string = NbBundle.getMessage(FormBundle.class, (String)"DLG_MessageExchangeChooserTitle");
        DefaultDialogDescriptor defaultDialogDescriptor = new DefaultDialogDescriptor((Object)treeNodeChooser, string);
        SoaDialogDisplayer.getDefault().notify((NotifyDescriptor)defaultDialogDescriptor);
        if (defaultDialogDescriptor.isOkHasPressed() && (messageExchange = messageExchangeChooserPanel.getSelectedValue()) != null) {
            this.setMessageExchange(messageExchange);
        }
    }

    private void recalculateMsgEx() {
        this.myMsgEx = null;
        String string = this.fldMessageExchange.getText();
        if (string == null || string.length() == 0) {
            return;
        }
        Object object = this.myEditor.getEditedObject();
        if (object != null && object instanceof BpelEntity) {
            BpelEntity bpelEntity = (BpelEntity)object;
            Lookup lookup = this.myEditor.getLookup();
            FindHelper findHelper = (FindHelper)Lookup.getDefault().lookup(FindHelper.class);
            Iterator iterator = findHelper.scopeIterator(bpelEntity);
            while (iterator.hasNext()) {
                MessageExchange[] messageExchangeArray;
                BaseScope baseScope = (BaseScope)iterator.next();
                MessageExchangeContainer messageExchangeContainer = baseScope.getMessageExchangeContainer();
                if (messageExchangeContainer == null) continue;
                for (MessageExchange messageExchange : messageExchangeArray = messageExchangeContainer.getMessageExchanges()) {
                    String string2 = messageExchange.getName();
                    if (!string.equals(string2)) continue;
                    this.myMsgEx = messageExchange;
                    return;
                }
            }
        }
    }

    public boolean initControls() {
        try {
            BpelReference bpelReference;
            Node.Property property = PropertyUtils.lookForPropertyByType(this.myEditor.getEditedNode(), PropertyType.MESSAGE_EXCHANGE);
            if (property != null && (bpelReference = (BpelReference)property.getValue()) != null) {
                MessageExchange messageExchange = (MessageExchange)bpelReference.get();
                this.setMessageExchange(messageExchange);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        return true;
    }

    public boolean applyNewValues() {
        try {
            Object object = this.myEditor.getEditedObject();
            assert (object instanceof ReferenceCollection);
            ReferenceCollection referenceCollection = (ReferenceCollection)object;
            Node.Property property = PropertyUtils.lookForPropertyByType(this.myEditor.getEditedNode(), PropertyType.MESSAGE_EXCHANGE);
            if (property != null) {
                if (this.myMsgEx == null) {
                    property.setValue(null);
                } else {
                    BpelReference bpelReference = referenceCollection.createReference((BpelReferenceable)this.myMsgEx, MessageExchange.class);
                    property.setValue((Object)bpelReference);
                }
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        return true;
    }

    public MessageExchange getMessageExchange() {
        return this.myMsgEx;
    }

    public void setMessageExchange(MessageExchange messageExchange) {
        if (this.myMsgEx == null && messageExchange != null || this.myMsgEx != null && !this.myMsgEx.equals(messageExchange)) {
            this.myMsgEx = messageExchange;
            this.fldMessageExchange.setText(this.myMsgEx == null ? "" : this.myMsgEx.getName());
        }
    }

    public DefaultValidator getValidator() {
        if (this.myValidator == null) {
            this.myValidator = new DefaultValidator((ValidStateManager.Provider)this.myEditor, ErrorMessagesBundle.class){

                public void doFastValidation() {
                    String string = MessageExchangeController.this.fldMessageExchange.getText();
                    if (MessageExchangeController.this.myMsgEx == null && string != null && string.length() != 0) {
                        this.addReasonKey(Validator.Severity.ERROR, "ERR_INCORRECT_MESSAGE_EXCHANGE");
                    }
                }
            };
        }
        return this.myValidator;
    }

    public JButton getBtnChooseMsgEx() {
        return this.btnChooseMsgEx;
    }

    public JTextField getFldMessageExchange() {
        return this.fldMessageExchange;
    }
}

