/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties.editors.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import javax.xml.namespace.QName;
import org.netbeans.modules.bpel.model.api.events.VetoException;
import org.netbeans.modules.bpel.model.api.support.TBoolean;
import org.netbeans.modules.bpel.nodes.BpelNode;
import org.netbeans.modules.bpel.properties.PropertyType;
import org.netbeans.modules.bpel.properties.editors.controls.QNameComboChooser;
import org.netbeans.modules.bpel.properties.editors.controls.QNameIndicator;
import org.netbeans.modules.soa.ui.SoaUtil;
import org.netbeans.modules.soa.ui.UserNotification;
import org.netbeans.modules.soa.ui.form.CustomNodeEditor;
import org.netbeans.modules.soa.ui.form.EditorLifeCycle;
import org.netbeans.modules.soa.ui.form.valid.DefaultValidStateManager;
import org.netbeans.modules.soa.ui.form.valid.ValidStateManager;
import org.netbeans.modules.soa.ui.form.valid.Validator;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractCustomNodeEditor<T>
extends JPanel
implements CustomNodeEditor<T> {
    private static final long serialVersionUID = 1L;
    private DefaultValidStateManager fastValidationState;
    private transient DefaultValidStateManager finalValidationState;
    private CustomNodeEditor.EditingMode editingMode = CustomNodeEditor.EditingMode.NOT_SPECIFIED;
    private BpelNode<T> modelNode;
    protected Map<PropertyType, JComponent> name2SimpleComponentMap = new HashMap<PropertyType, JComponent>();
    protected boolean isComponentsRegistered = false;

    public AbstractCustomNodeEditor(BpelNode<T> bpelNode) {
        this.modelNode = bpelNode;
        this.fastValidationState = new DefaultValidStateManager();
        this.finalValidationState = new DefaultValidStateManager();
    }

    public void createContent() {
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 0, 4));
        this.setLayout(new BorderLayout());
    }

    public boolean initControls() {
        assert (this.editingMode != CustomNodeEditor.EditingMode.NOT_SPECIFIED);
        try {
            this.processChildrenControls(this, LifeCycleStage.INIT);
            this.initSimpleControls();
            this.fastValidationState.clearReasons();
            this.fastValidationState.validateChildrenControls((Container)this, true);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        return true;
    }

    public boolean subscribeListeners() {
        try {
            this.processChildrenControls(this, LifeCycleStage.SUBSCRIBE);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        return true;
    }

    public boolean unsubscribeListeners() {
        try {
            this.processChildrenControls(this, LifeCycleStage.UNSUBSCRIBE);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        return true;
    }

    public boolean afterClose() {
        try {
            this.processChildrenControls(this, LifeCycleStage.AFTER_CLOSE);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        return true;
    }

    public boolean revalidate(boolean bl) {
        if (bl) {
            this.fastValidationState.clearReasons();
            this.fastValidationState.validateChildrenControls((Container)this, bl);
            return this.fastValidationState.isValid();
        }
        this.finalValidationState.clearReasons();
        this.finalValidationState.validateChildrenControls((Container)this, bl);
        return this.finalValidationState.isValid();
    }

    public boolean applyNewValues() throws Exception {
        this.applySimpleControlsValues();
        this.processChildrenControls(this, LifeCycleStage.APPLY);
        return true;
    }

    public BpelNode<T> getEditedNode() {
        return this.modelNode;
    }

    public T getEditedObject() {
        return this.modelNode.getReference();
    }

    public Lookup getLookup() {
        return this.modelNode.getLookup();
    }

    public boolean doValidateAndSave() {
        boolean bl;
        block8: {
            Validator.Reason reason;
            bl = false;
            if (this.revalidate(false)) {
                try {
                    this.applyNewValues();
                    bl = true;
                }
                catch (VetoException vetoException) {
                    String string = vetoException.getMessage();
                    UserNotification.showMessage((Throwable)vetoException, (String)string);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getTargetException();
                    if (throwable instanceof VetoException) {
                        String string = throwable.getMessage();
                        UserNotification.showMessage((Throwable)throwable, (String)string);
                        break block8;
                    }
                    ErrorManager.getDefault().notify((Throwable)invocationTargetException);
                }
                catch (Throwable throwable) {
                    ErrorManager.getDefault().notify(throwable);
                }
            } else if (this.finalValidationState != null && (reason = this.finalValidationState.getFistReason(null)) != null) {
                UserNotification.showMessage((String)reason.getText());
            }
        }
        return bl;
    }

    protected void initSimpleControls() {
        this.registerNamedSimpleComponents();
        for (Node.PropertySet propertySet : this.modelNode.getPropertySets()) {
            for (Node.Property property : propertySet.getProperties()) {
                Object object;
                JComponent jComponent;
                PropertyType propertyType = (PropertyType)((Object)property.getValue("PropertyTypeAttribute"));
                Class clazz = property.getValueType();
                if (Boolean.TYPE.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz)) {
                    jComponent = this.name2SimpleComponentMap.get((Object)propertyType);
                    if (!(jComponent instanceof JCheckBox)) continue;
                    try {
                        if (jComponent == null) continue;
                        object = (Boolean)property.getValue();
                        ((JCheckBox)jComponent).setSelected((Boolean)object);
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify((Throwable)exception);
                    }
                    continue;
                }
                if (TBoolean.class.isAssignableFrom(clazz)) {
                    jComponent = this.name2SimpleComponentMap.get((Object)propertyType);
                    if (!(jComponent instanceof JCheckBox)) continue;
                    try {
                        if (jComponent == null) continue;
                        object = (TBoolean)property.getValue();
                        if (object == null) {
                            object = TBoolean.INVALID;
                        }
                        switch (1.$SwitchMap$org$netbeans$modules$bpel$model$api$support$TBoolean[object.ordinal()]) {
                            case 1: {
                                ((JCheckBox)jComponent).setSelected(true);
                                break;
                            }
                            case 2: {
                                ((JCheckBox)jComponent).setSelected(false);
                                break;
                            }
                            default: {
                                ((JCheckBox)jComponent).setSelected(false);
                            }
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        ErrorManager.getDefault().notify((Throwable)illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        ErrorManager.getDefault().notify((Throwable)invocationTargetException);
                    }
                    continue;
                }
                if (QName.class.isAssignableFrom(clazz)) {
                    jComponent = this.name2SimpleComponentMap.get((Object)propertyType);
                    if (jComponent instanceof QNameIndicator) {
                        try {
                            if (jComponent == null) continue;
                            object = (QName)property.getValue();
                            ((QNameIndicator)jComponent).setQName((QName)object);
                        }
                        catch (Exception exception) {
                            ErrorManager.getDefault().notify((Throwable)exception);
                        }
                        continue;
                    }
                    if (!(jComponent instanceof QNameComboChooser)) continue;
                    try {
                        if (jComponent == null) continue;
                        object = (QName)property.getValue();
                        ((QNameComboChooser)jComponent).setQName((QName)object);
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify((Throwable)exception);
                    }
                    continue;
                }
                if (!String.class.isAssignableFrom(clazz) || !((jComponent = this.name2SimpleComponentMap.get((Object)propertyType)) instanceof JTextComponent)) continue;
                try {
                    if (jComponent == null) continue;
                    object = (String)property.getValue();
                    ((JTextComponent)jComponent).setText((String)object);
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                }
            }
        }
    }

    protected void applySimpleControlsValues() throws Exception {
        this.registerNamedSimpleComponents();
        for (Node.PropertySet propertySet : this.modelNode.getPropertySets()) {
            for (Node.Property property : propertySet.getProperties()) {
                Object object;
                JComponent jComponent;
                PropertyType propertyType = (PropertyType)((Object)property.getValue("PropertyTypeAttribute"));
                Class clazz = property.getValueType();
                if (String.class.isAssignableFrom(clazz)) {
                    jComponent = this.name2SimpleComponentMap.get((Object)propertyType);
                    if (!(jComponent instanceof JTextComponent) || jComponent == null) continue;
                    object = ((JTextComponent)jComponent).getText();
                    Object object2 = property.getValue();
                    if (!property.canWrite() || ((String)object).equals(object2)) continue;
                    property.setValue(object);
                    continue;
                }
                if (Boolean.TYPE.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz)) {
                    jComponent = this.name2SimpleComponentMap.get((Object)propertyType);
                    if (!(jComponent instanceof JCheckBox) || jComponent == null) continue;
                    Object object3 = object = ((JCheckBox)jComponent).isSelected() ? Boolean.TRUE : Boolean.FALSE;
                    if (!property.canWrite()) continue;
                    property.setValue(object);
                    continue;
                }
                if (TBoolean.class.isAssignableFrom(clazz)) {
                    jComponent = this.name2SimpleComponentMap.get((Object)propertyType);
                    if (!(jComponent instanceof JCheckBox) || jComponent == null) continue;
                    Object object4 = object = ((JCheckBox)jComponent).isSelected() ? TBoolean.YES : TBoolean.NO;
                    if (!property.canWrite()) continue;
                    property.setValue(object);
                    continue;
                }
                if (!QName.class.isAssignableFrom(clazz)) continue;
                jComponent = this.name2SimpleComponentMap.get((Object)propertyType);
                if (jComponent instanceof QNameIndicator) {
                    if (jComponent == null) continue;
                    object = ((QNameIndicator)jComponent).getQName();
                    if (!property.canWrite()) continue;
                    property.setValue(object);
                    continue;
                }
                if (!(jComponent instanceof QNameComboChooser) || jComponent == null) continue;
                object = ((QNameComboChooser)jComponent).getQName();
                if (!property.canWrite()) continue;
                property.setValue(object);
            }
        }
    }

    protected void registerNamedSimpleComponents() {
        if (this.isComponentsRegistered) {
            return;
        }
        this.registerNamedSimpleComponents(this);
        this.isComponentsRegistered = true;
    }

    protected void registerNamedSimpleComponents(Container container) {
        for (Component component : container.getComponents()) {
            if (component instanceof JTextComponent || component instanceof JCheckBox || component instanceof JComboBox) {
                PropertyType propertyType = (PropertyType)((Object)((JComponent)component).getClientProperty("PropertyBinder"));
                this.name2SimpleComponentMap.put(propertyType, (JComponent)component);
            }
            if (!(component instanceof Container)) continue;
            this.registerNamedSimpleComponents((Container)component);
        }
    }

    protected void processChildrenControls(Container container, LifeCycleStage lifeCycleStage) throws Exception {
        for (Component component : container.getComponents()) {
            boolean bl = false;
            if (component instanceof EditorLifeCycle) {
                switch (lifeCycleStage) {
                    case CREATE: {
                        ((EditorLifeCycle)component).createContent();
                        bl = true;
                        break;
                    }
                    case INIT: {
                        bl = ((EditorLifeCycle)component).initControls();
                        break;
                    }
                    case SUBSCRIBE: {
                        bl = ((EditorLifeCycle)component).subscribeListeners();
                        break;
                    }
                    case UNSUBSCRIBE: {
                        bl = ((EditorLifeCycle)component).unsubscribeListeners();
                        break;
                    }
                    case APPLY: {
                        bl = ((EditorLifeCycle)component).applyNewValues();
                        break;
                    }
                    case AFTER_CLOSE: {
                        bl = ((EditorLifeCycle)component).afterClose();
                    }
                }
            }
            switch (lifeCycleStage) {
                case VALIDATE_FINAL: {
                    this.finalValidationState.validateChildrenControls(container, false);
                    bl = true;
                    break;
                }
                case VALIDATE_FAST: {
                    this.fastValidationState.validateChildrenControls(container, true);
                    bl = true;
                }
            }
            if (bl || !(component instanceof Container)) continue;
            this.processChildrenControls((Container)component, lifeCycleStage);
        }
    }

    public ValidStateManager getValidStateManager(boolean bl) {
        return bl ? this.fastValidationState : this.finalValidationState;
    }

    public CustomNodeEditor.EditingMode getEditingMode() {
        return this.editingMode;
    }

    public void setEditingMode(CustomNodeEditor.EditingMode editingMode) {
        this.editingMode = editingMode;
    }

    public HelpCtx getHelpCtx() {
        String string = this.modelNode.getNodeType().getHelpId();
        return new HelpCtx(string);
    }

    protected void fireHelpContextChange() {
        SoaUtil.fireHelpContextChange((Component)this, (HelpCtx)this.getHelpCtx());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LifeCycleStage {
        CREATE,
        INIT,
        SUBSCRIBE,
        VALIDATE_FAST,
        VALIDATE_FINAL,
        APPLY,
        UNSUBSCRIBE,
        AFTER_CLOSE;

    }
}

