/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.bpel.editors.api.EditorUtil;
import org.netbeans.modules.bpel.editors.api.ui.valid.ErrorMessagesBundle;
import org.netbeans.modules.bpel.model.api.AbstractVariableDeclaration;
import org.netbeans.modules.bpel.model.api.Variable;
import org.netbeans.modules.bpel.model.api.VariableContainer;
import org.netbeans.modules.bpel.model.api.references.SchemaReference;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.bpel.model.api.support.VisibilityScope;
import org.netbeans.modules.bpel.properties.Constants;
import org.netbeans.modules.bpel.properties.ImportRegistrationHelper;
import org.netbeans.modules.bpel.properties.PropertyType;
import org.netbeans.modules.bpel.properties.TypeContainer;
import org.netbeans.modules.bpel.properties.Util;
import org.netbeans.modules.bpel.properties.choosers.TypeChooserPanel;
import org.netbeans.modules.bpel.properties.editors.FormBundle;
import org.netbeans.modules.soa.ui.form.CustomNodeEditor;
import org.netbeans.modules.soa.ui.form.EditorLifeCycle;
import org.netbeans.modules.soa.ui.form.EditorLifeCycleAdapter;
import org.netbeans.modules.soa.ui.form.valid.DefaultValidator;
import org.netbeans.modules.soa.ui.form.valid.ValidStateManager;
import org.netbeans.modules.soa.ui.form.valid.Validator;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.ReferenceableSchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Reference;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableMainPanel
extends EditorLifeCycleAdapter
implements Validator.Provider {
    static final long serialVersionUID = 1L;
    private CustomNodeEditor<Variable> myEditor;
    private DefaultValidator myValidator;
    private ButtonGroup bngVariableMetaType;
    private JTextField fldVariableName;
    private JLabel lblErrorMessage;
    private JLabel lblVariableName;
    private JPanel pnlTypeChooser;

    public VariableMainPanel(CustomNodeEditor<Variable> customNodeEditor) {
        this.myEditor = customNodeEditor;
        this.createContent();
    }

    private void bindControls2PropertyNames() {
        this.fldVariableName.putClientProperty("PropertyBinder", (Object)PropertyType.NAME);
    }

    public boolean initControls() {
        try {
            TypeChooserPanel typeChooserPanel = (TypeChooserPanel)this.pnlTypeChooser;
            typeChooserPanel.init(Constants.StereotypeFilter.ALL, this.myEditor.getLookup());
            Variable variable = (Variable)this.myEditor.getEditedObject();
            Reference reference = EditorUtil.getVariableType((AbstractVariableDeclaration)variable);
            if (reference == null) {
                typeChooserPanel.setSelectedValue(null);
            } else {
                TypeContainer typeContainer = new TypeContainer(reference);
                typeChooserPanel.setSelectedValue(typeContainer);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        return true;
    }

    public void createContent() {
        this.initComponents();
        this.bindControls2PropertyNames();
        ((EditorLifeCycle)this.pnlTypeChooser).createContent();
        TypeChooserPanel typeChooserPanel = (TypeChooserPanel)this.pnlTypeChooser;
        Util.attachDefaultDblClickAction(typeChooserPanel, typeChooserPanel);
        this.myEditor.getValidStateManager(true).addValidStateListener(new ValidStateManager.ValidStateListener(){

            public void stateChanged(ValidStateManager validStateManager, boolean bl) {
                if (validStateManager.isValid()) {
                    VariableMainPanel.this.lblErrorMessage.setText("");
                } else {
                    VariableMainPanel.this.lblErrorMessage.setText(validStateManager.getHtmlReasons());
                }
            }
        });
    }

    public boolean applyNewValues() {
        try {
            Variable variable = (Variable)this.myEditor.getEditedObject();
            SchemaModel schemaModel = null;
            TypeContainer typeContainer = ((TypeChooserPanel)this.pnlTypeChooser).getSelectedValue();
            if (typeContainer != null) {
                switch (typeContainer.getStereotype()) {
                    case PRIMITIVE_TYPE: 
                    case GLOBAL_SIMPLE_TYPE: 
                    case GLOBAL_COMPLEX_TYPE: 
                    case GLOBAL_TYPE: {
                        GlobalType globalType = typeContainer.getGlobalType();
                        SchemaReference schemaReference = variable.createSchemaReference((ReferenceableSchemaComponent)globalType, GlobalType.class);
                        variable.setType(schemaReference);
                        variable.removeElement();
                        variable.removeMessageType();
                        schemaModel = globalType.getModel();
                        break;
                    }
                    case MESSAGE: {
                        Message message = typeContainer.getMessage();
                        WSDLReference wSDLReference = variable.createWSDLReference((ReferenceableWSDLComponent)message, Message.class);
                        variable.setMessageType(wSDLReference);
                        variable.removeElement();
                        variable.removeType();
                        schemaModel = message.getModel();
                        break;
                    }
                    case GLOBAL_ELEMENT: {
                        GlobalElement globalElement = typeContainer.getGlobalElement();
                        SchemaReference schemaReference = variable.createSchemaReference((ReferenceableSchemaComponent)globalElement, GlobalElement.class);
                        variable.setElement(schemaReference);
                        variable.removeType();
                        variable.removeMessageType();
                        schemaModel = globalElement.getModel();
                    }
                }
            }
            if (schemaModel != null) {
                new ImportRegistrationHelper(variable.getBpelModel()).addImport((Model)schemaModel);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        return true;
    }

    public DefaultValidator getValidator() {
        if (this.myValidator == null) {
            this.myValidator = new DefaultValidator((ValidStateManager.Provider)this.myEditor, ErrorMessagesBundle.class){

                public void doFastValidation() {
                    String string = VariableMainPanel.this.fldVariableName.getText();
                    if (string == null || string.length() == 0) {
                        this.addReasonKey(Validator.Severity.ERROR, "ERR_NAME_EMPTY");
                    }
                }

                public void doDetailedValidation() {
                    super.doDetailedValidation();
                    VariableContainer variableContainer = null;
                    if (VariableMainPanel.this.myEditor.getEditingMode() == CustomNodeEditor.EditingMode.CREATE_NEW_INSTANCE) {
                        Object object;
                        VisibilityScope visibilityScope = (VisibilityScope)VariableMainPanel.this.myEditor.getLookup().lookup(VisibilityScope.class);
                        if (visibilityScope != null) {
                            object = visibilityScope.getClosestScope();
                            variableContainer = object.getVariableContainer();
                        }
                        if (variableContainer != null) {
                            Variable[] variableArray;
                            object = VariableMainPanel.this.fldVariableName.getText();
                            for (Variable variable : variableArray = variableContainer.getVariables()) {
                                if (!((String)object).equals(variable.getName())) continue;
                                this.addReasonKey(Validator.Severity.ERROR, "ERR_NOT_UNIQUE_VARIABLE_NAME");
                            }
                        }
                    }
                }
            };
        }
        return this.myValidator;
    }

    private void initComponents() {
        this.bngVariableMetaType = new ButtonGroup();
        this.lblVariableName = new JLabel();
        this.fldVariableName = new JTextField();
        this.pnlTypeChooser = new TypeChooserPanel();
        this.lblErrorMessage = new JLabel();
        this.lblVariableName.setLabelFor(this.fldVariableName);
        this.lblVariableName.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_VariableName"));
        this.pnlTypeChooser.setFocusable(false);
        GroupLayout groupLayout = new GroupLayout((Container)this.pnlTypeChooser);
        this.pnlTypeChooser.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 394, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 308, Short.MAX_VALUE));
        this.lblErrorMessage.setForeground(new Color(255, 0, 0));
        this.lblErrorMessage.setFocusable(false);
        GroupLayout groupLayout2 = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(2).add(1, (Component)this.pnlTypeChooser, -1, -1, Short.MAX_VALUE).add(1, (Component)this.lblErrorMessage, -1, 394, Short.MAX_VALUE).add(1, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.lblVariableName).addPreferredGap(0).add((Component)this.fldVariableName, -1, 342, Short.MAX_VALUE))).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.lblVariableName).add((Component)this.fldVariableName, -2, -1, -2)).addPreferredGap(0).add((Component)this.pnlTypeChooser, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.lblErrorMessage, -2, 39, -2)));
        this.lblVariableName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_LBL_VariableName"));
        this.lblVariableName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_VariableName"));
        this.lblErrorMessage.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_ErrorLabel"));
        this.lblErrorMessage.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_ErrorLabel"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_Variable_Editor"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_Variable_Editor"));
    }
}

