/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.bpel.design.DnDHandler;
import org.netbeans.modules.bpel.design.model.PartnerLinkHelper;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.editors.api.ui.valid.ErrorMessagesBundle;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.bpel.model.api.support.Utils;
import org.netbeans.modules.bpel.nodes.BpelNode;
import org.netbeans.modules.bpel.properties.ImportRegistrationHelper;
import org.netbeans.modules.bpel.properties.PropertyType;
import org.netbeans.modules.bpel.properties.ResolverUtility;
import org.netbeans.modules.bpel.properties.Util;
import org.netbeans.modules.bpel.properties.editors.FormBundle;
import org.netbeans.modules.bpel.properties.editors.WsdlWrapper;
import org.netbeans.modules.bpel.properties.editors.controls.EmptyComboBoxModel;
import org.netbeans.modules.bpel.properties.importchooser.WSDLFileImportDialog;
import org.netbeans.modules.soa.ui.SoaUtil;
import org.netbeans.modules.soa.ui.form.CustomNodeEditor;
import org.netbeans.modules.soa.ui.form.EditorLifeCycleAdapter;
import org.netbeans.modules.soa.ui.form.valid.DefaultValidator;
import org.netbeans.modules.soa.ui.form.valid.ValidStateManager;
import org.netbeans.modules.soa.ui.form.valid.Validator;
import org.netbeans.modules.xml.catalogsupport.util.ProjectUtilities;
import org.netbeans.modules.xml.catalogsupport.util.ProjectWSDL;
import org.netbeans.modules.xml.schema.ui.basic.UIUtilities;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Import;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.BPELComponentFactory;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PartnerLinkType;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.Role;
import org.netbeans.modules.xml.wsdl.model.visitor.WSDLModelVisitor;
import org.netbeans.modules.xml.wsdl.model.visitor.WSDLUtilities;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xam.ui.customizer.Customizer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartnerLinkMainPanel
extends EditorLifeCycleAdapter
implements Validator.Provider,
HelpCtx.Provider {
    static final long serialVersionUID = 1L;
    private CustomNodeEditor<PartnerLink> myEditor;
    private ArrayList<Role> rolesList;
    private Role myRole;
    private Role partnerRole;
    private DefaultValidator myValidator;
    private Timer inputDelayTimer;
    private static final String ROLE_NA = "-----";
    private static final String SLASH = "/";
    private static final EmptyComboBoxModel emptyModel = new EmptyComboBoxModel();
    private JButton btnSwapRoles;
    private ButtonGroup btngrPLT;
    private JComboBox cbxPartnerLinkType;
    private JComboBox cbxPartnerPortType;
    private JComboBox cbxProcessPortType;
    private JComboBox cbxWsdlFile;
    private JCheckBox chbxPartnerWillImpement;
    private JCheckBox chbxProcessWillImplement;
    private JTextField fldMyRole;
    private JTextField fldNewPLTName;
    private JTextField fldPartnerLinkName;
    private JTextField fldPartnerRole;
    private JTextField fldPartnerRoleName;
    private JTextField fldProcessRoleName;
    private JLabel lblErrorMessage;
    private JLabel lblMyRole;
    private JLabel lblName;
    private JLabel lblNewPLTypeName;
    private JLabel lblNewPLTypeName1;
    private JLabel lblPartnerLinkType;
    private JLabel lblPartnerPortType;
    private JLabel lblPartnerRole;
    private JLabel lblPartnerRoleName;
    private JLabel lblProcessPortType;
    private JLabel lblProcessRoleName;
    private JLabel lblWsdlFile;
    private JButton myBrowseButton;
    private JTextField myWsdlWrapperName;
    private JRadioButton rbtnCreateNewPLT;
    private JRadioButton rbtnUseExistingPLT;

    public PartnerLinkMainPanel(CustomNodeEditor<PartnerLink> customNodeEditor) {
        this.myEditor = customNodeEditor;
        this.createContent();
    }

    private void bindControls2PropertyNames() {
        this.fldPartnerLinkName.putClientProperty("PropertyBinder", (Object)PropertyType.NAME);
    }

    private Project getProject() {
        return FileOwnerQuery.getOwner((FileObject)((DataObject)this.myEditor.getLookup().lookup(DataObject.class)).getPrimaryFile());
    }

    public void createContent() {
        this.initComponents();
        this.bindControls2PropertyNames();
        List list = ProjectUtilities.getProjectWSDLRecursively((Project)this.getProject());
        ProjectWSDL[] projectWSDLArray = list.toArray(new ProjectWSDL[list.size()]);
        this.cbxWsdlFile.setModel(new DefaultComboBoxModel<ProjectWSDL>(projectWSDLArray));
        this.cbxWsdlFile.setRenderer(new WsdlFileRenderer());
        this.cbxProcessPortType.setRenderer(new PortTypeRenderer());
        this.cbxPartnerPortType.setRenderer(new PortTypeRenderer());
        this.cbxWsdlFile.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    PartnerLinkMainPanel.this.processWsdlFileChange();
                } else if (itemEvent.getStateChange() == 2) {
                    PartnerLinkMainPanel.this.cbxPartnerLinkType.setSelectedIndex(-1);
                    PartnerLinkMainPanel.this.cbxPartnerLinkType.setModel(emptyModel);
                }
            }
        });
        this.cbxPartnerLinkType.setRenderer(new DefaultListCellRenderer(){
            static final long serialVersionUID = 1L;

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object != null && object instanceof PartnerLinkType) {
                    PartnerLinkType partnerLinkType = (PartnerLinkType)object;
                    String string = partnerLinkType.getName();
                    this.setText(string);
                }
                return this;
            }
        });
        this.cbxPartnerLinkType.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    PartnerLinkMainPanel.this.reloadRoles();
                    PartnerLinkMainPanel.this.setRolesByDefault();
                } else if (itemEvent.getStateChange() == 2) {
                    PartnerLinkMainPanel.this.getRolesList().clear();
                    PartnerLinkMainPanel.this.setRole(false, null);
                    PartnerLinkMainPanel.this.setRole(true, null);
                }
            }
        });
        this.btnSwapRoles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PartnerLinkMainPanel.this.swapRoles();
            }
        });
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PartnerLinkMainPanel.this.updateEnabledState();
                PartnerLinkMainPanel.this.getValidator().revalidate(true);
            }
        };
        this.rbtnUseExistingPLT.addActionListener(actionListener);
        this.rbtnCreateNewPLT.addActionListener(actionListener);
        this.chbxProcessWillImplement.addActionListener(actionListener);
        this.chbxPartnerWillImpement.addActionListener(actionListener);
        this.updateEnabledState();
        this.myEditor.getValidStateManager(true).addValidStateListener(new ValidStateManager.ValidStateListener(){

            public void stateChanged(ValidStateManager validStateManager, boolean bl) {
                if (validStateManager.isValid()) {
                    PartnerLinkMainPanel.this.lblErrorMessage.setText("");
                } else {
                    PartnerLinkMainPanel.this.lblErrorMessage.setText(validStateManager.getHtmlReasons());
                }
            }
        });
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PartnerLinkMainPanel.this.getValidator().revalidate(true);
            }
        };
        this.inputDelayTimer = new Timer(400, actionListener2);
        this.inputDelayTimer.setCoalesce(true);
        this.inputDelayTimer.setRepeats(false);
        DocumentListener documentListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                PartnerLinkMainPanel.this.inputDelayTimer.restart();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                PartnerLinkMainPanel.this.inputDelayTimer.restart();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                PartnerLinkMainPanel.this.inputDelayTimer.restart();
            }
        };
        this.fldPartnerLinkName.getDocument().addDocumentListener(documentListener);
        this.fldPartnerRoleName.getDocument().addDocumentListener(documentListener);
        this.fldProcessRoleName.getDocument().addDocumentListener(documentListener);
        this.fldNewPLTName.getDocument().addDocumentListener(documentListener);
        FocusAdapter focusAdapter = new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                PartnerLinkMainPanel.this.inputDelayTimer.stop();
                PartnerLinkMainPanel.this.getValidator().revalidate(true);
            }
        };
        this.fldPartnerLinkName.addFocusListener(focusAdapter);
        this.fldPartnerRoleName.addFocusListener(focusAdapter);
        this.fldProcessRoleName.addFocusListener(focusAdapter);
        this.fldNewPLTName.addFocusListener(focusAdapter);
    }

    private void updateEnabledState() {
        if (this.cbxWsdlFile.getSelectedIndex() == -1) {
            this.rbtnUseExistingPLT.setEnabled(false);
            this.rbtnCreateNewPLT.setEnabled(false);
            this.cbxPartnerLinkType.setEnabled(false);
            this.btnSwapRoles.setEnabled(false);
            this.fldNewPLTName.setEnabled(false);
            this.chbxProcessWillImplement.setEnabled(false);
            this.fldProcessRoleName.setEnabled(false);
            this.cbxProcessPortType.setEnabled(false);
            this.chbxPartnerWillImpement.setEnabled(false);
            this.fldPartnerRoleName.setEnabled(false);
            this.cbxPartnerPortType.setEnabled(false);
            this.myWsdlWrapperName.setEnabled(false);
            this.myBrowseButton.setEnabled(false);
        } else {
            this.rbtnUseExistingPLT.setEnabled(true);
            this.rbtnCreateNewPLT.setEnabled(true);
            if (this.rbtnUseExistingPLT.isSelected()) {
                this.cbxPartnerLinkType.setEnabled(true);
                this.btnSwapRoles.setEnabled(true);
                this.myWsdlWrapperName.setEnabled(false);
                this.myBrowseButton.setEnabled(false);
                this.fldNewPLTName.setEnabled(false);
                this.chbxProcessWillImplement.setEnabled(false);
                this.fldProcessRoleName.setEnabled(false);
                this.cbxProcessPortType.setEnabled(false);
                this.chbxPartnerWillImpement.setEnabled(false);
                this.fldPartnerRoleName.setEnabled(false);
                this.cbxPartnerPortType.setEnabled(false);
            } else {
                this.cbxPartnerLinkType.setEnabled(false);
                this.btnSwapRoles.setEnabled(false);
                this.myWsdlWrapperName.setEnabled(true);
                this.myBrowseButton.setEnabled(true);
                this.fldNewPLTName.setEnabled(true);
                this.chbxProcessWillImplement.setEnabled(true);
                boolean bl = this.chbxProcessWillImplement.isSelected();
                this.fldProcessRoleName.setEnabled(bl);
                this.cbxProcessPortType.setEnabled(bl);
                this.chbxPartnerWillImpement.setEnabled(true);
                boolean bl2 = this.chbxPartnerWillImpement.isSelected();
                this.fldPartnerRoleName.setEnabled(bl2);
                this.cbxPartnerPortType.setEnabled(bl2);
            }
        }
    }

    public boolean initControls() {
        try {
            Object object;
            this.cbxWsdlFile.setSelectedIndex(-1);
            boolean bl = false;
            PartnerLink partnerLink = (PartnerLink)this.myEditor.getEditedObject();
            WSDLReference wSDLReference = partnerLink.getPartnerLinkType();
            PartnerLinkType partnerLinkType = null;
            FileObject fileObject = null;
            WSDLModel wSDLModel = null;
            if (wSDLReference != null && (partnerLinkType = (PartnerLinkType)wSDLReference.get()) != null) {
                fileObject = (FileObject)partnerLinkType.getModel().getModelSource().getLookup().lookup(FileObject.class);
            }
            if (fileObject == null) {
                object = partnerLink.getCookie(DnDHandler.class);
                if (object != null && object instanceof WSDLModel) {
                    wSDLModel = (WSDLModel)object;
                    fileObject = (FileObject)wSDLModel.getModelSource().getLookup().lookup(FileObject.class);
                    bl = true;
                } else if (object != null && object instanceof FileObject) {
                    fileObject = (FileObject)object;
                    wSDLModel = PartnerLinkHelper.getWSDLModel(fileObject);
                    bl = true;
                }
            }
            if (fileObject != null) {
                this.cbxWsdlFile.setSelectedItem(new ProjectWSDL(fileObject, this.getProject()));
            } else if (this.cbxWsdlFile.getModel().getSize() > 0) {
                this.cbxWsdlFile.setSelectedIndex(0);
            }
            if (partnerLinkType != null) {
                this.cbxPartnerLinkType.setSelectedItem(partnerLinkType);
            } else if (this.cbxPartnerLinkType.getModel().getSize() > 0) {
                this.cbxPartnerLinkType.setSelectedIndex(0);
            }
            if (this.myEditor.getEditingMode() == CustomNodeEditor.EditingMode.EDIT_INSTANCE) {
                object = partnerLink.getMyRole();
                this.setRoleByRef(true, (WSDLReference<Role>)object);
                WSDLReference wSDLReference2 = partnerLink.getPartnerRole();
                this.setRoleByRef(false, (WSDLReference<Role>)wSDLReference2);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        this.setWrapper(this.getCurrentWsdlFile());
        this.myWsdlWrapperName.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                PartnerLinkMainPanel.this.getValidator().revalidate(true);
            }
        });
        this.updateEnabledState();
        this.getValidator().revalidate(true);
        return true;
    }

    private void processWsdlFileChange() {
        this.reloadPartnerLinkTypes();
        if (this.cbxPartnerLinkType.getModel().getSize() > 0) {
            this.cbxPartnerLinkType.setSelectedIndex(0);
        } else {
            this.cbxPartnerLinkType.setSelectedIndex(-1);
        }
        this.reloadPortTypes();
        this.setWrapper(this.getCurrentWsdlFile());
        WSDLModel wSDLModel = this.getCurrentWsdlModel();
        List<PartnerLinkType> list = this.getPartnerLinkTypeRecursively(wSDLModel);
        if (list.isEmpty()) {
            this.rbtnCreateNewPLT.setSelected(true);
            this.setDefaultParamsForNewPLT(wSDLModel);
        } else {
            this.rbtnUseExistingPLT.setSelected(true);
            this.setRolesByDefault();
        }
        this.updateEnabledState();
        this.getValidator().revalidate(true);
    }

    private void setDefaultParamsForNewPLT(WSDLModel wSDLModel) {
        int n;
        String string;
        if (wSDLModel == null) {
            return;
        }
        List<PortType> list = this.getPortTypeRecursively(wSDLModel);
        if (list.isEmpty()) {
            return;
        }
        PortType portType = list.iterator().next();
        String string2 = portType.getName();
        String string3 = "PortType";
        if (string2 != null && string2.endsWith(string3) && (string = string2.substring(0, n = string2.length() - string3.length())).length() != 0) {
            string2 = string;
        }
        this.chbxPartnerWillImpement.setSelected(true);
        this.fldNewPLTName.setText(string2 + "LinkType");
        this.fldPartnerRoleName.setText(string2 + "Role");
        this.cbxPartnerPortType.setSelectedItem(portType);
    }

    private void reloadPartnerLinkTypes() {
        List<PartnerLinkType> list = this.getPartnerLinkTypeRecursively(this.getCurrentWsdlModel());
        if (list != null && list.size() > 0) {
            this.cbxPartnerLinkType.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
            this.cbxPartnerLinkType.setSelectedIndex(-1);
        }
    }

    private List<Role> getRolesList() {
        if (this.rolesList == null) {
            this.rolesList = new ArrayList(2);
            this.reloadRoles();
        }
        return this.rolesList;
    }

    private void reloadRoles() {
        PartnerLinkType partnerLinkType = (PartnerLinkType)this.cbxPartnerLinkType.getSelectedItem();
        this.getRolesList().clear();
        if (partnerLinkType != null) {
            Role role = partnerLinkType.getRole1();
            if (role != null) {
                this.rolesList.add(role);
            }
            if ((role = partnerLinkType.getRole2()) != null) {
                this.rolesList.add(role);
            }
        }
    }

    private void setRolesByDefault() {
        Role role = null;
        Role role2 = null;
        Iterator<Role> iterator = this.getRolesList().iterator();
        if (iterator.hasNext()) {
            role = iterator.next();
        }
        if (iterator.hasNext()) {
            role2 = iterator.next();
        }
        this.setRole(true, role);
        this.setRole(false, role2);
    }

    private void setRoleByRef(boolean bl, WSDLReference<Role> wSDLReference) {
        if (wSDLReference == null) {
            this.setRole(bl, null);
            return;
        }
        Role role = (Role)wSDLReference.get();
        if (role == null) {
            String string = wSDLReference.getRefString();
            if (bl) {
                if (string == null || string.length() == 0) {
                    this.fldMyRole.setText(ROLE_NA);
                } else {
                    this.fldMyRole.setText(string);
                }
            } else if (string == null || string.length() == 0) {
                this.fldPartnerRole.setText(ROLE_NA);
            } else {
                this.fldPartnerRole.setText(string);
            }
        } else {
            this.setRole(bl, role);
        }
    }

    private void setRole(boolean bl, Role role) {
        if (bl) {
            this.myRole = role;
            if (role == null) {
                this.fldMyRole.setText(ROLE_NA);
            } else {
                this.fldMyRole.setText(role.getName());
            }
        } else {
            this.partnerRole = role;
            if (role == null) {
                this.fldPartnerRole.setText(ROLE_NA);
            } else {
                this.fldPartnerRole.setText(role.getName());
            }
        }
    }

    private void swapRoles() {
        Role role = this.myRole;
        String string = this.fldMyRole.getText();
        this.myRole = this.partnerRole;
        String string2 = this.fldPartnerRole.getText();
        this.fldMyRole.setText(string2);
        this.partnerRole = role;
        this.fldPartnerRole.setText(string);
    }

    private void reloadPortTypes() {
        List<PortType> list = this.getPortTypeRecursively(this.getCurrentWsdlModel());
        if (list != null && list.size() > 0) {
            this.cbxProcessPortType.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
            this.cbxPartnerPortType.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        }
        this.getValidator().revalidate(true);
    }

    public boolean applyNewValues() {
        try {
            PartnerLink partnerLink = (PartnerLink)this.myEditor.getEditedObject();
            PartnerLinkType partnerLinkType = null;
            partnerLinkType = this.rbtnUseExistingPLT.isSelected() ? this.tuneForExistingPLT(partnerLink) : this.tuneFromNewPLT(partnerLink);
            if (partnerLinkType != null) {
                new ImportRegistrationHelper(partnerLink.getBpelModel()).addImport((Model)partnerLinkType.getModel());
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        return true;
    }

    private WSDLModel getCurrentWsdlModel(boolean bl, boolean bl2) {
        FileObject fileObject = this.getCurrentWsdlFile();
        WSDLModel wSDLModel = PartnerLinkHelper.getWSDLModel(fileObject);
        if (bl) {
            WsdlWrapper wsdlWrapper = new WsdlWrapper(ResolverUtility.getProjectSource(this.myEditor.getLookup()), this.myWsdlWrapperName.getText(), bl2);
            WSDLModel wSDLModel2 = wsdlWrapper.getModel();
            if (wSDLModel2 == null) {
                return null;
            }
            FileObject fileObject2 = wsdlWrapper.getFile();
            this.addImport(wSDLModel2, fileObject2, wSDLModel, fileObject);
            return wSDLModel2;
        }
        return wSDLModel;
    }

    private FileObject getSource() {
        return SoaUtil.getFileObjectByModel((Model)((Model)this.myEditor.getLookup().lookup(BpelModel.class)));
    }

    private void addImport(WSDLModel wSDLModel, FileObject fileObject, WSDLModel wSDLModel2, FileObject fileObject2) {
        if (fileObject.equals(fileObject2)) {
            return;
        }
        Definitions definitions = wSDLModel.getDefinitions();
        Import import_ = wSDLModel.getFactory().createImport();
        import_.setLocation(this.getRelativePath(fileObject, fileObject2));
        import_.setNamespace(wSDLModel2.getDefinitions().getTargetNamespace());
        if (this.containsImport(wSDLModel, import_)) {
            return;
        }
        wSDLModel.startTransaction();
        definitions.addImport(import_);
        wSDLModel.endTransaction();
    }

    private boolean containsImport(WSDLModel wSDLModel, Import import_) {
        Definitions definitions = wSDLModel.getDefinitions();
        for (Import import_2 : definitions.getImports()) {
            if (!this.equals(import_2, import_)) continue;
            return true;
        }
        return false;
    }

    private boolean equals(Import import_, Import import_2) {
        return import_.getLocation().equals(import_2.getLocation()) && import_.getNamespace().equals(import_2.getNamespace());
    }

    private String getRelativePath(FileObject fileObject, FileObject fileObject2) {
        StringTokenizer stringTokenizer = new StringTokenizer(fileObject.getPath(), SLASH);
        StringTokenizer stringTokenizer2 = new StringTokenizer(fileObject2.getPath(), SLASH);
        String string = "";
        while (stringTokenizer.hasMoreTokens() && stringTokenizer2.hasMoreTokens()) {
            string = stringTokenizer2.nextToken();
            if (stringTokenizer.nextToken().equals(string)) continue;
        }
        while (stringTokenizer.hasMoreTokens()) {
            string = "../".concat(string);
            stringTokenizer.nextToken();
        }
        while (stringTokenizer2.hasMoreTokens()) {
            string = string.concat(SLASH);
            string = string.concat(stringTokenizer2.nextToken());
        }
        return string;
    }

    private WSDLModel getCurrentWsdlModel() {
        return this.getCurrentWsdlModel(false, false);
    }

    private FileObject getCurrentWsdlFile() {
        Object object = this.cbxWsdlFile.getSelectedItem();
        if (object == null) {
            return null;
        }
        return ((ProjectWSDL)object).getFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PartnerLinkType tuneFromNewPLT(PartnerLink partnerLink) {
        PartnerLinkType partnerLinkType = null;
        Role role = null;
        Role role2 = null;
        WSDLModel wSDLModel = this.getCurrentWsdlModel(true, true);
        if (wSDLModel != null) {
            wSDLModel.startTransaction();
            try {
                NamedComponentReference namedComponentReference;
                PortType portType;
                String string;
                boolean bl = false;
                BPELComponentFactory bPELComponentFactory = new BPELComponentFactory(wSDLModel);
                partnerLinkType = bPELComponentFactory.createPartnerLinkType((WSDLComponent)wSDLModel.getDefinitions());
                String string2 = this.fldNewPLTName.getText();
                partnerLinkType.setName(string2);
                wSDLModel.getDefinitions().addExtensibilityElement((ExtensibilityElement)partnerLinkType);
                if (this.chbxProcessWillImplement.isSelected()) {
                    role = bPELComponentFactory.createRole((WSDLComponent)wSDLModel.getDefinitions());
                    string = this.fldProcessRoleName.getText();
                    role.setName(string);
                    partnerLinkType.setRole1(role);
                    bl = true;
                    portType = (PortType)this.cbxProcessPortType.getSelectedItem();
                    namedComponentReference = role.createReferenceTo((ReferenceableWSDLComponent)portType, PortType.class);
                    role.setPortType(namedComponentReference);
                }
                if (this.chbxPartnerWillImpement.isSelected()) {
                    role2 = bPELComponentFactory.createRole((WSDLComponent)wSDLModel.getDefinitions());
                    string = this.fldPartnerRoleName.getText();
                    role2.setName(string);
                    if (bl) {
                        partnerLinkType.setRole2(role2);
                    } else {
                        partnerLinkType.setRole1(role2);
                    }
                    portType = (PortType)this.cbxPartnerPortType.getSelectedItem();
                    namedComponentReference = role2.createReferenceTo((ReferenceableWSDLComponent)portType, PortType.class);
                    role2.setPortType(namedComponentReference);
                }
            }
            finally {
                wSDLModel.endTransaction();
            }
            PartnerLinkHelper.saveModel((Model)wSDLModel);
            if (partnerLinkType != null) {
                partnerLink.setPartnerLinkType(partnerLink.createWSDLReference((ReferenceableWSDLComponent)partnerLinkType, PartnerLinkType.class));
                if (role != null) {
                    WSDLReference wSDLReference = partnerLink.createWSDLReference((ReferenceableWSDLComponent)role, Role.class);
                    partnerLink.setMyRole(wSDLReference);
                } else {
                    partnerLink.removeMyRole();
                }
                if (role2 != null) {
                    WSDLReference wSDLReference = partnerLink.createWSDLReference((ReferenceableWSDLComponent)role2, Role.class);
                    partnerLink.setPartnerRole(wSDLReference);
                } else {
                    partnerLink.removePartnerRole();
                }
            }
        }
        return partnerLinkType;
    }

    private PartnerLinkType tuneForExistingPLT(PartnerLink partnerLink) {
        WSDLReference wSDLReference;
        PartnerLinkType partnerLinkType = (PartnerLinkType)this.cbxPartnerLinkType.getSelectedItem();
        if (partnerLinkType != null) {
            partnerLink.setPartnerLinkType(partnerLink.createWSDLReference((ReferenceableWSDLComponent)partnerLinkType, PartnerLinkType.class));
        }
        if (this.myRole == null) {
            partnerLink.removeMyRole();
        } else {
            wSDLReference = partnerLink.createWSDLReference((ReferenceableWSDLComponent)this.myRole, Role.class);
            partnerLink.setMyRole(wSDLReference);
        }
        if (this.partnerRole == null) {
            partnerLink.removePartnerRole();
        } else {
            wSDLReference = partnerLink.createWSDLReference((ReferenceableWSDLComponent)this.partnerRole, Role.class);
            partnerLink.setPartnerRole(wSDLReference);
        }
        return partnerLinkType;
    }

    public DefaultValidator getValidator() {
        if (this.myValidator == null) {
            this.myValidator = new DefaultValidator((ValidStateManager.Provider)this.myEditor, ErrorMessagesBundle.class){

                public void doFastValidation() {
                    String string;
                    WsdlWrapper wsdlWrapper = new WsdlWrapper(ResolverUtility.getProjectSource(PartnerLinkMainPanel.this.myEditor.getLookup()), PartnerLinkMainPanel.this.myWsdlWrapperName.getText(), false);
                    FileObject fileObject = wsdlWrapper.getFile();
                    if (fileObject != null && !fileObject.canWrite()) {
                        this.addReasonKey(Validator.Severity.ERROR, "ERR_FILE_IS_READ_ONLY", new String[]{PartnerLinkMainPanel.this.myWsdlWrapperName.getText()});
                    }
                    if ((string = PartnerLinkMainPanel.this.fldPartnerLinkName.getText()) == null || string.length() == 0) {
                        this.addReasonKey(Validator.Severity.ERROR, "ERR_NAME_EMPTY");
                    }
                    if (PartnerLinkMainPanel.this.cbxWsdlFile.getSelectedIndex() == -1) {
                        this.addReasonKey(Validator.Severity.ERROR, "ERR_WSDL_FILE_NOT_SPECIFIED");
                    }
                    if (PartnerLinkMainPanel.this.rbtnUseExistingPLT.isSelected()) {
                        if (PartnerLinkMainPanel.this.cbxPartnerLinkType.getSelectedIndex() == -1) {
                            this.addReasonKey(Validator.Severity.ERROR, "ERR_PL_TYPE_NOT_SPECIFIED");
                        }
                        if (PartnerLinkMainPanel.this.myRole == null && PartnerLinkMainPanel.this.partnerRole == null) {
                            this.addReasonKey(Validator.Severity.ERROR, "ERR_PL_TYPE_WITHOUT_ROLES");
                        }
                    } else {
                        Object object;
                        String string2 = PartnerLinkMainPanel.this.fldNewPLTName.getText();
                        if (string2 == null || string2.length() == 0) {
                            this.addReasonKey(Validator.Severity.ERROR, "ERR_PLT_NAME_EMPTY");
                        } else {
                            boolean bl = Util.isNCName(string2);
                            if (!bl) {
                                this.addReasonKey(Validator.Severity.ERROR, "ERR_PLT_NAME_INVALID");
                            } else {
                                object = PartnerLinkMainPanel.this.getCurrentWsdlModel(true, false);
                                if (object != null && !(bl = Util.isUniquePartnerLinkTypeName(object, string2))) {
                                    this.addReasonKey(Validator.Severity.ERROR, "ERR_PLT_NAME_NOT_UNIQUE");
                                }
                            }
                        }
                        if (!PartnerLinkMainPanel.this.chbxProcessWillImplement.isSelected() && !PartnerLinkMainPanel.this.chbxPartnerWillImpement.isSelected()) {
                            this.addReasonKey(Validator.Severity.ERROR, "ERR_NEW_PLT_ROLES_NOT_SPECIFIED");
                        }
                        if (PartnerLinkMainPanel.this.chbxProcessWillImplement.isSelected()) {
                            String string3 = PartnerLinkMainPanel.this.fldProcessRoleName.getText();
                            if (string3 == null || string3.length() == 0) {
                                this.addReasonKey(Validator.Severity.ERROR, "ERR_PLT_MY_ROLE_NAME_EMPTY");
                            } else {
                                boolean bl = Util.isNCName(string3);
                                if (!bl) {
                                    this.addReasonKey(Validator.Severity.ERROR, "ERR_PLT_MY_ROLE_NAME_INVALID");
                                }
                            }
                            int n = PartnerLinkMainPanel.this.cbxProcessPortType.getSelectedIndex();
                            if (n == -1) {
                                this.addReasonKey(Validator.Severity.ERROR, "ERR_PLT_MY_ROLE_PORT_TYPE_EMPTY");
                            }
                        }
                        if (PartnerLinkMainPanel.this.chbxPartnerWillImpement.isSelected()) {
                            String string4 = PartnerLinkMainPanel.this.fldPartnerRoleName.getText();
                            if (string4 == null || string4.length() == 0) {
                                this.addReasonKey(Validator.Severity.ERROR, "ERR_PLT_PARTNER_ROLE_NAME_EMPTY");
                            } else {
                                boolean bl = Util.isNCName(string4);
                                if (!bl) {
                                    this.addReasonKey(Validator.Severity.ERROR, "ERR_PLT_PARTNER_ROLE_NAME_INVALID");
                                }
                            }
                            int n = PartnerLinkMainPanel.this.cbxPartnerPortType.getSelectedIndex();
                            if (n == -1) {
                                this.addReasonKey(Validator.Severity.ERROR, "ERR_PLT_PARTNER_ROLE_PORT_TYPE_EMPTY");
                            }
                        }
                        if (PartnerLinkMainPanel.this.chbxPartnerWillImpement.isSelected() && PartnerLinkMainPanel.this.chbxProcessWillImplement.isSelected()) {
                            String string5 = PartnerLinkMainPanel.this.fldProcessRoleName.getText();
                            object = PartnerLinkMainPanel.this.fldPartnerRoleName.getText();
                            if (string5 != null && string5.length() > 0 && string5.equals(object)) {
                                this.addReasonKey(Validator.Severity.ERROR, "ERR_PLT_ROLES_NOT_UNIQUE");
                            }
                        }
                    }
                }
            };
        }
        return this.myValidator;
    }

    public HelpCtx getHelpCtx() {
        String string = ((BpelNode)this.myEditor.getEditedNode()).getNodeType().getHelpId();
        return new HelpCtx(string);
    }

    private void initComponents() {
        this.btngrPLT = new ButtonGroup();
        this.lblName = new JLabel();
        this.fldPartnerLinkName = new JTextField();
        this.lblWsdlFile = new JLabel();
        this.lblPartnerLinkType = new JLabel();
        this.lblMyRole = new JLabel();
        this.lblPartnerRole = new JLabel();
        this.cbxPartnerLinkType = new JComboBox();
        this.cbxWsdlFile = new JComboBox();
        this.lblErrorMessage = new JLabel();
        this.rbtnUseExistingPLT = new JRadioButton();
        this.rbtnCreateNewPLT = new JRadioButton();
        this.lblNewPLTypeName = new JLabel();
        this.chbxProcessWillImplement = new JCheckBox();
        this.lblProcessRoleName = new JLabel();
        this.lblProcessPortType = new JLabel();
        this.chbxPartnerWillImpement = new JCheckBox();
        this.lblPartnerRoleName = new JLabel();
        this.lblPartnerPortType = new JLabel();
        this.fldNewPLTName = new JTextField();
        this.fldProcessRoleName = new JTextField();
        this.cbxProcessPortType = new JComboBox();
        this.fldPartnerRoleName = new JTextField();
        this.cbxPartnerPortType = new JComboBox();
        this.btnSwapRoles = new JButton();
        this.fldMyRole = new JTextField();
        this.fldPartnerRole = new JTextField();
        this.lblNewPLTypeName1 = new JLabel();
        this.myWsdlWrapperName = new JTextField();
        this.myBrowseButton = new JButton();
        this.lblName.setLabelFor(this.fldPartnerLinkName);
        this.lblName.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_Name"));
        this.fldPartnerLinkName.setColumns(30);
        this.lblWsdlFile.setLabelFor(this.cbxWsdlFile);
        this.lblWsdlFile.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_WsdlFile"));
        this.lblPartnerLinkType.setLabelFor(this.cbxPartnerLinkType);
        this.lblPartnerLinkType.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_PartnerLinkType"));
        this.lblMyRole.setLabelFor(this.fldMyRole);
        this.lblMyRole.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_MyRole"));
        this.lblPartnerRole.setLabelFor(this.fldPartnerRole);
        this.lblPartnerRole.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_PartnerRole"));
        this.lblErrorMessage.setForeground(new Color(255, 0, 0));
        this.btngrPLT.add(this.rbtnUseExistingPLT);
        this.rbtnUseExistingPLT.setSelected(true);
        this.rbtnUseExistingPLT.setText(NbBundle.getMessage(FormBundle.class, (String)"RBTN_UseExisingPLType"));
        this.rbtnUseExistingPLT.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbtnUseExistingPLT.setMargin(new Insets(0, 0, 0, 0));
        this.btngrPLT.add(this.rbtnCreateNewPLT);
        this.rbtnCreateNewPLT.setText(NbBundle.getMessage(FormBundle.class, (String)"RBTN_CreateNewPLType"));
        this.rbtnCreateNewPLT.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbtnCreateNewPLT.setMargin(new Insets(0, 0, 0, 0));
        this.lblNewPLTypeName.setLabelFor(this.fldNewPLTName);
        this.lblNewPLTypeName.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_NewPLTypeName"));
        this.chbxProcessWillImplement.setText(NbBundle.getMessage(FormBundle.class, (String)"CHBX_ProcessWillImpement"));
        this.chbxProcessWillImplement.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chbxProcessWillImplement.setMargin(new Insets(0, 0, 0, 0));
        this.lblProcessRoleName.setLabelFor(this.fldProcessRoleName);
        this.lblProcessRoleName.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_ProcessRoleName"));
        this.lblProcessPortType.setLabelFor(this.cbxProcessPortType);
        this.lblProcessPortType.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_ProcessProtType"));
        this.chbxPartnerWillImpement.setText(NbBundle.getMessage(FormBundle.class, (String)"CHBX_PartnerWillImplement"));
        this.chbxPartnerWillImpement.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chbxPartnerWillImpement.setMargin(new Insets(0, 0, 0, 0));
        this.lblPartnerRoleName.setLabelFor(this.fldPartnerRoleName);
        this.lblPartnerRoleName.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_PartnerRoleName"));
        this.lblPartnerPortType.setLabelFor(this.cbxPartnerPortType);
        this.lblPartnerPortType.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_PartnerPortType"));
        this.btnSwapRoles.setText(NbBundle.getMessage(FormBundle.class, (String)"BTN_SwapRoles"));
        this.fldMyRole.setEditable(false);
        this.fldPartnerRole.setEditable(false);
        this.lblNewPLTypeName1.setLabelFor(this.myWsdlWrapperName);
        this.lblNewPLTypeName1.setText(NbBundle.getMessage(PartnerLinkMainPanel.class, (String)"LBL_Create_in_File"));
        this.myBrowseButton.setText(NbBundle.getMessage(PartnerLinkMainPanel.class, (String)"LBL_Browse"));
        this.myBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PartnerLinkMainPanel.this.browseWsdlFile(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(17, 17, 17).add((Component)this.lblNewPLTypeName1).addPreferredGap(0).add((Component)this.myWsdlWrapperName, -1, 373, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.myBrowseButton)).add((Component)this.lblErrorMessage, -1, 577, Short.MAX_VALUE).add((Component)this.rbtnUseExistingPLT).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblName).add((Component)this.lblWsdlFile)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.fldPartnerLinkName, -1, 500, Short.MAX_VALUE).add(1, (Component)this.cbxWsdlFile, 0, 500, Short.MAX_VALUE))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(17, 17, 17).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblMyRole).add((Component)this.lblPartnerRole).add((Component)this.lblPartnerLinkType)).add(0, 0, 0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.cbxPartnerLinkType, 0, 446, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.btnSwapRoles).addPreferredGap(0, 335, Short.MAX_VALUE)).add(2, (Component)this.fldMyRole, -1, 446, Short.MAX_VALUE).add(2, (Component)this.fldPartnerRole, -1, 446, Short.MAX_VALUE)))).addPreferredGap(0)).add((Component)this.rbtnCreateNewPLT).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add(17, 17, 17).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.chbxProcessWillImplement).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(17, 17, 17).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblProcessRoleName).add((Component)this.lblProcessPortType)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.cbxProcessPortType, 0, 462, Short.MAX_VALUE).add((Component)this.fldProcessRoleName, -1, 462, Short.MAX_VALUE))).add((Component)this.chbxPartnerWillImpement).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(17, 17, 17).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblPartnerRoleName).add((Component)this.lblPartnerPortType)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.cbxPartnerPortType, 0, 462, Short.MAX_VALUE).add((Component)this.fldPartnerRoleName, -1, 462, Short.MAX_VALUE))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblNewPLTypeName).addPreferredGap(0).add((Component)this.fldNewPLTName, -1, 404, Short.MAX_VALUE))))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblName).add((Component)this.fldPartnerLinkName, -2, 22, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblWsdlFile).add((Component)this.cbxWsdlFile, -2, -1, -2)).add(11, 11, 11).add((Component)this.rbtnUseExistingPLT).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.cbxPartnerLinkType, -2, -1, -2).add((Component)this.lblPartnerLinkType)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblMyRole).add((Component)this.fldMyRole, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblPartnerRole).add((Component)this.fldPartnerRole, -2, -1, -2)).addPreferredGap(0).add((Component)this.btnSwapRoles).add(11, 11, 11).add((Component)this.rbtnCreateNewPLT).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblNewPLTypeName1).add((Component)this.myBrowseButton).add((Component)this.myWsdlWrapperName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblNewPLTypeName).add((Component)this.fldNewPLTName, -2, -1, -2)).addPreferredGap(0).add((Component)this.chbxProcessWillImplement).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblProcessRoleName).add((Component)this.fldProcessRoleName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblProcessPortType).add((Component)this.cbxProcessPortType, -2, -1, -2)).addPreferredGap(0).add((Component)this.chbxPartnerWillImpement).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblPartnerRoleName).add((Component)this.fldPartnerRoleName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblPartnerPortType).add((Component)this.cbxPartnerPortType, -2, -1, -2)).addPreferredGap(0).add((Component)this.lblErrorMessage, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.lblName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_LBL_Name"));
        this.lblName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_Name"));
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/bpel/properties/editors/Bundle");
        this.fldPartnerLinkName.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_INP_Name"));
        this.fldPartnerLinkName.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_INP_Name"));
        this.lblWsdlFile.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_LBL_WsdlFile"));
        this.lblWsdlFile.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_WsdlFile"));
        this.lblPartnerLinkType.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_LBL_PartnerLinkType"));
        this.lblPartnerLinkType.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_PartnerLinkType"));
        this.lblMyRole.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_LBL_MyRole"));
        this.lblMyRole.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_MyRole"));
        this.lblPartnerRole.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_LBL_PartnerRole"));
        this.lblPartnerRole.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_PartnerRole"));
        this.cbxPartnerLinkType.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_CMB_PartnerLinkType"));
        this.cbxPartnerLinkType.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CMB_PartnerLinkType"));
        this.cbxWsdlFile.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_CMB_WsdlFile"));
        this.cbxWsdlFile.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CMB_WsdlFile"));
        this.lblErrorMessage.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_ErrorLabel"));
        this.lblErrorMessage.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_ErrorLabel"));
        this.rbtnUseExistingPLT.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_RBTN_UseExisingPLType"));
        this.rbtnUseExistingPLT.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_RBTN_UseExisingPLType"));
        this.rbtnCreateNewPLT.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_RBTN_CreateNewPLType"));
        this.rbtnCreateNewPLT.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_RBTN_CreateNewPLType"));
        this.lblNewPLTypeName.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_LBL_NewPLTypeName"));
        this.lblNewPLTypeName.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_LBL_NewPLTypeName"));
        this.chbxProcessWillImplement.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_CHBX_ProcessWillImpement"));
        this.chbxProcessWillImplement.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CHBX_ProcessWillImpement"));
        this.lblProcessRoleName.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_LBL_ProcessRoleName"));
        this.lblProcessRoleName.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_LBL_ProcessRoleName"));
        this.lblProcessPortType.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_LBL_ProcessProtType"));
        this.lblProcessPortType.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_LBL_ProcessProtType"));
        this.chbxPartnerWillImpement.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_CHBX_PartnerWillImplement"));
        this.chbxPartnerWillImpement.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CHBX_PartnerWillImplement"));
        this.lblPartnerRoleName.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_LBL_PartnerRoleName"));
        this.lblPartnerRoleName.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_LBL_PartnerRoleName"));
        this.lblPartnerPortType.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_LBL_PartnerPortType"));
        this.lblPartnerPortType.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_LBL_PartnerPortType"));
        this.fldNewPLTName.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_INP_NewPLTypeName"));
        this.fldNewPLTName.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_INP_NewPLTypeName"));
        this.fldProcessRoleName.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_INP_ProcessRoleName"));
        this.fldProcessRoleName.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_INP_ProcessRoleName"));
        this.cbxProcessPortType.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_CMB_ProcessProtType"));
        this.cbxProcessPortType.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSN_CMB_ProcessProtType"));
        this.fldPartnerRoleName.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_INP_PartnerRoleName"));
        this.fldPartnerRoleName.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_INP_PartnerRoleName"));
        this.cbxPartnerPortType.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_CMB_PartnerPortType"));
        this.cbxPartnerPortType.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CMB_PartnerPortType"));
        this.btnSwapRoles.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_BTN_SwapRoles"));
        this.btnSwapRoles.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_BTN_SwapRoles"));
        this.fldMyRole.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_INP_MyRole"));
        this.fldMyRole.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_INP_MyRole"));
        this.fldPartnerRole.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_INP_PartnerRole"));
        this.fldPartnerRole.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_INP_PartnerRole"));
        this.lblNewPLTypeName1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PartnerLinkMainPanel.class, (String)"ACSN_LBL_CreateInFile"));
        this.lblNewPLTypeName1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PartnerLinkMainPanel.class, (String)"ACSD_LBL_CreateInFile"));
        this.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_PNL_PartnerLinkMain"));
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSN_PNL_PartnerLinkMain"));
    }

    private void browseWsdlFile(ActionEvent actionEvent) {
        String string = NbBundle.getMessage(FormBundle.class, (String)"LBL_Select_WSDL_File");
        WSDLFileImportDialog wSDLFileImportDialog = new WSDLFileImportDialog(this.getCurrentWsdlModel());
        DialogDescriptor dialogDescriptor = UIUtilities.getCustomizerDialog((Customizer)wSDLFileImportDialog, (String)string, (boolean)true);
        dialogDescriptor.setValid(false);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (object != DialogDescriptor.OK_OPTION) {
            return;
        }
        FileObject fileObject = SoaUtil.getFileObjectByModel((Model)wSDLFileImportDialog.getModel());
        String string2 = this.getRelativeName(fileObject);
        this.myWsdlWrapperName.setText(string2);
        this.getValidator().revalidate(true);
    }

    private void setWrapper(FileObject fileObject) {
        if (fileObject != null) {
            this.myWsdlWrapperName.setText(this.getRelativeName(fileObject) + "Wrapper");
        }
    }

    private String getRelativeName(FileObject fileObject) {
        BpelModel bpelModel = (BpelModel)this.myEditor.getLookup().lookup(BpelModel.class);
        Project project = Utils.safeGetProject((Model)bpelModel);
        String string = ResolverUtility.safeGetRelativePath(fileObject, project);
        String string2 = string != null ? string : fileObject.getPath();
        int n = string2.lastIndexOf(".wsdl");
        if (n == -1) {
            return string2;
        }
        return string2.substring(0, n);
    }

    private void out() {
        System.out.println();
    }

    private void out(Object object) {
        System.out.println("*** " + object);
    }

    private List<PartnerLinkType> getPartnerLinkTypeRecursively(WSDLModel wSDLModel) {
        final ArrayList<PartnerLinkType> arrayList = new ArrayList<PartnerLinkType>();
        WSDLUtilities.visitRecursively((WSDLModel)wSDLModel, (WSDLModelVisitor)new WSDLModelVisitor(){

            public void visit(WSDLModel wSDLModel) {
                Definitions definitions = wSDLModel.getDefinitions();
                if (definitions == null) {
                    return;
                }
                arrayList.addAll(definitions.getExtensibilityElements(PartnerLinkType.class));
            }
        });
        return arrayList;
    }

    private List<PortType> getPortTypeRecursively(WSDLModel wSDLModel) {
        final ArrayList<PortType> arrayList = new ArrayList<PortType>();
        WSDLUtilities.visitRecursively((WSDLModel)wSDLModel, (WSDLModelVisitor)new WSDLModelVisitor(){

            public void visit(WSDLModel wSDLModel) {
                Definitions definitions = wSDLModel.getDefinitions();
                if (definitions == null) {
                    return;
                }
                arrayList.addAll(definitions.getPortTypes());
            }
        });
        return arrayList;
    }

    private class PortTypeRenderer
    extends DefaultListCellRenderer {
        static final long serialVersionUID = 1L;

        private PortTypeRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object != null && object instanceof PortType) {
                String string = ((PortType)object).getName();
                this.setText(string);
            }
            return this;
        }
    }

    private static class WsdlFileRenderer
    extends DefaultListCellRenderer {
        static final long serialVersionUID = 1L;

        public WsdlFileRenderer() {
            this.setIcon(new ImageIcon(NodeType.WSDL_FILE.getImage()));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof ProjectWSDL) {
                this.setText(((ProjectWSDL)object).getName());
            }
            return this;
        }
    }
}

