/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.bpel.editors.api.ui.valid.ErrorMessagesBundle;
import org.netbeans.modules.bpel.properties.Constants;
import org.netbeans.modules.bpel.properties.ImportWsdlRegistrationHelper;
import org.netbeans.modules.bpel.properties.PropertyType;
import org.netbeans.modules.bpel.properties.TypeContainer;
import org.netbeans.modules.bpel.properties.Util;
import org.netbeans.modules.bpel.properties.choosers.TypeChooserPanel;
import org.netbeans.modules.bpel.properties.editors.FormBundle;
import org.netbeans.modules.soa.ui.form.CustomNodeEditor;
import org.netbeans.modules.soa.ui.form.EditorLifeCycle;
import org.netbeans.modules.soa.ui.form.EditorLifeCycleAdapter;
import org.netbeans.modules.soa.ui.form.valid.DefaultValidator;
import org.netbeans.modules.soa.ui.form.valid.ValidStateManager;
import org.netbeans.modules.soa.ui.form.valid.Validator;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.ReferenceableSchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.CorrelationProperty;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrelationPropertyMainPanel
extends EditorLifeCycleAdapter
implements Validator.Provider,
HelpCtx.Provider {
    static final long serialVersionUID = 1L;
    private CustomNodeEditor<CorrelationProperty> myEditor;
    private DefaultValidator myValidator;
    private ButtonGroup bngVariableMetaType;
    private JTextField fldPropertyName;
    private JLabel lblErrorMessage;
    private JLabel lblPropertyName;
    private JPanel pnlTypeChooser;

    public CorrelationPropertyMainPanel(CustomNodeEditor<CorrelationProperty> customNodeEditor) {
        this.myEditor = customNodeEditor;
        this.createContent();
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    private void bindControls2PropertyNames() {
        this.fldPropertyName.putClientProperty("PropertyBinder", (Object)PropertyType.NAME);
    }

    public boolean initControls() {
        try {
            TypeChooserPanel typeChooserPanel = (TypeChooserPanel)this.pnlTypeChooser;
            typeChooserPanel.init(Constants.CORRELATION_PROPERTY_STEREO_TYPE_FILTER, this.myEditor.getLookup());
            typeChooserPanel.hideChbShowImportedOnly(true);
            typeChooserPanel.setIncorrectNodeSelectionReasonKey("ERR_PROPERTY_TYPE_NOT_SPECIFIED");
            CorrelationProperty correlationProperty = (CorrelationProperty)this.myEditor.getEditedObject();
            if (correlationProperty == null) {
                typeChooserPanel.setSelectedValue(null);
            } else {
                NamedComponentReference namedComponentReference = correlationProperty.getElement();
                if (namedComponentReference != null) {
                    typeChooserPanel.setSelectedValue(new TypeContainer((GlobalElement)namedComponentReference.get()));
                } else {
                    NamedComponentReference namedComponentReference2 = correlationProperty.getType();
                    if (namedComponentReference2 != null) {
                        typeChooserPanel.setSelectedValue(new TypeContainer((GlobalType)namedComponentReference2.get()));
                    } else {
                        typeChooserPanel.setSelectedValue(null);
                    }
                }
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        return true;
    }

    public void createContent() {
        this.initComponents();
        this.bindControls2PropertyNames();
        ((EditorLifeCycle)this.pnlTypeChooser).createContent();
        TypeChooserPanel typeChooserPanel = (TypeChooserPanel)this.pnlTypeChooser;
        Util.attachDefaultDblClickAction(typeChooserPanel, typeChooserPanel);
        this.myEditor.getValidStateManager(true).addValidStateListener(new ValidStateManager.ValidStateListener(){

            public void stateChanged(ValidStateManager validStateManager, boolean bl) {
                if (validStateManager.isValid()) {
                    CorrelationPropertyMainPanel.this.lblErrorMessage.setText("");
                } else {
                    CorrelationPropertyMainPanel.this.lblErrorMessage.setText(validStateManager.getHtmlReasons());
                }
            }
        });
    }

    public boolean applyNewValues() {
        try {
            ImportWsdlRegistrationHelper importWsdlRegistrationHelper;
            CorrelationProperty correlationProperty = (CorrelationProperty)this.myEditor.getEditedObject();
            SchemaModel schemaModel = null;
            TypeContainer typeContainer = ((TypeChooserPanel)this.pnlTypeChooser).getSelectedValue();
            if (typeContainer != null) {
                switch (typeContainer.getStereotype()) {
                    case PRIMITIVE_TYPE: 
                    case GLOBAL_SIMPLE_TYPE: 
                    case GLOBAL_COMPLEX_TYPE: 
                    case GLOBAL_TYPE: {
                        importWsdlRegistrationHelper = typeContainer.getGlobalType();
                        NamedComponentReference namedComponentReference = correlationProperty.createSchemaReference((ReferenceableSchemaComponent)importWsdlRegistrationHelper, GlobalType.class);
                        correlationProperty.setType(namedComponentReference);
                        schemaModel = importWsdlRegistrationHelper.getModel();
                        break;
                    }
                    case MESSAGE: {
                        break;
                    }
                    case GLOBAL_ELEMENT: {
                        GlobalElement globalElement = typeContainer.getGlobalElement();
                        NamedComponentReference namedComponentReference = correlationProperty.createSchemaReference((ReferenceableSchemaComponent)globalElement, GlobalElement.class);
                        correlationProperty.setElement(namedComponentReference);
                        schemaModel = globalElement.getModel();
                    }
                }
            }
            if (schemaModel != null) {
                importWsdlRegistrationHelper = new ImportWsdlRegistrationHelper(correlationProperty.getModel());
                importWsdlRegistrationHelper.addImport((Model)schemaModel);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        return true;
    }

    public DefaultValidator getValidator() {
        if (this.myValidator == null) {
            this.myValidator = new DefaultValidator((ValidStateManager.Provider)this.myEditor, ErrorMessagesBundle.class){

                public void doFastValidation() {
                    String string = CorrelationPropertyMainPanel.this.fldPropertyName.getText();
                    if (string == null || string.length() == 0) {
                        this.addReasonKey(Validator.Severity.ERROR, "ERR_PROP_NAME_EMPTY");
                    } else {
                        boolean bl = Util.isNCName(string);
                        if (!bl) {
                            this.addReasonKey(Validator.Severity.ERROR, "ERR_PROP_NAME_INVALID");
                        }
                        if (bl) {
                            CorrelationProperty correlationProperty = (CorrelationProperty)CorrelationPropertyMainPanel.this.myEditor.getEditedObject();
                            WSDLModel wSDLModel = null;
                            if (correlationProperty != null) {
                                wSDLModel = correlationProperty.getModel();
                            }
                            if (wSDLModel != null && (CorrelationPropertyMainPanel.this.myEditor.getEditingMode() == CustomNodeEditor.EditingMode.CREATE_NEW_INSTANCE || CorrelationPropertyMainPanel.this.myEditor.getEditingMode() == CustomNodeEditor.EditingMode.EDIT_INSTANCE && !string.equals(correlationProperty.getName()))) {
                                bl = Util.isUniquePropertyName(wSDLModel, string);
                            }
                        }
                        if (!bl) {
                            this.addReasonKey(Validator.Severity.ERROR, "ERR_PROP_NAME_NOT_UNIQUE");
                        }
                    }
                }
            };
        }
        return this.myValidator;
    }

    private void initComponents() {
        this.bngVariableMetaType = new ButtonGroup();
        this.lblPropertyName = new JLabel();
        this.fldPropertyName = new JTextField();
        this.fldPropertyName.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                CorrelationPropertyMainPanel.this.getValidator().revalidate(true);
            }

            public void keyReleased(KeyEvent keyEvent) {
                CorrelationPropertyMainPanel.this.getValidator().revalidate(true);
            }

            public void keyTyped(KeyEvent keyEvent) {
                CorrelationPropertyMainPanel.this.getValidator().revalidate(true);
            }
        });
        this.pnlTypeChooser = new TypeChooserPanel(Constants.CORRELATION_PROPERTY_STEREO_TYPE_FILTER, this.myEditor.getLookup());
        this.lblErrorMessage = new JLabel();
        this.lblPropertyName.setLabelFor(this.fldPropertyName);
        this.lblPropertyName.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_VariableName"));
        this.pnlTypeChooser.setFocusable(false);
        GroupLayout groupLayout = new GroupLayout((Container)this.pnlTypeChooser);
        this.pnlTypeChooser.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 438, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 268, Short.MAX_VALUE));
        this.lblErrorMessage.setForeground(new Color(255, 0, 0));
        this.lblErrorMessage.setFocusable(false);
        GroupLayout groupLayout2 = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(2).add(1, (Component)this.lblErrorMessage, -1, 438, Short.MAX_VALUE).add(1, (Component)this.pnlTypeChooser, -1, -1, Short.MAX_VALUE).add(1, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.lblPropertyName).addPreferredGap(0).add((Component)this.fldPropertyName, -1, 396, Short.MAX_VALUE))).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.lblPropertyName).add((Component)this.fldPropertyName, -2, -1, -2)).addPreferredGap(0).add((Component)this.pnlTypeChooser, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.lblErrorMessage, -2, 47, -2).addContainerGap()));
        this.lblPropertyName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_LBL_VariableName"));
        this.lblPropertyName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_VariableName"));
        this.lblErrorMessage.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_ErrorLabel"));
        this.lblErrorMessage.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_ErrorLabel"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_AddCorrelationProperty"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_AddCorrelationProperty"));
    }
}

