/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties;

import java.util.Collection;
import org.netbeans.modules.bpel.core.BPELCatalog;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Import;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.events.VetoException;
import org.netbeans.modules.bpel.properties.Constants;
import org.netbeans.modules.bpel.properties.ResolverUtility;
import org.netbeans.modules.bpel.properties.Util;
import org.netbeans.modules.bpel.properties.WsAddressingImportHelper;
import org.netbeans.modules.soa.ui.SoaUtil;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

public class ImportRegistrationHelper {
    private final BpelModel model;

    public ImportRegistrationHelper(BpelModel bpelModel) {
        this.model = bpelModel;
    }

    public BpelModel getBpelModel() {
        return this.model;
    }

    public void addImport(Model model) {
        this.addImport(this.createImport(model));
        if (!(model instanceof WSDLModel)) {
            return;
        }
        Definitions definitions = ((WSDLModel)model).getDefinitions();
        if (definitions == null) {
            return;
        }
        Collection collection = definitions.getImports();
        if (collection == null) {
            return;
        }
        for (org.netbeans.modules.xml.wsdl.model.Import import_ : collection) {
            try {
                WSDLModel wSDLModel = import_.getImportedWSDLModel();
                if (wSDLModel == null || wSDLModel.equals(import_.getModel()) || ResolverUtility.isModelImported((Model)wSDLModel, this.model)) continue;
                this.addImport((Model)wSDLModel);
            }
            catch (CatalogModelException catalogModelException) {}
        }
    }

    public void addImport(Import import_) {
        if (import_ == null) {
            return;
        }
        Process process = this.model.getProcess();
        if (process == null) {
            return;
        }
        if (!this.isImported(import_)) {
            process.addImport(import_);
        }
    }

    public Import createImport(Model model) {
        Object object;
        FileObject fileObject = SoaUtil.getFileObjectByModel((Model)model);
        if (fileObject != null) {
            return this.createImport(fileObject);
        }
        BPELCatalog bPELCatalog = BPELCatalog.getDefault();
        WsAddressingImportHelper wsAddressingImportHelper = WsAddressingImportHelper.getInstance(this.getBpelModel(), this);
        String string = null;
        Constants.StandardImportType standardImportType = null;
        if (model instanceof SchemaModel) {
            object = ((SchemaModel)model).getSchema();
            string = object == null ? null : object.getTargetNamespace();
            standardImportType = Constants.StandardImportType.IMPORT_SCHEMA;
        } else if (model instanceof WSDLModel) {
            object = ((WSDLModel)model).getDefinitions();
            string = object == null ? null : object.getTargetNamespace();
            standardImportType = Constants.StandardImportType.IMPORT_WSDL;
        }
        object = null;
        if (string != null) {
            if (wsAddressingImportHelper != null && wsAddressingImportHelper.isAccepted(string)) {
                return wsAddressingImportHelper.createWsAddressingImport(string);
            }
            object = bPELCatalog.resolveURI(string);
        }
        if (object != null && standardImportType != null) {
            return this.createImport(string, (String)object, standardImportType.getImportType());
        }
        return null;
    }

    public Import createImport(FileObject fileObject) {
        if (fileObject != null) {
            Constants.StandardImportType standardImportType = Constants.StandardImportType.forExt(fileObject.getExt());
            return this.createImport(Util.getNewModelNamespace(fileObject, standardImportType), Util.getNewModelLocation((Model)this.model, fileObject), standardImportType.getImportType());
        }
        return null;
    }

    public Import createImport(String string, String string2, String string3) {
        Import import_ = this.model.getBuilder().createImport();
        if (string != null) {
            try {
                import_.setNamespace(string);
            }
            catch (VetoException vetoException) {
                ErrorManager.getDefault().notify(1, (Throwable)vetoException);
            }
        }
        if (string2 != null) {
            try {
                string2 = ResolverUtility.encodeLocation(string2);
                import_.setLocation(string2);
            }
            catch (VetoException vetoException) {
                ErrorManager.getDefault().notify(1, (Throwable)vetoException);
            }
        }
        if (string3 != null) {
            try {
                import_.setImportType(string3);
            }
            catch (VetoException vetoException) {
                ErrorManager.getDefault().notify(1, (Throwable)vetoException);
            }
        }
        return import_;
    }

    private boolean isImported(Import import_) {
        Process process = this.model.getProcess();
        if (process == null) {
            return false;
        }
        Import[] importArray = process.getImports();
        if (importArray == null) {
            return false;
        }
        String string = import_.getNamespace();
        String string2 = ResolverUtility.decodeLocation(import_.getLocation());
        String string3 = import_.getImportType();
        for (Import import_2 : importArray) {
            if (string != null && !string.equals(import_2.getNamespace()) || string2 != null && !string2.equals(ResolverUtility.decodeLocation(import_2.getLocation())) || string3 != null && !string3.equals(import_2.getImportType())) continue;
            return true;
        }
        return false;
    }
}

