/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.nodes.navigator;

import java.util.Comparator;
import org.netbeans.api.project.Project;
import org.netbeans.modules.bpel.model.api.Import;
import org.netbeans.modules.bpel.model.api.support.Utils;
import org.netbeans.modules.bpel.properties.ResolverUtility;
import org.netbeans.modules.xml.xam.Model;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportComparator
implements Comparator<Import> {
    private static final int EQUALS = 0;
    private static final int GREATER = 1;
    private static final int LESS = -1;
    private static final String PATH_SLASH = "/";
    private Lookup myLookup;

    public ImportComparator(Lookup lookup) {
        this.myLookup = lookup;
    }

    private Lookup getLookup() {
        return this.myLookup;
    }

    @Override
    public int compare(Import import_, Import import_2) {
        assert (import_ != null);
        assert (import_2 != null);
        if (import_.equals(import_2)) {
            return 0;
        }
        String string = this.getRelativePath(import_);
        String string2 = this.getRelativePath(import_2);
        if (string != null && string2 != null) {
            return this.comparePaths(string, string2);
        }
        if (string == null && string2 == null) {
            return this.compareExternal(import_, import_2);
        }
        return string != null ? -1 : 1;
    }

    private String getRelativePath(Import import_) {
        assert (import_ != null);
        FileObject fileObject = ResolverUtility.getImportedFileObject(import_);
        Project project = Utils.safeGetProject((Model)import_.getBpelModel());
        return ResolverUtility.safeGetRelativePath(fileObject, project);
    }

    private int comparePaths(String string, String string2) {
        String[] stringArray;
        String[] stringArray2 = string.split(PATH_SLASH);
        if (stringArray2.length != (stringArray = string2.split(PATH_SLASH)).length) {
            return stringArray2.length > stringArray.length ? 1 : -1;
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            if (stringArray2[i].equals(stringArray[i])) continue;
            return stringArray2[i].compareTo(stringArray[i]);
        }
        return 0;
    }

    private int compareExternal(Import import_, Import import_2) {
        if (this.hasValue(import_.getLocation()) && this.hasValue(import_2.getLocation())) {
            return import_.getLocation().compareTo(import_2.getLocation());
        }
        if (!this.hasValue(import_.getLocation()) && !this.hasValue(import_2.getLocation())) {
            return this.compareNoLocation(import_, import_2);
        }
        return this.hasValue(import_.getLocation()) ? -1 : 1;
    }

    private int compareNoLocation(Import import_, Import import_2) {
        if (this.hasValue(import_.getNamespace()) && this.hasValue(import_2.getNamespace())) {
            return import_.getNamespace().compareTo(import_2.getNamespace());
        }
        if (!this.hasValue(import_.getNamespace()) && !this.hasValue(import_2.getNamespace())) {
            return 0;
        }
        return this.hasValue(import_.getNamespace()) ? -1 : 1;
    }

    private boolean hasValue(String string) {
        return string != null && string.length() != 0;
    }
}

