/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.nodes;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.api.project.Project;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.support.Utils;
import org.netbeans.modules.bpel.nodes.BpelNode;
import org.netbeans.modules.bpel.nodes.MessageTypeNode;
import org.netbeans.modules.bpel.properties.ResolverUtility;
import org.netbeans.modules.soa.ui.SoaUtil;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.Model;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlFileNode
extends BpelNode<WSDLModel> {
    public WsdlFileNode(WSDLModel wSDLModel, Lookup lookup) {
        super(wSDLModel, (Children)new MessageTypeChildren(wSDLModel, lookup), lookup);
    }

    public WsdlFileNode(WSDLModel wSDLModel, Children children, Lookup lookup) {
        super(wSDLModel, children, lookup);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.WSDL_FILE;
    }

    @Override
    protected String getNameImpl() {
        WSDLModel wSDLModel = (WSDLModel)this.getReference();
        if (wSDLModel == null) {
            return null;
        }
        FileObject fileObject = (FileObject)wSDLModel.getModelSource().getLookup().lookup(FileObject.class);
        if (fileObject == null || !fileObject.isValid()) {
            return null;
        }
        BpelModel bpelModel = (BpelModel)this.getLookup().lookup(BpelModel.class);
        Project project = Utils.safeGetProject((Model)bpelModel);
        String string = ResolverUtility.safeGetRelativePath(fileObject, project);
        return string != null ? string : fileObject.getPath();
    }

    @Override
    protected String getImplHtmlDisplayName() {
        return SoaUtil.getGrayString((String)super.getImplHtmlDisplayName());
    }

    static class MessageTypeChildren
    extends Children.Keys {
        private Lookup myLookup;

        public MessageTypeChildren(WSDLModel wSDLModel, Lookup lookup) {
            this.myLookup = lookup;
            this.setKeys(new Object[]{wSDLModel});
        }

        protected Node[] createNodes(Object object) {
            if (object instanceof WSDLModel) {
                ArrayList<MessageTypeNode> arrayList = new ArrayList<MessageTypeNode>();
                Collection collection = ((WSDLModel)object).getDefinitions().getMessages();
                for (Message message : collection) {
                    MessageTypeNode messageTypeNode = new MessageTypeNode(message, this.myLookup);
                    arrayList.add(messageTypeNode);
                }
                return arrayList.toArray(new Node[arrayList.size()]);
            }
            return null;
        }
    }
}

