/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.nodes;

import org.netbeans.api.project.Project;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.support.Utils;
import org.netbeans.modules.bpel.nodes.BpelNode;
import org.netbeans.modules.bpel.properties.ResolverUtility;
import org.netbeans.modules.soa.ui.SoaUtil;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.xam.Model;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Children;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaFileNode
extends BpelNode<SchemaModel> {
    public SchemaFileNode(SchemaModel schemaModel, Lookup lookup) {
        super(schemaModel, lookup);
    }

    public SchemaFileNode(SchemaModel schemaModel, Children children, Lookup lookup) {
        super(schemaModel, children, lookup);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.SCHEMA_FILE;
    }

    @Override
    protected String getNameImpl() {
        SchemaModel schemaModel = (SchemaModel)this.getReference();
        if (schemaModel == null) {
            return null;
        }
        FileObject fileObject = (FileObject)schemaModel.getModelSource().getLookup().lookup(FileObject.class);
        if (fileObject == null || !fileObject.isValid()) {
            Schema schema = schemaModel.getSchema();
            return schema == null ? null : schema.getTargetNamespace();
        }
        BpelModel bpelModel = (BpelModel)this.getLookup().lookup(BpelModel.class);
        Project project = Utils.safeGetProject((Model)bpelModel);
        String string = ResolverUtility.safeGetRelativePath(fileObject, project);
        return string != null ? string : fileObject.getPath();
    }

    @Override
    protected String getImplHtmlDisplayName() {
        return SoaUtil.getGrayString((String)super.getImplHtmlDisplayName());
    }
}

