/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.nodes;

import java.awt.Component;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.editors.api.nodes.actions.ActionType;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.bpel.model.api.support.Utils;
import org.netbeans.modules.bpel.nodes.BpelNode;
import org.netbeans.modules.bpel.nodes.actions.DeletePLinkAction;
import org.netbeans.modules.bpel.properties.Constants;
import org.netbeans.modules.bpel.properties.PropertyType;
import org.netbeans.modules.bpel.properties.ResolverUtility;
import org.netbeans.modules.bpel.properties.editors.PartnerLinkMainPanel;
import org.netbeans.modules.bpel.properties.editors.controls.SimpleCustomEditor;
import org.netbeans.modules.bpel.properties.props.CustomEditorProperty;
import org.netbeans.modules.bpel.properties.props.PropertyUtils;
import org.netbeans.modules.soa.ui.form.CustomNodeEditor;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PartnerLinkType;
import org.netbeans.modules.xml.xam.Model;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartnerLinkNode
extends BpelNode<PartnerLink> {
    private String wsdlFile;

    public PartnerLinkNode(PartnerLink partnerLink, Children children, Lookup lookup) {
        super(partnerLink, children, lookup);
    }

    public PartnerLinkNode(PartnerLink partnerLink, Lookup lookup) {
        super(partnerLink, lookup);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.PARTNER_LINK;
    }

    @Override
    public String getHelpId() {
        return this.getNodeType().getHelpId();
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        if (this.getReference() == null) {
            return sheet;
        }
        Sheet.Set set = this.getPropertySet(sheet, Constants.PropertiesGroups.MAIN_SET);
        CustomEditorProperty customEditorProperty = new CustomEditorProperty(this);
        set.put((Node.Property)customEditorProperty);
        PropertyUtils.registerAttributeProperty(this, set, "name", PropertyType.NAME, "getName", "setName", null);
        Node.Property property = PropertyUtils.registerCalculatedProperty((Object)this, set, PropertyType.WSDL_FILE, "getWsdlFile", null);
        property.setValue("canEditAsText", (Object)Boolean.FALSE);
        property = PropertyUtils.registerAttributeProperty(this, set, "partnerLinkType", PropertyType.PARTNER_LINK_TYPE, "getPartnerLinkType", "setPartnerLinkType", null);
        property.setValue("canEditAsText", (Object)Boolean.FALSE);
        property = PropertyUtils.registerAttributeProperty(this, set, "myRole", PropertyType.MY_ROLE, "getMyRole", "setMyRole", "removeMyRole");
        property.setValue("canEditAsText", (Object)Boolean.FALSE);
        property = PropertyUtils.registerAttributeProperty(this, set, "partnerRole", PropertyType.PARTNER_ROLE, "getPartnerRole", "setPartnerRole", "removePartnerRole");
        property.setValue("canEditAsText", (Object)Boolean.FALSE);
        PropertyUtils.registerProperty(this, set, PropertyType.DOCUMENTATION, "getDocumentation", "setDocumentation", "removeDocumentation");
        return sheet;
    }

    public String getWsdlFile() {
        if (this.wsdlFile == null) {
            this.wsdlFile = this.calculateWsdlUri();
        }
        return this.wsdlFile;
    }

    private String calculateWsdlUri() {
        try {
            Project project;
            PartnerLink partnerLink = (PartnerLink)this.getReference();
            if (partnerLink == null) {
                return "";
            }
            WSDLReference wSDLReference = partnerLink.getPartnerLinkType();
            if (wSDLReference == null) {
                return "";
            }
            PartnerLinkType partnerLinkType = (PartnerLinkType)wSDLReference.get();
            if (partnerLinkType == null) {
                return "";
            }
            Lookup lookup = partnerLinkType.getModel().getModelSource().getLookup();
            FileObject fileObject = (FileObject)lookup.lookup(FileObject.class);
            String string = ResolverUtility.safeGetRelativePath(fileObject, project = Utils.safeGetProject((Model)partnerLink.getBpelModel()));
            return string != null ? string : fileObject.getPath();
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
            return "";
        }
    }

    @Override
    public Component getCustomizer(CustomNodeEditor.EditingMode editingMode) {
        return new SimpleCustomEditor<PartnerLink>(this, PartnerLinkMainPanel.class, editingMode);
    }

    @Override
    protected ActionType[] getActionsArray() {
        return new ActionType[]{ActionType.GO_TO, ActionType.SEPARATOR, ActionType.FIND_USAGES, ActionType.SEPARATOR, ActionType.SHOW_POPERTY_EDITOR, ActionType.SEPARATOR, ActionType.OPEN_PL_IN_EDITOR, ActionType.SEPARATOR, ActionType.REMOVE, ActionType.SEPARATOR, ActionType.PROPERTIES};
    }

    @Override
    public Action createAction(ActionType actionType) {
        switch (actionType) {
            case REMOVE: {
                return SystemAction.get(DeletePLinkAction.class);
            }
        }
        return super.createAction(actionType);
    }
}

