/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.nodes;

import java.awt.Image;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.editors.api.nodes.images.FolderIcon;
import org.netbeans.modules.bpel.nodes.BpelNode;
import org.openide.nodes.Children;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryFolderNode
extends BpelNode<NodeType> {
    private AtomicReference<Image> myIconRef = new AtomicReference();
    private AtomicReference<Image> myOpenedIconRef = new AtomicReference();

    public CategoryFolderNode(NodeType nodeType, Children children, Lookup lookup) {
        super(nodeType, children, lookup);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.FOLDER;
    }

    @Override
    public synchronized Image getIcon(int n) {
        if (this.myIconRef.get() == null) {
            Image image = null;
            boolean bl = false;
            NodeType nodeType = (NodeType)this.getReference();
            Image image2 = nodeType.getBadgeImage();
            if (NodeType.isValidImage((Image)image2) && (image = FolderIcon.getIcon((int)n)) != null) {
                image = Utilities.mergeImages((Image)image, (Image)image2, (int)8, (int)8);
                bl = true;
            }
            if (!bl) {
                image = nodeType.getImage();
            }
            if (!NodeType.isValidImage((Image)image)) {
                image = FolderIcon.getIcon((int)n);
            }
            if (image != null) {
                this.myIconRef.compareAndSet(null, image);
            }
        }
        return this.myIconRef.get();
    }

    @Override
    public Image getOpenedIcon(int n) {
        if (this.myOpenedIconRef.get() == null) {
            Image image = null;
            boolean bl = false;
            NodeType nodeType = (NodeType)this.getReference();
            Image image2 = nodeType.getBadgeImage();
            if (NodeType.isValidImage((Image)image2) && (image = FolderIcon.getOpenedIcon((int)n)) != null) {
                image = Utilities.mergeImages((Image)image, (Image)image2, (int)8, (int)8);
                bl = true;
            }
            if (!bl) {
                image = nodeType.getImage();
            }
            if (!NodeType.isValidImage((Image)image)) {
                image = FolderIcon.getIcon((int)n);
            }
            if (image != null) {
                this.myOpenedIconRef.compareAndSet(null, image);
            }
        }
        return this.myOpenedIconRef.get();
    }

    @Override
    protected String getNameImpl() {
        String string = null;
        NodeType nodeType = (NodeType)this.getReference();
        string = this.getNodeType().getDisplayName((Object)nodeType);
        if (string == null || string.length() == 0) {
            string = nodeType.getDisplayName();
        }
        return string != null ? string : "";
    }
}

