/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.selection;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.bpel.design.DiagramView;
import org.netbeans.modules.bpel.design.geometry.FPoint;
import org.netbeans.modules.bpel.design.model.patterns.CompensatePattern;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.design.selection.DefaultPlaceholder;
import org.netbeans.modules.bpel.design.selection.DnDTool;
import org.netbeans.modules.bpel.design.selection.ImpliciteSequencePlaceHolder;
import org.netbeans.modules.bpel.design.selection.PlaceHolder;
import org.netbeans.modules.bpel.model.api.Activity;
import org.netbeans.modules.bpel.model.api.BpelContainer;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.CompensatableActivityHolder;
import org.netbeans.modules.bpel.model.api.Else;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlaceHolderManager
implements DnDTool {
    private List<PlaceHolder> placeHolders = new ArrayList<PlaceHolder>();
    private PlaceHolder currentPlaceHolder;
    private DiagramView diagramView;
    private Pattern draggedPattern;
    private PlaceHolder defaultPlaceholder;

    public PlaceHolderManager(DiagramView diagramView) {
        this.diagramView = diagramView;
    }

    public boolean isEmpty() {
        return this.placeHolders.isEmpty();
    }

    public PlaceHolder getCurrentPlaceholder() {
        return this.currentPlaceHolder;
    }

    public void setCurrentPlaceholder(PlaceHolder placeHolder) {
        PlaceHolder placeHolder2;
        if (!this.placeHolders.contains(placeHolder)) {
            placeHolder = null;
        }
        if ((placeHolder2 = this.getCurrentPlaceholder()) != placeHolder) {
            if (placeHolder2 != null) {
                placeHolder2.dragExit();
            }
            if (placeHolder != null) {
                placeHolder.dragEnter();
            }
            this.currentPlaceHolder = placeHolder;
            this.getDiagramView().repaint();
        }
    }

    public void clear() {
        if (!this.isEmpty()) {
            this.placeHolders.clear();
            this.currentPlaceHolder = null;
            this.draggedPattern = null;
            this.defaultPlaceholder = null;
        }
        this.getDiagramView().repaint();
    }

    public DiagramView getDiagramView() {
        return this.diagramView;
    }

    public Pattern getDraggedPattern() {
        return this.draggedPattern;
    }

    private PlaceHolder findPlaceholder(float f, float f2) {
        for (int i = this.placeHolders.size() - 1; i >= 0; --i) {
            PlaceHolder placeHolder = this.placeHolders.get(i);
            if (!placeHolder.contains(f, f2)) continue;
            return placeHolder;
        }
        return this.defaultPlaceholder;
    }

    public void init(Pattern pattern) {
        this.draggedPattern = pattern;
        this.defaultPlaceholder = null;
        this.createPlaceHolders();
        this.getDiagramView().repaint();
    }

    private boolean canContainCompensate(Pattern pattern) {
        while (pattern != null) {
            BpelEntity bpelEntity = pattern.getOMReference();
            if (bpelEntity instanceof CompensatableActivityHolder) {
                return true;
            }
            pattern = pattern.getParent();
        }
        return false;
    }

    private void createPlaceHolders() {
        this.getDiagramView().getPlaceholders(this.getDraggedPattern(), this.placeHolders);
        Iterator<Pattern> iterator = this.getDiagramView().getPatterns();
        while (iterator.hasNext()) {
            Pattern pattern = iterator.next();
            if (this.getDraggedPattern() == pattern || pattern.isNestedIn(this.getDraggedPattern()) || this.getDraggedPattern() instanceof CompensatePattern && !this.canContainCompensate(pattern)) continue;
            pattern.createPlaceholders(this.getDraggedPattern(), this.placeHolders);
            if (!(this.getDraggedPattern().getOMReference() instanceof Activity)) continue;
            ImpliciteSequencePlaceHolder.create(this.getDraggedPattern(), pattern, this.placeHolders);
        }
        for (PlaceHolder placeHolder : this.placeHolders) {
            if (!(placeHolder instanceof DefaultPlaceholder)) continue;
            this.defaultPlaceholder = placeHolder;
            break;
        }
    }

    public List<PlaceHolder> getPlaceHolders() {
        return this.placeHolders;
    }

    @Override
    public void move(FPoint fPoint) {
        if (this.isEmpty()) {
            return;
        }
        PlaceHolder placeHolder = this.findPlaceholder(fPoint.x, fPoint.y);
        this.setCurrentPlaceholder(placeHolder);
    }

    @Override
    public boolean isValidLocation() {
        return this.currentPlaceHolder != null;
    }

    @Override
    public void drop(FPoint fPoint) {
        if (this.isEmpty()) {
            return;
        }
        PlaceHolder placeHolder = this.findPlaceholder(fPoint.x, fPoint.y);
        if (placeHolder == null) {
            placeHolder = this.defaultPlaceholder;
        }
        if (placeHolder != null) {
            try {
                BpelContainer bpelContainer;
                BpelEntity bpelEntity = this.getDraggedPattern().getOMReference();
                BpelContainer bpelContainer2 = bpelContainer = bpelEntity != null ? bpelEntity.getParent() : null;
                if (bpelContainer != null) {
                    BpelContainer bpelContainer3;
                    bpelEntity.cut();
                    if (bpelContainer instanceof Else && (bpelContainer3 = bpelContainer.getParent()) != null) {
                        bpelContainer3.remove((BpelEntity)bpelContainer);
                    }
                }
                placeHolder.drop();
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }
    }

    public void paint(Graphics2D graphics2D) {
        if (this.isEmpty()) {
            return;
        }
        for (PlaceHolder placeHolder : this.placeHolders) {
            placeHolder.paint(graphics2D);
        }
    }
}

