/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.model.patterns;

import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.bpel.design.DiagramView;
import org.netbeans.modules.bpel.design.geometry.FBounds;
import org.netbeans.modules.bpel.design.layout.LayoutManager;
import org.netbeans.modules.bpel.design.model.DiagramModel;
import org.netbeans.modules.bpel.design.model.PartnerRole;
import org.netbeans.modules.bpel.design.model.elements.VisualElement;
import org.netbeans.modules.bpel.design.model.patterns.CompositePattern;
import org.netbeans.modules.bpel.design.model.patterns.PartnerlinkPattern;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.PartnerLinkContainer;
import org.netbeans.modules.bpel.model.api.PartnerLinkReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartnerLinksPattern
extends CompositePattern {
    private List<Pattern> providers = new ArrayList<Pattern>();
    private List<Pattern> consumers = new ArrayList<Pattern>();

    public PartnerLinksPattern(DiagramModel diagramModel) {
        super(diagramModel);
    }

    public List<Pattern> getConsumers() {
        return this.consumers;
    }

    public List<Pattern> getProviders() {
        return this.providers;
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    public VisualElement getFirstElement() {
        return null;
    }

    @Override
    public VisualElement getLastElement() {
        return null;
    }

    @Override
    public DiagramView getView() {
        return null;
    }

    @Override
    protected void onAppendPattern(Pattern pattern) {
        if (((PartnerlinkPattern)pattern).getType() == PartnerRole.PROVIDER) {
            this.providers.add(pattern);
        } else {
            this.consumers.add(pattern);
        }
    }

    @Override
    protected void onRemovePattern(Pattern pattern) {
        this.consumers.remove(pattern);
        this.providers.remove(pattern);
    }

    @Override
    protected void createElementsImpl() {
        PartnerLinkContainer partnerLinkContainer = (PartnerLinkContainer)this.getOMReference();
        if (partnerLinkContainer == null || partnerLinkContainer.getPartnerLinks() == null) {
            return;
        }
        for (PartnerLink partnerLink : partnerLinkContainer.getPartnerLinks()) {
            Pattern pattern = this.getModel().createPattern((BpelEntity)partnerLink);
            pattern.setParent(this);
        }
    }

    @Override
    public FBounds layoutPattern(LayoutManager layoutManager) {
        FBounds fBounds;
        double d = 0.0;
        for (Pattern pattern : this.consumers) {
            fBounds = pattern.getBounds();
            layoutManager.setPatternPosition(pattern, 0.0, d);
            d += (double)(fBounds.height + 12.0f);
        }
        d = 0.0;
        for (Pattern pattern : this.providers) {
            fBounds = pattern.getBounds();
            layoutManager.setPatternPosition(pattern, 0.0, d);
            d += (double)(fBounds.height + 12.0f);
        }
        return null;
    }

    @Override
    public String getDefaultName() {
        return "Process";
    }

    @Override
    public Area createSelection() {
        return new Area();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Position
    implements Comparable<Position> {
        public double position = 0.0;
        public double count = 0.0;
        public Pattern pattern;

        public Position(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public int compareTo(Position position) {
            return Double.compare(this.position, position.position);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PositionCalculator {
        private ArrayList<Position> optimalPositions;

        public PositionCalculator() {
            this.optimalPositions = new ArrayList(PartnerLinksPattern.this.getNestedPatterns().size());
            for (Pattern object : PartnerLinksPattern.this.getNestedPatterns()) {
                this.optimalPositions.add(new Position(object));
            }
            this.calculatePositions(PartnerLinksPattern.this.getModel().getRootPattern());
            for (Position position : this.optimalPositions) {
                if (!(position.count > 0.0)) continue;
                position.position /= position.count;
            }
            Collections.sort(this.optimalPositions);
        }

        public ArrayList<Position> getResult() {
            return this.optimalPositions;
        }

        private void calculatePositions(Pattern pattern) {
            Object object;
            BpelEntity bpelEntity = pattern.getOMReference();
            if (bpelEntity instanceof PartnerLinkReference && (object = ((PartnerLinkReference)bpelEntity).getPartnerLink()) != null && !object.isBroken()) {
                this.adjustPosition(PartnerLinksPattern.this.getModel().getPattern((BpelEntity)object.get()), pattern.getBounds().getCenterY());
            }
            if (pattern instanceof CompositePattern) {
                for (Pattern pattern2 : ((CompositePattern)pattern).getNestedPatterns()) {
                    this.calculatePositions(pattern2);
                }
            }
        }

        private void adjustPosition(Pattern pattern, double d) {
            Object var4_3 = null;
            for (Position position : this.optimalPositions) {
                if (position.pattern != pattern) continue;
                position.position += d;
                position.count += 1.0;
            }
        }
    }
}

