/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.decoration.providers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.decoration.ComponentsDescriptor;
import org.netbeans.modules.bpel.design.decoration.Decoration;
import org.netbeans.modules.bpel.design.decoration.DecorationProvider;
import org.netbeans.modules.bpel.design.decoration.Descriptor;
import org.netbeans.modules.bpel.design.decoration.components.ContextToolBar;
import org.netbeans.modules.bpel.design.decoration.components.ContextToolBarButton;
import org.netbeans.modules.bpel.design.selection.DiagramSelectionListener;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.EventHandlers;
import org.netbeans.modules.bpel.model.api.FaultHandlers;
import org.netbeans.modules.bpel.model.api.If;
import org.netbeans.modules.bpel.model.api.Invoke;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.Pick;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.Receive;
import org.netbeans.modules.bpel.model.api.Reply;
import org.netbeans.modules.bpel.model.api.Scope;
import org.netbeans.modules.bpel.model.api.support.UniqueId;
import org.netbeans.modules.bpel.nodes.BpelNode;
import org.netbeans.modules.bpel.nodes.actions.AddCatchAction;
import org.netbeans.modules.bpel.nodes.actions.AddCatchAllAction;
import org.netbeans.modules.bpel.nodes.actions.AddCompensationHandlerAction;
import org.netbeans.modules.bpel.nodes.actions.AddCorrelationSetAction;
import org.netbeans.modules.bpel.nodes.actions.AddElseIfAction;
import org.netbeans.modules.bpel.nodes.actions.AddEventHandlersAction;
import org.netbeans.modules.bpel.nodes.actions.AddFaultHandlersAction;
import org.netbeans.modules.bpel.nodes.actions.AddOnAlarmAction;
import org.netbeans.modules.bpel.nodes.actions.AddOnEventAction;
import org.netbeans.modules.bpel.nodes.actions.AddOnMessageAction;
import org.netbeans.modules.bpel.nodes.actions.AddTerminationHandlerAction;
import org.netbeans.modules.bpel.nodes.actions.AddVariableAction;
import org.netbeans.modules.bpel.nodes.actions.BpelNodeAction;
import org.netbeans.modules.bpel.nodes.actions.OpenPartnerLinkInEditor;
import org.netbeans.modules.bpel.nodes.actions.ShowPropertyEditorAction;
import org.openide.actions.NewAction;
import org.openide.awt.Actions;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolbarDecorationProvider
extends DecorationProvider
implements DiagramSelectionListener {
    private static final Map<Class, List<Class>> CONTEXT_ACTIONS = new HashMap<Class, List<Class>>();
    private static final Map<Class, Icon> CONTEXT_ICONS;

    public ToolbarDecorationProvider(DesignView designView) {
        super(designView);
        this.getDesignView().getSelectionModel().addSelectionListener(this);
    }

    @Override
    public Decoration getDecoration(BpelEntity bpelEntity) {
        UniqueId uniqueId = bpelEntity.getUID();
        UniqueId uniqueId2 = this.getDesignView().getSelectionModel().getSelectedID();
        if (uniqueId != null && uniqueId.equals(uniqueId2)) {
            ArrayList<ComponentsDescriptor> arrayList = new ArrayList<ComponentsDescriptor>();
            List<Action> list = this.getContextActions(bpelEntity);
            ContextToolBar contextToolBar = new ContextToolBar();
            Action action = this.getDesignView().getCollapseExpandDecorationProvider().createCollapseExpandAction(bpelEntity);
            if (action != null) {
                contextToolBar.add(new ContextToolBarButton(action));
            }
            for (int i = 0; i < list.size(); ++i) {
                Action action2 = list.get(i);
                ContextToolBarButton contextToolBarButton = new ContextToolBarButton(CONTEXT_ICONS.get(action2.getClass()));
                Actions.connect((AbstractButton)contextToolBarButton, (Action)action2);
                contextToolBar.add(contextToolBarButton);
            }
            if (!list.isEmpty() || action != null) {
                ComponentsDescriptor componentsDescriptor = new ComponentsDescriptor();
                componentsDescriptor.add(contextToolBar);
                arrayList.add(componentsDescriptor);
            }
            return new Decoration(arrayList.toArray(new Descriptor[arrayList.size()]));
        }
        return null;
    }

    @Override
    public void selectionChanged(BpelEntity bpelEntity, BpelEntity bpelEntity2) {
        this.fireDecorationChanged();
    }

    private Map<Class, Action> extractActions(BpelEntity bpelEntity) {
        HashMap<Class, Action> hashMap = new HashMap<Class, Action>();
        Node node = this.getDesignView().getNodeForPattern(this.getDesignView().getModel().getPattern(bpelEntity));
        if (node == null || !(node instanceof BpelNode)) {
            return hashMap;
        }
        BpelNode bpelNode = (BpelNode)node;
        Action[] actionArray = node.getActions(true);
        if (actionArray == null) {
            return hashMap;
        }
        for (Action action : actionArray) {
            if (action == null) continue;
            if (action instanceof NewAction) {
                List<BpelNodeAction> list = bpelNode.getAddActions();
                if (list == null) continue;
                for (BpelNodeAction bpelNodeAction : list) {
                    if (bpelNodeAction == null) continue;
                    hashMap.put(((Object)((Object)bpelNodeAction)).getClass(), (Action)((Object)bpelNodeAction));
                }
                continue;
            }
            hashMap.put(action.getClass(), action);
        }
        return hashMap;
    }

    private List<Action> getContextActions(BpelEntity bpelEntity) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        Map<Class, Action> map = this.extractActions(bpelEntity);
        List<Class> list = null;
        for (Class clazz : CONTEXT_ACTIONS.keySet()) {
            if (!clazz.isAssignableFrom(bpelEntity.getClass())) continue;
            list = CONTEXT_ACTIONS.get(clazz);
            break;
        }
        if (list == null) {
            return arrayList;
        }
        for (Class<Object> clazz : list) {
            Action action = map.get(clazz);
            if (action == null) continue;
            arrayList.add(action);
        }
        return arrayList;
    }

    private static Icon loadPNGIcon(String string) {
        return new ImageIcon(Decoration.class.getResource("resources/" + string + ".png"));
    }

    static {
        CONTEXT_ACTIONS.put(Invoke.class, new ArrayList());
        CONTEXT_ACTIONS.get(Invoke.class).add(ShowPropertyEditorAction.class);
        CONTEXT_ACTIONS.get(Invoke.class).add(AddCatchAllAction.class);
        CONTEXT_ACTIONS.get(Invoke.class).add(AddCatchAction.class);
        CONTEXT_ACTIONS.get(Invoke.class).add(AddCompensationHandlerAction.class);
        CONTEXT_ACTIONS.put(Receive.class, new ArrayList());
        CONTEXT_ACTIONS.get(Receive.class).add(ShowPropertyEditorAction.class);
        CONTEXT_ACTIONS.put(Reply.class, new ArrayList());
        CONTEXT_ACTIONS.get(Reply.class).add(ShowPropertyEditorAction.class);
        CONTEXT_ACTIONS.put(PartnerLink.class, new ArrayList());
        CONTEXT_ACTIONS.get(PartnerLink.class).add(ShowPropertyEditorAction.class);
        CONTEXT_ACTIONS.get(PartnerLink.class).add(OpenPartnerLinkInEditor.class);
        CONTEXT_ACTIONS.put(If.class, new ArrayList());
        CONTEXT_ACTIONS.get(If.class).add(AddElseIfAction.class);
        CONTEXT_ACTIONS.put(Process.class, new ArrayList());
        CONTEXT_ACTIONS.get(Process.class).add(AddVariableAction.class);
        CONTEXT_ACTIONS.get(Process.class).add(AddCorrelationSetAction.class);
        CONTEXT_ACTIONS.get(Process.class).add(AddEventHandlersAction.class);
        CONTEXT_ACTIONS.get(Process.class).add(AddFaultHandlersAction.class);
        CONTEXT_ACTIONS.put(Scope.class, new ArrayList());
        CONTEXT_ACTIONS.get(Scope.class).add(AddVariableAction.class);
        CONTEXT_ACTIONS.get(Scope.class).add(AddCorrelationSetAction.class);
        CONTEXT_ACTIONS.get(Scope.class).add(AddEventHandlersAction.class);
        CONTEXT_ACTIONS.get(Scope.class).add(AddCompensationHandlerAction.class);
        CONTEXT_ACTIONS.get(Scope.class).add(AddTerminationHandlerAction.class);
        CONTEXT_ACTIONS.get(Scope.class).add(AddFaultHandlersAction.class);
        CONTEXT_ACTIONS.put(Pick.class, new ArrayList());
        CONTEXT_ACTIONS.get(Pick.class).add(AddOnMessageAction.class);
        CONTEXT_ACTIONS.get(Pick.class).add(AddOnAlarmAction.class);
        CONTEXT_ACTIONS.put(EventHandlers.class, new ArrayList());
        CONTEXT_ACTIONS.get(EventHandlers.class).add(AddOnEventAction.class);
        CONTEXT_ACTIONS.get(EventHandlers.class).add(AddOnAlarmAction.class);
        CONTEXT_ACTIONS.put(FaultHandlers.class, new ArrayList());
        CONTEXT_ACTIONS.get(FaultHandlers.class).add(AddCatchAllAction.class);
        CONTEXT_ACTIONS.get(FaultHandlers.class).add(AddCatchAction.class);
        CONTEXT_ICONS = new HashMap<Class, Icon>();
        CONTEXT_ICONS.put(AddCatchAction.class, ToolbarDecorationProvider.loadPNGIcon("add_catch"));
        CONTEXT_ICONS.put(AddCatchAllAction.class, ToolbarDecorationProvider.loadPNGIcon("add_catch_all"));
        CONTEXT_ICONS.put(AddElseIfAction.class, ToolbarDecorationProvider.loadPNGIcon("add_else_if"));
        CONTEXT_ICONS.put(AddCompensationHandlerAction.class, ToolbarDecorationProvider.loadPNGIcon("add_compensation_handler"));
        CONTEXT_ICONS.put(AddVariableAction.class, ToolbarDecorationProvider.loadPNGIcon("add_variable"));
        CONTEXT_ICONS.put(AddCorrelationSetAction.class, ToolbarDecorationProvider.loadPNGIcon("add_correlation_set"));
        CONTEXT_ICONS.put(AddEventHandlersAction.class, ToolbarDecorationProvider.loadPNGIcon("add_event_handlers"));
        CONTEXT_ICONS.put(AddTerminationHandlerAction.class, ToolbarDecorationProvider.loadPNGIcon("add_termination_handler"));
        CONTEXT_ICONS.put(AddFaultHandlersAction.class, ToolbarDecorationProvider.loadPNGIcon("add_fault_handlers"));
        CONTEXT_ICONS.put(AddOnMessageAction.class, ToolbarDecorationProvider.loadPNGIcon("add_on_message"));
        CONTEXT_ICONS.put(AddOnAlarmAction.class, ToolbarDecorationProvider.loadPNGIcon("add_on_alarm"));
        CONTEXT_ICONS.put(AddOnEventAction.class, ToolbarDecorationProvider.loadPNGIcon("add_on_event"));
        CONTEXT_ICONS.put(ShowPropertyEditorAction.class, ToolbarDecorationProvider.loadPNGIcon("edit_properties"));
        CONTEXT_ICONS.put(OpenPartnerLinkInEditor.class, ToolbarDecorationProvider.loadPNGIcon("open_wsdl"));
    }
}

