/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.decoration;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.bpel.design.DiagramView;
import org.netbeans.modules.bpel.design.decoration.Descriptor;
import org.netbeans.modules.bpel.design.decoration.Positioner;
import org.netbeans.modules.bpel.design.geometry.FPoint;
import org.netbeans.modules.bpel.design.model.elements.VisualElement;
import org.netbeans.modules.bpel.design.model.patterns.CompositePattern;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentsDescriptor
implements Descriptor,
Iterable<Component> {
    private List<PairComponentPositioner> pairs = new ArrayList<PairComponentPositioner>();
    private Component myComponent;
    public static final Positioner TOP_LR = new Positioner(){
        private static final int HSPACING = 0;
        private static final int VSPACING = 3;

        @Override
        public void position(Pattern pattern, Collection<Component> collection, double d) {
            FPoint fPoint = 1.getPatternBounds(pattern).getTopLeft();
            DiagramView diagramView = pattern.getView();
            Point point = diagramView.convertDiagramToScreen(fPoint);
            int n = point.x;
            int n2 = point.y - 3;
            for (Component component : collection) {
                Dimension dimension = component.getPreferredSize();
                int n3 = dimension.width;
                int n4 = dimension.height;
                component.setBounds(n, n2 - n4, n3, n4);
                n -= n3 + 0;
            }
        }
    };
    public static final Positioner TOP_RL = new Positioner(){
        private static final int HSPACING = 0;
        private static final int VSPACING = 3;

        @Override
        public void position(Pattern pattern, Collection<Component> collection, double d) {
            FPoint fPoint = 2.getPatternBounds(pattern).getTopRight();
            DiagramView diagramView = pattern.getView();
            Point point = diagramView.convertDiagramToScreen(fPoint);
            int n = point.x;
            int n2 = point.y - 3;
            for (Component component : collection) {
                Dimension dimension = component.getPreferredSize();
                int n3 = dimension.width;
                int n4 = dimension.height;
                component.setBounds(n - n3, n2 - n4, n3, n4);
                n -= n3 + 0;
            }
        }
    };
    public static final Positioner LEFT_TB = new Positioner(){
        private static final int HSPACING = 2;
        private static final int VSPACING = 0;

        @Override
        public void position(Pattern pattern, Collection<Component> collection, double d) {
            FPoint fPoint = 3.getPatternBounds(pattern).getTopLeft();
            DiagramView diagramView = pattern.getView();
            Point point = diagramView.convertDiagramToScreen(fPoint);
            int n = point.x - 2;
            int n2 = point.y;
            for (Component component : collection) {
                Dimension dimension = component.getPreferredSize();
                int n3 = dimension.width;
                int n4 = dimension.height;
                component.setBounds(n - n3, n2, n3, n4);
                n2 += n4 + 0;
            }
        }
    };
    public static final Positioner TOP_CENTER = new Positioner(){
        private static final int HSPACING = 2;

        @Override
        public void position(Pattern pattern, Collection<Component> collection, double d) {
            VisualElement visualElement = null;
            if (pattern instanceof CompositePattern) {
                visualElement = ((CompositePattern)pattern).getBorder();
                if (visualElement == null) {
                    visualElement = pattern.getFirstElement();
                }
            } else {
                visualElement = pattern.getFirstElement();
            }
            DiagramView diagramView = pattern.getView();
            Point point = diagramView.convertDiagramToScreen(new FPoint(visualElement.getCenterX(), visualElement.getY()));
            int n = 0;
            for (Component component : collection) {
                n += component.getPreferredSize().width;
            }
            int n2 = point.y;
            int n3 = point.x - (n += Math.max(0, (collection.size() - 1) * 2)) / 2;
            for (Component component : collection) {
                Dimension dimension = component.getPreferredSize();
                component.setBounds(n3, n2 - dimension.height / 2, dimension.width, dimension.height);
                n3 += dimension.width + 2;
            }
        }
    };
    public static final Positioner RIGHT_TB = new Positioner(){
        private static final int HSPACING = 2;
        private static final int VSPACING = 0;

        @Override
        public void position(Pattern pattern, Collection<Component> collection, double d) {
            FPoint fPoint = 5.getPatternBounds(pattern).getTopRight();
            DiagramView diagramView = pattern.getView();
            Point point = diagramView.convertDiagramToScreen(fPoint);
            int n = point.x + 2;
            int n2 = point.y;
            for (Component component : collection) {
                Dimension dimension = component.getPreferredSize();
                int n3 = dimension.width;
                int n4 = dimension.height;
                component.setBounds(n, n2, n3, n4);
                n2 += n4 + 0;
            }
        }
    };
    public static final Positioner BOTTOM_RL = new Positioner(){
        private static final int SPACING = 2;

        @Override
        public void position(Pattern pattern, Collection<Component> collection, double d) {
            FPoint fPoint = pattern.getBounds().getBottomRight();
            DiagramView diagramView = pattern.getView();
            Point point = diagramView.convertDiagramToScreen(fPoint);
            int n = point.x;
            int n2 = point.y + 2;
            for (Component component : collection) {
                Dimension dimension = component.getPreferredSize();
                component.setBounds(n -= dimension.width, n2, dimension.width, dimension.height);
                n -= 2;
            }
        }
    };

    public void add(Component component) {
        this.add(component, TOP_LR);
    }

    public void add(Component component, Positioner positioner) {
        this.myComponent = component;
        this.pairs.add(new PairComponentPositioner(component, positioner));
    }

    public Component getComponent() {
        return this.myComponent;
    }

    public void addAll(ComponentsDescriptor componentsDescriptor) {
        int n = componentsDescriptor.getComponentCount();
        for (int i = 0; i < n; ++i) {
            this.add(componentsDescriptor.getComponent(i), componentsDescriptor.getPositioner(i));
        }
    }

    public int getComponentCount() {
        return this.pairs.size();
    }

    public Component getComponent(int n) {
        return this.pairs.get(n).getComponent();
    }

    public Positioner getPositioner(int n) {
        return this.pairs.get(n).getPositioner();
    }

    public Positioner getPositioner(Component component) {
        for (PairComponentPositioner pairComponentPositioner : this.pairs) {
            if (pairComponentPositioner.getComponent() != component) continue;
            return pairComponentPositioner.getPositioner();
        }
        return null;
    }

    @Override
    public Iterator<Component> iterator() {
        return new ComponentIterator(this.pairs);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComponentIterator
    implements Iterator<Component> {
        private Iterator<PairComponentPositioner> iterator;

        public ComponentIterator(Collection<PairComponentPositioner> collection) {
            this.iterator = collection.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Component next() {
            return this.iterator.next().getComponent();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private static class PairComponentPositioner {
        private Component component;
        private Positioner positioner;

        public PairComponentPositioner(Component component, Positioner positioner) {
            this.component = component;
            this.positioner = positioner;
        }

        public Component getComponent() {
            return this.component;
        }

        public Positioner getPositioner() {
            return this.positioner;
        }
    }
}

