/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.model.ViewFilters;
import org.openide.util.NbBundle;

public class SequenceFilterButton
extends JToggleButton
implements ActionListener {
    private DesignView designView;
    private static final Icon ICON = new ImageIcon(DesignView.class.getResource("resources/sequence_filter.png"));

    public SequenceFilterButton(DesignView designView) {
        super(ICON);
        this.designView = designView;
        this.setSelected(this.getViewFilters().showImplicitSequences());
        this.setToolTipText(NbBundle.getMessage(DesignView.class, (String)"LBL_SequenceFilterButton"));
        this.setFocusable(false);
        this.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.getViewFilters().setShowImplicitSequences(this.isSelected());
        this.updateView();
    }

    private void updateView() {
        this.designView.reloadModel();
        this.designView.diagramChanged();
        this.designView.getValidationDecorationProvider().updateDecorations();
    }

    private ViewFilters getViewFilters() {
        return this.designView.getModel().getFilters();
    }
}

