/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.DiagramView;
import org.netbeans.modules.bpel.design.geometry.FBounds;
import org.netbeans.modules.bpel.design.model.PartnerRole;
import org.netbeans.modules.bpel.design.model.connections.Connection;
import org.netbeans.modules.bpel.design.model.connections.MessageConnection;
import org.netbeans.modules.bpel.design.model.elements.VisualElement;
import org.netbeans.modules.bpel.design.model.patterns.PartnerlinkPattern;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.design.selection.PlaceHolder;
import org.netbeans.modules.bpel.design.selection.placeholders.PartnerlinkPlaceholder;
import org.netbeans.modules.bpel.model.api.BpelEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartnerlinksView
extends DiagramView {
    private PartnerRole mode;

    public PartnerlinksView(DesignView designView, PartnerRole partnerRole) {
        super(designView);
        this.mode = partnerRole;
        this.putClientProperty("print.printable", Boolean.TRUE);
        this.putClientProperty("print.order", partnerRole.getOrder());
    }

    public PartnerRole getMode() {
        return this.mode;
    }

    @Override
    protected void paintPattern(Graphics2D graphics2D, Graphics2D graphics2D2, Pattern pattern, FBounds fBounds, boolean bl) {
        List<Pattern> list = this.getDesignView().getModel().getPartnerLinks(this.getMode());
        if (list != null) {
            for (Pattern pattern2 : list) {
                super.paintPattern(graphics2D, graphics2D2, pattern2, fBounds, bl);
            }
        }
    }

    @Override
    protected void paintPatternConnections(Graphics2D graphics2D, Graphics2D graphics2D2, Pattern pattern, boolean bl) {
        List<Pattern> list = this.getDesignView().getModel().getPartnerLinks(this.getMode());
        if (list != null) {
            for (Pattern pattern2 : list) {
                for (VisualElement visualElement : pattern2.getElements()) {
                    for (Connection connection : visualElement.getAllConnections()) {
                        if (!(connection instanceof MessageConnection)) continue;
                        ((MessageConnection)connection).paintPL(graphics2D);
                    }
                }
            }
        }
    }

    @Override
    public FBounds getContentSize() {
        List<Pattern> list = this.getDesignView().getModel().getPartnerLinks(this.getMode());
        ArrayList<FBounds> arrayList = new ArrayList<FBounds>(list.size());
        for (Pattern pattern : list) {
            arrayList.add(pattern.getBounds());
        }
        return new FBounds(arrayList);
    }

    @Override
    public Iterator<Pattern> getPatterns() {
        return this.getDesignView().getModel().getPartnerLinks(this.getMode()).iterator();
    }

    @Override
    public void getPlaceholders(Pattern pattern, List<PlaceHolder> list) {
        if (!(pattern instanceof PartnerlinkPattern)) {
            return;
        }
        FBounds fBounds = this.getContentSize();
        List<Pattern> list2 = this.getDesignView().getModel().getPartnerLinks(this.getMode());
        if (list2.indexOf(pattern) != 0) {
            list.add(new PartnerlinkPlaceholder(this, null, pattern, fBounds.getCenterX(), 0.0));
        }
        for (Pattern pattern2 : list2) {
            if (pattern2 == pattern) continue;
            BpelEntity bpelEntity = pattern2.getOMReference();
            FBounds fBounds2 = pattern2.getBounds();
            list.add(new PartnerlinkPlaceholder(this, bpelEntity, pattern, fBounds.getCenterX(), fBounds2.getMaxY() + 10.0));
        }
    }
}

