/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.DiagramView;
import org.netbeans.modules.bpel.design.ProcessView;
import org.netbeans.modules.bpel.design.TriScrollPane;
import org.netbeans.modules.bpel.design.decoration.ComponentsDescriptor;
import org.netbeans.modules.bpel.design.decoration.Decoration;
import org.netbeans.modules.bpel.design.decoration.Positioner;
import org.netbeans.modules.bpel.design.decoration.components.ZoomableDecorationComponent;
import org.netbeans.modules.bpel.design.geometry.FBounds;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;

public class DiagramViewLayout
implements LayoutManager {
    public static int MARGIN_TOP = 32;
    public static int MARGIN_LEFT = 18;
    public static int MARGIN_BOTTOM = 32;
    public static int MARGIN_RIGHT = 18;

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            DiagramView diagramView = (DiagramView)container;
            DesignView designView = diagramView.getDesignView();
            int n = 0;
            int n2 = 0;
            double d = designView.getCorrectedZoom();
            FBounds fBounds = diagramView.getContentSize();
            n = (int)Math.round(d * (double)fBounds.width + (double)MARGIN_LEFT + (double)MARGIN_RIGHT);
            n2 = (int)Math.round(d * (double)fBounds.height + (double)MARGIN_TOP + (double)MARGIN_BOTTOM);
            if (container instanceof ProcessView) {
                TriScrollPane triScrollPane = designView.getScrollPane();
                int n3 = triScrollPane.getLeftPreferredWidth();
                int n4 = triScrollPane.getRightPreferredWidth();
                n += n3 + n4;
            }
            return new Dimension(n, n2);
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            DiagramView diagramView = (DiagramView)container;
            DesignView designView = diagramView.getDesignView();
            double d = designView.getCorrectedZoom();
            FBounds fBounds = diagramView.getContentSize();
            int n = (int)Math.round(((double)diagramView.getWidth() - (double)fBounds.width * d) / 2.0);
            int n2 = (int)Math.round(((double)diagramView.getHeight() - (double)fBounds.height * d) / 2.0);
            diagramView.setOffsets(n, n2);
            if (container.getComponentCount() > 0) {
                this.repositionDecorations(container);
            }
        }
    }

    private void repositionDecorations(Container container) {
        DiagramView diagramView = (DiagramView)container;
        DesignView designView = diagramView.getDesignView();
        Iterator<Pattern> iterator = diagramView.getPatterns();
        while (iterator.hasNext()) {
            Pattern pattern = iterator.next();
            Decoration decoration = designView.getDecoration(pattern);
            if (decoration == null || !decoration.hasComponents()) continue;
            double d = designView.getCorrectedZoom();
            HashMap<Positioner, ArrayList<Object>> hashMap = new HashMap<Positioner, ArrayList<Object>>();
            ComponentsDescriptor componentsDescriptor = decoration.getComponents();
            int n = componentsDescriptor.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Object object = componentsDescriptor.getComponent(i);
                Positioner positioner = componentsDescriptor.getPositioner(i);
                ArrayList<Object> arrayList = (ArrayList<Object>)hashMap.get(positioner);
                if (arrayList == null) {
                    arrayList = new ArrayList<Object>(n);
                    hashMap.put(positioner, arrayList);
                }
                arrayList.add(object);
                if (!(object instanceof ZoomableDecorationComponent)) continue;
                ((ZoomableDecorationComponent)object).setZoom(d);
            }
            for (Object object : hashMap.keySet()) {
                ((Positioner)object).position(pattern, (Collection)hashMap.get(object), d);
            }
        }
    }
}

