/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.value.IdentifierProvider;
import org.apache.batik.css.engine.value.Messages;
import org.apache.batik.css.engine.value.StringMap;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.DOMException;

public abstract class AbstractValueFactory {
    public abstract String getPropertyName();

    protected static String resolveURI(URL base, String value) {
        return new ParsedURL(base, value).toString();
    }

    private String getPropertyName(CSSEngine engine) {
        String name = null;
        if (engine != null) {
            name = engine.getExpandingShorthandProperty();
        }
        if (name == null) {
            name = this.getPropertyName();
        }
        return name;
    }

    protected DOMException createInvalidIdentifierDOMException(String ident, CSSEngine engine) {
        Object[] p = new Object[]{this.getPropertyName(engine), ident};
        String s = Messages.formatMessage("invalid.identifier", p);
        if (this instanceof IdentifierProvider) {
            StringMap map = ((IdentifierProvider)((Object)this)).getIdentifierMap();
            Iterator keys = map.keys();
            ArrayList<String> list = new ArrayList<String>();
            while (keys.hasNext()) {
                String identifier = (String)keys.next();
                if (identifier.startsWith("-")) continue;
                list.add(identifier);
            }
            if (list.size() > 0) {
                String identifiers = list.toString();
                if (identifiers.length() > 80) {
                    identifiers = identifiers.substring(0, 80) + "...]";
                }
                s = s + " " + identifiers;
            }
        }
        return new DOMException(12, s);
    }

    protected DOMException createInvalidLexicalUnitDOMException(short type, CSSEngine engine) {
        Object[] p = new Object[]{this.getPropertyName(engine), new Integer(type)};
        String s = Messages.formatMessage("invalid.lexical.unit", p);
        return new DOMException(9, s);
    }

    protected DOMException createInvalidFloatTypeDOMException(short t, CSSEngine engine) {
        Object[] p = new Object[]{this.getPropertyName(engine), new Integer(t)};
        String s = Messages.formatMessage("invalid.float.type", p);
        return new DOMException(15, s);
    }

    protected DOMException createInvalidFloatValueDOMException(float f, CSSEngine engine) {
        Object[] p = new Object[]{this.getPropertyName(engine), new Float(f)};
        String s = Messages.formatMessage("invalid.float.value", p);
        return new DOMException(15, s);
    }

    protected DOMException createInvalidStringTypeDOMException(short t, CSSEngine engine) {
        Object[] p = new Object[]{this.getPropertyName(engine), new Integer(t)};
        String s = Messages.formatMessage("invalid.string.type", p);
        return new DOMException(15, s);
    }

    protected DOMException createMalformedLexicalUnitDOMException(CSSEngine engine) {
        Object[] p = new Object[]{this.getPropertyName(engine)};
        String s = Messages.formatMessage("malformed.lexical.unit", p);
        return new DOMException(15, s);
    }

    protected DOMException createDOMException(CSSEngine engine) {
        Object[] p = new Object[]{this.getPropertyName(engine)};
        String s = Messages.formatMessage("invalid.access", p);
        return new DOMException(9, s);
    }
}

