/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.value.Value;

public class StyleMap {
    public static final short IMPORTANT_MASK = 1;
    public static final short COMPUTED_MASK = 2;
    public static final short NULL_CASCADED_MASK = 4;
    public static final short LINE_HEIGHT_RELATIVE_MASK = 8;
    public static final short FONT_SIZE_RELATIVE_MASK = 16;
    public static final short INHERITED_MASK = 32;
    public static final short PARENT_RELATIVE_MASK = 64;
    public static final short BLOCK_WIDTH_RELATIVE_MASK = 128;
    public static final short BLOCK_HEIGHT_RELATIVE_MASK = 256;
    public static final short BOX_RELATIVE_MASK = 512;
    public static final short ORIGIN_MASK = -8192;
    public static final short USER_AGENT_ORIGIN = 0;
    public static final short USER_ORIGIN = 8192;
    public static final short NON_CSS_ORIGIN = 16384;
    public static final short AUTHOR_ORIGIN = 24576;
    public static final short INLINE_AUTHOR_ORIGIN = Short.MIN_VALUE;
    protected Value[] values;
    protected short[] masks;
    protected boolean fixedCascadedValues;

    public StyleMap(int size) {
        this.values = new Value[size];
        this.masks = new short[size];
    }

    public boolean hasFixedCascadedValues() {
        return this.fixedCascadedValues;
    }

    public void setFixedCascadedStyle(boolean b) {
        this.fixedCascadedValues = b;
    }

    public Value getValue(int i) {
        return this.values[i];
    }

    public short getMask(int i) {
        return this.masks[i];
    }

    public boolean isImportant(int i) {
        return (this.masks[i] & 1) != 0;
    }

    public boolean isComputed(int i) {
        return (this.masks[i] & 2) != 0;
    }

    public boolean isNullCascaded(int i) {
        return (this.masks[i] & 4) != 0;
    }

    public short getOrigin(int i) {
        return (short)(this.masks[i] & 0xFFFFE000);
    }

    public boolean isColorRelative(int i) {
        return false;
    }

    public boolean isParentRelative(int i) {
        return (this.masks[i] & 0x40) != 0;
    }

    public boolean isLineHeightRelative(int i) {
        return (this.masks[i] & 8) != 0;
    }

    public boolean isFontSizeRelative(int i) {
        return (this.masks[i] & 0x10) != 0;
    }

    public boolean isBlockWidthRelative(int i) {
        return (this.masks[i] & 0x80) != 0;
    }

    public boolean isBlockHeightRelative(int i) {
        return (this.masks[i] & 0x100) != 0;
    }

    public void putValue(int i, Value v) {
        this.values[i] = v;
    }

    public void putMask(int i, short m) {
        this.masks[i] = m;
    }

    public void putImportant(int i, boolean b) {
        int n = i;
        this.masks[n] = (short)(this.masks[n] & 0xFFFFFFFE);
        int n2 = i;
        this.masks[n2] = (short)(this.masks[n2] | (b ? (short)1 : 0));
    }

    public void putOrigin(int i, short val) {
        int n = i;
        this.masks[n] = (short)(this.masks[n] & 0x1FFF);
        int n2 = i;
        this.masks[n2] = (short)(this.masks[n2] | (short)(val & 0xFFFFE000));
    }

    public void putComputed(int i, boolean b) {
        int n = i;
        this.masks[n] = (short)(this.masks[n] & 0xFFFFFFFD);
        int n2 = i;
        this.masks[n2] = (short)(this.masks[n2] | (b ? 2 : 0));
    }

    public void putNullCascaded(int i, boolean b) {
        int n = i;
        this.masks[n] = (short)(this.masks[n] & 0xFFFFFFFB);
        int n2 = i;
        this.masks[n2] = (short)(this.masks[n2] | (b ? 4 : 0));
    }

    public boolean isInherited(int i) {
        return (this.masks[i] & 0x20) != 0;
    }

    public void putInherited(int i, boolean b) {
        int n = i;
        this.masks[n] = (short)(this.masks[n] & 0xFFFFFFDF);
        int n2 = i;
        this.masks[n2] = (short)(this.masks[n2] | (b ? 32 : 0));
    }

    public void putParentRelative(int i, boolean b) {
        int n = i;
        this.masks[n] = (short)(this.masks[n] & 0xFFFFFFBF);
        int n2 = i;
        this.masks[n2] = (short)(this.masks[n2] | (b ? 64 : 0));
    }

    public void putLineHeightRelative(int i, boolean b) {
        int n = i;
        this.masks[n] = (short)(this.masks[n] & 0xFFFFFFF7);
        int n2 = i;
        this.masks[n2] = (short)(this.masks[n2] | (b ? 8 : 0));
    }

    public void putFontSizeRelative(int i, boolean b) {
        int n = i;
        this.masks[n] = (short)(this.masks[n] & 0xFFFFFFEF);
        int n2 = i;
        this.masks[n2] = (short)(this.masks[n2] | (b ? 16 : 0));
    }

    public void putBlockWidthRelative(int i, boolean b) {
        int n = i;
        this.masks[n] = (short)(this.masks[n] & 0xFFFFFF7F);
        int n2 = i;
        this.masks[n2] = (short)(this.masks[n2] | (b ? 128 : 0));
    }

    public void putBlockHeightRelative(int i, boolean b) {
        int n = i;
        this.masks[n] = (short)(this.masks[n] & 0xFFFFFEFF);
        int n2 = i;
        this.masks[n2] = (short)(this.masks[n2] | (b ? 256 : 0));
    }

    public String toString(CSSEngine eng) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.values.length; ++i) {
            Value v = this.values[i];
            if (v == null) continue;
            sb.append(eng.getPropertyName(i));
            sb.append(": ");
            sb.append(v);
            if (this.isImportant(i)) {
                sb.append(" !important");
            }
            sb.append(";\n");
        }
        return sb.toString();
    }

    public int getSize(boolean total) {
        if (total) {
            return this.values.length;
        }
        int count = 0;
        for (Value v : this.values) {
            if (v == null) continue;
            ++count;
        }
        return count;
    }

    public String toStyleString(CSSEngine eng) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        int n = this.values.length;
        for (int i = 0; i < n; ++i) {
            Value v = this.values[i];
            if (v == null) continue;
            if (first) {
                first = false;
            } else {
                sb.append("; ");
            }
            sb.append(eng.getPropertyName(i));
            sb.append(": ");
            sb.append(v);
            if (!this.isImportant(i)) continue;
            sb.append(" !important");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append('\n');
        for (int i = 0; i < this.values.length; ++i) {
            Value v = this.values[i];
            if (v == null) continue;
            sb.append("prop");
            sb.append(Integer.toString(i));
            sb.append(": ");
            sb.append(v);
            if (this.isImportant(i)) {
                sb.append(" !important");
            }
            sb.append(";\n");
        }
        return sb.toString();
    }
}

