/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.predicates;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.netbeans.modules.bpel.mapper.model.PathConverter;
import org.netbeans.modules.soa.ui.tree.TreeItem;
import org.netbeans.modules.xml.xpath.ext.LocationStep;
import org.netbeans.modules.xml.xpath.ext.StepNodeTestType;
import org.netbeans.modules.xml.xpath.ext.StepNodeTypeTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecialStepManager {
    private LinkedList<CachedStep> mSteps = new LinkedList();

    public List<LocationStep> getSteps(Iterable<Object> iterable) {
        ArrayList<LocationStep> arrayList = new ArrayList<LocationStep>();
        for (CachedStep cachedStep : this.mSteps) {
            if (!cachedStep.hasSameLocation(iterable)) continue;
            arrayList.add(cachedStep.getStep());
        }
        return arrayList;
    }

    public boolean addStep(List<Object> list, LocationStep locationStep) {
        for (CachedStep cachedStep : this.mSteps) {
            if (!cachedStep.hasSameLocation(list) || !cachedStep.getStep().equals(locationStep)) continue;
            return false;
        }
        CachedStep cachedStep = new CachedStep(list, locationStep);
        this.mSteps.add(cachedStep);
        return true;
    }

    public boolean addStep(TreeItem treeItem, LocationStep locationStep) {
        List<Object> list = PathConverter.constructObjectLocationtList(treeItem, true, false);
        if (list != null) {
            return this.addStep(list, locationStep);
        }
        return false;
    }

    public void removeStep(TreeItem treeItem, LocationStep locationStep) {
        List<Object> list = PathConverter.constructObjectLocationtList(treeItem, true, false);
        if (list != null) {
            for (CachedStep cachedStep : this.mSteps) {
                if (!cachedStep.getStep().equals(locationStep) || !cachedStep.hasSameLocation(list)) continue;
                this.mSteps.remove(cachedStep);
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CachedStep {
        private List<Object> mParentPath;
        private LocationStep mStep;
        private boolean isPersistent;

        public CachedStep(List<Object> list, LocationStep locationStep) {
            this.mParentPath = list;
            this.mStep = locationStep;
            assert (locationStep.getNodeTest() instanceof StepNodeTypeTest);
        }

        public boolean isPersistent() {
            return this.isPersistent;
        }

        public void setPersistent(boolean bl) {
            this.isPersistent = bl;
        }

        public LocationStep getStep() {
            return this.mStep;
        }

        public StepNodeTestType getNodeType() {
            StepNodeTypeTest stepNodeTypeTest = (StepNodeTypeTest)this.mStep.getNodeTest();
            return stepNodeTypeTest.getNodeType();
        }

        public List getParentPath() {
            return this.mParentPath;
        }

        public boolean hasSameLocation(Iterable iterable) {
            return this.hasSameLocationImpl(iterable.iterator());
        }

        private boolean hasSameLocationImpl(Iterator iterator) {
            Iterator<Object> iterator2 = this.mParentPath.iterator();
            boolean bl = true;
            while (iterator.hasNext() && iterator2.hasNext()) {
                Object object;
                Object e = iterator.next();
                if (e.equals(object = iterator2.next())) continue;
                bl = false;
                break;
            }
            if (bl && iterator2.hasNext()) {
                return false;
            }
            return bl;
        }

        public String toString() {
            String string = this.getNodeType().toString();
            String string2 = string + " persistent=" + this.isPersistent;
            String string3 = this.locationToString();
            if (string3 == null || string3.length() == 0) {
                return string2;
            }
            return string3 + " " + string2;
        }

        private String locationToString() {
            StringBuilder stringBuilder = new StringBuilder();
            ListIterator<Object> listIterator = this.mParentPath.listIterator(this.mParentPath.size());
            boolean bl = true;
            while (listIterator.hasPrevious()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append("/");
                }
                Object object = listIterator.previous();
                stringBuilder.append(object.toString());
            }
            return stringBuilder.toString();
        }

        public boolean equals(Object object) {
            if (!(object instanceof CachedStep)) {
                return false;
            }
            CachedStep cachedStep = (CachedStep)object;
            LocationStep locationStep = cachedStep.getStep();
            if (!locationStep.equals(this.mStep)) {
                return false;
            }
            List list = cachedStep.getParentPath();
            if (list.size() != this.mParentPath.size()) {
                return false;
            }
            ListIterator<Object> listIterator = this.mParentPath.listIterator();
            ListIterator listIterator2 = list.listIterator();
            while (listIterator.hasNext()) {
                Object e;
                Object e2 = listIterator.next();
                if (e2.equals(e = listIterator2.next())) continue;
                return false;
            }
            return true;
        }
    }
}

