/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.core.jsploader.TimeReference;
import org.netbeans.modules.web.core.jsploader.api.TagLibParseCookie;
import org.netbeans.modules.web.core.syntax.spi.ErrorAnnotation;
import org.netbeans.modules.web.core.syntax.spi.JSPColoringData;
import org.netbeans.modules.web.jsps.parserapi.JspParserAPI;
import org.netbeans.modules.web.jsps.parserapi.JspParserFactory;
import org.netbeans.modules.web.jsps.parserapi.PageInfo;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class TagLibParseSupport
implements Node.Cookie,
TagLibParseCookie {
    private FileObject jspFile;
    private boolean documentDirty;
    private RequestProcessor.Task parsingTask = null;
    private static RequestProcessor requestProcessor;
    private WeakReference jspColoringDataRef;
    private TimeReference jspOpenInfoRef;
    private SoftReference parseResultRef;
    private SoftReference parseResultSuccessfulRef;
    private Object parseResultLock = new Object();
    private Object openInfoLock = new Object();
    private boolean wasAnEditorPaneChangeEvent = false;
    private boolean parsingTaskCancelled = false;
    private boolean parserStarted = false;
    private ErrorAnnotation annotations;
    private boolean hasError = false;

    public TagLibParseSupport(FileObject fileObject) {
        this.jspFile = fileObject;
        if (requestProcessor == null) {
            requestProcessor = new RequestProcessor("background jsp parsing", 10);
        }
        this.annotations = new ErrorAnnotation(fileObject);
    }

    public JSPColoringData getJSPColoringData() {
        return this.getJSPColoringData(false);
    }

    private WebModule getWebModule(FileObject fileObject) {
        FileObject fileObject2;
        WebModule webModule = WebModule.getWebModule((FileObject)fileObject);
        if (webModule != null && (fileObject2 = webModule.getDocumentBase()) != null && (fileObject == fileObject2 || FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject))) {
            return webModule;
        }
        return null;
    }

    JSPColoringData getJSPColoringData(boolean bl) {
        Object object;
        if (this.jspColoringDataRef != null && (object = this.jspColoringDataRef.get()) != null) {
            return (JSPColoringData)object;
        }
        object = new JSPColoringData((Object)this);
        this.jspColoringDataRef = new WeakReference(object);
        if (bl) {
            this.prepare();
        }
        return object;
    }

    public void setDocumentDirty(boolean bl) {
        this.documentDirty = bl;
    }

    public boolean isDocumentDirty() {
        return this.documentDirty;
    }

    public RequestProcessor.Task autoParse() {
        if (this.isDocumentDirty() || !this.isParserStarted()) {
            return this.parseObject(1);
        }
        return requestProcessor.post(new Runnable(){

            public void run() {
            }
        });
    }

    public RequestProcessor.Task prepare() {
        return this.parseObject(9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RequestProcessor.Task parseObject(int n) {
        this.parsingTaskCancelled = false;
        if (!this.wasAnEditorPaneChangeEvent) {
            Exceptions.attachLocalizedMessage((Throwable)new IllegalStateException(), (String)"The TagLibParseSupport.parseObject() is called before editor support is created!");
        }
        Object object = this.parseResultLock;
        synchronized (object) {
            RequestProcessor.Task task = this.parsingTask;
            if (task != null) {
                task.setPriority(Math.max(task.getPriority(), n));
                return task;
            }
            this.setParserStarted();
            this.setDocumentDirty(false);
            this.parsingTask = task = requestProcessor.post((Runnable)new ParsingRunnable(), 0, n);
            return this.parsingTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEditorOpened(boolean bl) {
        this.wasAnEditorPaneChangeEvent = true;
        Object object = this.parseResultLock;
        synchronized (object) {
            if (!bl) {
                // empty if block
            }
        }
    }

    void cancelParsingTask() {
        if (this.parsingTask != null) {
            boolean bl = this.parsingTask.cancel();
            this.parsingTask = null;
            this.jspColoringDataRef = null;
        }
        this.parsingTaskCancelled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JspParserAPI.JspOpenInfo getCachedOpenInfo(boolean bl, boolean bl2) {
        Object object = this.openInfoLock;
        synchronized (object) {
            JspParserAPI.JspOpenInfo jspOpenInfo;
            if (bl) {
                this.jspOpenInfoRef = null;
            }
            long l = this.jspFile.lastModified().getTime();
            if (this.jspOpenInfoRef == null) {
                this.jspOpenInfoRef = new TimeReference();
            }
            if ((jspOpenInfo = (JspParserAPI.JspOpenInfo)this.jspOpenInfoRef.get(l)) == null) {
                jspOpenInfo = JspParserFactory.getJspParser().getJspOpenInfo(this.jspFile, this.getWebModule(this.jspFile), bl2);
                this.jspOpenInfoRef.put(jspOpenInfo, l);
            }
            return jspOpenInfo;
        }
    }

    public TagLibParseCookie.OpenInfo getOpenInfo(boolean bl, boolean bl2) {
        JspParserAPI.JspOpenInfo jspOpenInfo = this.getCachedOpenInfo(bl, bl2);
        return TagLibParseCookie.OpenInfo.create(jspOpenInfo.isXmlSyntax(), jspOpenInfo.getEncoding());
    }

    public JspParserAPI.ParseResult getCachedParseResult(boolean bl, boolean bl2) {
        return this.getCachedParseResult(bl, bl2, false);
    }

    public JspParserAPI.ParseResult getCachedParseResult(boolean bl, boolean bl2, boolean bl3) {
        SoftReference softReference;
        boolean bl4 = bl3;
        if (bl2 && this.isDocumentDirty()) {
            bl4 = true;
        }
        if (this.parseResultRef == null) {
            bl4 = true;
        }
        JspParserAPI.ParseResult parseResult = null;
        SoftReference softReference2 = softReference = bl ? this.parseResultSuccessfulRef : this.parseResultRef;
        if (softReference != null) {
            parseResult = (JspParserAPI.ParseResult)softReference.get();
        }
        if (parseResult == null && !bl) {
            bl4 = true;
        }
        if (bl4) {
            RequestProcessor.Task task = this.prepare();
            task.waitFinished();
            SoftReference softReference3 = softReference = bl ? this.parseResultSuccessfulRef : this.parseResultRef;
            if (softReference != null) {
                parseResult = (JspParserAPI.ParseResult)softReference.get();
            }
        }
        return parseResult;
    }

    private synchronized boolean isParserStarted() {
        return this.parserStarted;
    }

    private synchronized void setParserStarted() {
        this.parserStarted = true;
    }

    private class ParsingRunnable
    implements Runnable {
        JspParserAPI.ParseResult locResult = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (!TagLibParseSupport.this.parsingTaskCancelled && TagLibParseSupport.this.getWebModule(TagLibParseSupport.this.jspFile) != null) {
                JspParserAPI jspParserAPI = JspParserFactory.getJspParser();
                if (jspParserAPI == null) {
                    throw new InternalError();
                }
                TagLibParseSupport.this.getJSPColoringData(false).parsingStarted();
                this.locResult = jspParserAPI.analyzePage(TagLibParseSupport.this.jspFile, TagLibParseSupport.this.getWebModule(TagLibParseSupport.this.jspFile), 1);
                assert (this.locResult != null);
                Object object = TagLibParseSupport.this.parseResultLock;
                synchronized (object) {
                    TagLibParseSupport.this.parseResultRef = new SoftReference<JspParserAPI.ParseResult>(this.locResult);
                    if (this.locResult.isParsingSuccess()) {
                        TagLibParseSupport.this.parseResultSuccessfulRef = new SoftReference<JspParserAPI.ParseResult>(this.locResult);
                        if (TagLibParseSupport.this.hasError) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    TagLibParseSupport.this.annotations.annotate(new ErrorAnnotation.ErrorInfo[0]);
                                }
                            });
                            TagLibParseSupport.this.hasError = false;
                        }
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                for (int i = 0; i < ParsingRunnable.this.locResult.getErrors().length; ++i) {
                                    JspParserAPI.ErrorDescriptor errorDescriptor = ParsingRunnable.this.locResult.getErrors()[i];
                                    if (!ParsingRunnable.this.checkError(errorDescriptor)) continue;
                                    TagLibParseSupport.this.annotations.annotate(new ErrorAnnotation.ErrorInfo[]{new ErrorAnnotation.ErrorInfo(ParsingRunnable.this.translate(errorDescriptor.getErrorMessage()), errorDescriptor.getLine(), errorDescriptor.getColumn(), 1)});
                                }
                                if (!TagLibParseSupport.this.hasError) {
                                    TagLibParseSupport.this.hasError = true;
                                }
                            }
                        });
                    }
                    PageInfo pageInfo = this.locResult.getPageInfo();
                    TagLibParseSupport.this.parsingTask = null;
                    if (pageInfo == null) {
                        return;
                    }
                    Map map = null;
                    if (pageInfo.getXMLPrefixMapper().size() > 0) {
                        map = pageInfo.getApproxXmlPrefixMapper();
                        if (map.size() == 0) {
                            map = pageInfo.getXMLPrefixMapper();
                        }
                        map.putAll(pageInfo.getJspPrefixMapper());
                    } else {
                        map = pageInfo.getJspPrefixMapper();
                    }
                    TagLibParseSupport.this.getJSPColoringData(false).applyParsedData(pageInfo.getTagLibraries(), map, pageInfo.isELIgnored(), TagLibParseSupport.this.getCachedOpenInfo(false, false).isXmlSyntax(), this.locResult.isParsingSuccess());
                }
            }
        }

        private boolean checkError(JspParserAPI.ErrorDescriptor errorDescriptor) {
            if (errorDescriptor.getErrorMessage() == null) {
                Logger.global.log(Level.INFO, null, new IllegalStateException("Invalid JspParserAPI.ErrorDescription from jsp parser - null error message: " + errorDescriptor.toString()));
                return false;
            }
            return true;
        }

        private String translate(String string) {
            String string2 = string.replaceAll("&lt;", "<");
            string2 = string2.replaceAll("&gt;", ">");
            return string2;
        }
    }
}

