/*
 * Decompiled with CFR 0.152.
 */
package com.sun.errorhandler;

import com.sun.errorhandler.DebugClientTestThread;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class DebugClientTestWindow
extends JFrame {
    DebugClientTestThread clientThread = null;
    private JPanel buttonPanel;
    private JButton exitButton;
    private JPanel mainPanel;
    private JTextField messageField;
    private JPanel messagePanel;
    private JScrollPane scrollPane;
    private JButton sendButton;
    private JTextArea textArea;

    public DebugClientTestWindow() {
        this.initComponents();
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.scrollPane = new JScrollPane();
        this.textArea = new JTextArea();
        this.messagePanel = new JPanel();
        this.messageField = new JTextField();
        this.buttonPanel = new JPanel();
        this.exitButton = new JButton();
        this.sendButton = new JButton();
        this.setTitle("Client Window");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DebugClientTestWindow.this.exitForm(evt);
            }
        });
        this.mainPanel.setLayout(new BorderLayout());
        this.textArea.setColumns(35);
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(true);
        this.textArea.setRows(15);
        this.textArea.setWrapStyleWord(true);
        this.scrollPane.setViewportView(this.textArea);
        this.mainPanel.add((Component)this.scrollPane, "Center");
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.messagePanel.setLayout(new BorderLayout());
        this.messagePanel.setBorder(new EmptyBorder(new Insets(5, 1, 1, 1)));
        this.messagePanel.add((Component)this.messageField, "North");
        this.buttonPanel.setLayout(new GridBagLayout());
        this.buttonPanel.setBorder(new EmptyBorder(new Insets(5, 1, 1, 1)));
        this.exitButton.setText("Exit");
        this.exitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DebugClientTestWindow.this.exitButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.buttonPanel.add((Component)this.exitButton, gridBagConstraints);
        this.sendButton.setText("Send");
        this.sendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DebugClientTestWindow.this.sendButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.buttonPanel.add((Component)this.sendButton, gridBagConstraints);
        this.messagePanel.add((Component)this.buttonPanel, "East");
        this.getContentPane().add((Component)this.messagePanel, "South");
        this.setBounds(500, 100, 400, 300);
    }

    private void sendButtonActionPerformed(ActionEvent evt) {
        if (this.messageField.getText() != null || !this.messageField.getText().equals("")) {
            if (this.clientThread.isConnected()) {
                this.clientThread.sendMessage(this.messageField.getText());
            }
            this.messageField.setText("");
        }
    }

    private void exitButtonActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    public void connectSocket() {
        this.clientThread = new DebugClientTestThread(this.textArea);
        this.clientThread.start();
    }

    private void exitForm(WindowEvent evt) {
        this.clientThread.disconnect();
        System.exit(0);
    }

    public static void main(String[] args) {
        DebugClientTestWindow clientWindow = new DebugClientTestWindow();
        clientWindow.connectSocket();
        clientWindow.show();
    }
}

