/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.wizards;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.modules.versioning.system.cvss.ui.wizards.CvsRootPanel;
import org.netbeans.modules.versioning.system.cvss.ui.wizards.RepositoryPanel;
import org.netbeans.modules.versioning.system.cvss.ui.wizards.RepositoryStep;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class RootWizard
implements ActionListener,
DocumentListener {
    private final RepositoryStep repositoryStep;
    private final CvsRootPanel rootPanel;
    private DialogDescriptor dd;

    private RootWizard(RepositoryStep repositoryStep) {
        this.repositoryStep = repositoryStep;
        this.rootPanel = null;
    }

    private RootWizard(CvsRootPanel cvsRootPanel) {
        this.repositoryStep = null;
        this.rootPanel = cvsRootPanel;
    }

    public static RootWizard configureRoot(String string) {
        RepositoryStep repositoryStep = new RepositoryStep(string, "org.netbeans.modules.versioning.system.cvss.ui.wizards.RepositoryStep.rootConf");
        repositoryStep.applyStandaloneLayout();
        return new RootWizard(repositoryStep);
    }

    public static String editCvsRoot(String string) {
        CvsRootPanel cvsRootPanel = new CvsRootPanel();
        RootWizard rootWizard = new RootWizard(cvsRootPanel);
        return rootWizard.customizeRoot(string);
    }

    private String customizeRoot(String string) {
        Object object;
        String string2 = "pserver";
        String string3 = "";
        String string4 = "";
        String string5 = System.getProperty("user.name");
        String string6 = "";
        try {
            object = CVSRoot.parse((String)string);
            string2 = object.getMethod();
            string3 = object.getHostName();
            int n = object.getPort();
            if (n > 0) {
                string4 = "" + n;
            }
            string5 = object.getUserName();
            string6 = object.getRepository();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.rootPanel.accessComboBox.setSelectedItem(string2);
        this.rootPanel.hostTextField.setText(string3);
        this.rootPanel.portTextField.setText(string4);
        this.rootPanel.userTextField.setText(string5);
        this.rootPanel.repositoryTextField.setText(string6);
        this.rootPanel.accessComboBox.addActionListener(this);
        this.rootPanel.userTextField.getDocument().addDocumentListener(this);
        this.rootPanel.hostTextField.getDocument().addDocumentListener(this);
        this.rootPanel.userTextField.getDocument().addDocumentListener(this);
        this.rootPanel.portTextField.getDocument().addDocumentListener(this);
        this.rootPanel.repositoryTextField.getDocument().addDocumentListener(this);
        this.rootPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.dd = new DialogDescriptor((Object)this.rootPanel, NbBundle.getMessage(RootWizard.class, (String)"BK2024"));
        this.dd.setHelpCtx(new HelpCtx(CvsRootPanel.class));
        this.dd.setModal(true);
        this.rootPanel.setPreferredSize(this.rootPanel.getPreferredSize());
        this.updateVisibility();
        this.checkInput();
        object = DialogDisplayer.getDefault().createDialog(this.dd);
        ((Dialog)object).getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RootWizard.class, (String)"ACSD_CvsRootPanel"));
        ((Dialog)object).setVisible(true);
        if (DialogDescriptor.OK_OPTION.equals(this.dd.getValue())) {
            try {
                String string7 = this.collectRoot();
                CVSRoot cVSRoot = CVSRoot.parse((String)string7);
                return string7;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    private void updateVisibility() {
        String string = (String)this.rootPanel.accessComboBox.getSelectedItem();
        boolean bl = "pserver".equals(string) || "ext".equals(string);
        this.rootPanel.userLabel.setVisible(bl);
        this.rootPanel.userTextField.setVisible(bl);
        this.rootPanel.hostLabel.setVisible(bl);
        this.rootPanel.hostTextField.setVisible(bl);
        this.rootPanel.portLabel.setVisible(bl);
        this.rootPanel.portTextField.setVisible(bl);
    }

    private String collectRoot() throws IllegalArgumentException {
        String string;
        String string2 = (String)this.rootPanel.accessComboBox.getSelectedItem();
        boolean bl = "pserver".equals(string2) || "ext".equals(string2);
        StringBuffer stringBuffer = new StringBuffer(":");
        stringBuffer.append(string2);
        stringBuffer.append(":");
        if (bl) {
            int n;
            string = this.rootPanel.userTextField.getText();
            if ("".equals(string.trim())) {
                throw new IllegalArgumentException();
            }
            stringBuffer.append(string);
            stringBuffer.append("@");
            string = this.rootPanel.hostTextField.getText();
            if ("".equals(string.trim())) {
                throw new IllegalArgumentException();
            }
            stringBuffer.append(string);
            stringBuffer.append(":");
            String string3 = this.rootPanel.portTextField.getText();
            if (!string2.equals("pserver")) {
                string3 = "";
            }
            if (!"".equals(string3.trim()) && (n = Integer.parseInt(string3)) > 0) {
                stringBuffer.append(string3);
            }
        }
        if ("".equals((string = this.rootPanel.repositoryTextField.getText()).trim())) {
            throw new IllegalArgumentException();
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private void checkInput() {
        try {
            String string = this.collectRoot();
            CVSRoot cVSRoot = CVSRoot.parse((String)string);
            this.dd.setValid(true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.dd.setValid(false);
        }
    }

    public JPanel getPanel() {
        RepositoryPanel repositoryPanel = (RepositoryPanel)this.repositoryStep.getComponent();
        return repositoryPanel;
    }

    public String commit(boolean bl) {
        if (bl) {
            this.repositoryStep.prepareValidation();
            this.repositoryStep.validateBeforeNext();
            if (!this.repositoryStep.isValid()) {
                return this.repositoryStep.getErrorMessage();
            }
        }
        this.repositoryStep.storeValidValues();
        return null;
    }

    public boolean isValid() {
        return this.repositoryStep.isValid();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.repositoryStep.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.repositoryStep.removeChangeListener(changeListener);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.updateVisibility();
        this.checkInput();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkInput();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkInput();
    }
}

