/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.commit;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.ResourceBundle;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.modules.versioning.system.cvss.CvsFileNode;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitOptions;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitTable;
import org.netbeans.modules.versioning.system.cvss.ui.components.KTextArea;
import org.netbeans.modules.versioning.util.ListenersSupport;
import org.netbeans.modules.versioning.util.StringSelector;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CommitSettings
extends JPanel
implements PreferenceChangeListener,
TableModelListener,
DocumentListener {
    static final String COLUMN_NAME_NAME = "name";
    static final String COLUMN_NAME_STICKY = "sticky";
    static final String COLUMN_NAME_STATUS = "status";
    static final String COLUMN_NAME_ACTION = "action";
    static final String COLUMN_NAME_PATH = "path";
    static final Object EVENT_SETTINGS_CHANGED = new Object();
    private CommitTable commitTable;
    private JLabel errorLabel;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JButton loadTemplateButton;
    private JLabel messageErrorLabel;
    private JButton recentMessagesButton;
    private KTextArea taMessage;
    ListenersSupport listenerSupport = new ListenersSupport((Object)this);

    public CommitSettings() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setPreferredSize(new Dimension(dimension.width / 2, dimension.height / 5 * 2));
        this.init();
    }

    void setColumns(String[] stringArray) {
        this.commitTable.setColumns(stringArray);
    }

    void setNodes(CvsFileNode[] cvsFileNodeArray) {
        this.commitTable.setNodes(cvsFileNodeArray);
    }

    public String getCommitMessage() {
        return this.taMessage.getText();
    }

    public void addNotify() {
        super.addNotify();
        CvsModuleConfig.getDefault().getPreferences().addPreferenceChangeListener(this);
        this.commitTable.getTableModel().addTableModelListener(this);
        this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
        this.taMessage.selectAll();
        this.taMessage.requestFocus();
    }

    public void removeNotify() {
        this.commitTable.getTableModel().removeTableModelListener(this);
        CvsModuleConfig.getDefault().getPreferences().removePreferenceChangeListener(this);
        super.removeNotify();
    }

    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey().startsWith("commitExclusions")) {
            this.commitTable.dataChanged();
            this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
        }
    }

    public CommitFile[] getCommitFiles() {
        return this.commitTable.getCommitFiles();
    }

    private void init() {
        this.initComponents();
        this.errorLabel.setText("");
        this.messageErrorLabel.setText("");
        this.jScrollPane1.setMinimumSize(this.jScrollPane1.getPreferredSize());
        this.commitTable = new CommitTable(this.jLabel3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.commitTable.getComponent(), gridBagConstraints);
        List list = Utils.getStringList((Preferences)CvsModuleConfig.getDefault().getPreferences(), (String)"commitAction.commitMessage");
        if (list.size() > 0) {
            this.taMessage.setText((String)list.get(0));
        } else {
            this.loadTemplate(true);
        }
        this.taMessage.getDocument().addDocumentListener(this);
        this.onCommitMessageChanged();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.onCommitMessageChanged();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.onCommitMessageChanged();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.onCommitMessageChanged();
    }

    private void onCommitMessageChanged() {
        if (this.taMessage.getText().trim().length() == 0) {
            this.messageErrorLabel.setText(NbBundle.getMessage(CommitSettings.class, (String)"MSG_CommitForm_MessageEmpty"));
        } else {
            this.messageErrorLabel.setText("");
        }
    }

    private void loadTemplate(boolean bl) {
        NotifyDescriptor notifyDescriptor;
        for (CommitFile commitFile : notifyDescriptor = this.getCommitFiles()) {
            block6: {
                File file = commitFile.getNode().getFile();
                File file2 = new File(file.getParentFile(), "CVS/Template");
                if (!file2.canRead()) continue;
                StringWriter stringWriter = new StringWriter();
                try {
                    Utils.copyStreamsCloseAll((Writer)stringWriter, (Reader)new FileReader(file2));
                    String string = stringWriter.toString();
                    if (string.trim().length() == 0) {
                        NotifyDescriptor notifyDescriptor2 = new NotifyDescriptor((Object)NbBundle.getMessage(CommitSettings.class, (String)"CTL_LoadTemplate_Empty"), NbBundle.getMessage(CommitSettings.class, (String)"CTL_LoadTemplate_Title"), 0, 2, null, NotifyDescriptor.NO_OPTION);
                        if (DialogDisplayer.getDefault().notify(notifyDescriptor2) != NotifyDescriptor.YES_OPTION) {
                            return;
                        }
                    }
                    this.taMessage.setText(string);
                }
                catch (IOException iOException) {
                    if (bl) break block6;
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
            return;
        }
        if (!bl) {
            NotifyDescriptor notifyDescriptor3 = new NotifyDescriptor((Object)NbBundle.getMessage(CommitSettings.class, (String)"CTL_LoadTemplate_NoTemplate"), NbBundle.getMessage(CommitSettings.class, (String)"CTL_LoadTemplate_Title"), -1, 0, null, null);
            DialogDisplayer.getDefault().notify(notifyDescriptor3);
        }
    }

    private void onBrowseRecentMessages() {
        String string = StringSelector.select((String)NbBundle.getMessage(CommitSettings.class, (String)"CTL_RecentMessages_Prompt"), (String)NbBundle.getMessage(CommitSettings.class, (String)"CTL_RecentMessages_Title"), (List)Utils.getStringList((Preferences)CvsModuleConfig.getDefault().getPreferences(), (String)"commitAction.commitMessage"));
        if (string != null) {
            this.taMessage.replaceSelection(string);
        }
    }

    void setErrorLabel(String string) {
        this.errorLabel.setText(string);
        this.revalidate();
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.taMessage = new KTextArea();
        this.jLabel3 = new JLabel();
        this.errorLabel = new JLabel();
        this.messageErrorLabel = new JLabel();
        this.recentMessagesButton = new JButton();
        this.loadTemplateButton = new JButton();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 11));
        this.setLayout(new GridBagLayout());
        this.jLabel2.setLabelFor(this.taMessage);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/commit/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)resourceBundle.getString("CTL_CommitForm_Message"));
        this.jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.taMessage.setColumns(30);
        this.taMessage.setLineWrap(true);
        this.taMessage.setRows(6);
        this.taMessage.setTabSize(4);
        this.taMessage.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.taMessage);
        this.taMessage.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("TT_CommitForm_Message"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)resourceBundle.getString("CTL_CommitForm_FilesToCommit"));
        this.jLabel3.setBorder(BorderFactory.createEmptyBorder(12, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.errorLabel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.errorLabel, gridBagConstraints);
        this.messageErrorLabel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.messageErrorLabel, gridBagConstraints);
        this.recentMessagesButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/recent_messages.png")));
        this.recentMessagesButton.setToolTipText(NbBundle.getMessage(CommitSettings.class, (String)"CTL_CommitForm_RecentMessages"));
        this.recentMessagesButton.setBorderPainted(false);
        this.recentMessagesButton.setMargin(new Insets(2, 2, 2, 2));
        this.recentMessagesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CommitSettings.this.recentMessagesButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.recentMessagesButton, gridBagConstraints);
        this.loadTemplateButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/load_template.png")));
        this.loadTemplateButton.setToolTipText(NbBundle.getMessage(CommitSettings.class, (String)"TT_CommitForm_LoadTemplate"));
        this.loadTemplateButton.setBorderPainted(false);
        this.loadTemplateButton.setMargin(new Insets(2, 2, 2, 2));
        this.loadTemplateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CommitSettings.this.loadTemplateButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.loadTemplateButton, gridBagConstraints);
    }

    private void loadTemplateButtonActionPerformed(ActionEvent actionEvent) {
        this.loadTemplate(false);
    }

    private void recentMessagesButtonActionPerformed(ActionEvent actionEvent) {
        this.onBrowseRecentMessages();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
    }

    public void addVersioningListener(VersioningListener versioningListener) {
        this.listenerSupport.addListener(versioningListener);
    }

    public void removeVersioningListener(VersioningListener versioningListener) {
        this.listenerSupport.removeListener(versioningListener);
    }

    public static class CommitFile {
        private final CommitOptions options;
        private final CvsFileNode node;

        public CommitFile(CvsFileNode cvsFileNode, CommitOptions commitOptions) {
            this.node = cvsFileNode;
            this.options = commitOptions;
        }

        public CommitOptions getOptions() {
            return this.options;
        }

        public CvsFileNode getNode() {
            return this.node;
        }
    }
}

