/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.archive.project;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.j2ee.archive.Util;
import org.netbeans.modules.j2ee.archive.customizer.ProvidesCustomizer;
import org.netbeans.modules.j2ee.archive.project.ArchiveProjectOperations;
import org.netbeans.modules.j2ee.archive.project.ArchiveProjectProperties;
import org.netbeans.modules.j2ee.archive.project.ProvidesAction;
import org.netbeans.modules.j2ee.archive.project.ProvidesJ2eeModule;
import org.netbeans.modules.j2ee.archive.project.ProvidesLogicalView;
import org.netbeans.modules.j2ee.archive.project.UpdateHelper;
import org.netbeans.modules.j2ee.common.ui.BrokenServerSupport;
import org.netbeans.modules.j2ee.dd.api.application.DDProvider;
import org.netbeans.modules.j2ee.dd.api.application.Web;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleFactory;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleImplementation;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.netbeans.spi.project.support.LookupProviderSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.netbeans.spi.project.support.ant.ProjectXmlSavedHook;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.netbeans.spi.project.ui.support.UILookupMergerSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.NotImplementedException;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ArchiveProject
implements Project {
    private final AuxiliaryConfiguration aux;
    private final AntProjectHelper helper;
    private final PropertyEvaluator eval;
    private final GeneratedFilesHelper genFilesHelper;
    private final Lookup lookup;
    private ArchiveProjectProperties projProperties;
    private static final Icon ARCHIVE_PROJECT_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/j2ee/archive/project/resources/packaged_archive_16.png"));
    private final UpdateHelper updateHelper;
    private HashMap<String, String> nameMap;
    private static final String NAME_LIT = "name";

    public ArchiveProject(AntProjectHelper antProjectHelper) {
        this.helper = antProjectHelper;
        this.eval = antProjectHelper.getStandardPropertyEvaluator();
        this.aux = antProjectHelper.createAuxiliaryConfiguration();
        this.genFilesHelper = new GeneratedFilesHelper(antProjectHelper);
        this.lookup = new HelpfulLookup();
        this.updateHelper = new UpdateHelper(this, this.helper, this.aux, this.genFilesHelper, UpdateHelper.createDefaultNotifier());
        this.nameMap = new HashMap(5);
    }

    public FileObject getProjectDirectory() {
        return this.helper.getProjectDirectory();
    }

    public AntProjectHelper getAntProjectHelper() {
        return this.helper;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public PropertyEvaluator getPropertyEvaluator() {
        return this.eval;
    }

    public String getProjectProperty(String string) {
        return (String)this.getArchiveProjectProperties().get(string);
    }

    public String getEarPath(String string) {
        return this.nameMap.get(string);
    }

    public void setEarPath(String string, String string2) {
        this.nameMap.put(string, string2);
    }

    public void setName(final String string) {
        ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Object>(){

            public Object run() {
                Element element;
                Element element2 = ArchiveProject.this.helper.getPrimaryConfigurationData(true);
                NodeList nodeList = element2.getElementsByTagNameNS("http://www.netbeans.org/ns/archive-project/1", ArchiveProject.NAME_LIT);
                if (nodeList.getLength() == 1) {
                    element = (Element)nodeList.item(0);
                    NodeList nodeList2 = element.getChildNodes();
                    while (nodeList2.getLength() > 0) {
                        element.removeChild(nodeList2.item(0));
                    }
                } else {
                    element = element2.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/archive-project/1", ArchiveProject.NAME_LIT);
                    element2.insertBefore(element, element2.getChildNodes().item(0));
                }
                element.appendChild(element2.getOwnerDocument().createTextNode(string));
                ArchiveProject.this.helper.putPrimaryConfigurationData(element2, true);
                return null;
            }
        });
    }

    public String getName() {
        return (String)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String>(){

            public String run() {
                Element element = ArchiveProject.this.updateHelper.getPrimaryConfigurationData(true);
                NodeList nodeList = element.getElementsByTagNameNS("http://www.netbeans.org/ns/archive-project/1", ArchiveProject.NAME_LIT);
                if (nodeList.getLength() == 1 && (nodeList = nodeList.item(0).getChildNodes()).getLength() == 1 && nodeList.item(0).getNodeType() == 3) {
                    return ((Text)nodeList.item(0)).getNodeValue();
                }
                return "BINARCHIVE???";
            }
        });
    }

    public ArchiveProjectProperties getArchiveProjectProperties() {
        this.projProperties = new ArchiveProjectProperties(this, this.getAntProjectHelper());
        return this.projProperties;
    }

    public String getNamedProjectAttribute(final String string) {
        return (String)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String>(){

            public String run() {
                Element element = ArchiveProject.this.helper.getPrimaryConfigurationData(true);
                NodeList nodeList = element.getElementsByTagNameNS("http://www.netbeans.org/ns/archive-project/1", string);
                if (nodeList.getLength() == 1 && (nodeList = nodeList.item(0).getChildNodes()).getLength() == 1 && nodeList.item(0).getNodeType() == 3) {
                    return ((Text)nodeList.item(0)).getNodeValue();
                }
                return "???";
            }
        });
    }

    public void setNamedProjectAttribute(final String string, final String string2) {
        ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Object>(){

            public Object run() {
                Element element;
                Element element2 = ArchiveProject.this.helper.getPrimaryConfigurationData(true);
                NodeList nodeList = element2.getElementsByTagNameNS("http://www.netbeans.org/ns/archive-project/1", string);
                if (nodeList.getLength() == 1) {
                    element = (Element)nodeList.item(0);
                    NodeList nodeList2 = element.getChildNodes();
                    while (nodeList2.getLength() > 0) {
                        element.removeChild(nodeList2.item(0));
                    }
                } else {
                    element = element2.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/archive-project/1", string);
                    element2.insertBefore(element, element2.getChildNodes().item(0));
                }
                element.appendChild(element2.getOwnerDocument().createTextNode(string2));
                ArchiveProject.this.helper.putPrimaryConfigurationData(element2, true);
                return null;
            }
        });
    }

    private void doRegeneration() {
        String string;
        GeneratedFilesHelper generatedFilesHelper = new GeneratedFilesHelper(this.helper);
        ArchiveProjectProperties archiveProjectProperties = this.getArchiveProjectProperties();
        String string2 = this.eval.evaluate((String)archiveProjectProperties.get("source.archive"));
        try {
            if (string2.endsWith("war")) {
                generatedFilesHelper.refreshBuildScript("nbproject/build-impl.xml", ArchiveProject.class.getResource("resources/build-impl-war.xsl"), true);
            } else {
                generatedFilesHelper.refreshBuildScript("nbproject/build-impl.xml", ArchiveProject.class.getResource("resources/build-impl.xsl"), true);
            }
        }
        catch (IllegalStateException illegalStateException) {
            ErrorManager.getDefault().log(1, "IllegalStateException while opening project: " + illegalStateException);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().log(1, "IOException while opening project: " + iOException);
        }
        try {
            generatedFilesHelper.refreshBuildScript("build.xml", ArchiveProject.class.getResource("resources/build.xsl"), true);
        }
        catch (IllegalStateException illegalStateException) {
            ErrorManager.getDefault().log(1, "IllegalStateException while opening project: " + illegalStateException);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().log(1, "IOException while opening project: " + iOException);
        }
        String string3 = (String)archiveProjectProperties.get("j2ee.server.instance");
        J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(string3);
        if (j2eePlatform != null) {
            ArchiveProjectProperties.setServerInstance(this, this.helper, string3);
        } else {
            String[] stringArray;
            string = (String)archiveProjectProperties.get("j2ee.server.type");
            if (string != null && (stringArray = Deployment.getDefault().getInstancesOfServer(string)).length > 0) {
                ArchiveProjectProperties.setServerInstance(this, this.helper, stringArray[0]);
                j2eePlatform = Deployment.getDefault().getJ2eePlatform(stringArray[0]);
            }
            if (j2eePlatform == null) {
                BrokenServerSupport.showAlert();
            }
        }
        string = this.helper.getProjectDirectory();
        try {
            FileUtil.createFolder((FileObject)string, (String)"setup");
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().log(1, "Error while opening project: " + iOException);
        }
    }

    static /* synthetic */ PropertyEvaluator access$300(ArchiveProject archiveProject) {
        return archiveProject.eval;
    }

    class MyOpenHook {
        MyOpenHook() {
        }

        public void regenerateBuildFiles() {
            ArchiveProject.this.doRegeneration();
        }
    }

    private static final class RecommendedTemplatesImpl
    implements RecommendedTemplates,
    PrivilegedTemplates {
        private static final String[] APPLICATION_TYPES = new String[]{"sunresource-types", "XML", "simple-files"};
        private static final String[] PRIVILEGED_NAMES = new String[]{"Templates/SunResources/JDBC_Connection_Pool", "Templates/SunResources/JDBC_Resource", "Templates/SunResources/JMS_Resource", "Templates/SunResources/JavaMail_Resource", "Templates/Persistence/Schema.dbschema"};

        RecommendedTemplatesImpl() {
        }

        public String[] getRecommendedTypes() {
            return APPLICATION_TYPES;
        }

        public String[] getPrivilegedTemplates() {
            return PRIVILEGED_NAMES;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class J2eeModuleForAddModuleAction
    implements J2eeModuleImplementation {
        private Object mt = null;

        J2eeModuleForAddModuleAction(Object object) {
            this.mt = object;
        }

        public String getModuleVersion() {
            return "1.5";
        }

        public Object getModuleType() {
            return this.mt;
        }

        public String getUrl() {
            return null;
        }

        public void setUrl(String string) {
            throw new UnsupportedOperationException();
        }

        public FileObject getArchive() throws IOException {
            FileObject fileObject = ArchiveProject.this.getProjectDirectory().getFileObject("dist");
            FileObject[] fileObjectArray = fileObject.getChildren();
            FileObject fileObject2 = null;
            if (null != fileObjectArray && fileObjectArray.length == 1) {
                fileObject2 = fileObjectArray[0];
            } else if (null != fileObjectArray && fileObjectArray.length > 1) {
                for (FileObject fileObject3 : fileObjectArray) {
                    if (!fileObject3.isData() || !fileObject3.getNameExt().endsWith("ar")) continue;
                    fileObject2 = fileObject3;
                }
            }
            return fileObject2;
        }

        public Iterator getArchiveContents() throws IOException {
            throw new UnsupportedOperationException();
        }

        public FileObject getContentDirectory() throws IOException {
            return null;
        }

        public <T> MetadataModel<T> getMetadataModel(Class<T> clazz) {
            throw new NotImplementedException();
        }

        public File getResourceDirectory() {
            return new File(FileUtil.toFile((FileObject)ArchiveProject.this.getProjectDirectory()), "setup");
        }

        public File getDeploymentConfigurationFile(String string) {
            String string2 = (String)ArchiveProject.this.getArchiveProjectProperties().get("proxy.project.dir");
            FileObject fileObject = ArchiveProject.this.getProjectDirectory().getFileObject(string2).getFileObject("src").getFileObject("conf");
            int n = string.lastIndexOf("/");
            String string3 = -1 < n ? string.substring(n) : string;
            FileObject fileObject2 = fileObject.getFileObject(string3);
            File file = null == fileObject2 ? new File(FileUtil.toFile((FileObject)fileObject), string3) : FileUtil.toFile((FileObject)fileObject2);
            return file;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            throw new UnsupportedOperationException();
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            throw new UnsupportedOperationException();
        }
    }

    class ProjectXmlSaved
    extends ProjectXmlSavedHook {
        ProjectXmlSaved() {
        }

        protected void projectXmlSaved() throws IOException {
            FileObject fileObject = ArchiveProject.this.getProjectDirectory().getFileObject("tmpproj");
            if (fileObject != null) {
                Project project = null;
                try {
                    project = ProjectManager.getDefault().findProject(fileObject);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ErrorManager.getDefault().log(1, "" + illegalArgumentException);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().log(1, "" + iOException);
                }
                ProvidesJ2eeModule providesJ2eeModule = (ProvidesJ2eeModule)((Object)ArchiveProject.this.getLookup().lookup(ProvidesJ2eeModule.class));
                if (null != project) {
                    providesJ2eeModule.setServerInstanceID((String)ArchiveProject.this.getArchiveProjectProperties().get("j2ee.server.instance"));
                }
            }
        }
    }

    class OpenCloseHook
    extends ProjectOpenedHook {
        List<ClassPath[]> paths = new ArrayList<ClassPath[]>();

        OpenCloseHook() {
        }

        protected void projectOpened() {
            ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Object>(){

                public Object run() {
                    Object object;
                    ProvidesJ2eeModule providesJ2eeModule;
                    Project project;
                    ArchiveProject.this.doRegeneration();
                    FileObject fileObject = ArchiveProject.this.helper.getProjectDirectory();
                    ArchiveProjectProperties archiveProjectProperties = ArchiveProject.this.getArchiveProjectProperties();
                    String string = (String)archiveProjectProperties.get("javaee.archive.type");
                    boolean bl = "ear".equals(string);
                    FileObject fileObject2 = fileObject.getFileObject("tmpproj");
                    if (fileObject2 != null) {
                        project = null;
                        try {
                            project = ProjectManager.getDefault().findProject(fileObject2);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            ErrorManager.getDefault().log(1, "" + illegalArgumentException);
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().log(1, "" + iOException);
                        }
                        providesJ2eeModule = (ProvidesJ2eeModule)((Object)ArchiveProject.this.getLookup().lookup(ProvidesJ2eeModule.class));
                        if (null != project) {
                            J2eeModuleProvider j2eeModuleProvider;
                            object = new ArrayList();
                            FileObject fileObject3 = project.getProjectDirectory().getFileObject("src/java");
                            if (null != fileObject3) {
                                object.add(fileObject3);
                            }
                            if (null != (fileObject3 = project.getProjectDirectory().getFileObject("src/conf"))) {
                                object.add(fileObject3);
                            }
                            if (null != (fileObject3 = project.getProjectDirectory().getFileObject("web/WEB-INF/classes"))) {
                                object.add(fileObject3);
                            }
                            if (object.size() > 0) {
                                j2eeModuleProvider = ClassPathSupport.createClassPath((FileObject[])object.toArray(new FileObject[object.size()]));
                                ClassPath[] classPathArray = new ClassPath[]{j2eeModuleProvider};
                                GlobalPathRegistry.getDefault().register("classpath/source", classPathArray);
                                GlobalPathRegistry.getDefault().register("classpath/compile", classPathArray);
                                OpenCloseHook.this.paths.add(classPathArray);
                            }
                            j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
                            j2eeModuleProvider.getConfigSupport().ensureConfigurationReady();
                            providesJ2eeModule.setInner(j2eeModuleProvider);
                        } else {
                            object = bl ? J2eeModule.EAR : J2eeModule.CONN;
                            providesJ2eeModule.setJ2eeModule(J2eeModuleFactory.createJ2eeModule((J2eeModuleImplementation)new J2eeModuleForAddModuleAction(object)));
                            providesJ2eeModule.setServerInstanceID((String)archiveProjectProperties.get("j2ee.server.instance"));
                            if (bl) {
                                providesJ2eeModule.getConfigSupport().ensureConfigurationReady();
                            }
                        }
                    }
                    if (!bl) {
                        return null;
                    }
                    project = ArchiveProject.this.getProjectDirectory().getFileObject("nbproject").getFileObject("application.xml");
                    if (null != project) {
                        try {
                            providesJ2eeModule = DDProvider.getDefault().getDDRoot((FileObject)project);
                            object = providesJ2eeModule.getModule();
                            for (FileObject fileObject4 : object) {
                                String string2 = fileObject4.getEjb();
                                if (null != string2) {
                                    OpenCloseHook.this.openSubarchiveProject(string2);
                                    continue;
                                }
                                string2 = fileObject4.getJava();
                                if (null != string2) {
                                    OpenCloseHook.this.openSubarchiveProject(string2);
                                    continue;
                                }
                                string2 = fileObject4.getConnector();
                                if (null != string2) {
                                    OpenCloseHook.this.openSubarchiveProject(string2);
                                    continue;
                                }
                                Web web = fileObject4.getWeb();
                                if (null == web || null == (string2 = web.getWebUri())) continue;
                                OpenCloseHook.this.openSubarchiveProject(string2);
                            }
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().log(1, "" + iOException);
                        }
                    } else {
                        ErrorManager.getDefault().log(16, NbBundle.getMessage(ArchiveProject.class, (String)"WARN_EAR_ARCH_MISSING_APPLICATION_XML", (Object)ArchiveProject.this.getName()));
                    }
                    return null;
                }
            });
        }

        private void openSubarchiveProject(String string) throws IOException {
            block11: {
                FileObject fileObject = ArchiveProject.this.getProjectDirectory();
                FileObject fileObject2 = fileObject.getFileObject("subarchives");
                String string2 = Util.getKey(string);
                try {
                    FileObject fileObject3 = fileObject2.getFileObject(string2);
                    ArchiveProject.this.nameMap.put(string2, string);
                    FileObject fileObject4 = fileObject3.getFileObject("tmpproj");
                    Project project = ProjectManager.getDefault().findProject(fileObject4);
                    Project project2 = ProjectManager.getDefault().findProject(fileObject3);
                    MyOpenHook myOpenHook = (MyOpenHook)project2.getLookup().lookup(MyOpenHook.class);
                    myOpenHook.regenerateBuildFiles();
                    ProvidesJ2eeModule providesJ2eeModule = (ProvidesJ2eeModule)((Object)project2.getLookup().lookup(ProvidesJ2eeModule.class));
                    if (null != project) {
                        ClassPath[] classPathArray;
                        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
                        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
                        FileObject fileObject5 = project.getProjectDirectory().getFileObject("src/java");
                        if (null != fileObject5) {
                            arrayList.add(fileObject5);
                        }
                        if (null != (fileObject5 = project.getProjectDirectory().getFileObject("src/conf"))) {
                            arrayList.add(fileObject5);
                        }
                        if (null != (fileObject5 = project.getProjectDirectory().getFileObject("web/WEB-INF/classes"))) {
                            arrayList.add(fileObject5);
                        }
                        if (arrayList.size() > 0) {
                            ClassPath classPath = ClassPathSupport.createClassPath((FileObject[])arrayList.toArray(new FileObject[arrayList.size()]));
                            classPathArray = new ClassPath[]{classPath};
                            GlobalPathRegistry.getDefault().register("classpath/source", classPathArray);
                            GlobalPathRegistry.getDefault().register("classpath/compile", classPathArray);
                            this.paths.add(classPathArray);
                        }
                        try {
                            j2eeModuleProvider.getConfigSupport().ensureConfigurationReady();
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            classPathArray = project.getProjectDirectory();
                            if (null != classPathArray) {
                                ErrorManager.getDefault().log(1, project.getProjectDirectory().toString());
                            } else {
                                ErrorManager.getDefault().log(1, "null");
                            }
                            throw illegalArgumentException;
                        }
                        providesJ2eeModule.setInner(j2eeModuleProvider);
                        break block11;
                    }
                    Object object = J2eeModule.CONN;
                    providesJ2eeModule.setJ2eeModule(J2eeModuleFactory.createJ2eeModule((J2eeModuleImplementation)new J2eeModuleForAddModuleAction(object)));
                    providesJ2eeModule.setServerInstanceID((String)ArchiveProject.this.getArchiveProjectProperties().get("j2ee.server.instance"));
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().log(1, "" + iOException);
                }
            }
        }

        protected void projectClosed() {
            ArrayList<ClassPath[]> arrayList = new ArrayList<ClassPath[]>();
            for (ClassPath[] classPathArray : this.paths) {
                GlobalPathRegistry.getDefault().unregister("classpath/source", classPathArray);
                GlobalPathRegistry.getDefault().unregister("classpath/compile", classPathArray);
                arrayList.add(classPathArray);
            }
            for (ClassPath[] classPathArray : arrayList) {
                this.paths.remove(classPathArray);
            }
        }
    }

    private final class MyAntProvider
    implements AntArtifactProvider {
        private MyAntProvider() {
        }

        public AntArtifact[] getBuildArtifacts() {
            return new AntArtifact[]{ArchiveProject.this.helper.createSimpleAntArtifact("j2ee_ear_archive", "dist.archive", ArchiveProject.this.helper.getStandardPropertyEvaluator(), "dist", "clean")};
        }
    }

    private final class Info
    implements ProjectInformation {
        private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private WeakReference<String> cachedName = null;

        Info() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void firePropertyChange(String string) {
            this.pcs.firePropertyChange(string, null, null);
            PropertyChangeSupport propertyChangeSupport = this.pcs;
            synchronized (propertyChangeSupport) {
                this.cachedName = null;
            }
        }

        public String getName() {
            return PropertyUtils.getUsablePropertyName((String)this.getDisplayName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getDisplayName() {
            Object object;
            Object object2 = this.pcs;
            synchronized (object2) {
                if (this.cachedName != null && (object = (String)this.cachedName.get()) != null) {
                    return object;
                }
            }
            object2 = ArchiveProject.this.getNamedProjectAttribute(ArchiveProject.NAME_LIT);
            object = this.pcs;
            synchronized (object) {
                this.cachedName = new WeakReference<Object>(object2);
            }
            return object2;
        }

        public Icon getIcon() {
            return ARCHIVE_PROJECT_ICON;
        }

        public Project getProject() {
            return ArchiveProject.this;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class HelpfulLookup
    extends Lookup {
        private boolean verbose = Boolean.getBoolean("archiveproject.lookup.verbose");
        Lookup inner = LookupProviderSupport.createCompositeLookup((Lookup)Lookups.fixed((Object[])new Object[]{new Info(), ArchiveProject.access$100(ArchiveProject.this).createAuxiliaryConfiguration(), ArchiveProject.access$100(ArchiveProject.this).createCacheDirectoryProvider(), ArchiveProject.access$100(ArchiveProject.this).createGlobFileBuiltQuery(ArchiveProject.access$300(ArchiveProject.this), new String[]{"${src.dir}/*.java"}, new String[]{"${build.classes.dir}/*.class"}), ArchiveProject.access$100(ArchiveProject.this).createSharabilityQuery(ArchiveProject.access$300(ArchiveProject.this), new String[]{"${src.dir}"}, new String[]{"${build.dir}", "${dist.dir}", "${proxy.project.dir}"}), UILookupMergerSupport.createProjectOpenHookMerger((ProjectOpenedHook)new OpenCloseHook()), new ProvidesAction(ArchiveProject.this), new ProvidesLogicalView(ArchiveProject.this), ArchiveProject.access$100(ArchiveProject.this), new ProvidesJ2eeModule(ArchiveProject.access$100(ArchiveProject.this), ArchiveProject.this), new J2eeModuleForAddModuleAction(J2eeModule.EAR), new MyAntProvider(), new ProvidesCustomizer(ArchiveProject.this, ArchiveProject.access$100(ArchiveProject.this)), new RecommendedTemplatesImpl(), new ArchiveProjectOperations(ArchiveProject.this), ArchiveProject.this, new MyOpenHook(), new ProjectXmlSaved()}), (String)"Projects/org-netbeans-modules-j2ee-archiveproject/Lookup");

        private HelpfulLookup() {
        }

        public <T> Lookup.Item<T> lookupItem(Lookup.Template<T> template) {
            Lookup.Item item = this.inner.lookupItem(template);
            if (this.verbose && null == item && ErrorManager.getDefault().isNotifiable(4096)) {
                StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                ErrorManager.getDefault().log(4096, NbBundle.getMessage(ArchiveProject.class, (String)"LOOKUP_MISS", (Object)template.toString(), (Object)stackTraceElementArray[3], (Object)stackTraceElementArray[4]));
            }
            return item;
        }

        public <T> Lookup.Result<T> lookupResult(Class<T> clazz) {
            Lookup.Result result = this.inner.lookupResult(clazz);
            if (this.verbose && null == result && ErrorManager.getDefault().isNotifiable(4096)) {
                StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                ErrorManager.getDefault().log(4096, NbBundle.getMessage(ArchiveProject.class, (String)"LOOKUP_MISS", (Object)clazz.toString(), (Object)stackTraceElementArray[3], (Object)stackTraceElementArray[4]));
            }
            return result;
        }

        public <T> Collection<? extends T> lookupAll(Class<T> clazz) {
            Collection collection = this.inner.lookupAll(clazz);
            if (this.verbose && null == collection && ErrorManager.getDefault().isNotifiable(4096)) {
                StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                ErrorManager.getDefault().log(4096, NbBundle.getMessage(ArchiveProject.class, (String)"LOOKUP_MISS", (Object)clazz.toString(), (Object)stackTraceElementArray[3], (Object)stackTraceElementArray[4]));
            }
            return collection;
        }

        public <T> T lookup(Class<T> clazz) {
            Object object = this.inner.lookup(clazz);
            if (this.verbose && null == object && ErrorManager.getDefault().isNotifiable(4096)) {
                StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                ErrorManager.getDefault().log(4096, NbBundle.getMessage(ArchiveProject.class, (String)"LOOKUP_MISS", (Object)clazz.getName(), (Object)stackTraceElementArray[3], (Object)stackTraceElementArray[4]));
            }
            return (T)object;
        }

        public <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
            Lookup.Result result = this.inner.lookup(template);
            if (this.verbose && null == result && ErrorManager.getDefault().isNotifiable(4096)) {
                StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                ErrorManager.getDefault().log(4096, NbBundle.getMessage(ArchiveProject.class, (String)"LOOKUP_MISS", (Object)template.toString(), (Object)stackTraceElementArray[3], (Object)stackTraceElementArray[4]));
            }
            return result;
        }
    }
}

