/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.screen.resource;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.screen.resource.ScreenResourceCategoryDescriptor;
import org.netbeans.modules.vmd.api.screen.resource.ScreenResourceItemPresenter;
import org.netbeans.modules.vmd.screen.MainPanel;
import org.netbeans.modules.vmd.screen.ScreenAccessController;
import org.netbeans.modules.vmd.screen.resource.ResourceCategoryPanel;
import org.netbeans.modules.vmd.screen.resource.ResourcePanelSupport;

public class ResourcePanel
extends JPanel {
    private ScreenAccessController controller;
    private JPanel fillPanel;

    public ResourcePanel(ScreenAccessController screenAccessController) {
        this.controller = screenAccessController;
        this.setBackground(MainPanel.BACKGROUND_COLOR);
        this.setLayout(new GridBagLayout());
        this.fillPanel = new JPanel();
        this.fillPanel.setBackground(MainPanel.BACKGROUND_COLOR);
        this.fillPanel.setPreferredSize(new Dimension(250, 0));
    }

    public void reload() {
        DesignComponent designComponent = this.controller.getEditedScreen();
        Map<ScreenResourceCategoryDescriptor, ArrayList<ScreenResourceItemPresenter>> map = ResourcePanelSupport.getCategoryDescriptors(designComponent);
        ResourcePanelSupport.resolveResources(this.controller.getDocument(), designComponent, map);
        List<ScreenResourceCategoryDescriptor> list = ResourcePanelSupport.getSortedCategories(map.keySet());
        this.removeAll();
        int n = 0;
        for (ScreenResourceCategoryDescriptor screenResourceCategoryDescriptor : list) {
            ResourceCategoryPanel resourceCategoryPanel = new ResourceCategoryPanel(screenResourceCategoryDescriptor);
            resourceCategoryPanel.reload(map.get(screenResourceCategoryDescriptor));
            this.add((Component)resourceCategoryPanel, new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 20, 0), 0, 0));
        }
        this.add((Component)this.fillPanel, new GridBagConstraints(0, n, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }
}

