/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee.tomcat;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.integration.IntegrationUtils;
import org.netbeans.modules.profiler.attach.providers.TargetPlatformEnum;
import org.netbeans.modules.profiler.attach.providers.ValidationResult;
import org.netbeans.modules.profiler.attach.spi.IntegrationProvider;
import org.netbeans.modules.profiler.attach.spi.ModificationException;
import org.netbeans.modules.profiler.j2ee.tomcat.AbstractTomcatIntegrationProvider;
import org.openide.util.NbBundle;

public class Tomcat5IntegrationProvider
extends AbstractTomcatIntegrationProvider {
    private final String INTEGR_REVIEW_STEP1_WINEXE_MSG = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TomcatIntegrationProvider_IntegrReviewStep1WinExeMsg");
    private final String MANUAL_WINEXE_HINT_MSG = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TomcatIntegrationProvider_ManualWinExeHint");
    private final String PATH_TO_CATALINA_BASE_MSG = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TomcatIntegrationProvider_Catalina_Base_Hint");
    private final String TOMCAT_50_TITLE = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TomcatIntegrationProvider_Tomcat50String");

    public IntegrationProvider.IntegrationHints getIntegrationReview(AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints integrationHints;
        String string = attachSettings.getHostOS();
        if (this.isTomcatExeUsed(this.getInstallationPath())) {
            integrationHints = new IntegrationProvider.IntegrationHints();
            integrationHints.addStep(MessageFormat.format(this.INTEGR_REVIEW_STEP1_WINEXE_MSG, this.getModifiedScriptPath(string, true)));
            integrationHints.addStep(MessageFormat.format(INTEGR_REVIEW_STEP2_MSG, this.getChangedLines(string, attachSettings, this.getCatalinaBase(), false)));
        } else {
            integrationHints = super.getIntegrationReview(attachSettings);
        }
        return integrationHints;
    }

    public String getTitle() {
        return this.TOMCAT_50_TITLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(AttachSettings attachSettings) throws ModificationException {
        String string = attachSettings.getHostOS();
        if (this.isTomcatExeUsed(this.getInstallationPath())) {
            StringBuffer stringBuffer = this.getChangedLines(string, attachSettings, this.getCatalinaBase(), false);
            File file = new File(this.getModifiedScriptPath(string, false));
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                ((OutputStream)fileOutputStream).write(stringBuffer.toString().getBytes());
                fileOutputStream.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                try {
                    if (fileOutputStream != null) {
                        ((OutputStream)fileOutputStream).close();
                    }
                }
                catch (Exception exception) {}
            }
        } else {
            super.modify(attachSettings);
        }
    }

    public boolean supportsJVM(TargetPlatformEnum targetPlatformEnum) {
        return true;
    }

    public ValidationResult validateInstallation(String string, String string2) {
        ValidationResult validationResult = super.validateInstallation(string, string2);
        if (!validationResult.isValid() && this.isTomcatExeUsed(string2) && IntegrationUtils.isWindowsPlatform((String)string)) {
            validationResult = new ValidationResult(true, "No CATALINA script found. Using Tomcat5.exe instead");
        }
        return validationResult;
    }

    protected int getAttachWizardPriority() {
        return 11;
    }

    protected String getCatalinaScriptName() {
        return "catalina.50";
    }

    protected int getMagicNumber() {
        return 20;
    }

    protected IntegrationProvider.IntegrationHints getManualLocalDirectIntegrationStepsInstructions(String string, AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints integrationHints = super.getManualLocalDirectIntegrationStepsInstructions(string, attachSettings);
        this.addWinExeHint(integrationHints, string, attachSettings);
        return integrationHints;
    }

    protected IntegrationProvider.IntegrationHints getManualLocalDynamicIntegrationStepsInstructions(String string, AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints integrationHints = super.getManualLocalDynamicIntegrationStepsInstructions(string, attachSettings);
        this.addWinExeHint(integrationHints, string, attachSettings);
        return integrationHints;
    }

    protected IntegrationProvider.IntegrationHints getManualRemoteIntegrationStepsInstructions(String string, AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints integrationHints = super.getManualRemoteIntegrationStepsInstructions(string, attachSettings);
        this.addWinExeHint(integrationHints, string, attachSettings);
        return integrationHints;
    }

    private StringBuffer getChangedLines(String string, AttachSettings attachSettings, String string2, boolean bl) {
        String string3 = System.getProperty("file.separator");
        String string4 = "";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(IntegrationUtils.getAssignEnvVariableValueString((String)string, (String)"CATALINA_OPTS", (String)IntegrationUtils.getProfilerAgentCommandLineArgs((String)string, (String)this.getTargetJava(), (boolean)false, (int)attachSettings.getPort())));
        this.appendNewLine(bl, stringBuffer);
        if (string2 != null && string2.trim().length() > 0) {
            stringBuffer.append(IntegrationUtils.getAssignEnvVariableValueString((String)string, (String)"CATALINA_BASE", (String)this.getQuotedPath(string2)));
            this.appendNewLine(bl, stringBuffer);
            string4 = ";-Dcatalina.base=" + IntegrationUtils.getEnvVariableReference((String)"CATALINA_BASE", (String)string);
        }
        stringBuffer.append(this.getQuotedPath(this.getInstallationPath() + string3 + "bin" + string3 + "tomcat5.exe")).append(" //TS//Tomcat5 ");
        stringBuffer.append("--JavaHome=").append(this.getQuotedPath(this.getTargetJavaHome())).append(' ');
        stringBuffer.append("--JvmOptions %CATALINA_OPTS%").append(string4);
        return stringBuffer;
    }

    private String getQuotedPath(String string) {
        if (string.indexOf(32) > -1) {
            return "\"" + string + "\"";
        }
        return string;
    }

    private boolean isTomcatExeUsed(String string) {
        String string2 = System.getProperty("file.separator");
        File file = new File(string + string2 + "bin" + string2 + "tomcat5.exe");
        File file2 = new File(this.getScriptPath(IntegrationUtils.PLATFORM_WINDOWS_OS, false));
        return file.exists() && !file2.exists();
    }

    private void addWinExeHint(IntegrationProvider.IntegrationHints integrationHints, String string, AttachSettings attachSettings) {
        if (this.isTomcatExeUsed(this.getInstallationPath())) {
            integrationHints.addHint(MessageFormat.format(this.MANUAL_WINEXE_HINT_MSG, this.getScriptPath(string, true), this.getModifiedScriptPath(string, true), this.getChangedLines(string, attachSettings, this.PATH_TO_CATALINA_BASE_MSG, true)));
        }
    }

    private void appendNewLine(boolean bl, StringBuffer stringBuffer) {
        if (bl) {
            stringBuffer.append("<br>");
        } else {
            stringBuffer.append('\n');
        }
    }
}

