/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.FilteringPathResourceImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.project.LookupMerger;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ClassPathProviderMerger
implements LookupMerger<ClassPathProvider> {
    private final ClassPathProvider defaultProvider;

    ClassPathProviderMerger(ClassPathProvider classPathProvider) {
        assert (classPathProvider != null);
        this.defaultProvider = classPathProvider;
    }

    public Class<ClassPathProvider> getMergeableClass() {
        return ClassPathProvider.class;
    }

    public ClassPathProvider merge(Lookup lookup) {
        return new CPProvider(lookup);
    }

    static FilteringPathResourceImplementation getClassPathImplementation(ClassPath classPath) {
        return new ProxyFilteringCPI(classPath);
    }

    private static class ProxyFilteringCPI
    implements FilteringPathResourceImplementation {
        private ClassPath classpath;

        private ProxyFilteringCPI(ClassPath classPath) {
            this.classpath = classPath;
        }

        public boolean includes(URL uRL, String string) {
            for (ClassPath.Entry entry : this.classpath.entries()) {
                if (!entry.getURL().equals(uRL)) continue;
                return entry.includes(string);
            }
            return false;
        }

        public URL[] getRoots() {
            ArrayList<URL> arrayList = new ArrayList<URL>();
            for (ClassPath.Entry entry : this.classpath.entries()) {
                arrayList.add(entry.getURL());
            }
            return arrayList.toArray(new URL[arrayList.size()]);
        }

        public ClassPathImplementation getContent() {
            return null;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.classpath.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.classpath.removePropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ProxyClassPathImplementation
    implements ClassPathImplementation {
        private PathResourceImplementation[] classPaths;
        private List<PathResourceImplementation> resourcesCache;
        private ArrayList<PropertyChangeListener> listeners;
        private LookupListener lookupList;
        private Lookup.Result<ClassPathProvider> providers;
        private ClassPathProvider mainProvider;
        private PropertyChangeListener classPathsListener;
        private FileObject file;
        private String type;
        private boolean hasAny = false;

        public ProxyClassPathImplementation(ClassPathProvider classPathProvider, Lookup lookup, FileObject fileObject, String string) {
            assert (classPathProvider != null);
            this.type = string;
            this.file = fileObject;
            this.mainProvider = classPathProvider;
            this.providers = lookup.lookupResult(ClassPathProvider.class);
            this.classPathsListener = new DelegatesListener();
            this.checkProviders();
            this.lookupList = new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    ProxyClassPathImplementation.this.checkProviders();
                }
            };
            this.providers.addLookupListener(this.lookupList);
        }

        boolean hasAnyResults() {
            return this.hasAny;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkProviders() {
            this.hasAny = false;
            ArrayList<FilteringPathResourceImplementation> arrayList = new ArrayList<FilteringPathResourceImplementation>();
            ClassPath classPath = this.mainProvider.findClassPath(this.file, this.type);
            if (classPath != null) {
                this.hasAny = true;
                arrayList.add(ClassPathProviderMerger.getClassPathImplementation(classPath));
            }
            for (Object object : this.providers.allInstances()) {
                ClassPath classPath2 = object.findClassPath(this.file, this.type);
                if (classPath2 == null) continue;
                arrayList.add(ClassPathProviderMerger.getClassPathImplementation(classPath2));
                this.hasAny = true;
            }
            Object object = this;
            synchronized (object) {
                if (this.classPaths != null) {
                    for (PathResourceImplementation pathResourceImplementation : this.classPaths) {
                        pathResourceImplementation.removePropertyChangeListener(this.classPathsListener);
                    }
                }
                for (PathResourceImplementation pathResourceImplementation : arrayList) {
                    if (pathResourceImplementation == null) continue;
                    pathResourceImplementation.addPropertyChangeListener(this.classPathsListener);
                }
                this.classPaths = arrayList.toArray(new PathResourceImplementation[arrayList.size()]);
            }
            object = new PropertyChangeEvent(this, "resources", null, null);
            this.firePropertyChange((PropertyChangeEvent)object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<? extends PathResourceImplementation> getResources() {
            Object object = this;
            synchronized (object) {
                if (this.resourcesCache != null) {
                    return this.resourcesCache;
                }
            }
            object = new ArrayList(this.classPaths.length * 10);
            for (PathResourceImplementation pathResourceImplementation : this.classPaths) {
                ((ArrayList)object).add(pathResourceImplementation);
            }
            ProxyClassPathImplementation proxyClassPathImplementation = this;
            synchronized (proxyClassPathImplementation) {
                if (this.resourcesCache == null) {
                    this.resourcesCache = Collections.unmodifiableList(object);
                }
                return this.resourcesCache;
            }
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(propertyChangeListener);
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(propertyChangeListener);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("[");
            for (PathResourceImplementation pathResourceImplementation : this.classPaths) {
                stringBuilder.append(pathResourceImplementation.toString());
                stringBuilder.append(", ");
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
            PropertyChangeListener[] propertyChangeListenerArray = this;
            synchronized (this) {
                this.resourcesCache = null;
                if (this.listeners == null) {
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return;
                }
                PropertyChangeListener[] propertyChangeListenerArray2 = this.listeners.toArray(new PropertyChangeListener[this.listeners.size()]);
                // ** MonitorExit[var3_2] (shouldn't be in output)
                for (PropertyChangeListener propertyChangeListener : propertyChangeListenerArray2) {
                    propertyChangeListener.propertyChange(propertyChangeEvent);
                }
                return;
            }
        }

        private class DelegatesListener
        implements PropertyChangeListener {
            private DelegatesListener() {
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PropertyChangeEvent propertyChangeEvent2 = new PropertyChangeEvent(ProxyClassPathImplementation.this, propertyChangeEvent.getPropertyName(), null, null);
                ProxyClassPathImplementation.this.firePropertyChange(propertyChangeEvent2);
            }
        }
    }

    private class CPProvider
    implements ClassPathProvider {
        private final Lookup lookup;
        private final Map<FileObject, Map<String, ClassPath>> cpCache = new HashMap<FileObject, Map<String, ClassPath>>();

        public CPProvider(Lookup lookup) {
            assert (lookup != null);
            this.lookup = lookup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ClassPath findClassPath(FileObject fileObject, String string) {
            Object object;
            ClassPath classPath;
            Object object2 = this.cpCache;
            synchronized (object2) {
                classPath = this.cpCache.get(fileObject);
                if (classPath != null && (object = classPath.get(string)) != null) {
                    return object;
                }
            }
            object2 = new ProxyClassPathImplementation(ClassPathProviderMerger.this.defaultProvider, this.lookup, fileObject, string);
            if (!((ProxyClassPathImplementation)object2).hasAnyResults()) {
                return null;
            }
            classPath = ClassPathFactory.createClassPath((ClassPathImplementation)object2);
            object = this.cpCache;
            synchronized (object) {
                Map<String, ClassPath> map = this.cpCache.get(fileObject);
                if (map == null) {
                    map = new HashMap<String, ClassPath>();
                    this.cpCache.put(fileObject, map);
                }
                map.put(string, classPath);
            }
            return classPath;
        }
    }
}

