/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.project.runner;

import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;
import org.netbeans.spi.java.project.runner.ProjectRunnerImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public final class ProjectRunner {
    public static final String QUICK_RUN = "run";
    public static final String QUICK_DEBUG = "debug";
    public static final String QUICK_TEST = "junit";
    public static final String QUICK_TEST_DEBUG = "junit-debug";
    private static final Logger LOG = Logger.getLogger(ProjectRunner.class.getName());

    public static boolean isSupported(String string, FileObject fileObject) {
        Parameters.notNull((CharSequence)"command", (Object)string);
        Parameters.notNull((CharSequence)"toRun", (Object)fileObject);
        for (ProjectRunnerImplementation projectRunnerImplementation : Lookup.getDefault().lookupAll(ProjectRunnerImplementation.class)) {
            if (!projectRunnerImplementation.isSupported(string, fileObject)) continue;
            return true;
        }
        return false;
    }

    public static void execute(String string, Properties properties, FileObject fileObject) throws IOException {
        Parameters.notNull((CharSequence)"command", (Object)string);
        Parameters.notNull((CharSequence)"props", (Object)properties);
        Parameters.notNull((CharSequence)"toRun", (Object)fileObject);
        for (ProjectRunnerImplementation projectRunnerImplementation : Lookup.getDefault().lookupAll(ProjectRunnerImplementation.class)) {
            if (!projectRunnerImplementation.isSupported(string, fileObject)) continue;
            projectRunnerImplementation.execute(string, properties, fileObject);
            break;
        }
    }
}

