/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.gsp.editor;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.gsfret.InstantRenameAction;
import org.netbeans.modules.editor.html.HTMLKit;
import org.netbeans.modules.groovy.gsp.lexer.api.GspTokenId;
import org.netbeans.modules.gsf.DeleteToNextCamelCasePosition;
import org.netbeans.modules.gsf.DeleteToPreviousCamelCasePosition;
import org.netbeans.modules.gsf.GsfEditorKitFactory;
import org.netbeans.modules.gsf.NextCamelCasePosition;
import org.netbeans.modules.gsf.PreviousCamelCasePosition;
import org.netbeans.modules.gsf.SelectCodeElementAction;
import org.netbeans.modules.gsf.SelectNextCamelCasePosition;
import org.netbeans.modules.gsf.SelectPreviousCamelCasePosition;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GspKit
extends HTMLKit {
    static final long serialVersionUID = -1381945567613910297L;

    public HelpCtx getHelpCtx() {
        return new HelpCtx(GspKit.class);
    }

    public GspKit() {
        super("application/x-gsp");
    }

    public String getContentType() {
        return "application/x-gsp";
    }

    protected BaseKit.DeleteCharAction createDeletePrevAction() {
        return new GspDeleteCharAction("delete-previous", false, super.createDeletePrevAction());
    }

    protected ExtKit.ExtDefaultKeyTypedAction createDefaultKeyTypedAction() {
        return new GspDefaultKeyTypedAction(super.createDefaultKeyTypedAction());
    }

    protected Action[] createActions() {
        Action[] actionArray = super.createActions();
        return TextAction.augmentList(actionArray, new Action[]{new SelectCodeElementAction("select-element-next", true), new SelectCodeElementAction("select-element-previous", false), new NextCamelCasePosition(GsfEditorKitFactory.findAction((Action[])actionArray, (String)"caret-next-word")), new PreviousCamelCasePosition(GsfEditorKitFactory.findAction((Action[])actionArray, (String)"caret-previous-word")), new SelectNextCamelCasePosition(GsfEditorKitFactory.findAction((Action[])actionArray, (String)"selection-next-word")), new SelectPreviousCamelCasePosition(GsfEditorKitFactory.findAction((Action[])actionArray, (String)"selection-previous-word")), new DeleteToNextCamelCasePosition(GsfEditorKitFactory.findAction((Action[])actionArray, (String)"remove-word-next")), new DeleteToPreviousCamelCasePosition(GsfEditorKitFactory.findAction((Action[])actionArray, (String)"remove-word-previous")), new InstantRenameAction()});
    }

    private boolean handleDeletion(BaseDocument baseDocument, int n) {
        if (n > 0) {
            try {
                char c = baseDocument.getText(n - 1, 1).charAt(0);
                if (c == '%') {
                    Token token;
                    TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
                    TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
                    tokenSequence.move(n);
                    if (tokenSequence.movePrevious() && (token = tokenSequence.token()).id() == GspTokenId.DELIMITER && tokenSequence.offset() + token.length() == n && tokenSequence.moveNext() && (token = tokenSequence.token()).id() == GspTokenId.DELIMITER && tokenSequence.offset() == n) {
                        baseDocument.remove(n - 1, 1 + token.length());
                        return true;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
        return false;
    }

    private boolean handleInsertion(BaseDocument baseDocument, Caret caret, char c) {
        int n = caret.getDot();
        if (c == ' ' && n >= 2) {
            try {
                String string = baseDocument.getText(n - 2, 2);
                if ("%=".equals(string) && n >= 3) {
                    string = baseDocument.getText(n - 3, 3);
                }
                if ("<%".equals(string) || "<%=".equals(string)) {
                    baseDocument.insertString(n, "  ", null);
                    caret.setDot(n + 1);
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            return false;
        }
        if (n > 0 && (c == '%' || c == '>')) {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
            tokenSequence.move(n);
            try {
                if (tokenSequence.moveNext() || tokenSequence.movePrevious()) {
                    String string;
                    Token token = tokenSequence.token();
                    if (token.id() == GspTokenId.HTML && baseDocument.getText(n - 1, 1).charAt(0) == '<') {
                        int n2 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)n, (int)Utilities.getRowEnd((BaseDocument)baseDocument, (int)n));
                        if (n2 == -1) {
                            baseDocument.insertString(n, "%%>", null);
                            caret.setDot(n + 1);
                            return true;
                        }
                    } else if (token.id() == GspTokenId.DELIMITER) {
                        int n3;
                        String string2 = ((Object)token.text()).toString();
                        if (string2.endsWith("%>")) {
                            int n4 = c == '%' ? n : n - 1;
                            CharSequence charSequence = DocumentUtilities.getText((Document)baseDocument, (int)n4, (int)2);
                            if (CharSequenceUtilities.textEquals((CharSequence)charSequence, (CharSequence)"%>")) {
                                caret.setDot(n + 1);
                                return true;
                            }
                        } else if (string2.endsWith("<") && (n3 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)n, (int)Utilities.getRowEnd((BaseDocument)baseDocument, (int)n))) == -1) {
                            baseDocument.insertString(n, "%%>", null);
                            caret.setDot(n + 1);
                            return true;
                        }
                    } else if ((token.id() == GspTokenId.GROOVY || token.id() == GspTokenId.GROOVY_EXPR && n >= 1 && n <= baseDocument.getLength() - 3) && "% %>".equals(string = baseDocument.getText(n - 1, 4))) {
                        baseDocument.remove(n - 1, 2);
                        caret.setDot(n + 1);
                        return true;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
        return false;
    }

    public Object clone() {
        return new GspKit();
    }

    private static Token<?> getToken(BaseDocument baseDocument, int n, boolean bl) {
        TokenSequence tokenSequence;
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
        TokenSequence tokenSequence2 = tokenHierarchy.tokenSequence();
        tokenSequence2.move(n);
        if (!tokenSequence2.moveNext() && !tokenSequence2.movePrevious()) {
            return null;
        }
        if (bl && (tokenSequence = tokenSequence2.embedded()) != null) {
            tokenSequence.move(n);
            if (tokenSequence.moveNext() || tokenSequence.movePrevious()) {
                return tokenSequence.token();
            }
        }
        return tokenSequence2.token();
    }

    private class GspDeleteCharAction
    extends ExtKit.ExtDeleteCharAction {
        private BaseKit.DeleteCharAction htmlAction;

        public GspDeleteCharAction(String string, boolean bl, BaseKit.DeleteCharAction deleteCharAction) {
            super(string, bl);
            this.htmlAction = deleteCharAction;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            int n;
            Caret caret = jTextComponent.getCaret();
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            if (GspKit.this.handleDeletion(baseDocument, n = caret.getDot())) {
                return;
            }
            this.htmlAction.actionPerformed(actionEvent, jTextComponent);
        }
    }

    private class GspDefaultKeyTypedAction
    extends ExtKit.ExtDefaultKeyTypedAction {
        private ExtKit.ExtDefaultKeyTypedAction htmlAction;

        GspDefaultKeyTypedAction(ExtKit.ExtDefaultKeyTypedAction extDefaultKeyTypedAction) {
            this.htmlAction = extDefaultKeyTypedAction;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            char c;
            Caret caret = jTextComponent.getCaret();
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            String string = actionEvent.getActionCommand();
            if (string.length() > 0 && GspKit.this.handleInsertion(baseDocument, caret, c = string.charAt(0))) {
                return;
            }
            this.htmlAction.actionPerformed(actionEvent, jTextComponent);
        }
    }
}

