/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.ui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.Scrollable;
import org.netbeans.modules.welcome.content.BackgroundPanel;
import org.netbeans.modules.welcome.content.Constants;
import org.openide.util.Utilities;

abstract class AbstractTab
extends BackgroundPanel
implements Scrollable,
Constants {
    private boolean initialized = false;
    private Image bottomGradient = Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/bottom_gradient.png");

    public AbstractTab() {
        super(new BorderLayout());
    }

    public void addNotify() {
        super.addNotify();
        if (!this.initialized) {
            this.buildContent();
            this.initialized = true;
        }
    }

    protected abstract void buildContent();

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (null != this.getParent() && this.getParent().getHeight() > 0 && this.getParent().getHeight() > dimension.height) {
            dimension.height = this.getParent().getHeight();
        }
        if (null != this.getParent() && this.getParent().getWidth() > 0) {
            if (dimension.width > this.getParent().getWidth()) {
                dimension.width = Math.max(this.getParent().getWidth(), 600 + (int)((double)(FONT_SIZE - 11) / 11.0 * 600.0));
            } else if (dimension.width < this.getParent().getWidth()) {
                dimension.width = this.getParent().getWidth();
            }
        }
        return dimension;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return Constants.FONT_SIZE;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return 30 * Constants.FONT_SIZE;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    protected void paintComponent(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getBottomStripeOrigin();
        int n3 = this.bottomGradient.getHeight(null);
        int n4 = this.bottomGradient.getWidth(null);
        for (int i = 0; i <= n / n4; ++i) {
            graphics.drawImage(this.bottomGradient, i * n4, n2 - n3, null);
        }
    }

    protected abstract int getBottomStripeOrigin();
}

