/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.test.ui.wizards;

import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.compapp.test.ui.wizards.NewTestcaseConstants;
import org.netbeans.modules.compapp.test.ui.wizards.NewTestcaseNameVisualPanel;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class NewTestcaseNameWizardPanel
implements WizardDescriptor.ValidatingPanel,
NewTestcaseConstants {
    private static final Logger mLog = Logger.getLogger("org.netbeans.modules.compapp.test.ui.wizards.NewTestcaseNameWizardPanel");
    private NewTestcaseNameVisualPanel mComponent;
    protected FileObject mTestDir;
    private String mTestcaseName;
    private WizardDescriptor wiz;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public NewTestcaseNameWizardPanel(FileObject fileObject) {
        this.mTestDir = fileObject;
    }

    public Component getComponent() {
        if (this.mComponent == null) {
            String string;
            this.mComponent = new NewTestcaseNameVisualPanel(this);
            String string2 = string = NbBundle.getMessage(NewTestcaseNameWizardPanel.class, (String)"LBL_New_Testcase_Name");
            int n = 1;
            while (this.mTestDir.getFileObject(string2 = string + n) != null) {
                ++n;
            }
            this.mTestcaseName = string2;
            this.mComponent.getTestcaseNameTf().setText(this.mTestcaseName);
        }
        return this.mComponent;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        return this.mComponent.valid(this.wiz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> iterator;
        Object object = this.listeners;
        synchronized (object) {
            iterator = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        object = new ChangeEvent(this);
        while (iterator.hasNext()) {
            iterator.next().stateChanged((ChangeEvent)object);
        }
    }

    public void readSettings(Object object) {
        this.wiz = (WizardDescriptor)object;
        String string = (String)this.wiz.getProperty("TestcaseName");
        if (string != null) {
            this.mTestcaseName = string;
        }
    }

    public void storeSettings(Object object) {
        this.wiz = (WizardDescriptor)object;
        this.wiz.putProperty("TestcaseName", (Object)this.mComponent.getTestcaseName());
        mLog.info("Writing Testcase name to WizardDescriptor: " + this.mComponent.getTestcaseName());
    }

    public void validate() throws WizardValidationException {
        String string = this.mComponent.getTestcaseName();
        if (string == null || string.trim().equals("")) {
            String string2 = NbBundle.getMessage(NewTestcaseNameWizardPanel.class, (String)"LBL_Testcase_name_cannot_be_empty");
            throw new WizardValidationException((JComponent)this.mComponent.getTestcaseNameTf(), string2, string2);
        }
        if (this.mTestDir.getFileObject(string) != null) {
            String string3 = NbBundle.getMessage(NewTestcaseNameWizardPanel.class, (String)"LBL_Name_is_already_used_by_another_testcase");
            throw new WizardValidationException((JComponent)this.mComponent.getTestcaseNameTf(), string3, string3);
        }
    }

    private boolean isEmptyName() {
        return this.mTestcaseName.trim().length() != 0;
    }
}

