/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.test.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.netbeans.modules.compapp.projects.jbi.JbiProject;
import org.netbeans.modules.compapp.test.ui.TestCaseInputNode;
import org.netbeans.modules.compapp.test.ui.TestCaseOutputNode;
import org.netbeans.modules.compapp.test.ui.TestCaseResultNode;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class TestcaseChildren
extends Children.Keys
implements PropertyChangeListener {
    private JbiProject mProject;
    private FileObject mTestcaseDir;

    public TestcaseChildren(JbiProject jbiProject, FileObject fileObject) {
        this.mProject = jbiProject;
        this.mTestcaseDir = fileObject;
    }

    protected void addNotify() {
        super.addNotify();
        this.updateKeys();
    }

    private void updateKeys() {
        FileObject fileObject;
        FileObject fileObject2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        FileObject fileObject3 = this.mTestcaseDir.getFileObject("Input.xml");
        if (fileObject3 != null) {
            arrayList.add(fileObject3);
        }
        if ((fileObject2 = this.mTestcaseDir.getFileObject("Output.xml")) != null) {
            arrayList.add(fileObject2);
        }
        if ((fileObject = this.getRealTestCaseResultsFolder()) != null) {
            FileObject[] fileObjectArray = fileObject.getChildren();
            ArrayList<FileObject> arrayList2 = new ArrayList<FileObject>();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                FileObject fileObject4 = fileObjectArray[i];
                if (!TestcaseChildren.isValidTestCaseResult(fileObject4)) continue;
                arrayList2.add(fileObject4);
            }
            Collections.sort(arrayList2, new Comparator(){

                public int compare(Object object, Object object2) {
                    if (object instanceof FileObject && object2 instanceof FileObject) {
                        FileObject fileObject = (FileObject)object;
                        FileObject fileObject2 = (FileObject)object2;
                        return fileObject2.getName().compareTo(fileObject.getName());
                    }
                    return 0;
                }
            });
            arrayList.addAll(arrayList2);
        }
        this.setKeys(arrayList);
    }

    private static boolean isValidTestCaseResult(FileObject fileObject) {
        if (fileObject.isFolder()) {
            return false;
        }
        String string = fileObject.getNameExt();
        return string.matches("^Actual_\\d{14}(_[FS])?.xml$");
    }

    private FileObject getRealTestCaseResultsFolder() {
        FileObject fileObject;
        FileObject fileObject2 = null;
        String string = this.mTestcaseDir.getName();
        FileObject fileObject3 = this.mProject.getTestDirectory();
        if (fileObject3 != null && (fileObject = fileObject3.getFileObject("results")) != null) {
            fileObject2 = fileObject.getFileObject(string);
        }
        return fileObject2;
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
        super.removeNotify();
    }

    protected Node[] createNodes(Object object) {
        FileObject fileObject = (FileObject)object;
        try {
            DataObject dataObject = DataFolder.find((FileObject)fileObject);
            String string = fileObject.getName();
            if (string.equals("Input")) {
                return new Node[]{new TestCaseInputNode(this.mProject, dataObject)};
            }
            if (string.equals("Output")) {
                return new Node[]{new TestCaseOutputNode(this.mProject, dataObject)};
            }
            return new Node[]{new TestCaseResultNode(this.mProject, dataObject)};
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return new Node[0];
        }
    }

    public void modelChanged(Object object) {
        this.updateKeys();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateKeys();
    }
}

