/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.test.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.netbeans.modules.compapp.projects.jbi.JbiProject;
import org.netbeans.modules.compapp.test.ui.TestcaseNode;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class TestChildren
extends Children.Keys
implements PropertyChangeListener {
    private final FileObject mTestDir;
    private final JbiProject mProject;
    private static final String[] TEST_PROPERTY_FILES = new String[]{"Invoke.properties", "Concurrent.properties", "Correlation.properties"};

    public TestChildren(JbiProject jbiProject, FileObject fileObject) {
        this.mProject = jbiProject;
        this.mTestDir = fileObject;
    }

    protected void addNotify() {
        super.addNotify();
        this.updateKeys();
    }

    private static boolean isTest(FileObject fileObject) {
        if (!fileObject.isFolder()) {
            return false;
        }
        for (int i = 0; i < TEST_PROPERTY_FILES.length; ++i) {
            FileObject fileObject2 = fileObject.getFileObject(TEST_PROPERTY_FILES[i]);
            if (fileObject2 == null) continue;
            return true;
        }
        return false;
    }

    private void updateKeys() {
        ArrayList<FileObject> arrayList = Collections.EMPTY_LIST;
        FileObject[] fileObjectArray = this.mTestDir.getChildren();
        arrayList = new ArrayList<FileObject>();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            if (!TestChildren.isTest(fileObjectArray[i])) continue;
            arrayList.add(fileObjectArray[i]);
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((FileObject)object).getName().compareTo(((FileObject)object2).getName());
            }

            public boolean equals(Object object) {
                return this == object;
            }
        });
        this.setKeys(arrayList);
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
        super.removeNotify();
    }

    protected Node[] createNodes(Object object) {
        FileObject fileObject = (FileObject)object;
        return new Node[]{new TestcaseNode(this.mProject, fileObject)};
    }

    public void modelChanged(Object object) {
        this.updateKeys();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateKeys();
    }
}

