/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.jbi.ui.actions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.compapp.javaee.sunresources.SunResourcesUtil;
import org.netbeans.modules.compapp.projects.jbi.CasaHelper;
import org.netbeans.modules.compapp.projects.jbi.ComponentHelper;
import org.netbeans.modules.compapp.projects.jbi.JbiProject;
import org.netbeans.modules.compapp.projects.jbi.JbiSubprojectProvider;
import org.netbeans.modules.compapp.projects.jbi.ProjectPropertyProvider;
import org.netbeans.modules.compapp.projects.jbi.api.JbiProjectConstants;
import org.netbeans.modules.compapp.projects.jbi.ui.customizer.AntArtifactChooser;
import org.netbeans.modules.compapp.projects.jbi.ui.customizer.JbiProjectProperties;
import org.netbeans.modules.compapp.projects.jbi.ui.customizer.VisualClassPathItem;
import org.netbeans.spi.project.ui.support.ProjectActionPerformer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddProjectAction
implements ProjectActionPerformer {
    private List<String> javaeeAntArtifactTypes = new ArrayList<String>();
    private String descEjbProjectsOnly = "EJB projects only";
    private String descWebProjectsOnly = "Web projects only";
    private String descEarProjectsOnly = "Ear projects only";
    private static final String STR_EJB_PROJECT = "EjbJarProject";
    private static final String STR_WEB_PROJECT = "WebProject";
    private static final String STR_EAR_PROJECT = "EarProject";
    private static final String EJB_PROJ_DESC = "descEjbProject";
    private static final String WEB_PROJ_DESC = "descWebProject";
    private static final String EAR_PROJ_DESC = "descEarProject";

    public AddProjectAction() {
        this.init();
    }

    private void init() {
        this.javaeeAntArtifactTypes.addAll(JbiProjectConstants.JAVA_EE_AA_TYPES);
        this.javaeeAntArtifactTypes.add("CAPS.asa");
        ResourceBundle resourceBundle = NbBundle.getBundle(this.getClass());
        this.descEjbProjectsOnly = resourceBundle.getString(EJB_PROJ_DESC);
        this.descWebProjectsOnly = resourceBundle.getString(WEB_PROJ_DESC);
    }

    public boolean enable(Project project) {
        return true;
    }

    public void perform(Project project) {
        AntArtifact[] antArtifactArray;
        CasaHelper.saveCasa((JbiProject)project);
        JbiProjectProperties jbiProjectProperties = ((ProjectPropertyProvider)project).getProjectProperties();
        List list = (List)jbiProjectProperties.get("jbi.content.additional");
        for (int i = 0; i < list.size(); ++i) {
            antArtifactArray = (AntArtifact[])list.get(i);
            String string = antArtifactArray.getProjectName();
            if (!string.equals("")) continue;
            String string2 = NbBundle.getMessage(AddProjectAction.class, (String)"MSG_ResolveBrokenReference");
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        ArrayList<FileFilter> arrayList = new ArrayList<FileFilter>();
        arrayList.add(new EJBArtifactsFilter());
        arrayList.add(new WebAppArtifactsFilter());
        arrayList.add(new EarArtifactsFilter());
        antArtifactArray = AntArtifactChooser.showDialog(this.javaeeAntArtifactTypes, project, arrayList, null);
        if (antArtifactArray != null) {
            for (int i = 0; i < antArtifactArray.length; ++i) {
                this.addProject(project, antArtifactArray[i]);
            }
        }
    }

    public boolean addProject(Project project, AntArtifact antArtifact) {
        String string;
        Object object2;
        JbiProjectProperties jbiProjectProperties = ((ProjectPropertyProvider)project).getProjectProperties();
        List list = (List)jbiProjectProperties.get("meta.inf");
        List list2 = (List)jbiProjectProperties.get("jbi.content.additional");
        if (list == null || list.size() < 1) {
            return false;
        }
        VisualClassPathItem visualClassPathItem = new VisualClassPathItem(antArtifact, 2, null, antArtifact.getArtifactLocations()[0].toString(), true);
        String string2 = visualClassPathItem.getProjectName();
        for (Object object2 : list2) {
            string = ((VisualClassPathItem)object2).getProjectName();
            if (!string.equals(string2)) continue;
            String string3 = NbBundle.getMessage(AddProjectAction.class, (String)"MSG_DuplicateJBIModule", (Object)string2);
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string3, 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return false;
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(visualClassPathItem);
        arrayList.addAll(list2);
        object2 = (List)jbiProjectProperties.get("jbi.content.component");
        string = visualClassPathItem.getAsaType();
        ComponentHelper componentHelper = new ComponentHelper(project);
        String string4 = componentHelper.getDefaultTarget(string);
        if (string4 == null) {
            String string5 = NbBundle.getMessage(AddProjectAction.class, (String)"MSG_UnknownJBIModuleType", (Object)string2, (Object)string);
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string5, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return false;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(string4);
        arrayList2.addAll((Collection<String>)object2);
        jbiProjectProperties.put("jbi.content.additional", arrayList);
        this.storeJavaEEJarList(jbiProjectProperties, arrayList);
        jbiProjectProperties.put("jbi.content.component", arrayList2);
        jbiProjectProperties.store();
        SunResourcesUtil.addJavaEEResourceMetaData(project, antArtifact);
        Project project2 = antArtifact.getProject();
        ((JbiSubprojectProvider)project.getLookup().lookup(JbiSubprojectProvider.class)).subprojectAdded(project2);
        return true;
    }

    private void storeJavaEEJarList(JbiProjectProperties jbiProjectProperties, List<VisualClassPathItem> list) {
        if (list != null) {
            ArrayList<VisualClassPathItem> arrayList = new ArrayList<VisualClassPathItem>();
            VisualClassPathItem visualClassPathItem2 = null;
            for (VisualClassPathItem visualClassPathItem2 : list) {
                if (!(visualClassPathItem2.getObject() instanceof AntArtifact) || !VisualClassPathItem.isJavaEEProjectAntArtifact((AntArtifact)visualClassPathItem2.getObject())) continue;
                arrayList.add(visualClassPathItem2);
            }
            if (arrayList.size() > 0) {
                jbiProjectProperties.put("jbi.content.javaee.jars", arrayList);
            }
        }
    }

    public class EarArtifactsFilter
    extends FileFilter {
        public boolean accept(File file) {
            block7: {
                if (file == null) {
                    return false;
                }
                if (!file.isDirectory()) {
                    return false;
                }
                try {
                    FileObject fileObject = FileUtil.toFileObject((File)file);
                    if (fileObject == null) break block7;
                    Project project = ProjectManager.getDefault().findProject(fileObject);
                    if (project != null) {
                        Lookup lookup = project.getLookup();
                        Class<?> clazz = project.getClass();
                        if (clazz.getName().indexOf(AddProjectAction.STR_EAR_PROJECT) != -1) {
                            return true;
                        }
                        break block7;
                    }
                    return true;
                }
                catch (IOException iOException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return false;
        }

        public String getDescription() {
            return AddProjectAction.this.descEarProjectsOnly;
        }
    }

    public class WebAppArtifactsFilter
    extends FileFilter {
        public boolean accept(File file) {
            block7: {
                if (file == null) {
                    return false;
                }
                if (!file.isDirectory()) {
                    return false;
                }
                try {
                    FileObject fileObject = FileUtil.toFileObject((File)file);
                    if (fileObject == null) break block7;
                    Project project = ProjectManager.getDefault().findProject(fileObject);
                    if (project != null) {
                        Lookup lookup = project.getLookup();
                        Class<?> clazz = project.getClass();
                        if (clazz.getName().indexOf(AddProjectAction.STR_WEB_PROJECT) != -1) {
                            return true;
                        }
                        break block7;
                    }
                    return true;
                }
                catch (IOException iOException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return false;
        }

        public String getDescription() {
            return AddProjectAction.this.descWebProjectsOnly;
        }
    }

    public class EJBArtifactsFilter
    extends FileFilter {
        public boolean accept(File file) {
            block7: {
                if (file == null) {
                    return false;
                }
                if (!file.isDirectory()) {
                    return false;
                }
                try {
                    FileObject fileObject = FileUtil.toFileObject((File)file);
                    if (fileObject == null) break block7;
                    Project project = ProjectManager.getDefault().findProject(fileObject);
                    if (project != null) {
                        Lookup lookup = project.getLookup();
                        Class<?> clazz = project.getClass();
                        if (clazz.getName().indexOf(AddProjectAction.STR_EJB_PROJECT) != -1) {
                            return true;
                        }
                        break block7;
                    }
                    return true;
                }
                catch (IOException iOException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return false;
        }

        public String getDescription() {
            return AddProjectAction.this.descEjbProjectsOnly;
        }
    }
}

