/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.jbi.ui;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.compapp.projects.jbi.CasaHelper;
import org.netbeans.modules.compapp.projects.jbi.JbiProject;
import org.netbeans.modules.compapp.projects.jbi.ui.customizer.JbiJarCustomizer;
import org.netbeans.modules.compapp.projects.jbi.ui.customizer.JbiProjectProperties;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class JbiCustomizerProvider
implements CustomizerProvider {
    private static final int OPTION_OK = 0;
    private static final int OPTION_CANCEL = 1;
    private static final String COMMAND_OK = "OK";
    private static final String COMMAND_CANCEL = "CANCEL";
    private final JbiProject project;
    private final AntProjectHelper antProjectHelper;
    private final ReferenceHelper refHelper;
    private JbiProjectProperties webProperties;

    public JbiCustomizerProvider(JbiProject jbiProject, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
        this.project = jbiProject;
        this.antProjectHelper = antProjectHelper;
        this.refHelper = referenceHelper;
    }

    public void showCustomizer() {
        Object[] objectArray = new JButton[]{new JButton(NbBundle.getMessage(JbiCustomizerProvider.class, (String)"LBL_Customizer_Ok_Option")), new JButton(NbBundle.getMessage(JbiCustomizerProvider.class, (String)"LBL_Customizer_Cancel_Option"))};
        objectArray[0].setActionCommand(COMMAND_OK);
        objectArray[1].setActionCommand(COMMAND_CANCEL);
        objectArray[0].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JbiCustomizerProvider.class, (String)"AD_Customizer_Ok_Option"));
        objectArray[1].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JbiCustomizerProvider.class, (String)"AD_Customizer_Cancel_Option"));
        this.webProperties = new JbiProjectProperties(this.project, this.antProjectHelper, this.refHelper);
        OptionListener optionListener = new OptionListener(this.project, this.webProperties);
        objectArray[0].addActionListener(optionListener);
        objectArray[1].addActionListener(optionListener);
        CasaHelper.saveCasa(this.project);
        JbiJarCustomizer jbiJarCustomizer = new JbiJarCustomizer(this.webProperties);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jbiJarCustomizer, MessageFormat.format(NbBundle.getMessage(JbiCustomizerProvider.class, (String)"LBL_Customizer_Title"), ProjectUtils.getInformation((Project)this.project).getDisplayName()), false, objectArray, (Object)objectArray[0], 0, null, null);
        jbiJarCustomizer.setDialogDescriptor(dialogDescriptor);
        dialogDescriptor.setClosingOptions(new Object[]{objectArray[0], objectArray[1]});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
    }

    private static class OptionListener
    implements ActionListener {
        private Project project;
        private JbiProjectProperties webProperties;

        OptionListener(Project project, JbiProjectProperties jbiProjectProperties) {
            this.project = project;
            this.webProperties = jbiProjectProperties;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (JbiCustomizerProvider.COMMAND_OK.equals(string)) {
                this.webProperties.store();
                try {
                    ProjectManager.getDefault().saveProject(this.project);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }
    }
}

