/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.javaee.annotation.handler;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Logger;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.ClassName;
import org.netbeans.modules.compapp.javaee.annotation.handler.ClassFileLoader;
import org.netbeans.modules.compapp.javaee.annotation.handler.JarClassFileLoader;
import org.netbeans.modules.compapp.javaee.util.ProjectUtil;

public class JarInJarClassFileLoader
implements ClassFileLoader {
    private URL jarInJarUrl;
    private String rootClassDir;
    private Logger logger = Logger.getLogger(JarClassFileLoader.class.getName());

    public JarInJarClassFileLoader(URL uRL, String string) {
        this.jarInJarUrl = uRL;
        this.rootClassDir = string;
    }

    private String getClassPath(ClassName className) {
        String string = className.getExternalName(true).replaceAll("\\.", "\\/");
        string = string + ".class";
        return string;
    }

    private String getClassPath(String string) {
        return this.getClassPath(ClassName.getClassName((String)string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassFile loadClassFileFor(String string) throws IOException {
        ClassFile classFile = null;
        JarURLConnection jarURLConnection = null;
        JarInputStream jarInputStream = null;
        InputStream inputStream = null;
        URLConnection uRLConnection = this.jarInJarUrl.openConnection();
        try {
            if (uRLConnection instanceof JarURLConnection) {
                jarURLConnection = (JarURLConnection)uRLConnection;
                inputStream = jarURLConnection.getInputStream();
                jarInputStream = new JarInputStream(inputStream);
                JarEntry jarEntry = jarInputStream.getNextJarEntry();
                while (jarEntry != null && !string.equals(jarEntry.getName())) {
                    jarEntry = jarInputStream.getNextJarEntry();
                }
                if (jarEntry != null) {
                    classFile = new ClassFile((InputStream)jarInputStream);
                }
            }
        }
        finally {
            ProjectUtil.close(jarInputStream);
            ProjectUtil.close(inputStream);
        }
        return classFile;
    }

    public ClassFile getClassFileFromInternalName(String string) {
        ClassFile classFile = null;
        string = this.getClassPath(string);
        try {
            classFile = this.loadClassFileFor(this.rootClassDir + string);
        }
        catch (IOException iOException) {
            this.logger.warning("Exception while reading class file:" + string + ":" + iOException.getMessage());
        }
        return classFile;
    }

    public ClassFile getClassFile(ClassName className) {
        ClassFile classFile = null;
        try {
            classFile = this.loadClassFileFor(this.rootClassDir + this.getClassPath(className));
        }
        catch (IOException iOException) {
            this.logger.warning("Exception while reading class file:" + className + ":" + iOException.getMessage());
        }
        return classFile;
    }

    public ClassFile getClassFileUsingJarEntry(JarEntry jarEntry) {
        ClassFile classFile = null;
        try {
            classFile = this.loadClassFileFor(jarEntry.getName());
        }
        catch (IOException iOException) {
            this.logger.warning("Exception while reading class file:" + jarEntry.getName() + ":" + iOException.getMessage());
        }
        return classFile;
    }
}

