/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.insync.faces.refactoring;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.visualweb.project.jsf.api.JsfProjectUtils;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class FacesMovePanel
extends JPanel
implements ActionListener,
CustomRefactoringPanel {
    private static final ListCellRenderer PROJECT_CELL_RENDERER = new ProjectCellRenderer();
    private static final ProjectByDisplayNameComparator PROJECT_BY_DISPLAY_NAME_COMPARATOR = new ProjectByDisplayNameComparator();
    private ChangeListener parent;
    private Project project;
    private FileObject webRootFolder;
    private FileObject fo;
    private boolean initialized = false;
    protected JPanel bottomPanel;
    private JComboBox folderComboBox;
    private JLabel labelFolder;
    private JLabel labelHeadLine;
    private JLabel labelProject;
    private JLabel labelWebRoot;
    private JComboBox projectsComboBox;
    private JCheckBox updateReferencesCheckBox;
    private JTextField webRootTextField;

    public FacesMovePanel(ChangeListener changeListener, String string, FileObject fileObject) {
        this.parent = changeListener;
        this.fo = fileObject;
        this.initComponents();
        this.setCombosEnabled(true);
        this.setName(string);
        this.projectsComboBox.setRenderer(PROJECT_CELL_RENDERER);
        this.folderComboBox.setRenderer(new FolderRenderer());
        this.projectsComboBox.addActionListener(this);
        this.folderComboBox.addActionListener(this);
        this.project = this.fo != null ? FileOwnerQuery.getOwner((FileObject)this.fo) : OpenProjects.getDefault().getOpenProjects()[0];
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.initValues(this.fo);
        this.initialized = true;
    }

    public void initValues(FileObject fileObject) {
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        TreeSet<Project> treeSet = new TreeSet<Project>(PROJECT_BY_DISPLAY_NAME_COMPARATOR);
        for (Project project : projectArray) {
            if (!JsfProjectUtils.isJsfProject((Project)project)) continue;
            treeSet.add(project);
        }
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(treeSet.toArray());
        this.projectsComboBox.setModel(defaultComboBoxModel);
        this.projectsComboBox.setSelectedItem(this.project);
        this.updateRoot();
        this.updateFolders();
        if (fileObject != null) {
            this.folderComboBox.setSelectedItem(fileObject);
        }
    }

    public void requestFocus() {
        this.folderComboBox.requestFocus();
    }

    public FileObject getWebRootFolder() {
        return this.webRootFolder;
    }

    public FileObject getTargeFolder() {
        FileObject fileObject = (FileObject)this.folderComboBox.getSelectedItem();
        if (fileObject != null) {
            return fileObject;
        }
        return null;
    }

    private void fireChange() {
        this.parent.stateChanged(null);
    }

    private void initComponents() {
        this.labelProject = new JLabel();
        this.projectsComboBox = new JComboBox();
        this.labelWebRoot = new JLabel();
        this.webRootTextField = new JTextField();
        this.labelFolder = new JLabel();
        this.folderComboBox = new JComboBox();
        this.bottomPanel = new JPanel();
        this.labelHeadLine = new JLabel();
        this.updateReferencesCheckBox = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.labelProject.setLabelFor(this.projectsComboBox);
        Mnemonics.setLocalizedText((JLabel)this.labelProject, (String)NbBundle.getMessage(FacesMovePanel.class, (String)"LBL_Project"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.labelProject, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.projectsComboBox, gridBagConstraints);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/visualweb/insync/faces/refactoring/Bundle");
        this.projectsComboBox.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_projectsCombo"));
        Mnemonics.setLocalizedText((JLabel)this.labelWebRoot, (String)NbBundle.getMessage(FacesMovePanel.class, (String)"LBL_Location"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.labelWebRoot, gridBagConstraints);
        this.webRootTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.webRootTextField, gridBagConstraints);
        this.labelFolder.setLabelFor(this.folderComboBox);
        Mnemonics.setLocalizedText((JLabel)this.labelFolder, (String)NbBundle.getMessage(FacesMovePanel.class, (String)"LBL_Folder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.labelFolder, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.folderComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.bottomPanel, gridBagConstraints);
        this.labelHeadLine.setBorder(BorderFactory.createEmptyBorder(1, 1, 6, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.labelHeadLine, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.updateReferencesCheckBox, (String)NbBundle.getBundle(FacesMovePanel.class).getString("LBL_MoveWithoutReferences"));
        this.updateReferencesCheckBox.setBorder(BorderFactory.createEmptyBorder(4, 4, 0, 4));
        this.updateReferencesCheckBox.setMargin(new Insets(2, 2, 0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.updateReferencesCheckBox, gridBagConstraints);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.projectsComboBox == actionEvent.getSource()) {
            this.project = (Project)this.projectsComboBox.getSelectedItem();
            this.updateRoot();
            this.updateFolders();
            this.fireChange();
        } else if (this.folderComboBox == actionEvent.getSource()) {
            this.fireChange();
        }
    }

    private void updateFolders() {
        LinkedHashSet<FileObject> linkedHashSet = new LinkedHashSet<FileObject>();
        if (this.webRootFolder != null) {
            linkedHashSet.add(this.webRootFolder);
            Enumeration enumeration = this.webRootFolder.getChildren(true);
            while (enumeration.hasMoreElements()) {
                String string;
                FileObject fileObject = (FileObject)enumeration.nextElement();
                if (!fileObject.isFolder() || fileObject.getNameExt().equalsIgnoreCase("META-INF") || fileObject.getNameExt().equalsIgnoreCase("WEB-INF") || (string = FileUtil.getRelativePath((FileObject)this.webRootFolder, (FileObject)fileObject)) != null && (string.startsWith("META-INF/") || string.startsWith("WEB-INF/"))) continue;
                linkedHashSet.add(fileObject);
            }
        }
        this.folderComboBox.setModel(new DefaultComboBoxModel<FileObject>(linkedHashSet.toArray(new FileObject[linkedHashSet.size()])));
    }

    void setCombosEnabled(boolean bl) {
        this.projectsComboBox.setEnabled(bl);
        this.folderComboBox.setEnabled(bl);
        this.updateReferencesCheckBox.setVisible(!bl);
    }

    public boolean isUpdateReferences() {
        return !this.updateReferencesCheckBox.isVisible() || !this.updateReferencesCheckBox.isSelected();
    }

    private void updateRoot() {
        FileObject fileObject;
        this.webRootTextField.setText("");
        this.webRootFolder = null;
        Project project = (Project)this.projectsComboBox.getSelectedItem();
        if (project != null && (fileObject = project.getProjectDirectory()) != null) {
            this.webRootFolder = JsfProjectUtils.getDocumentRoot((Project)this.project);
            if (this.webRootFolder != null) {
                this.webRootTextField.setText(FileUtil.getRelativePath((FileObject)fileObject, (FileObject)this.webRootFolder));
            }
        }
    }

    public Component getComponent() {
        return this;
    }

    private static class ProjectByDisplayNameComparator
    implements Comparator {
        private static Comparator COLLATOR = Collator.getInstance();

        private ProjectByDisplayNameComparator() {
        }

        public int compare(Object object, Object object2) {
            if (!(object instanceof Project)) {
                return 1;
            }
            if (!(object2 instanceof Project)) {
                return -1;
            }
            Project project = (Project)object;
            Project project2 = (Project)object2;
            return COLLATOR.compare(ProjectUtils.getInformation((Project)project).getDisplayName(), ProjectUtils.getInformation((Project)project2).getDisplayName());
        }
    }

    class FolderRenderer
    extends BaseCellRenderer {
        FolderRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setName("ComboBox.listRenderer");
            FileObject fileObject = (FileObject)object;
            if (FacesMovePanel.this.webRootFolder != null) {
                if (FacesMovePanel.this.webRootFolder == fileObject) {
                    this.setText(".");
                } else {
                    this.setText(FileUtil.getRelativePath((FileObject)FacesMovePanel.this.webRootFolder, (FileObject)fileObject));
                }
            } else {
                this.setText(fileObject.getPath());
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }

    static class ProjectCellRenderer
    extends BaseCellRenderer {
        ProjectCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setName("ComboBox.listRenderer");
            if (object != null) {
                ProjectInformation projectInformation = ProjectUtils.getInformation((Project)((Project)object));
                this.setText(projectInformation.getDisplayName());
                this.setIcon(projectInformation.getIcon());
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }

    private static abstract class BaseCellRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public BaseCellRenderer() {
            this.setOpaque(true);
        }

        public String getName() {
            String string = super.getName();
            return string == null ? "ComboBox.renderer" : string;
        }
    }
}

