/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.insync.faces.refactoring;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.visualweb.insync.Model;
import org.netbeans.modules.visualweb.insync.ModelSet;
import org.netbeans.modules.visualweb.insync.faces.AnyAttrValueScanner;
import org.netbeans.modules.visualweb.insync.faces.refactoring.FacesRefactoringPlugin;
import org.netbeans.modules.visualweb.insync.faces.refactoring.FacesRefactoringUtils;
import org.netbeans.modules.visualweb.insync.faces.refactoring.FacesRefactoringsPluginFactory;
import org.netbeans.modules.visualweb.insync.faces.refactoring.JSFConfigRenameFromViewIdElement;
import org.netbeans.modules.visualweb.insync.faces.refactoring.JSFConfigRenameToViewIdElement;
import org.netbeans.modules.visualweb.insync.faces.refactoring.PostProcessRenamedFolderRefactoringElement;
import org.netbeans.modules.visualweb.insync.faces.refactoring.RenameResourceReferencesRefactoringElement;
import org.netbeans.modules.visualweb.insync.faces.refactoring.SetProjectStartPageRefactoringElement;
import org.netbeans.modules.visualweb.insync.markup.MarkupUnit;
import org.netbeans.modules.visualweb.insync.models.FacesModel;
import org.netbeans.modules.visualweb.insync.models.FacesModelSet;
import org.netbeans.modules.visualweb.project.jsf.api.JsfProjectUtils;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.api.ConfigurationUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class FacesJspFileMoveRefactoringPlugin
extends FacesRefactoringPlugin {
    private static final Logger LOGGER = Logger.getLogger(FacesJspFileMoveRefactoringPlugin.class.getName());
    private List<FileObject> filesToMove = new ArrayList<FileObject>();
    private Map<FileObject, String> folderPostfix = new HashMap<FileObject, String>();

    public FacesJspFileMoveRefactoringPlugin(MoveRefactoring moveRefactoring) {
        super((AbstractRefactoring)moveRefactoring);
        this.setup(moveRefactoring.getRefactoringSource().lookupAll(FileObject.class), "", true);
    }

    public FacesJspFileMoveRefactoringPlugin(RenameRefactoring renameRefactoring) {
        super((AbstractRefactoring)renameRefactoring);
        this.setup(Collections.singleton(renameRefactoring.getRefactoringSource().lookup(FileObject.class)), "", true);
    }

    private MoveRefactoring getMoveRefactoring() {
        return (MoveRefactoring)this.getRefactoring();
    }

    private RenameRefactoring getRenameRefactoring() {
        return (RenameRefactoring)this.getRefactoring();
    }

    private void setup(Collection collection, String string, boolean bl) {
        for (FileObject fileObject : collection) {
            if (FacesRefactoringUtils.isVisualWebJspFile(fileObject)) {
                this.folderPostfix.put(fileObject, string);
                this.filesToMove.add(fileObject);
                continue;
            }
            if (!fileObject.isFolder()) {
                this.folderPostfix.put(fileObject, string);
                continue;
            }
            if (!VisibilityQuery.getDefault().isVisible(fileObject)) continue;
            boolean bl2 = !"".equals(string);
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            for (FileObject fileObject2 : fileObject.getChildren()) {
                if (fileObject2.isFolder() && (!fileObject2.isFolder() || !bl)) continue;
                arrayList.add(fileObject2);
            }
            this.setup(arrayList, string + (bl2 ? "/" : "") + fileObject.getName(), bl);
        }
    }

    public Problem preCheck() {
        return null;
    }

    public Problem fastCheckParameters() {
        if (this.getRefactoring() instanceof MoveRefactoring) {
            FileObject fileObject = (FileObject)this.getMoveRefactoring().getRefactoringSource().lookup(FileObject.class);
            URL uRL = (URL)this.getMoveRefactoring().getTarget().lookup(URL.class);
            if (fileObject != null) {
                if (uRL == null) {
                    return new Problem(true, NbBundle.getMessage(FacesJspFileMoveRefactoringPlugin.class, (String)"ERR_TargetLocationCannotBeNull"));
                }
                if (FacesRefactoringUtils.isFileUnderDocumentRoot(fileObject)) {
                    if (fileObject.isFolder()) {
                        if (FacesRefactoringUtils.isSpecialFolderName(fileObject.getNameExt())) {
                            return new Problem(true, NbBundle.getMessage(FacesJspFileMoveRefactoringPlugin.class, (String)"ERR_CannotMoveSpecialFolders"));
                        }
                    } else if (FacesRefactoringUtils.isVisualWebJspFile(fileObject)) {
                        Object object;
                        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                        FileObject fileObject2 = URLMapper.findFileObject((URL)uRL);
                        if (fileObject2 == null) {
                            object = null;
                            try {
                                object = new File(uRL.toURI());
                            }
                            catch (URISyntaxException uRISyntaxException) {
                                Exceptions.printStackTrace((Throwable)uRISyntaxException);
                            }
                            if (object == null) {
                                return new Problem(true, NbBundle.getMessage(FacesJspFileMoveRefactoringPlugin.class, (String)"ERR_TargetLocationCannotBeResolved"));
                            }
                            fileObject2 = FileUtil.toFileObject((File)object);
                            if (fileObject2 == null) {
                                return new Problem(true, NbBundle.getMessage(FacesJspFileMoveRefactoringPlugin.class, (String)"ERR_TargetLocationCannotBeResolved"));
                            }
                        }
                        if ((object = FileOwnerQuery.getOwner((FileObject)fileObject2)) == null) {
                            return new Problem(true, NbBundle.getMessage(FacesJspFileMoveRefactoringPlugin.class, (String)"ERR_TargetLocationIsNotInAnOpenProject"));
                        }
                        if (!project.equals(object)) {
                            return new Problem(true, NbBundle.getMessage(FacesJspFileMoveRefactoringPlugin.class, (String)"ERR_TargetLocationIsNotInSameProject"));
                        }
                        if (!fileObject2.isFolder()) {
                            return new Problem(true, NbBundle.getMessage(FacesJspFileMoveRefactoringPlugin.class, (String)"ERR_TargetLocationIsNotAFolder"));
                        }
                        if (fileObject2.equals(fileObject.getParent())) {
                            return new Problem(true, NbBundle.getMessage(FacesJspFileMoveRefactoringPlugin.class, (String)"ERR_CannotMoveToSameLocation"));
                        }
                        FileObject fileObject3 = fileObject2.getFileObject(fileObject.getName(), fileObject.getExt());
                        if (fileObject3 != null && fileObject3.isValid()) {
                            return new Problem(true, NbBundle.getMessage(FacesJspFileMoveRefactoringPlugin.class, (String)"ERR_TargetJspFileAlreadyExists"));
                        }
                        Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject);
                        if (!project2.equals(object)) {
                            boolean bl;
                            boolean bl2 = JsfProjectUtils.isJsfProject((Project)object);
                            if (bl2) {
                                // empty if block
                            }
                            if (bl = JsfProjectUtils.isStartPage((FileObject)fileObject)) {
                                return new Problem(false, NbBundle.getMessage(FacesJspFileMoveRefactoringPlugin.class, (String)"WRN_MovingProjectStartPage"));
                            }
                        }
                    }
                }
            }
        } else if (this.getRefactoring() instanceof RenameRefactoring) {
            FileObject fileObject = (FileObject)this.getRefactoring().getRefactoringSource().lookup(FileObject.class);
            String string = this.getRenameRefactoring().getNewName();
            if (fileObject != null && FacesRefactoringUtils.isFileUnderDocumentRoot(fileObject) && fileObject.isFolder()) {
                if (FacesRefactoringUtils.isSpecialFolderName(fileObject.getNameExt())) {
                    return new Problem(true, NbBundle.getMessage(FacesJspFileMoveRefactoringPlugin.class, (String)"ERR_CannotRenameSpecialFolders"));
                }
                if (string == null) {
                    return new Problem(true, NbBundle.getMessage(FacesJspFileMoveRefactoringPlugin.class, (String)"ERR_NewNameCannotBeNull"));
                }
                if ((string = string.trim()).length() == 0) {
                    return new Problem(true, NbBundle.getMessage(FacesJspFileMoveRefactoringPlugin.class, (String)"ERR_NewNameCannotBeEmpty"));
                }
                if (string.equals(fileObject.getName())) {
                    return new Problem(true, NbBundle.getMessage(FacesJspFileMoveRefactoringPlugin.class, (String)"ERR_NewNameSameAsOldName"));
                }
                if (!Utilities.isJavaIdentifier((String)string)) {
                    return new Problem(true, NbBundle.getMessage(FacesJspFileMoveRefactoringPlugin.class, (String)"ERR_NewNameIsNotAValidJavaIdentifier"));
                }
                FileObject fileObject4 = fileObject.getParent().getFileObject(string, fileObject.getExt());
                if (fileObject4 != null && fileObject4.isValid()) {
                    return new Problem(false, NbBundle.getMessage(FacesJspFileMoveRefactoringPlugin.class, (String)"ERR_NewNameFolderAlreadyExists"));
                }
            }
        }
        return null;
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        RefactoringSession refactoringSession = refactoringElementsBag.getSession();
        if (this.getRefactoring() instanceof MoveRefactoring) {
            FileObject fileObject;
            Object object;
            URL uRL = (URL)this.getMoveRefactoring().getTarget().lookup(URL.class);
            if (uRL == null) {
                return new Problem(true, NbBundle.getMessage(FacesJspFileMoveRefactoringPlugin.class, (String)"ERR_TargetLocationCannotBeNull"));
            }
            FileObject fileObject2 = URLMapper.findFileObject((URL)uRL);
            if (fileObject2 == null) {
                object = null;
                try {
                    object = new File(uRL.toURI());
                }
                catch (URISyntaxException uRISyntaxException) {
                    Exceptions.printStackTrace((Throwable)uRISyntaxException);
                }
                if (object == null) {
                    return new Problem(true, NbBundle.getMessage(FacesJspFileMoveRefactoringPlugin.class, (String)"ERR_TargetLocationCannotBeResolved"));
                }
                fileObject2 = FileUtil.toFileObject((File)object);
                if (fileObject2 == null) {
                    return new Problem(true, NbBundle.getMessage(FacesJspFileMoveRefactoringPlugin.class, (String)"ERR_TargetLocationCannotBeResolved"));
                }
            }
            if ((object = FileOwnerQuery.getOwner((FileObject)fileObject2)) == null) {
                return new Problem(true, NbBundle.getMessage(FacesJspFileMoveRefactoringPlugin.class, (String)"ERR_TargetLocationIsNotInAnOpenProject"));
            }
            if (!fileObject2.isFolder()) {
                return new Problem(true, NbBundle.getMessage(FacesJspFileMoveRefactoringPlugin.class, (String)"ERR_TargetLocationIsNotAFolder"));
            }
            FileObject fileObject3 = JsfProjectUtils.getPageBeanRoot((Project)object);
            if (fileObject3 == null) {
                // empty if block
            }
            if ((fileObject = JsfProjectUtils.getDocumentRoot((Project)object)) == null) {
                // empty if block
            }
            String string = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2);
            for (FileObject fileObject4 : this.filesToMove) {
                Object object2;
                Object object3;
                FileObject[] fileObjectArray;
                MarkupUnit markupUnit;
                FacesModel facesModel;
                Object object4;
                Object object5;
                Object object6;
                String string2;
                FileObject fileObject5;
                FileObject fileObject6;
                if (!FacesRefactoringUtils.isFileUnderDocumentRoot(fileObject4) || !FacesRefactoringUtils.isVisualWebJspFile(fileObject4)) continue;
                Project project = FileOwnerQuery.getOwner((FileObject)fileObject4);
                if (project == null) {
                    return new Problem(true, NbBundle.getMessage(FacesJspFileMoveRefactoringPlugin.class, (String)"ERR_SourceIsNotInAnOpenProject"));
                }
                if (!project.equals(object)) {
                    return new Problem(true, NbBundle.getMessage(FacesJspFileMoveRefactoringPlugin.class, (String)"ERR_TargetLocationIsNotInSameProject"));
                }
                String string3 = this.folderPostfix.get(fileObject4);
                if (!FacesJspFileMoveRefactoringPlugin.isDelegatedRefactoring(this.getRefactoring())) {
                    fileObject6 = FacesModel.getJavaForJsp(fileObject4);
                    if (fileObject6 == null) {
                        // empty if block
                    }
                    fileObject5 = new MoveRefactoring(Lookups.singleton((Object)fileObject6));
                    string2 = string;
                    if (string3 != null && string3.length() > 0) {
                        string2 = string2.length() > 0 ? string2 + "/" + string3 : string3;
                    }
                    if ((object6 = fileObject3.getFileObject(string2)) == null) {
                        try {
                            object6 = FileUtil.createFolder((FileObject)fileObject3, (String)string2);
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().notify(65536, (Throwable)iOException);
                        }
                    }
                    if (object6 == null) {
                        return new Problem(true, NbBundle.getMessage(FacesJspFileMoveRefactoringPlugin.class, (String)"ERR_TargetPackageDoesNotExist", (Object)string2));
                    }
                    object5 = URLMapper.findURL((FileObject)object6, (int)1);
                    try {
                        fileObject5.setTarget(Lookups.singleton((Object)new URL(((URL)object5).toExternalForm())));
                    }
                    catch (MalformedURLException malformedURLException) {
                        return new Problem(true, NbBundle.getMessage(FacesJspFileMoveRefactoringPlugin.class, (String)"ERR_TargetPackageDoesNotExist", (Object)string2));
                    }
                    object4 = FacesRefactoringUtils.getClasspathInfoFor(fileObject6);
                    fileObject5.getContext().add(object4);
                    fileObject5.getContext().add((Object)FacesRefactoringsPluginFactory.DELEGATED_REFACTORING);
                    facesModel = fileObject5.prepare(refactoringSession);
                    if (facesModel != null) {
                        return facesModel;
                    }
                }
                fileObject6 = JsfProjectUtils.getDocumentRoot((Project)project);
                fileObject5 = fileObject4.getParent();
                string2 = FileUtil.getRelativePath((FileObject)fileObject6, (FileObject)fileObject5);
                object6 = string2 + (string2.length() > 0 ? "/" : "") + fileObject4.getNameExt();
                object5 = string + (string.length() > 0 ? "/" : "") + (string3 != null && string3.length() > 0 ? string3 + "/" : "") + fileObject4.getNameExt();
                object4 = FacesModelSet.getInstance(fileObject4);
                facesModel = ((FacesModelSet)object4).getFacesModel(fileObject4);
                if (facesModel != null && facesModel.isPageBean() && (markupUnit = facesModel.getMarkupUnit()) != null) {
                    fileObjectArray = new AnyAttrValueScanner();
                    object3 = ((ModelSet)object4).getModels();
                    for (int i = 0; i < ((Model[])object3).length; ++i) {
                        String string4;
                        Document document;
                        int n;
                        String string5;
                        Object object7;
                        int n2;
                        Document document2;
                        int n3;
                        FacesModel facesModel2;
                        object2 = object3[i];
                        if (!(object2 instanceof FacesModel) || (facesModel2 = (FacesModel)object2).isBusted() || !facesModel2.isPageBean()) continue;
                        FileObject fileObject7 = facesModel2.getMarkupFile();
                        MarkupUnit markupUnit2 = facesModel2.getMarkupUnit();
                        if (markupUnit2 != null && (n3 = fileObjectArray.getReferenceCount(document2 = markupUnit2.getSourceDom(), "/faces/" + (String)object6)) > 0) {
                            refactoringElementsBag.add(this.getRefactoring(), (RefactoringElementImplementation)new RenameResourceReferencesRefactoringElement(fileObject7, markupUnit2, "/faces/" + (String)object6, "/faces/" + (String)object5));
                        }
                        if (fileObject7 == null || fileObject4.equals(fileObject7) || this.filesToMove.contains(fileObject7)) continue;
                        document2 = fileObject4.getParent();
                        FileObject fileObject8 = fileObject7.getParent();
                        String string6 = FileUtil.getRelativePath((FileObject)fileObject6, (FileObject)fileObject7);
                        String string7 = FileUtil.getRelativePath((FileObject)fileObject6, (FileObject)fileObject8);
                        String string8 = FacesRefactoringUtils.computeRelativePath(fileObject8.getPath(), fileObject4.getPath());
                        if (string8 != null && markupUnit2 != null && (n2 = fileObjectArray.getReferenceCount((Node)(object7 = markupUnit2.getSourceDom()), string8)) > 0 && (string5 = FacesRefactoringUtils.computeRelativePath(string7, (String)object5)) != null) {
                            refactoringElementsBag.add(this.getRefactoring(), (RefactoringElementImplementation)new RenameResourceReferencesRefactoringElement(fileObject7, markupUnit2, string8, string5));
                        }
                        if ((object7 = FacesRefactoringUtils.computeRelativePath(document2.getPath(), fileObject7.getPath())) == null || (n = fileObjectArray.getReferenceCount(document = markupUnit.getSourceDom(), (String)object7)) <= 0 || (string4 = FacesRefactoringUtils.computeRelativePath(string, string6)) == null) continue;
                        refactoringElementsBag.add(this.getRefactoring(), (RefactoringElementImplementation)new RenameResourceReferencesRefactoringElement(fileObject7, markupUnit, (String)object7, string4));
                    }
                }
                if (JsfProjectUtils.isStartPage((FileObject)fileObject4)) {
                    refactoringElementsBag.addFileChange(this.getRefactoring(), (RefactoringElementImplementation)new SetProjectStartPageRefactoringElement(project, (String)object6, (String)object5));
                }
                if ((markupUnit = WebModule.getWebModule((FileObject)project.getProjectDirectory())) == null || (fileObjectArray = ConfigurationUtils.getFacesConfigFiles((WebModule)markupUnit)) == null) continue;
                object3 = FacesRefactoringUtils.getAllFromViewIdOccurrences((WebModule)markupUnit, "/" + (String)object6, "/" + (String)object5);
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    object2 = (FacesRefactoringUtils.OccurrenceItem)iterator.next();
                    refactoringElementsBag.add(this.getRefactoring(), (RefactoringElementImplementation)new JSFConfigRenameFromViewIdElement((FacesRefactoringUtils.OccurrenceItem)object2));
                }
                object3 = FacesRefactoringUtils.getAllToViewOccurrences((WebModule)markupUnit, "/" + (String)object6, "/" + (String)object5);
                iterator = object3.iterator();
                while (iterator.hasNext()) {
                    object2 = (FacesRefactoringUtils.OccurrenceItem)iterator.next();
                    refactoringElementsBag.add(this.getRefactoring(), (RefactoringElementImplementation)new JSFConfigRenameToViewIdElement((FacesRefactoringUtils.OccurrenceItem)object2));
                }
            }
        } else if (this.getRefactoring() instanceof RenameRefactoring) {
            String string;
            String string9 = this.getRenameRefactoring().getNewName();
            String string10 = null;
            FileObject fileObject = (FileObject)this.getRefactoring().getRefactoringSource().lookup(FileObject.class);
            if (fileObject != null) {
                assert (fileObject.isFolder());
                Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                if (project == null) {
                    return new Problem(true, NbBundle.getMessage(FacesJspFileMoveRefactoringPlugin.class, (String)"ERR_SourceIsNotInAnOpenProject"));
                }
                FileObject fileObject9 = JsfProjectUtils.getDocumentRoot((Project)project);
                if (fileObject9 == null) {
                    // empty if block
                }
                string10 = (string = FileUtil.getRelativePath((FileObject)fileObject9, (FileObject)fileObject.getParent())).length() == 0 ? string9 : string + "/" + string9;
            }
            for (FileObject fileObject9 : this.filesToMove) {
                Object object;
                Object object8;
                FileObject[] fileObjectArray;
                MarkupUnit markupUnit;
                Object object9;
                Object object10;
                Object object11;
                Object object12;
                String string11;
                FileObject fileObject10;
                FileObject fileObject11;
                if (!FacesRefactoringUtils.isFileUnderDocumentRoot(fileObject9) || !FacesRefactoringUtils.isVisualWebJspFile(fileObject9)) continue;
                string = FileOwnerQuery.getOwner((FileObject)fileObject9);
                if (string == null) {
                    return new Problem(true, NbBundle.getMessage(FacesJspFileMoveRefactoringPlugin.class, (String)"ERR_SourceIsNotInAnOpenProject"));
                }
                String string12 = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject9.getParent());
                if (!FacesJspFileMoveRefactoringPlugin.isDelegatedRefactoring(this.getRefactoring())) {
                    fileObject11 = FacesModel.getJavaForJsp(fileObject9);
                    if (fileObject11 == null) {
                        // empty if block
                    }
                    fileObject10 = new MoveRefactoring(Lookups.singleton((Object)fileObject11));
                    string11 = string10;
                    if (string12 != null && string12.length() > 0) {
                        string11 = string11.length() > 0 ? string11 + "/" + string12 : string12;
                    }
                    if ((object12 = (object11 = JsfProjectUtils.getPageBeanRoot((Project)string)).getFileObject(string11)) == null) {
                        try {
                            object12 = FileUtil.createFolder((FileObject)object11, (String)string11);
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().notify(65536, (Throwable)iOException);
                        }
                    }
                    if (object12 == null) {
                        return new Problem(true, NbBundle.getMessage(FacesJspFileMoveRefactoringPlugin.class, (String)"ERR_TargetPackageDoesNotExist", (Object)string11));
                    }
                    object10 = URLMapper.findURL((FileObject)object12, (int)1);
                    try {
                        fileObject10.setTarget(Lookups.singleton((Object)new URL(((URL)object10).toExternalForm())));
                    }
                    catch (MalformedURLException malformedURLException) {
                        return new Problem(true, NbBundle.getMessage(FacesJspFileMoveRefactoringPlugin.class, (String)"ERR_TargetPackageDoesNotExist", (Object)string11));
                    }
                    object9 = FacesRefactoringUtils.getClasspathInfoFor(fileObject11);
                    fileObject10.getContext().add(object9);
                    fileObject10.getContext().add((Object)FacesRefactoringsPluginFactory.DELEGATED_REFACTORING);
                    markupUnit = fileObject10.prepare(refactoringSession);
                    if (markupUnit != null) {
                        return markupUnit;
                    }
                }
                fileObject11 = JsfProjectUtils.getDocumentRoot((Project)string);
                fileObject10 = fileObject9.getParent();
                string11 = FileUtil.getRelativePath((FileObject)fileObject11, (FileObject)fileObject10);
                object11 = string11 + (string11.length() > 0 ? "/" : "") + fileObject9.getNameExt();
                object12 = string10 + (string10.length() > 0 ? "/" : "") + (string12 != null && string12.length() > 0 ? string12 + "/" : "") + fileObject9.getNameExt();
                object10 = FacesModelSet.getInstance(fileObject9);
                object9 = ((FacesModelSet)object10).getFacesModel(fileObject9);
                if (object9 != null && ((FacesModel)object9).isPageBean() && (markupUnit = ((FacesModel)object9).getMarkupUnit()) != null) {
                    fileObjectArray = new AnyAttrValueScanner();
                    object8 = ((ModelSet)object10).getModels();
                    for (int i = 0; i < ((Model[])object8).length; ++i) {
                        String string13;
                        Document document;
                        int n;
                        Object object13;
                        FileObject fileObject12;
                        FacesModel facesModel;
                        object = object8[i];
                        if (!(object instanceof FacesModel) || (facesModel = (FacesModel)object).isBusted() || !facesModel.isPageBean() || (fileObject12 = facesModel.getMarkupFile()) == null || fileObject9.equals(fileObject12) || this.filesToMove.contains(fileObject12)) continue;
                        FileObject fileObject13 = fileObject9.getParent();
                        FileObject fileObject14 = fileObject12.getParent();
                        String string14 = FileUtil.getRelativePath((FileObject)fileObject11, (FileObject)fileObject12);
                        String string15 = FileUtil.getRelativePath((FileObject)fileObject11, (FileObject)fileObject14);
                        String string16 = FacesRefactoringUtils.computeRelativePath(fileObject14.getPath(), fileObject9.getPath());
                        if (string16 != null && (object13 = facesModel.getMarkupUnit()) != null && (n = fileObjectArray.getReferenceCount(document = ((MarkupUnit)object13).getSourceDom(), string16)) > 0 && (string13 = FacesRefactoringUtils.computeRelativePath(string15, (String)object12)) != null) {
                            refactoringElementsBag.add(this.getRefactoring(), (RefactoringElementImplementation)new RenameResourceReferencesRefactoringElement(fileObject12, (MarkupUnit)object13, string16, string13));
                        }
                        if ((object13 = FacesRefactoringUtils.computeRelativePath(fileObject13.getPath(), fileObject12.getPath())) == null || (n = fileObjectArray.getReferenceCount(document = markupUnit.getSourceDom(), (String)object13)) <= 0 || (string13 = FacesRefactoringUtils.computeRelativePath(string10, string14)) == null) continue;
                        refactoringElementsBag.add(this.getRefactoring(), (RefactoringElementImplementation)new RenameResourceReferencesRefactoringElement(fileObject12, markupUnit, (String)object13, string13));
                    }
                }
                if (JsfProjectUtils.isStartPage((FileObject)fileObject9)) {
                    refactoringElementsBag.addFileChange(this.getRefactoring(), (RefactoringElementImplementation)new SetProjectStartPageRefactoringElement((Project)string, (String)object11, (String)object12));
                }
                if ((markupUnit = WebModule.getWebModule((FileObject)string.getProjectDirectory())) == null || (fileObjectArray = ConfigurationUtils.getFacesConfigFiles((WebModule)markupUnit)) == null) continue;
                object8 = FacesRefactoringUtils.getAllFromViewIdOccurrences((WebModule)markupUnit, "/" + (String)object11, "/" + (String)object12);
                Iterator iterator = object8.iterator();
                while (iterator.hasNext()) {
                    object = (FacesRefactoringUtils.OccurrenceItem)iterator.next();
                    refactoringElementsBag.add(this.getRefactoring(), (RefactoringElementImplementation)new JSFConfigRenameFromViewIdElement((FacesRefactoringUtils.OccurrenceItem)object));
                }
                object8 = FacesRefactoringUtils.getAllToViewOccurrences((WebModule)markupUnit, "/" + (String)object11, "/" + (String)object12);
                iterator = object8.iterator();
                while (iterator.hasNext()) {
                    object = (FacesRefactoringUtils.OccurrenceItem)iterator.next();
                    refactoringElementsBag.add(this.getRefactoring(), (RefactoringElementImplementation)new JSFConfigRenameToViewIdElement((FacesRefactoringUtils.OccurrenceItem)object));
                }
            }
            refactoringElementsBag.addFileChange(this.getRefactoring(), (RefactoringElementImplementation)new PostProcessRenamedFolderRefactoringElement(fileObject, string9));
        }
        return null;
    }
}

